/*  testSort.c  */

#include "../DA2.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   -------------------------
   test the sort routine

   created -- 97jul23, cca
   -------------------------
*/
{
DA2      *A ;
double   t1, t2 ;
FILE     *msgFile ;
int      flag, ierr, inc1, inc2, msglvl, nrow, ncol, seed ;
int      *colind, *rowind ;

if ( argc != 9 ) {
   fprintf(stdout, 
"\n\n this driver tests the DA2_sortRowsUp() "
"\n and DA2_sortColumnsUp() methods"
"\n\n usage : %s msglvl msgFile nrow ncol inc1 inc2 seed flag"
"\n    msglvl  -- message level"
"\n    msgFile -- message file"
"\n    nrow    -- # of rows "
"\n    ncol    -- # of columns "
"\n    inc1    -- row increment "
"\n    inc2    -- column increment "
"\n    seed    -- random number seed"
"\n    flag    -- gather flag"
"\n       flag = 1 --> use DA2_sortRowsUp"
"\n       flag = 2 --> use DA2_sortColumnsUp"
"\n       flag = 3 --> use DA2_sortRowsUp and DA2_sortColumnsUp"
"\n", argv[0]) ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
nrow = atoi(argv[3]) ;
ncol = atoi(argv[4]) ;
inc1 = atoi(argv[5]) ;
inc2 = atoi(argv[6]) ;
if ( nrow < 0 || ncol < 0 || inc1 < 1 || inc2 < 1 ) {
   fprintf(stderr, 
       "\n fatal error, nrow = %d, ncol = %d, inc1 = %d, inc2 = %d",
       nrow, ncol, inc1, inc2) ;
   exit(-1) ;
}
seed = atoi(argv[7]) ;
flag = atoi(argv[8]) ;
fprintf(msgFile, "\n\n test_sort :"
        "\n msglvl  = %d"
        "\n msgFile = %s"
        "\n nrow    = %d"
        "\n ncol    = %d"
        "\n inc1    = %d"
        "\n inc2    = %d"
        "\n seed    = %d"
        "\n flag    = %d"
        "\n",
        msglvl, argv[2], nrow, ncol, inc1, inc2, seed, flag) ;
/*
   -----------------------------
   initialize the matrix objects
   -----------------------------
*/
MARKTIME(t1) ;
A = DA2_new() ;
DA2_init(A, nrow, ncol, inc1, inc2, NULL) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to initialize matrix object",
        t2 - t1) ;
MARKTIME(t1) ;
DA2_fillRandomUniform(A, 0, 1, seed) ;
seed++ ;
MARKTIME(t2) ;
fprintf(msgFile, 
        "\n CPU : %.3f to fill matrix with random numbers", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n matrix A") ;
   DA2_writeForHumanEye(A, msgFile) ;
}
/*
   --------------------------------------------
   initialize the rowind[] and colind[] vectors
   --------------------------------------------
*/
rowind = IVinit(nrow, -1) ;
IVramp(nrow, rowind, 0, 1) ;
if ( flag == 1 || flag == 3 ) {
   IVshuffle(nrow, rowind, seed) ;
}
seed++ ;
colind = IVinit(ncol, -1) ;
IVramp(ncol, colind, 0, 1) ;
if ( flag == 2 || flag == 3 ) {
   IVshuffle(ncol, colind, seed) ;
}
seed++ ;
if ( msglvl > 1 ) {
   if ( flag == 1 || flag == 3 ) {
      fprintf(msgFile, "\n rowind :") ;
      IVfp80(msgFile, nrow, rowind, 10, &ierr) ;
   }
   if ( flag == 2 || flag == 3 ) {
      fprintf(msgFile, "\n colind :") ;
      IVfp80(msgFile, ncol, colind, 10, &ierr) ;
   }
}
/*
   ----
   sort
   ----
*/
MARKTIME(t1) ;
switch ( flag ) {
case 1 :
   DA2_sortRowsUp(A, nrow, rowind) ;
   break ;
case 2 :
   DA2_sortColumnsUp(A, ncol, colind) ;
   break ;
case 3 :
   DA2_sortRowsUp(A, nrow, rowind) ;
   DA2_sortColumnsUp(A, ncol, colind) ;
   break ;
}
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f sort", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n after the sort") ;
   fprintf(msgFile, "\n matrix ") ;
   DA2_writeForHumanEye(A, msgFile) ;
}

fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
