/*  testInverse.c  */

#include "../DA2.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   -------------------------
   test the inverse routine

   created -- 96jun29, cca
   -------------------------
*/
{
DA2      *A, *Aback, *B ;
double   t1, t2 ;
FILE     *msgFile ;
int      inc1, inc2, msglvl, n, seed ;

if ( argc != 7 ) {
   fprintf(stdout, 
"\n\n usage : %s msglvl msgFile n inc1 inc2 seed"
"\n    msglvl  -- message level"
"\n    msgFile -- message file"
"\n    n       -- # of rows and columns"
"\n    inc1    -- row increment"
"\n    inc2    -- column increment"
"\n    seed    -- random number seed"
"\n", argv[0]) ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
n    = atoi(argv[3]) ;
inc1 = atoi(argv[4]) ;
inc2 = atoi(argv[5]) ;
if ( n < 0 || inc1 < 1 || inc2 < 1 || (inc1 != 1 && inc2 != 1) ) {
   fprintf(stderr, "\n fatal error, n = %d, inc1 = %d, inc2 = %d",
       n, inc1, inc2) ;
   exit(-1) ;
}
seed = atoi(argv[6]) ;
/*
   -----------------------------
   initialize the matrix objects
   -----------------------------
*/
MARKTIME(t1) ;
A     = DA2_new() ;
Aback = DA2_new() ;
B     = DA2_new() ;
DA2_init(A, n, n, inc1, inc2, NULL) ;
DA2_init(Aback, n, n, inc1, inc2, NULL) ;
DA2_init(B, n, n, inc1, inc2, NULL) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to initialize matrix objects",
        t2 - t1) ;
MARKTIME(t1) ;
DA2_fillRandomUniform(A, 0.0, 1.0, seed) ;
DA2_copy(Aback, A) ;
DA2_fillWithIdentity(B) ;
MARKTIME(t2) ;
fprintf(msgFile, 
        "\n CPU : %.3f to fill matrix with random numbers", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n matrix A") ;
   DA2_writeForHumanEye(A, msgFile) ;
   fprintf(msgFile, "\n matrix Aback") ;
   DA2_writeForHumanEye(Aback, msgFile) ;
   fprintf(msgFile, "\n matrix B") ;
   DA2_writeForHumanEye(B, msgFile) ;
   fflush(msgFile) ;
}
/*
   -----------------
   invert the matrix
   -----------------
*/
MARKTIME(t1) ;
DA2_invert(A, B) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to invert matrix", t2 - t1) ;
fflush(msgFile) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n matrix A") ;
   DA2_writeForHumanEye(A, msgFile) ;
   fprintf(msgFile, "\n matrix B") ;
   DA2_writeForHumanEye(B, msgFile) ;
}
/*
   ----------------------------------
   compute the matrix vector multiply
   ----------------------------------
*/
DA2_fillWithIdentity(A) ;
DA2_ndUpd(A, Aback, B) ;
fprintf(msgFile, "\n max|I - A*B| = %20.12e", DA2_maxabs(A)) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n residual matrix") ;
   DA2_writeForHumanEye(A, msgFile) ;
}
/*
   ----------------------------------
   compute the matrix vector multiply
   ----------------------------------
*/
DA2_fillWithIdentity(A) ;
DA2_ndUpd(A, B, Aback) ;
fprintf(msgFile, "\n max|I - B*A| = %20.12e", DA2_maxabs(A)) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n residual matrix") ;
   DA2_writeForHumanEye(A, msgFile) ;
}

fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
