/*  testGather.c  */

#include "../DA2.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   -------------------------
   test the gather routine

   B = A(rowind[], colind[]) 

   created -- 96may10, cca
   -------------------------
*/
{
DA2      *A, *B, *C ;
double   entry, ops, t1, t2 ;
FILE     *msgFile ;
int      flag, ierr, ii, inc1A, inc1B, inc2A, inc2B, irow, jcol,
         jj, msglvl, nrowA, nrowB, ncolA, ncolB, seed ;
int      *colind, *rowind ;

if ( argc != 13 ) {
   fprintf(stdout, 
"\n\n this driver tests the DA2_gather() and DA2_gatherZero() methods"
"\n B := A(rowids[], colids[])"
"\n\n usage : %s msglvl msgFile "
"\n         nrowB ncolB inc1B inc2B nrowA ncolA inc1A inc2A seed flag"
"\n    msglvl  -- message level"
"\n    msgFile -- message file"
"\n    nrowB   -- # of rows in B"
"\n    ncolB   -- # of columns in B"
"\n    inc1B   -- row increment for B"
"\n    inc2B   -- row increment for B"
"\n    nrowA   -- # of rows in A"
"\n    ncolA   -- # of columns in A"
"\n    inc1A   -- row increment for A"
"\n    inc2A   -- row increment for A"
"\n    seed    -- random number seed"
"\n    flag    -- gather flag"
"\n       flag = 1 --> use DA2_gather"
"\n       flag = 2 --> use DA2_gatherZero"
"\n", argv[0]) ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
nrowB = atoi(argv[3]) ;
ncolB = atoi(argv[4]) ;
inc1B = atoi(argv[5]) ;
inc2B = atoi(argv[6]) ;
if ( nrowB < 0 || ncolB < 0 || inc1B < 1 || inc2B < 1 ) {
   fprintf(stderr, 
       "\n fatal error, nrowB = %d, ncolB = %d, inc1B = %d, inc2B = %d",
       nrowB, ncolB, inc1B, inc2B) ;
   exit(-1) ;
}
nrowA = atoi(argv[7]) ;
ncolA = atoi(argv[8]) ;
inc1A = atoi(argv[9]) ;
inc2A = atoi(argv[10]) ;
if ( nrowA < 0 || ncolA < 0 || inc1A < 1 || inc2A < 1 ) {
   fprintf(stderr, 
       "\n fatal error, nrowA = %d, ncolA = %d, inc1A = %d, inc2A = %d",
       nrowA, ncolA, inc1A, inc2A) ;
   exit(-1) ;
}
if ( nrowB > nrowA || ncolB > ncolA ) {
   fprintf(stderr, 
       "\n fatal error, nrowB = %d, nrowA = %d, ncolB = %d, ncolA = %d",
       nrowB, nrowA, ncolB, ncolA) ;
   exit(-1) ;
}
seed = atoi(argv[11]) ;
flag = atoi(argv[12]) ;
/*
   -----------------------------
   initialize the matrix objects
   -----------------------------
*/
MARKTIME(t1) ;
A = DA2_new() ;
B = DA2_new() ;
C = DA2_new() ;
DA2_init(A, nrowA, ncolA, inc1A, inc2A, NULL) ;
DA2_init(B, nrowB, ncolB, inc1B, inc2B, NULL) ;
DA2_init(C, nrowB, ncolB, inc1B, inc2B, NULL) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to initialize matrix objects",
        t2 - t1) ;
MARKTIME(t1) ;
DA2_fillRandomUniform(A, 0, 1, seed) ;
seed++ ;
MARKTIME(t2) ;
fprintf(msgFile, 
        "\n CPU : %.3f to fill matrix with random numbers", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n matrix A") ;
   DA2_writeForHumanEye(A, msgFile) ;
}
/*
   --------------------------------------------
   initialize the rowind[] and colind[] vectors
   --------------------------------------------
*/
MARKTIME(t1) ;
if ( nrowB < nrowA ) {
   rowind = IVinit(nrowA, -1) ;
   IVramp(nrowA, rowind, 0, 1) ;
   IVshuffle(nrowA, rowind, seed) ;
   seed++ ;
   IVqsortUp(nrowB, rowind) ;
} else {
   rowind = NULL ;
}
if ( ncolB < ncolA ) {
   colind = IVinit(ncolA, -1) ;
   IVramp(ncolA, colind, 0, 1) ;
   IVshuffle(ncolA, colind, seed) ;
   seed++ ;
   IVqsortUp(ncolB, colind) ;
} else {
   colind = NULL ;
}
MARKTIME(t2) ;
fprintf(msgFile, 
        "\n CPU : %.3f to fill row and column indices", t2 - t1) ;
if ( msglvl > 1 ) {
   if ( rowind == NULL ) {
      fprintf(msgFile, "\n rowind is NULL ") ;
   } else {
      fprintf(msgFile, "\n rowind :") ;
      IVfp80(msgFile, nrowB, rowind, 10, &ierr) ;
   }
   if ( colind == NULL ) {
      fprintf(msgFile, "\n colind is NULL ") ;
   } else {
      fprintf(msgFile, "\n colind :") ;
      IVfp80(msgFile, ncolB, colind, 10, &ierr) ;
   }
}
/*
   ----------------------------------------------
   gather the entries in the simple foolproof way
   ----------------------------------------------
*/
MARKTIME(t1) ;
for ( jj = 0 ; jj < ncolB ; jj++ ) {
   jcol = (colind != NULL) ? colind[jj] : jj ;
   for ( ii = 0 ; ii < nrowB ; ii++ ) {
      irow = (rowind != NULL) ? rowind[ii] : ii ;
      entry = DA2_entry(A, irow, jcol) ;
      DA2_setEntry(C, ii, jj, entry) ;
   }
}
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f foolproof gather", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n after the foolproof gather") ;
   fprintf(msgFile, "\n matrix C") ;
   DA2_writeForHumanEye(C, msgFile) ;
}
/*
   ------------------
   gather the entries
   ------------------
*/
MARKTIME(t1) ;
if ( flag == 1 ) {
   DA2_gather(B, A, rowind, colind) ;
} else if ( flag == 2 ) {
   DA2_gatherZero(B, A, rowind, colind) ;
}
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f fast gather", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n after the gather") ;
   fprintf(msgFile, "\n matrix B") ;
   DA2_writeForHumanEye(B, msgFile) ;
   fprintf(msgFile, "\n matrix A") ;
   DA2_writeForHumanEye(A, msgFile) ;
}
MARKTIME(t1) ;
/*
   -----------------
   compute the error
   -----------------
*/
DA2_sub(C, B) ;
fprintf(msgFile, "\n ||C-B||_F = %12.4e", DA2_frobNorm(C)) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n error matrix") ;
   DA2_writeForHumanEye(C, msgFile) ;
}

fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
