/*  testLocalMaxes.c  */

#include "../DA2.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   -------------------------------------------
   test the DA2_fastBunchParlettPivot() method

   created -- 97mar08, cca
   -------------------------------------------
*/
{
double   t1, t2, value ;
double   *vals ;
DA2      *a ;
FILE     *msgFile ;
int      ii, inc1, inc2, irow, jcol, msglvl, n, 
         nOnDiag, npivot, seed, tag ;
int      *cols, *mark, *rows ;

if ( argc != 7 ) {
   fprintf(stdout, 
"\n usage : testFastBunchParlettPivot msglvl msgFile n inc1 inc2 seed"
"\n    msglvl  -- message level"
"\n    msgFile -- message file"
"\n    n       -- # of rows and columns"
"\n    inc1    -- row increment"
"\n    inc2    -- column increment"
"\n    seed    -- random number seed"
"\n") ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
if ( (n = atoi(argv[3])) < 0 ) {
   fprintf(stderr, "\n matrix dimension must be positive\n") ;
   exit(-1) ;
}
inc1  = atoi(argv[4]) ;
inc2  = atoi(argv[5]) ;
seed  = atoi(argv[6]) ;
/*
   ----------------------------
   initialize the matrix object
   ----------------------------
*/
a = DA2_new() ;
MARKTIME(t1) ;
DA2_init(a, n, n, inc1, inc2, NULL) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to initialize %d x %d object",
        t2 - t1, n, n) ;
/*
   ------------------------
   fill with random entries
   ------------------------
*/
MARKTIME(t1) ;
DA2_fillRandomUniform(a, 0, 1, seed++) ;
for ( irow = 0 ; irow < n ; irow++ ) {
   for ( jcol = irow + 1 ; jcol < n ; jcol++ ) {
      DA2_setEntry(a, jcol, irow, 0.0) ;
   }
}
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to fill with random numbers", t2 - t1) ;
if ( msglvl > 3 ) {
   DA2_writeForHumanEye(a, msgFile) ;
}
/*
   ----------------------------------
   find the fast Bunch-Parlett pivots
   ----------------------------------
*/
mark = IVinit(n, -1) ;
rows = IVinit(n, -1) ;
cols = IVinit(n, -1) ;
vals = DVinit(n, -1) ;
tag  = -1 ;
for ( ii = npivot = nOnDiag = 0 ; ii < n ; ii++ ) {
   DA2_fastBunchParlettPivot(a, mark, tag, &irow, &jcol) ;
   if ( irow == -1 || jcol == -1 ) {
      break ;
   }
   if ( irow == jcol ) {
      nOnDiag++ ;
   }
   rows[npivot] = irow ;
   cols[npivot] = jcol ;
   vals[npivot] = value = DA2_entry(a, irow, jcol) ;

   mark[irow] = mark[jcol] = npivot ;

   if ( msglvl > 3 ) {
      fprintf(msgFile, "\n a(%d,%d) = %20.12e", irow, jcol, value) ;
   }
   npivot++ ;
}
fprintf(msgFile, "\n %d pivots found, %d on diagonal", 
        npivot, nOnDiag) ;

fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
