/*  test_copyEntriesToVector.c  */

#include "../DA2.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   ------------------------------------
   test the copyEntriesToVector routine

   created -- 97jun03, cca,dkw
   ------------------------------------
*/
{
DA2      *A ;
double   t1, t2 ;
double   *diagent, *entries, *upperent, *lowerent ;
FILE     *msgFile ;
int      copyflag, inc1, inc2, msglvl, ncol, nent, 
         nrow, seed, storeflag ;
int      total, nentD, nentU, nentL, nL, nU ;

if ( argc != 9 ) {
   fprintf(stdout, 
"\n\n usage : %s msglvl msgFile m n inc1 inc2 seed"
"\n    msglvl    -- message level"
"\n    msgFile   -- message file"
"\n    nrow      -- # of rows"
"\n    ncol      -- # of columns"
"\n    inc1      -- row increment"
"\n    inc2      -- column increment"
"\n    storeflag -- flag to denote how to store entries"
"\n        0 --> store by rows"
"\n        1 --> store by columns"
"\n    seed      -- random number seed"
"\n", argv[0]) ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
nrow = atoi(argv[3]) ;
ncol = atoi(argv[4]) ;
inc1 = atoi(argv[5]) ;
inc2 = atoi(argv[6]) ;
storeflag = atoi(argv[7]) ;
if ( nrow < 0 || ncol < 0 || inc1 < 1 || inc2 < 1 
   || storeflag < 0 || storeflag > 1 ) {
   fprintf(stderr, 
           "\n fatal error, nrow = %d, ncol = %d, inc1 = %d, inc2 = %d"
           "\n storeflag = %d",
           nrow, ncol, inc1, inc2, storeflag) ;
   exit(-1) ;
}
seed = atoi(argv[8]) ;
if ( msglvl > 0 ) {
   switch ( storeflag ) {
   case 0  : fprintf(msgFile, "\n\n STORE BY ROWS") ; break ;
   case 1  : fprintf(msgFile, "\n\n STORE BY COLUMNS") ; break ;
   default : break ;
   }
}
/*
   -----------------------------
   initialize the matrix objects
   -----------------------------
*/
MARKTIME(t1) ;
A     = DA2_new() ;
DA2_init(A, nrow, ncol, inc1, inc2, NULL) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to initialize matrix objects",
        t2 - t1) ;
MARKTIME(t1) ;
DA2_fillRandomUniform(A, 0.0, 1.0, seed) ;
MARKTIME(t2) ;
fprintf(msgFile, 
        "\n CPU : %.3f to fill matrix with random numbers", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n matrix A") ;
   DA2_writeForHumanEye(A, msgFile) ;
   fflush(msgFile) ;
}
/*
   -------------------------------------
   copy the diagonal entries to a vector
   -------------------------------------
*/
copyflag = 3 ;
nentD = ( nrow < ncol ? nrow : ncol ) ;
diagent = DVinit(nentD, 0.0) ;
MARKTIME(t1) ;
total = DA2_copyEntriesToVector(A, nentD, diagent, 
                                copyflag, storeflag) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to copy %d entries", t2 - t1, total) ;
fflush(msgFile) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n\n diagonal entries of A = %d", total) ;
   DVfprintf(msgFile, nentD, diagent) ;
   fflush(msgFile) ;
}
if ( total != nentD ) {
   fprintf(stderr, "\n whoa, error!"
           "\n %d diagonal entries, total = %d",
           nentD, total) ;
   exit(-1) ;
}
/*
   ----------------------------------
   copy the upper entries to a vector
   ----------------------------------
*/
copyflag = 4 ;
nU = ncol - nentD ;
nentU = (nentD*(nentD+1))/2 + nentD*nU ;
upperent = DVinit(nentU, 0.0) ;
MARKTIME(t1) ;
total = DA2_copyEntriesToVector(A, nentU, upperent, 
                                copyflag, storeflag) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to copy %d entries", t2 - t1, total) ;
fflush(msgFile) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n\n upper entries of A = %d", total) ;
   DVfprintf(msgFile, nentU, upperent) ;
   fflush(msgFile) ;
}
if ( total != nentU ) {
   fprintf(stderr, "\n whoa, error!"
           "\n %d upper entries, total = %d",
           nentU, total) ;
   exit(-1) ;
}
/*
   -----------------------------------------
   copy the strict upper entries to a vector
   -----------------------------------------
*/
copyflag = 5 ;
nU = ncol - nentD ;
nentU = (nentD*(nentD-1))/2 + nentD*nU ;
upperent = DVinit(nentU, 0.0) ;
MARKTIME(t1) ;
total = DA2_copyEntriesToVector(A, nentU, upperent, 
                                copyflag, storeflag) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to copy %d entries", t2 - t1, total) ;
fflush(msgFile) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n\n strict upper entries of A = %d", total) ;
   DVfprintf(msgFile, nentU, upperent) ;
   fflush(msgFile) ;
}
if ( total != nentU ) {
   fprintf(stderr, "\n whoa, error!"
           "\n %d strict upper entries, total = %d",
           nentU, total) ;
   exit(-1) ;
}
/*
   -----------------------------------------
   copy the strict lower entries to a vector
   -----------------------------------------
*/
copyflag = 1 ;
nL = nrow - nentD ;
nentL = (nentD*(nentD-1))/2 + nentD*nL ;
lowerent = DVinit(nentL, 0.0) ;
MARKTIME(t1) ;
total = DA2_copyEntriesToVector(A, nentL, lowerent, 
                                copyflag, storeflag) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to copy %d entries", t2 - t1, total) ;
fflush(msgFile) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n\n strict lower entries of A = %d", total) ;
   DVfprintf(msgFile, nentL, lowerent) ;
   fflush(msgFile) ;
}
if ( total != nentL ) {
   fprintf(stderr, "\n whoa, error!"
           "\n %d strict lower entries, total = %d",
           nentL, total) ;
   exit(-1) ;
}
/*
   ----------------------------------
   copy the lower entries to a vector
   ----------------------------------
*/
copyflag = 2 ;
nL = nrow - nentD ;
nentL = (nentD*(nentD+1))/2 + nentD*nL ;
lowerent = DVinit(nentL, 0.0) ;
MARKTIME(t1) ;
total = DA2_copyEntriesToVector(A, nentL, lowerent, 
                                copyflag, storeflag) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to copy %d entries", t2 - t1, total) ;
fflush(msgFile) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n\n lower entries of A = %d", total) ;
   DVfprintf(msgFile, nentL, lowerent) ;
   fflush(msgFile) ;
}
if ( total != nentL ) {
   fprintf(stderr, "\n whoa, error!"
           "\n %d lower entries, total = %d",
           nentL, total) ;
   exit(-1) ;
}
/*
   ----------------------------
   copy all entries to a vector
   ----------------------------
*/
copyflag = 6 ;
nent = nrow * ncol ;
entries = DVinit(nent, 0.0) ;
MARKTIME(t1) ;
total = DA2_copyEntriesToVector(A, nent, entries, 
                                copyflag, storeflag) ;
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to copy %d entries", t2 - t1, total) ;
fflush(msgFile) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n\n entries of A = %d", total) ;
   DVfprintf(msgFile, nent, entries) ;
   fflush(msgFile) ;
}
if ( total != nent ) {
   fprintf(stderr, "\n whoa, error!"
           "\n %d entries, total = %d",
           nent, total) ;
   exit(-1) ;
}
fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
