/*  test_QR.c  */

#include "../DA2.h"
#include "../../timings.h"

/*--------------------------------------------------------------------*/

void
main ( int argc, char *argv[] )
/*
   --------------------------------
   test the QR routine DA2_QRfactor

   created -- 97mar29, cca
   --------------------------------
*/
{
DA2      *a, *b, *H ;
double   ops, t1, t2 ;
DV       *betaDV ;
FILE     *msgFile ;
int      ierr, istep, major, msglvl, ncolA, ncolB, nrowA, 
         nstep, seed, size ;

if ( argc != 8 ) {
   fprintf(stdout, 
"\n\n usage : %s msglvl msgFile major nrowA ncolA ncolB seed "
"\n    msglvl  -- message level"
"\n    msgFile -- message file"
"\n    major   -- 0 for A row major, 1 for A column major"
"\n    nrowA   -- # of rows in A"
"\n    ncolA   -- # of columns in A"
"\n    ncolB   -- # of columns in B"
"\n    seed    -- random number seed"
"\n", argv[0]) ;
   return ;
}
if ( (msglvl = atoi(argv[1])) < 0 ) {
   fprintf(stderr, "\n message level must be positive\n") ;
   exit(-1) ;
}
if ( strcmp(argv[2], "stdout") == 0 ) {
   msgFile = stdout ;
} else if ( (msgFile = fopen(argv[2], "a")) == NULL ) {
   fprintf(stderr, "\n unable to open file %s\n", argv[2]) ;
   return ;
}
major = atoi(argv[3]) ;
nrowA = atoi(argv[4]) ;
ncolA = atoi(argv[5]) ;
ncolB = atoi(argv[6]) ;
if (  nrowA <= 0 || ncolA <= 0 || ncolB < 0 ) {
   fprintf(stderr, "\n invalid matrix dimensions"
           "\n nrowA = %d, ncolA = %d, ncolB = %d", 
           nrowA, ncolA, ncolB) ;
   exit(-1) ;
}
if ( major < 0 || major > 1 ) {
   fprintf(stderr, "\n invalid major values"
           "\n major = %d "
           "\n 0 --> row major, 1 --> column major\n", major) ;
   exit(-1) ;
}
seed = atoi(argv[7]) ;
fprintf(msgFile, "\n major = %d, nrowA = %d, ncolA = %d, ncolB = %d",
        major, nrowA, ncolA, ncolB) ;
fflush(msgFile) ;
/*
   -----------------------------
   initialize the matrix objects
   -----------------------------
*/
MARKTIME(t1) ;
a = DA2_new() ;
b = DA2_new() ;
if ( major == 0 ) {
   DA2_init(a, nrowA, ncolA, ncolA, 1, NULL) ;
   DA2_init(b, nrowA, ncolB, ncolB, 1, NULL) ;
} else {
   DA2_init(a, nrowA, ncolA, 1, nrowA, NULL) ;
   DA2_init(b, nrowA, ncolB, 1, nrowA, NULL) ;
}
MARKTIME(t2) ;
fprintf(msgFile, "\n CPU : %.3f to initialize matrix object",
        t2 - t1) ;
MARKTIME(t1) ;
DA2_fillRandomUniform(a, 0, 1, seed) ;
DA2_fillRandomUniform(b, 0, 1, seed+1) ;
MARKTIME(t2) ;
fprintf(msgFile, 
        "\n CPU : %.3f to fill matrix with random numbers", t2 - t1) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n matrix A") ;
   DA2_writeForHumanEye(a, msgFile) ;
   fprintf(msgFile, "\n matrix B") ;
   DA2_writeForHumanEye(b, msgFile) ;
}
/*
   --------------------------------
   set up the coefficient DV object
   --------------------------------
*/
betaDV = DV_new();
nstep = (ncolA < nrowA) ? ncolA : nrowA - 1 ;
DV_init(betaDV, nstep, NULL) ;
/*
   ----------------------------
   compute the QR factorization
   ----------------------------
*/
ops = 0.0 ;
for ( istep = 1, size = nrowA ; istep <= nstep ; istep++, size-- ) {
   ops += (3*size + 6 + (ncolA - istep)*(4*size - 2)) ;
}
MARKTIME(t1) ;
DA2_QRfactor(a, betaDV) ;
MARKTIME(t2) ;
fprintf(msgFile, 
"\n CPU : %.3f compute simplest QR, %.0f ops, %.3f megaflops", 
    t2 - t1, ops, 1.0e-6*ops/(t2 - t1)) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n A") ;
   DA2_writeForHumanEye(a, msgFile) ;
   fprintf(msgFile, "\n betaDV") ;
   DV_writeForHumanEye(betaDV, msgFile) ;
}
/*
   -------------------------------------
   apply the householder transformations
   -------------------------------------
*/
H = DA2_new() ;
DA2_subDA2(H, a, 0, nrowA - 1, 0, nstep - 1) ;
DA2_applyHouseholders(H, betaDV, b) ;
if ( msglvl > 3 ) {
   fprintf(msgFile, "\n b") ;
   DA2_writeForHumanEye(b, msgFile) ;
}

fprintf(msgFile, "\n") ;

return ; }

/*--------------------------------------------------------------------*/
