/*  util.c  */

#include "../CV.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------------
   shift the base of the entries and adjust the dimensions
   note: this is a dangerous operation because the iv->vec
   does not point to the base of the entries any longer,
   and thus if the object owns its entries and it is called
   to resize them or to free them, malloc and free will choke.

   USE WITH CAUTION!

   created  -- 97mar27, cca
   -----------------------------------------------------------
*/
void
CV_shiftBase (
   CV    *iv,
   int    offset
) {
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_shiftBase(%p,%d)"
           "\n bad input\n", iv, offset) ;
   exit(-1) ;
}
iv->vec     += offset ;
iv->size    -= offset ;
iv->maxsize -= offset ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------
   push an entry onto the list

   created -- 97mar27, cca
   -----------------------------
*/
void
CV_push (
   CV    *iv,
   int   val
) {
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_push(%p,%d)"
           "\n bad input\n", iv, val) ;
   exit(-1) ;
}
if ( iv->size == iv->maxsize ) {
   if ( iv->maxsize == 0 ) {
      CV_setMaxsize(iv, 10) ;
   } else {
      CV_setMaxsize(iv, 2*iv->maxsize) ;
   }
}
iv->vec[iv->size++] = val ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------
   return the number of bytes taken by the object

   created -- 97mar27, cca
   ----------------------------------------------
*/
int
CV_sizeOf ( 
   CV   *iv
) {
int   nbytes ;

if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_sizeOf(%p)"
           "\n bad input \n", iv) ;
   exit(-1) ;
}
nbytes = sizeof(struct _CV) ;
if ( iv->owned == 1 ) {
   nbytes += iv->maxsize * sizeof(char) ;
}
return(nbytes) ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------
   iterator :
   return the pointer to the head of the vector

   created -- 97mar27, cca
   --------------------------------------------
*/
char *
CV_first (
   CV   *iv
) {
char   *pc ;
/*
   ---------------
   check the input
   ---------------
*/
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_first(%p)"
           "\n bad input", iv) ;
   exit(-1) ;
}
if ( iv->size == 0 ) {
   pc = NULL ;
} else {
   pc = iv->vec ;
}
return(pc) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------------------------------------
   iterator :
   return the pointer to the next location in the vector

   created -- 97mar27, cca
   -----------------------------------------------------
*/
char *
CV_next (
   CV     *iv,
   char   *pc
) {
int   offset ;
/*
   ---------------
   check the input
   ---------------
*/
if ( iv == NULL || pc == NULL ) {
   fprintf(stderr, "\n fatal error in CV_next(%p,%p)"
           "\n bad input", iv, pc) ;
   fflush(stderr) ;
   exit(-1) ;
}
/*
   ---------------
   check the input
   ---------------
*/
if ( (offset = pc - iv->vec) < 0 || offset >= iv->size ) {
/*
   -----------------------------
   error, offset is out of range
   -----------------------------
*/
   fprintf(stderr, "\n fatal error in CV_next(%p,%p)"
           "\n offset = %d, must be in [0,%d)",
           iv, pc, offset, iv->size) ;
   fflush(stderr) ;
   exit(-1) ;
} else if ( offset == iv->size - 1 ) {
/*
   ----------------------------
   end of the list, return NULL
   ----------------------------
*/
   pc = NULL ;
} else {
/*
   ----------------------------------------
   middle of the list, return next location
   ----------------------------------------
*/
   pc++ ;
}
return(pc) ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------
   fill a vector with a value

   created -- 97mar27, cca
   --------------------------
*/
void
CV_fill (
   CV     *iv,
   char   value
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_fill(%p,%d)"
           "\n bad input\n", iv, value) ;
   exit(-1) ;
}
if ( iv->size > 0 ) {
   CVfill(iv->size, iv->vec, value) ;
}

return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------
   copy entries from iv2 into iv1.
   note: this is a "mapped" copy, 
   iv1 and iv2 need not be the same size.

   created -- 97mar27, cca
   --------------------------------------
*/
void
CV_copy (
   CV   *iv1,
   CV   *iv2
) {
int    ii, size ;
char   *vec1, *vec2 ;
/*
   ---------------
   check the input
   ---------------
*/
if ( iv1 == NULL || iv2 == NULL ) {
   fprintf(stderr, "\n fatal error in CV_copy(%p,%p)"
           "\n bad input\n", iv1, iv2) ;
   exit(-1) ;
}
size = iv1->size ;
if ( size > iv2->size ) {
   size = iv2->size ;
}
vec1 = iv1->vec ;
vec2 = iv2->vec ;
for ( ii = 0 ; ii < size ; ii++ ) {
   vec1[ii] = vec2[ii] ;
}
return ; }

/*--------------------------------------------------------------------*/
