/*  instance.c  */

#include "../CV.h"

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------------------------
   return value is 0 if the entries are not owned by the object
   otherwise the return value is the number of entries at the base
   storage of the vector

   created  -- 97mar27, cca
   ---------------------------------------------------------------
*/
int
CV_owned (
   CV   *iv
) {
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_owned(%p)"
           "\n bad input\n", iv) ;
   exit(-1) ;
}
return(iv->owned) ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   return the vector size

   created -- 97mar27, cca
   -----------------------
*/
int
CV_size (
   CV   *iv
) {
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_size(%p)"
           "\n bad input\n", iv) ;
   exit(-1) ;
}
return(iv->size) ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------------------
   return the maximum size of the vector

   created -- 97mar27, cca
   -------------------------------------
*/
int
CV_maxsize (
   CV   *iv
) {
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_maxsize(%p)"
           "\n bad input\n", iv) ;
   exit(-1) ;
}
return(iv->maxsize) ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------------
   return the loc'th entry of a vector.
   note: if loc is out of range then '\0' is returned

   created -- 97mar27, cca
   --------------------------------------------------
*/
char 
CV_entry (
   CV    *iv,
   int   loc
) {
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_entries(%p)"
           "\n bad input\n", iv) ;
   exit(-1) ;
}
if ( loc < 0 || loc >= iv->size ) {
   return('\0') ;
} else {
   return(iv->vec[loc]) ; 
}
}

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------
   return a pointer to the object's entries array

   created -- 97mar27, cca
   ----------------------------------------------
*/
char *
CV_entries (
   CV   *iv
) {
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_entries(%p)"
           "\n bad input\n", iv) ;
   exit(-1) ;
}
return(iv->vec) ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------------------------
   fill *psize with the vector's size
   and *pentries with the address of the vector

   created -- 97mar27, cca
   --------------------------------------------
*/
void
CV_sizeAndEntries (
   CV     *iv,
   int    *psize,
   char   **pentries
) {
if ( iv == NULL || psize == NULL || pentries == NULL ) {
   fprintf(stderr, "\n fatal error in CV_sizeAndEntries(%p,%p,%p)"
           "\n bad input\n", iv, psize, pentries) ;
   exit(-1) ;
}
*psize    = iv->size ;
*pentries = iv->vec  ;

return ; }

/*--------------------------------------------------------------------*/
/*
   ---------------------------
   set and entry in the vector

   created -- 97mar27, cca
   ---------------------------
*/
void
CV_setEntry ( 
   CV     *iv,
   int    loc,
   char   value
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( iv == NULL || loc < 0 ) {
   fprintf(stderr, "\n fatal error in CV_setEntry(%p,%d,%d)"
           "\n bad input\n", iv, loc, value) ;
   exit(-1) ;
}
if ( loc >= iv->maxsize ) {
   int newmaxsize = (int) 1.25*iv->maxsize ;
   if ( newmaxsize < 10 ) {
      newmaxsize = 10 ;
   }
   if ( loc >= newmaxsize ) {
      newmaxsize = loc + 1 ;
   }
   CV_setMaxsize(iv, newmaxsize) ;
}
if ( loc >= iv->size ) {
   iv->size = loc + 1 ;
}
iv->vec[loc] = value ;

return ; }
   
/*--------------------------------------------------------------------*/
