/*  init.C  */

#include "../CV.h"

/*--------------------------------------------------------------------*/
/*
   ---------------------------------------------
   simplest initialization method

   if entries != NULL
      the object does not own the entries,
      it just points to the entries base address
   else if size > 0
      the object will own the entries, 
      it allocates a vector of size int's.
   else 
      nothing happens
   endif

   created -- 97mar27, cca
   ---------------------------------------------
*/
void
CV_init (
   CV     *iv,
   int    size,
   char   *entries 
) {
if ( iv == NULL || size < 0 ) {
   fprintf(stderr, "\n fatal error in CV_init(%p,%d,%p)"
           "\n bad input\n", iv, size, entries) ;
   exit(-1) ;
}
/*
   --------------
   clear any data
   --------------
*/
CV_clearData(iv) ;
/*
   -----------------------------
   set the size and maximum size
   -----------------------------
*/
iv->maxsize = iv->size = size ;
/*
   -------------------------
   set vector and owner flag
   -------------------------
*/
if ( entries != NULL ) {
   iv->owned = 0 ;
   iv->vec   = entries ; 
} else if ( size > 0 ) {
   iv->owned = 1 ;
   iv->vec   = CVinit(size, -1) ;
}
return ; }
   
/*--------------------------------------------------------------------*/
/*
   -------------------------
   basic initializion method
 
   created -- 97mar27, cca
   -------------------------
*/
void
CV_init1 ( 
   CV    *iv,
   int   size
) {
CV_init(iv, size, NULL) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -------------------------
   total initializion method
 
   created -- 97mar27, cca
   -------------------------
*/
void
CV_init2 ( 
   CV     *iv,
   int    size, 
   int    maxsize, 
   int    owned, 
   char   *vec 
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_init2(%p,%d,%d,%d,%p)"
           "\n bad input\n", iv, size, maxsize, owned, vec) ;
   exit(-1) ;
}
if ( size < 0 || maxsize < size ) {
   fprintf(stderr, "\n fatal error in CV_init2(%p,%d,%d,%d,%p)"
           "\n size = %d, maxsize = %d \n", 
           iv, size, maxsize, owned, vec, size, maxsize) ;
   exit(-1) ;
}
if ( owned < 0 || 1 < owned ) {
   fprintf(stderr, "\n fatal error in CV_init2(%p,%d,%d,%d,%p)"
           "\n owned = %d\n", iv, size, maxsize, owned, vec, owned) ;
   exit(-1) ;
}
if ( owned == 1 && vec == NULL ) {
   fprintf(stderr, "\n fatal error in CV_init2(%p,%d,%d,%d,%p)"
           "\n owned = %d and vec = %p", 
           iv, size, maxsize, owned, vec, owned, vec) ;
   exit(-1) ;
} 
/*
   --------------
   clear any data
   --------------
*/
CV_clearData(iv) ;

if ( vec == NULL ) {
/*
   ----------------------------------------------
   no entries input, use the simplest initializer
   ----------------------------------------------
*/
   CV_init(iv, size, NULL) ;
} else {
/*
   ---------------------------------
   entries are input, set the fields
   ---------------------------------
*/
   iv->size    = size    ;
   iv->maxsize = maxsize ;
   iv->owned   = owned   ;
   iv->vec     = vec     ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   ----------------------------------
   set the maximum size of the vector

   created -- 97mar27, cca
   ----------------------------------
*/
void
CV_setMaxsize (
   CV    *iv,
   int   newmaxsize
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( iv == NULL || newmaxsize < 0 ) {
   fprintf(stderr, "\n fatal error in CV_setMaxsize(%p,%d)"
           "\n bad input\n", iv, newmaxsize) ;
   exit(-1) ;
}
if ( iv->maxsize > 0 && iv->owned == 0 ) {
   fprintf(stderr, "\n fatal error in CV_setMaxsize(%p,%d)"
           "\n iv->maxsize = %d, iv->owned = %d\n", 
           iv, newmaxsize, iv->maxsize, iv->owned) ;
   exit(-1) ;
}
if ( iv->maxsize != newmaxsize ) {
/*
   -----------------------------------
   allocate new storage for the vector
   -----------------------------------
*/
   char   *vec = CVinit(newmaxsize, -1) ;
   if ( iv->size > 0 ) {
/*
      ---------------------------------
      copy old entries into new entries
      ---------------------------------
*/
      if ( iv->vec == NULL ) {
         fprintf(stderr, "\n fatal error in CV_setMaxsize(%p,%d)"
                 "\n iv->size = %d, iv->vec is NULL\n", 
                 iv, newmaxsize, iv->size) ;
         exit(-1) ;
      }
      if ( iv->size <= newmaxsize ) {
/*
         -----------------------------------------
         new maximum size is greater than old size
         -----------------------------------------
*/
         CVcopy(iv->size, vec, iv->vec) ;
      } else {
/*
         -----------------------
         note, data is truncated
         -----------------------
*/
         CVcopy(newmaxsize, vec, iv->vec) ;
         iv->size = newmaxsize ;
      }
   }
   if ( iv->vec != NULL ) {
/*
      ----------------
      free old entries
      ----------------
*/
      CVfree(iv->vec) ;
   }
/*
   ----------
   set fields
   ----------
*/
   iv->maxsize = newmaxsize ;
   iv->owned   = 1 ;
   iv->vec     = vec ;
}
return ; }

/*--------------------------------------------------------------------*/
/*
   --------------------------
   set the size of the vector

   created -- 97mar27, cca
   --------------------------
*/
void
CV_setSize (
   CV    *iv,
   int   newsize
) {
/*
   ---------------
   check the input
   ---------------
*/
if ( iv == NULL || newsize < 0 ) {
   fprintf(stderr, "\n fatal error in CV_setSize(%p,%d)"
           "\n bad input\n", iv, newsize) ;
   exit(-1) ;
}
if ( 0 < iv->maxsize && iv->maxsize < newsize && iv->owned == 0 ) {
   fprintf(stderr, "\n fatal error in CV_setSize(%p,%d)"
           "\n iv->maxsize = %d, newsize = %d, iv->owned = %d\n", 
           iv, newsize, iv->maxsize, newsize, iv->owned) ;
   exit(-1) ;
}
if ( iv->maxsize < newsize ) {
/*
   -------------------------------------------------------------
   new size requested is more than maxsize, set new maximum size 
   -------------------------------------------------------------
*/
   CV_setMaxsize(iv, newsize) ;
}
iv->size = newsize ;

return ; }

/*--------------------------------------------------------------------*/
