/*  basics.C  */

#include "../CV.h"

/*--------------------------------------------------------------------*/
/*
   -----------------------
   constructor method

   created -- 97mar27, cca
   -----------------------
*/
CV *
CV_new ( 
   void 
) {
CV   *iv ;

ALLOCATE(iv, struct _CV, 1) ;

CV_setDefaultFields(iv) ;

return(iv) ; }
/*--------------------------------------------------------------------*/
/*
   -----------------------
   set the default fields

   created -- 97mar27, cca
   -----------------------
*/
void
CV_setDefaultFields ( 
   CV   *iv
) {
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_setDefaultFields(%p)"
           "\n bad input\n", iv) ;
   exit(-1) ;
}
iv->size    =   0  ;
iv->maxsize =   0  ;
iv->owned   =   0  ;
iv->vec     = NULL ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   clear the data fields

   created -- 97mar27, cca
   -----------------------
*/
void
CV_clearData ( 
   CV   *iv
) {
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_clearData(%p)"
           "\n bad input\n", iv) ;
   exit(-1) ;
}
if ( iv->vec != NULL && iv->owned == 1 ) {
   CVfree(iv->vec) ;
}
CV_setDefaultFields(iv) ;

return ; }

/*--------------------------------------------------------------------*/
/*
   -----------------------
   destructor

   created -- 97mar27, cca
   -----------------------
*/
void
CV_free ( 
   CV   *iv
) {
if ( iv == NULL ) {
   fprintf(stderr, "\n fatal error in CV_free(%p)"
           "\n bad input\n", iv) ;
   exit(-1) ;
}
CV_clearData(iv) ;
FREE(iv) ;

return ; }

/*--------------------------------------------------------------------*/
