/*  CV.h  */

#include "../cfiles.h"

/*--------------------------------------------------------------------*/
/*
   ----------------------------------------------------
   CV -- character vector object
 
   size    -- size of the vector
   maxsize -- maximum size of the vector
   owned   -- owner flag
      when == 1, storage pointed to by entries
      has been allocated here and can be free'd.
      when == 0, storage pointed to by entries
      has not been allocated here and cannot be free'd.
   vec -- pointer to base address
   ----------------------------------------------------
*/
typedef struct _CV   CV ;
struct _CV {
   int    size    ;
   int    maxsize ;
   int    owned   ;
   char   *vec    ;
} ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in basics.c ----------------------------------------
------------------------------------------------------------------------
*/
/*
   -----------------------
   constructor method
 
   created -- 97mar27, cca
   -----------------------
*/
CV *
CV_new ( 
   void 
) ;
/*
   -----------------------
   set the default fields
 
   created -- 97mar27, cca
   -----------------------
*/
void
CV_setDefaultFields ( 
   CV   *iv
) ;
/*
   -----------------------
   clear the data fields
 
   created -- 97mar27, cca
   -----------------------
*/
void
CV_clearData (
   CV   *iv
) ;
/*
   -----------------------
   destructor
 
   created -- 97mar27, cca
   -----------------------
*/
void
CV_free (
   CV   *iv
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in instance.c --------------------------------------
------------------------------------------------------------------------
*/
/*
   ---------------------------------------------------------------
   return value is 0 if the entries are not owned by the object
   otherwise the return value is the number of entries at the base
   storage of the vector
 
   created  -- 97mar27, cca
   ---------------------------------------------------------------
*/
int
CV_owned (
   CV   *iv
) ;
/*
   -----------------------
   return the vector size
 
   created -- 97mar27, cca
   -----------------------
*/
int
CV_size (
   CV   *iv
) ;
/*
   -------------------------------------
   return the maximum size of the vector
 
   created -- 97mar27, cca
   -------------------------------------
*/
int
CV_maxsize (
   CV   *iv
) ;
/*
   --------------------------------------------------
   return the loc'th entry of a vector.
   note: if loc is out of range then '\0' is returned
 
   created -- 97mar27, cca
   --------------------------------------------------
*/
char
CV_entry (
   CV    *iv,
   int   loc
) ;
/*
   ----------------------------------------------
   return a pointer to the object's entries array
 
   created -- 97mar27, cca
   ----------------------------------------------
*/
char *
CV_entries (
   CV   *iv
) ;
/*
   --------------------------------------------
   fill *psize with the vector's size
   and *pentries with the address of the vector
 
   created -- 97mar27, cca
   --------------------------------------------
*/
void
CV_sizeAndEntries (
   CV     *iv,
   int    *psize,
   char   **pentries
) ;
/*
   ---------------------------
   set and entry in the vector
 
   created -- 97mar27, cca
   ---------------------------
*/
void
CV_setEntry (
   CV     *iv,
   int    loc,
   char   value
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in init.c ------------------------------------------
------------------------------------------------------------------------
*/
/*
   ---------------------------------------------
   simplest initialization method
 
   if entries != NULL
      the object does not own the entries,
      it just points to the entries base address
   else if size > 0
      the object will own the entries, 
      it allocates a vector of size int's.
   else 
      nothing happens
   endif
 
   created -- 97mar27, cca
   ---------------------------------------------
*/
void
CV_init (
   CV     *iv,
   int    size,
   char   *entries 
) ;
/*
   -------------------------
   basic initializion method
 
   created -- 97mar27, cca
   -------------------------
*/
void
CV_init1 (
   CV    *iv,
   int   size
) ;
/*
   -------------------------
   total initializion method
 
   created -- 97mar27, cca
   -------------------------
*/
void
CV_init2 (
   CV     *iv,
   int    size,
   int    maxsize,
   int    owned,
   char   *vec
) ;
/*
   ----------------------------------
   set the maximum size of the vector
 
   created -- 97mar27, cca
   ----------------------------------
*/
void
CV_setMaxsize (
   CV    *iv,
   int   newmaxsize
) ;
/*
   --------------------------
   set the size of the vector
 
   created -- 97mar27, cca
   --------------------------
*/
void
CV_setSize (
   CV    *iv,
   int   newsize
) ;
/*--------------------------------------------------------------------*/
/*
------------------------------------------------------------------------
----- methods found in IO.c ----------------------------------------
------------------------------------------------------------------------
*/
/*
   ----------------------------------------------
   purpose -- to read in an CV object from a file
 
   input --
 
      fn -- filename, must be *.cvb or *.cvf
 
   return value -- 1 if success, 0 if failure
 
   created -- 97mar27, cca
   ----------------------------------------------
*/
int
CV_readFromFile ( 
   CV    *iv, 
   char   *fn 
) ;
/*
   -----------------------------------------------------
   purpose -- to read an CV object from a formatted file
 
   return value -- 1 if success, 0 if failure
 
   created -- 97mar27, cca
   -----------------------------------------------------
*/
int
CV_readFromFormattedFile (
   CV    *iv,
   FILE   *fp
) ;
/*
   ---------------------------------------------------
   purpose -- to read an CV object from a binary file
 
   return value -- 1 if success, 0  if failure
 
   created -- 97mar27, cca
   ---------------------------------------------------
*/
int
CV_readFromBinaryFile (
   CV    *iv,
   FILE   *fp
) ;
/*
   -------------------------------------------
   purpose -- to write an CV object to a file
 
   input --
 
      fn -- filename
        *.cvb -- binary
        *.cvf -- formatted
        anything else -- for human eye
 
   return value -- 1 if success, 0 otherwise
 
   created -- 97mar27, cca
   -------------------------------------------
*/
int
CV_writeToFile (
   CV    *iv,
   char   *fn
) ;
/*
   -----------------------------------------------------
   purpose -- to write an CV object to a formatted file
 
   return value -- 1 if success, 0 otherwise
 
   created -- 97mar27, cca
   -----------------------------------------------------
*/
int
CV_writeToFormattedFile (
   CV    *iv,
   FILE   *fp
) ;
/*
   --------------------------------------------------
   purpose -- to write an CV object to a binary file
 
   return value -- 1 if success, 0 otherwise
 
   created -- 97mar27, cca
   --------------------------------------------------
*/
int
CV_writeToBinaryFile (
   CV    *iv,
   FILE   *fp
) ;
/*
   -------------------------------------------------
   purpose -- to write an CV object for a human eye
 
   return value -- 1 if success, 0 otherwise
 
   created -- 97mar27, cca
   -------------------------------------------------
*/
int
CV_writeForHumanEye (
   CV    *iv,
   FILE   *fp
) ;
/*
   ---------------------------------------------------------
   purpose -- to write out the statistics for the CV object
 
   return value -- 1 if success, 0 otherwise
 
   created -- 97mar27, cca
   ---------------------------------------------------------
*/
int
CV_writeStats (
   CV    *iv,
   FILE   *fp
) ;
/*
   -------------------------------------------------------------------
  purpose -- to write out an integer vector with eighty column lines
 
   input --
 
      fp     -- file pointer, must be formatted and write access
      column -- present column
      pierr  -- pointer to int to hold return value,
                should be 1 if any print was successful,
                if fprintf() failed, then ierr = -1
 
   return value -- present column
 
   created -- 97mar27, cca
   -------------------------------------------------------------------
*/
int
CV_fp80 (
   CV     *iv,
   FILE   *fp,
   int    column,
   int    *pierr
) ;
/*--------------------------------------------------------------------*/
