#
#  Rules for the level-1 makefiles.
#

#
#  Default target is help.
#  In the local makefiles, this target can be expanded.
#
help::
	@echo "usage:"
	@echo "   make src     - make all source files"
	@echo "   make nosrc   - remove all source files"
	@echo "   make obj     - make all object files"
	@echo "   make noobj   - remove all object files"

#
#  exe     - make all executable files.
#
exe:	$(EXE)
	@true

#
#  noexe   - remove all executable files.
#
noexe:
	@rm -f $(EXE)

#
#  lib     - make the library
#
lib:	$(LIB)
	@true

#
#  nolib   - remove the library
#
nolib:
	@rm -f $(LIB)

#
#  obj     - make all object files.
#
obj:	$(OBJ)
	@true

#
#  noobj   - remove all object files.
#
noobj:
	@rm -f $(OBJ)

#
#  src     - make all source files.
#
src:	$(SRC)
	@true

#
#  nosrc   - remove all source files.
#
nosrc:
	@rm -f $(SRC)

#
#  clean   - make noexe nolib noobj nosrc
#
clean::	noexe nolib noobj nosrc
