C**********************************************************************
C
C     Copyright (C) 1991-1992  Roland W. Freund and Noel M. Nachtigal
C     All rights reserved.
C
C     This code is part of a copyrighted package.  For details, see the
C     file "cpyrit.doc" in the top-level directory.
C
C     *****************************************************************
C     ANY USE OF  THIS CODE CONSTITUTES ACCEPTANCE OF  THE TERMS OF THE
C                             COPYRIGHT NOTICE
C     *****************************************************************
C
C**********************************************************************
C
      PROGRAM COOCSR
C
C     This program converts a COO data file to CSR format.
C
C     NOTE: This code uses an input format that, while valid on the Sun
C     and Cray compilers, might not be accepted  by other compilers. In
C     particular, the construct
C        WRITE (6,'(A30,$)') 'This is a test'
C     is used to prevent  the output processor from  moving to the next
C     line after writing the text.  If this construct  is not supported
C     by the compiler, remove the dollar sign ($).
C
C     Noel M. Nachtigal
C     October 04, 1992
C
C**********************************************************************
C
      INTRINSIC CDABS, MAX0
      EXTERNAL ZSPSRT, ZSPWAS
C
C     Compilation parameters.
C
      INTEGER NDIM
      PARAMETER (NDIM=5000)
      INTEGER NZMAX
      PARAMETER (NZMAX=100000)
C
C     Local variables.
C
      CHARACTER ANS*1, FNAME*32, GUESOL*2, KEY*8, TITLE*72, TYPE*3
      INTEGER I, J, K, NNZ, NCOL, NROW, IA(NDIM+1), JA(NZMAX)
      DOUBLE COMPLEX A(NZMAX), ZTMP
C
C     Get the COO data file from the user.
C
 10   WRITE (6,'(A26,$)') 'Enter COO data file name: '
      READ (5,'(A32)') FNAME
C
C     Initialize the counters.
C
      DO 20 I = 1, NDIM+1
        IA(I) = 0
 20   CONTINUE
      NCOL = 0
      NROW = 0
      NNZ  = 0
C
C     Open the file.
C
      OPEN (10,FILE=FNAME,STATUS='old',ERR=100)
C
C     Skip over any header lines.
C
      WRITE (6,'(A30,$)') 'Enter number of header lines: '
      READ (5,*) J
      DO 30 I = 1, J
         READ (10,'(A80)',END=110,ERR=110) TITLE
 30   CONTINUE
C
C     Now read in the rest of the matrix.
C
 40   READ (10,*,END=60,ERR=60) I, J, ZTMP
      IF (CDABS(ZTMP).EQ.0.0D0) GO TO 40
      IF (NNZ.GE.NZMAX) GO TO 120
      NNZ = NNZ + 1
      IF (I.NE.NROW) THEN
         IF (I.GT.NDIM) GO TO 130
         DO 50 K = NROW+1, I
           IA(K) = NNZ
 50      CONTINUE
         NROW = I
      END IF
      JA(NNZ) = J
      A(NNZ)  = ZTMP
      NCOL    = MAX0(J,NCOL)
      GO TO 40
 60   CLOSE(10)
      IA(NROW+1) = NNZ+1
C
C     Output some stats.
C
      WRITE (6,'(A7,I10)') 'NROW  :',NROW
      WRITE (6,'(A7,I10)') 'NCOL  :',NCOL
      WRITE (6,'(A7,I10)') 'NNZ   :',NNZ
      IF ((NROW.EQ.0).OR.(NCOL.EQ.0).OR.(NNZ.EQ.0)) THEN
         WRITE (6,'(A28)') 'Empty matrix, nothing to do.'
         GO TO 90
      ELSE IF (NROW.NE.NCOL) THEN
         WRITE (6,'(A35)') 'Rectangular matrices not supported.'
         GO TO 90
      END IF
C
C     Order the indices in ascending order.
C
      DO 70 I = 1, NROW
         K = IA(I)
         J = IA(I+1) - K
         CALL ZSPSRT (J,A(K),JA(K))
 70   CONTINUE
C
C     Get the remaining parameters.
C
 80   TYPE = 'CUA'
      GUESOL = 'NN'
      WRITE (6,'()')
      WRITE (6,'(A26,$)') 'Enter the title (max 72): '
      READ (5,'(A72)') TITLE
      WRITE (6,'(A26,$)') 'Enter the key (max 8)   : '
      READ (5,'(A8)') KEY
      WRITE (6,'(A26,$)') 'Symmetric matrix (Y/N) ?  '
      READ (5,'(A1)') ANS
      IF ((ANS.EQ.'Y').OR.(ANS.EQ.'y')) TYPE = 'CSA'
C
C     Output the matrix parameters.
C
      WRITE (6,'()')
      WRITE (6,'(A7,I10)') 'NDIM  :',NDIM
      WRITE (6,'(A7,I10)') 'NZMAX :',NZMAX
      WRITE (6,'(A7,A10)') 'GUESOL:',GUESOL
      WRITE (6,'(A7,I10)') 'NROW  :',NROW
      WRITE (6,'(A7,I10)') 'NCOL  :',NCOL
      WRITE (6,'(A7,I10)') 'NNZ   :',NNZ
      WRITE (6,'(A7,A73)') 'TITLE :',TITLE
      WRITE (6,'(A7,A10)') 'KEY   :',KEY
      WRITE (6,'(A7,A10)') 'TYPE  :',TYPE
      WRITE (6,'()')
      WRITE (6,'(A19,$)') 'Is this OK (Y/N) ? '
      READ (5,'(A1)') ANS
      IF ((ANS.NE.'Y').AND.(ANS.NE.'y')) GO TO 80
C
      WRITE (6,'(A29,$)') 'How many digits to print:    '
      READ (5,*) I
C
C     Write out the matrix.
C
      WRITE (6,'(A29,$)') 'Enter output data file name: '
      READ (5,'(A32)') FNAME
      OPEN (10,FILE=FNAME)
      CALL ZSPWAS (NROW,NCOL,A,IA,JA,TITLE,KEY,TYPE,I,10,J)
C
C     Do it again?
C
 90   CLOSE(10)
      WRITE (6,'(A24,$)') 'Convert another (Y/N) ? '
      READ (5,'(A1)') ANS
      IF ((ANS.EQ.'Y').OR.(ANS.EQ.'y')) GO TO 10
C
C     Done.
C
      STOP
C
C     Handle any errors.
C
 100  WRITE (6,'(A30)') 'Data file could not be opened.'
      GO TO 90
 110  WRITE (6,'(A41)') 'Data file should have three header lines.'
      GO TO 90
 120  WRITE (6,'(A41)') 'Too much data in file --- increase NZMAX.'
      GO TO 90
 130  WRITE (6,'(A40)') 'Too much data in file --- increase NDIM.'
      GO TO 90
C
      END
C
C**********************************************************************
