C     SUBROUTINE ZSWPRT(M,N,FIDA,DESCRA,A,IA1,IA2,
C                      INFOA,IOUT,IERROR)
C     Purpose
C     =======
C
C     Print sparse matrix: call internal drivers according to
c     sparse matrix kind.
C
C     Parameters
C     ==========
C
C     M        - INTEGER
C             On entry: number of rows of matrix A 
C             Unchanged on exit.
C
C     N        - INTEGER
C             On entry: number of columns of matrix A
C             Unchanged on exit.
C
C     FIDA     - CHARACTER*5
C             On entry FIDA defines the format of the input sparse matrix.
C             Unchanged on exit.
C
C     DESCRA   - CHARACTER*1 array of DIMENSION (9)
C             On entry DESCRA describes the characteristics of the input
C             sparse matrix.
C             Unchanged on exit.
C
C     A        - DOUBLE COMPLEX   array of DIMENSION (*)
C             On entry A specifies the values of the input sparse
C             matrix.
C             Unchanged on exit.
C
C     IA1      - INTEGER array of dimension (*)
C             On entry IA1 holds integer information on input sparse
C             matrix.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     IA2      - INTEGER array of dimension (*)
C             On entry IA2 holds integer information on input sparse
C             matrix.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     INFOA     - INTEGER array of length 10.
C             On entry can hold auxiliary information on input matrices
C             formats or environment of subsequent calls.
C             Might be changed on exit.
C
C     IOUT    - INTEGER
C             FORTRAN unit to use for printing.
C             Unchanged on exit.
C
C
C     IERROR   - INTEGER
C             On exit IERROR contains the value of error flag as follows:
C             IERROR = 0   no error
C             IERROR > 0   warning
C             IERROR < 0   fatal error
C
C     Note
C     ====
C     All checks on argument are performed in the calling routine.
C
C
      SUBROUTINE ZSWPRT(M,N,FIDA,DESCRA,A,IA1,IA2,INFOA,IOUT,IERROR)
C     .. Scalar Arguments ..
      INTEGER       M,N,K,LDB,LDC,IOUT,IERROR
      CHARACTER     TRANS
C     .. Array Arguments ..
      INTEGER       IA1(*),IA2(*),INFOA(*)
      CHARACTER     DESCRA*11, FIDA*5
      DOUBLE COMPLEX    A(*)
C     .. Executable Statements ..
C
C     Switching on FIDA: proper sparse BLAS routine is selected
C     according to data structure
C
      IF (FIDA(1:3).EQ.'CSR') THEN
C
C        A, IA1, IA2 --->  AR,   JA,   IA
C                         VAL, INDX, PNTR
C        INFOA(*) not used
 
        CALL  ZCSRPRT(M,N,DESCRA,A,IA1,IA2,IOUT)
      ELSE IF (FIDA(1:3).EQ.'COO') THEN
C
C        A, IA1, IA2 --->  AR,   JA,   IA
C                         VAL, INDX, PNTR
C        INFOA(*) not used
         CALL  ZCOOPRT(M,N,DESCRA,A,IA1,IA2,INFOA,IOUT)
      ELSE


C
C     This data structure not yet considered
C
         IERROR = 3010
      END IF

      RETURN
      END
