C     DOUBLE PRECISION FUNCTION ZCSMAX(TRANS,M,N,FIDA,DESCRA,A,IA1,IA2,      &
C    &                 INFOA,IERROR)
C     Purpose
C     =======
C
C     Computing infinite norm for matrix A
C                 ZCSMAX = NRMI(A)
C
C     Parameters
C     ==========
C
C     TRANS    - CHARACTER*1
C             On entry TRANS specifies if the routine operates with matrix A
C             or with the transpose of A as follows:
C                TRANS = 'N'         ->  use matrix A
C                TRANS = 'T'         ->  use A' (transpose of matrix A)
C                TRANS = 'C'         ->  use conjugate transpose of A
C             Unchanged on exit.
C
C     M        - INTEGER
C             On entry: number of rows of matrix A (A') and
C                       number of rows of matrix C
C             Unchanged on exit.
C
C     N        - INTEGER
C             On entry: number of columns of matrix B
C             and number of columns of matrix C.
C             Unchanged on exit.
C
C     FIDA     - CHARACTER*5
C             On entry FIDA defines the format of the input sparse matrix.
C             Unchanged on exit.
C
C     DESCRA   - CHARACTER*1 array of DIMENSION (9)
C             On entry DESCRA describes the characteristics of the input
C             sparse matrix.
C             Unchanged on exit.
C
C     A        - COMPLEX*16 array of DIMENSION (*)
C             On entry A specifies the values of the input sparse
C             matrix.
C             Unchanged on exit.
C
C     IA1      - INTEGER array of dimension (*)
C             On entry IA1 holds integer information on input sparse
C             matrix.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     IA2      - INTEGER array of dimension (*)
C             On entry IA2 holds integer information on input sparse
C             matrix.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     INFOA     - INTEGER array of length 10.
C             On entry can hold auxiliary information on input matrices
C             formats or environment of subsequent calls.
C             Might be changed on exit.
C
C     IERROR   - INTEGER
C             On exit IERROR contains the value of error flag as follows:
C             IERROR = 0   no error
C             IERROR > 0   warning
C             IERROR < 0   fatal error
C
C
      DOUBLE PRECISION FUNCTION ZCSMAX(TRANS,M,N,FIDA,DESCRA,A,IA1,IA2,
     &                 INFOA,IERROR)
      IMPLICIT NONE
C     .. Scalar Arguments ..
      INTEGER    M,N, IERROR
      CHARACTER  TRANS
C     .. Array Arguments ..
      INTEGER    IA1(*),IA2(*),INFOA(*)
      CHARACTER  DESCRA*11, FIDA*5
      COMPLEX*16 A(*)
C     .. Local Array..
      INTEGER    INT_VAL(5)
      COMPLEX*16 Z_VAL(5)
      CHARACTER*30 NAME,  STRINGS(2)
C     .. Parameters ..
      COMPLEX*16 ZERO
      INTEGER    IONE
      PARAMETER  (ZERO = (0.D0, 0.D0), IONE=1)
C     .. External Subroutines ..
      DOUBLE PRECISION  ZCRNRMI, ZJDNRMI
      EXTERNAL          ZCRNRMI, ZJDNRMI
C     .. Executable Statements ..
C
C     Check for argument errors
C
      
      IF     (M.LT.0) THEN
         NAME = 'ZCSMAX\0'
         IERROR = 10
         INT_VAL(1) = 2
         INT_VAL(2) = M
      ELSE IF (N.LT.0) THEN
         NAME = 'ZCSMAX\0'
         IERROR = 10
         INT_VAL(1) = 3
         INT_VAL(2) = N
      ELSE IF (TRANS.NE.'T' .AND. TRANS.NE.'N' .AND. TRANS.NE.'C') THEN
         NAME = 'ZCSMAX\0'
         IERROR = 40
         INT_VAL(1) = 1
         STRINGS(1) = TRANS//'\0'
      ENDIF

C
C     Error handling
C
      IF(IERROR.NE.0) THEN
         CALL ZSPERROR(IERROR,NAME,STRINGS,INT_VAL,Z_VAL)
         GOTO 9999
      ENDIF

C
C     Check for M, N, K
C
      IF(M.LE.0 .OR. N.LE.0) THEN
         GOTO 9999
      ENDIF

      IF (FIDA(1:3).EQ.'CSR') THEN
         ZCSMAX = ZCRNRMI(TRANS,M,N,DESCRA,A,IA1,IA2,
     +      INFOA,IERROR)
      ELSE IF (.TRUE.) THEN
C                                                                      
C        Subroutines involving formats other than CSR
C        not yet implemented                                         
C                                                                        
         IERROR = 3010
         STRINGS(1) = FIDA//'\0'
         NAME = 'ZCSMAX\0'
         CALL ZSPERROR(IERROR,NAME,STRINGS,INT_VAL,Z_VAL)
         GOTO 9999        
      ELSE IF (FIDA(1:3).EQ.'JAD') THEN
C         ZCSMAX = ZJDNRMI(TRANS,M,N,DESCRA,A,IA1,IA2,
C     +      INFOA,IERROR)
      ENDIF

 9999 CONTINUE
      RETURN
      END
