      SUBROUTINE ZCSINS(M,N,FIDA,DESCRA,A,IA1,IA2,
     +   INFOA,IA,JA,LA,LIA1,LIA2,LATOT,LIA1TOT,LIA2TOT,
     +   FIDH,DESCRH,H,IH1,IH2,INFOH,IH,JH,WORK,LWORK,IERROR)
      IMPLICIT   NONE                                                      
C     .. Scalar Arguments ..                                             
      INTEGER    LWORK, M, N, IERROR, LA, LIA1, LIA2
      INTEGER    LATOT,LIA1TOT,LIA2TOT,IA,JA,IH,JH
C     .. Array Arguments ..                                              
      COMPLEX*16 A(*), H(*), WORK(LWORK)                     
      INTEGER    IA1(*), IA2(*), IH1(*), IH2(*),
     +   INFOA(*), INFOH(*)                         
      CHARACTER  FIDA*5, FIDH*5, DESCRA*11, DESCRH*11
C     .. Local Array..
      INTEGER    INT_VAL(5), IERRV(5)
      COMPLEX*16 Z_VAL(5)
      CHARACTER*30 NAME,  STRINGS(2)
C     .. External Subroutines ..                                         
C      EXTERNAL   ZCRINCO
C                                                                        
C     .. Executable Statements ..                                        
C                                                                        
C                                                                        
C     Check parameters                                                   
C                                                                        
      IERROR = 0

      IF (M.LT.0) THEN
        NAME = 'ZCSDP\0'
        IERROR = 10
        INT_VAL(1) = 1
        INT_VAL(2) = M
      ELSE IF (N.LT.0) THEN
        NAME = 'ZCSDP\0'
        IERROR = 10
        INT_VAL(1) = 2
        INT_VAL(2) = N
      ENDIF
C                                                                        
C     Error handling                                                     
C                                                                        
      IF(IERROR.NE.0) THEN
        CALL ZSPERROR(IERROR,NAME,STRINGS,INT_VAL,Z_VAL)
        GOTO 9999
      ENDIF

C                                                                        
C     Check for M, N                                                     
C                                                                        
      IF(M.LE.0 .OR. N.LE.0) THEN                                        
        GOTO 9999                                                       
      ENDIF
      
C                                                                        
C     Switching on FIDA                                               
C
C     COO format not yet supported
      IF ((FIDA(1:3).EQ.'COO').OR.(FIDA(1:3).EQ.'COI')) THEN                              
        IF (FIDH(1:3).EQ.'CSR') THEN
C
C           Submatrix H in CSR format into A matrix in COO format
C
            CALL ZCRINCO(M,N,DESCRA,A,IA1,IA2,
     +         INFOA,IA,JA,LA,LIA1,LIA2,LATOT,LIA1TOT,LIA2TOT,
     +         DESCRH,H,IH1,IH2,INFOH,IH,JH,WORK,LWORK,IERRV)
          IF (IERRV(1).EQ.10) THEN
            IERROR = 60
            NAME = 'ZCSINS\0'
            INT_VAL(1) = 14
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LATOT
          ELSE IF (IERRV(1).EQ.20) THEN
            IERROR = 60
            NAME = 'ZCSINS\0'
            INT_VAL(1) = 15
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LIA1TOT
          ELSE IF (IERRV(1).EQ.30) THEN
            IERROR = 60
            NAME = 'ZCSINS\0'
            INT_VAL(1) = 16
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LIA2TOT
          END IF
        ELSE
          IERROR = 3010
          STRINGS(1) = FIDH(1:3)
          NAME = 'ZCSINS\0'
        ENDIF
      ELSE
        IERROR = 3010
        STRINGS(1) = FIDH(1:3)
        NAME = 'ZCSINS\0'
      ENDIF

      CALL ZSPERROR(IERROR,NAME,STRINGS,INT_VAL,Z_VAL)
 9999 CONTINUE
      END

