C   SUBROUTINE DCSPRT(M,N,FIDA,DESCRA,A,IA1,IA2,INFOA,IOUT,IERROR)
C     Purpose
C     =======
C
C     Print a sparse matrix on file. 
C
C     Parameters
C     ==========
C
C     M        - INTEGER
C             On entry: number of rows of matrix A 
C             Unchanged on exit.
C
C     N        - INTEGER
C             On entry: number of columns of matrix A
C             Unchanged on exit.
C
C     FIDA    - CHARACTER*5
C             On entry FIDA describes the storage format of the input
C             sparse matrix.
C             Unchanged on exit.
c 
C     DESCRA   - CHARACTER*11 
C             On entry DESCRA describes the characteristics of the input
C             sparse matrix.
C             Unchanged on exit.
C
C     A        - DOUBLE PRECISION array of DIMENSION (*)
C             On entry A specifies the values of the input sparse
C             matrix.
C             Unchanged on exit.
C
C     IA1      - INTEGER array of dimension (*)
C             On entry IA1 holds integer information on input sparse
C             matrix.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     IA2      - INTEGER array of dimension (*)
C             On entry IA2 holds integer information on input sparse
C             matrix.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     INFOA     - INTEGER array of length 10.
C             On entry can hold auxiliary information on input matrices
C             formats or environment of subsequent calls.
C             Might be changed on exit.
C
C     IOUT    - INTEGER
C             A valid Fortran unit number to print to.
C             Unchanged on exit.
C
C     IERROR   - INTEGER
C             On exit IERROR contains the value of error flag as follows:
C             IERROR = 0   no error
C             IERROR > 0   warning
C             IERROR < 0   fatal error
C
C
C  We should probably define specialized output formats, with an input 
C  parameter to choose among Harwell-Boeng, MatrixMarket etc. 
C
C
      SUBROUTINE DCSPRT(M,N,FIDA,DESCRA,A,IA1,IA2,INFOA,IOUT,IERROR)
      IMPLICIT NONE
C     .. Scalar Arguments ..
      INTEGER           M,N,K,LDB,LDC,LWORK, IERROR,IOUT
      CHARACTER         TRANS
      DOUBLE PRECISION  ALPHA,BETA
C     .. Array Arguments ..
      INTEGER           IA1(*),IA2(*),INFOA(*)
      CHARACTER         DESCRA*11, FIDA*5
      DOUBLE PRECISION  A(*)
C     .. Local Scalars ..
      INTEGER           LWORKM,  LWORKB, LWORKC, LWORKS, P
      LOGICAL           LP, RP
C     .. Local Array..
      INTEGER           INT_VAL(5)
      DOUBLE PRECISION  REAL_VAL(5)
      CHARACTER*30      STRINGS(2)
      CHARACTER         NAME*30
C     .. Parameters ..
      DOUBLE PRECISION  ZERO
      INTEGER           IONE
      PARAMETER         (ZERO=0.D0,IONE=1)
C     .. Intrinsic Functions ..
      INTRINSIC         DBLE, IDINT
C     .. Executable Statements ..
C
C     Check for argument errors
C
      IERROR = 0
      NAME = 'DCSPRT'
      IF   (M.LT.0) THEN
         IERROR = 10
         INT_VAL(1) = 2
         INT_VAL(2) = M
      ELSE IF (N.LT.0) THEN
         IERROR = 10
         INT_VAL(1) = 3
         INT_VAL(2) = N
      ELSE IF (IOUT.LT.0) THEN
         IERROR = 11
         INT_VAL(1) = 3
         INT_VAL(2) = N
      ENDIF

C
C     Error handling
C
      IF (IERROR.NE.0) THEN
         CALL SPERROR(IERROR,NAME,STRINGS,INT_VAL,REAL_VAL)
         GOTO 9999
      ENDIF
      CALL DSWPRT(M,N,FIDA,DESCRA,A,IA1,IA2,INFOA,IOUT,IERROR)
      IF(IERROR .NE. 0) THEN
        NAME = 'DCSPRT\0'
        IF (IERROR.EQ.3010) THEN
          STRINGS(1) = FIDA//'\0'
          CALL SPERROR(IERROR,NAME,STRINGS,INT_VAL,REAL_VAL)
        ENDIF
      ENDIF

 9999 CONTINUE


      RETURN
      END



