C      SUBROUTINE DCSINS(M,N,FIDA,DESCRA,A,IA1,IA2,
C     +   INFOA,IA,JA,LA,LIA1,LIA2,LATOT,LIA1TOT,LIA2TOT,
C     +   FIDH,DESCRH,H,IH1,IH2,INFOH,IH,JH,WORK,LWORK,IERROR)
C     Purpose
C     =======
C
C     ... Insert a sparse block H in existing sparse matrix A ...
C
C     Parameters
C     ==========
C
C     M        - INTEGER
C             On entry: number of rows of matrix H to insert 
C             in matrix A
C             Unchanged on exit.
C
C     N        - INTEGER
C             On entry: number of columns of matrix H
C             to insert in matrix A.
C             Unchanged on exit.
C
C     FIDA     - CHARACTER*5
C             On entry FIDA defines the format of the input sparse matrix.
C             Unchanged on exit.
C
C     DESCRA   - CHARACTER*1 array of DIMENSION (9)
C             On entry DESCRA describes the characteristics of the input
C             sparse matrix.
C             Unchanged on exit.
C
C     A        - DOUBLE PRECISION array of DIMENSION (*)
C             On entry A specifies the values of the input sparse
C             matrix.
C             Unchanged on exit.
C
C     IA1      - INTEGER array of dimension (*)
C             On entry IA1 holds integer information on input sparse
C             matrix.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     IA2      - INTEGER array of dimension (*)
C             On entry IA2 holds integer information on input sparse
C             matrix.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     INFOA     - INTEGER array of length 10.
C             On entry can hold auxiliary information on input matrices
C             formats or environment of subsequent calls.
C             Might be changed on exit.
C
C     IA       - INTEGER
C             Specify the first row to insert in matrix A.
C             Unchanged on exit.
C
C     JA       - INTEGER
C             Specify the first column to insert in matrix A.
C             Unchanged on exit.
C
C     LA       - INTEGER
C             Specify number of elements in A.
C             Unchanged on exit.
C
C     LIA1      - INTEGER
C             Specify number of elements in IA1.
C             Unchanged on exit.
C
C     LIA2      - INTEGER
C             Specify number of elements in IA2.
C             Unchanged on exit.
C
C     LATOT    - INTEGER
C             Specify lenght of input array A.
C             Unchanged on exit.
C
C     LIA1TOT  - INTEGER
C             Specify lenght of input array IA1.
C             Unchanged on exit.
C
C     LIA2TOT  - INTEGER
C             Specify lenght of input array IA2.
C             Unchanged on exit.
C
C     FIDH     - CHARACTER*5
C             On entry FIDH defines the format of the sparse matrix 
C             to insert.
C             Unchanged on exit.
C
C     DESCRH   - CHARACTER*1 array of DIMENSION (9)
C             On entry DESCRH describes the characteristics of the
C             sparse matrix to insert.
C             Unchanged on exit.
C
C     H        - DOUBLE PRECISION array of DIMENSION (*)
C             On entry H specifies the values of the sparse
C             matrix to insert.
C             Unchanged on exit.
C
C     IH1      - INTEGER array of dimension (*)
C             On entry IH1 holds integer information on sparse matrix
C             to insert.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     IH2      - INTEGER array of dimension (*)
C             On entry IH2 holds integer information on sparse matrix
C             to insert.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     INFOH     - INTEGER array of length 10.
C             On entry can hold auxiliary information on matrices
C             formats or environment of subsequent calls.
C             Might be changed on exit.
C
C     IH       - INTEGER
C             Specify the first row of H to insert in matrix A.
C             Unchanged on exit.
C
C     JH       - INTEGER
C             Specify the first column of H to insert in matrix A.
C             Unchanged on exit.
C
C     WORK     - DOUBLE PRECISION array of dimension (LWORK)
C             On entry: work area.
C             On exit INT(WORK(1)) contains the minimum value
C             for LWORK satisfying DCSMM memory requirements.
C
C     LWORK    - INTEGER
C             On entry LWORK specifies the dimension of WORK
C             LWORK should be set as follows:
C                LWORK = (LWORK for DxxxMM) + Pr*K*N + Pl*M*N
C             where Pr Pl = 1 if right left permutation has to
C             be performed, 0 otherwise.
C             Unchanged on exit.
C
C     IERROR   - INTEGER
C             On exit IERROR contains the value of error flag as follows:
C             IERROR = 0   no error
C             IERROR > 0   warning
C             IERROR < 0   fatal error
C

      SUBROUTINE DCSINS(M,N,FIDA,DESCRA,A,IA1,IA2,
     +   INFOA,IA,JA,LA,LIA1,LIA2,LATOT,LIA1TOT,LIA2TOT,
     +   FIDH,DESCRH,H,IH1,IH2,INFOH,IH,JH,WORK,LWORK,IERROR)
      IMPLICIT NONE                                                      
C     .. Scalar Arguments ..                                             
      INTEGER          LWORK, M, N, IERROR, LA, LIA1, LIA2
      INTEGER          LATOT,LIA1TOT,LIA2TOT,IA,JA,IH,JH
C     .. Array Arguments ..                                              
      DOUBLE PRECISION A(*), H(*), WORK(LWORK)                     
      INTEGER          IA1(*), IA2(*), IH1(*), IH2(*),
     +   INFOA(*), INFOH(*)                         
      CHARACTER        FIDA*5, FIDH*5, DESCRA*11, DESCRH*11          
C     .. Local Array..
      INTEGER           INT_VAL(5), IERRV(5)
      DOUBLE PRECISION  REAL_VAL(5)
      CHARACTER*30      NAME, STRINGS(2)
      LOGICAL           DEBUG
      PARAMETER         (DEBUG=.FALSE.)
C     .. External Subroutines ..                                         
      EXTERNAL         DCRINCO
C                                                                        
C     .. Executable Statements ..                                        

C                                                                        
C     Check parameters                                                   
C                                                                        
      IERROR = 0

      NAME = 'DCSINS\0'
      IF (M.LT.0) THEN
        IERROR = 10
        INT_VAL(1) = 1
        INT_VAL(2) = M
      ELSE IF (N.LT.0) THEN
        IERROR = 10
        INT_VAL(1) = 2
        INT_VAL(2) = N
      ENDIF
C                                                                        
C     Error handling                                                     
C                                                                        
      IF(IERROR.NE.0) THEN
        CALL SPERROR(IERROR,NAME,STRINGS,INT_VAL,REAL_VAL)
        GOTO 9999
      ENDIF

C                                                                        
C     Check for M, N                                                     
C                                                                        
      IF(M.LE.0 .OR. N.LE.0) THEN                                        
        GOTO 9999                                                       
      ENDIF
      
C                                                                        
C     Switching on FIDA                                               
C                                                                        
      IF ((FIDA(1:3).EQ.'COO').OR.(FIDA(1:3).EQ.'COI')) THEN                              
        IF (FIDH(1:3).EQ.'CSR') THEN
C
C           Submatrix H in CSR format into A matrix in COO format
C
          if (debug) write(0,*) 'DCSINS: Calling DCRINCO ',m,n,
     +      ih,jh,la,lia1,lia2
          CALL DCRINCO(M,N,DESCRA,A,IA1,IA2,
     +       INFOA,IA,JA,LA,LIA1,LIA2,LATOT,LIA1TOT,LIA2TOT,
     +       DESCRH,H,IH1,IH2,INFOH,IH,JH,WORK,LWORK,IERRV)
          if (debug) write(0,*) 'DCSINS: Exit from DCRINCO ',m,n,
     +      ih,jh,la,lia1,lia2,ierror
          
          IF  (IERRV(1).EQ.10) THEN
            IERROR = 60
            INT_VAL(1) = 14
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LATOT
          ELSE IF (IERRV(1).EQ.20) THEN
            IERROR = 60
            INT_VAL(1) = 15
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LIA1TOT
          ELSE IF (IERRV(1).EQ.30) THEN
            IERROR = 60
            INT_VAL(1) = 16
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LIA2TOT
c$$$          ELSE 
c$$$            IERROR = IERRV(1)
          END IF
        ELSE IF ((FIDH(1:3).EQ.'COO').OR.(FIDH(1:3).EQ.'COI')) THEN
C
C           Submatrix H in COO format into A matrix in COO format
C
          CALL DCOINCO(M,N,DESCRA,A,IA1,IA2,
     +       INFOA,IA,JA,LA,LIA1,LIA2,LATOT,LIA1TOT,LIA2TOT,
     +       DESCRH,H,IH1,IH2,INFOH,IH,JH,WORK,LWORK,IERRV)
          
          IF  (IERRV(1).EQ.10) THEN
            IERROR = 60
            INT_VAL(1) = 14
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LATOT
          ELSE IF (IERRV(1).EQ.20) THEN
            IERROR = 60
            INT_VAL(1) = 15
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LIA1TOT
          ELSE IF (IERRV(1).EQ.30) THEN
            IERROR = 60
            INT_VAL(1) = 16
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LIA2TOT
          END IF
        ELSE 
          IERROR = 3010
          STRINGS(1) = FIDH(1:3)
        ENDIF
      ELSE
        IERROR = 3010
        STRINGS(1) = FIDH(1:3)
      ENDIF

      CALL SPERROR(IERROR,NAME,STRINGS,INT_VAL,REAL_VAL)
 9999 CONTINUE
      END

