C      SUBROUTINE DCSDP(CHECK,TRANS,M,N,UNITD,D,FIDA,DESCRA,A,IA1,IA2,   
C     &   INFOA,PL,FIDH,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,  
C     &   LH2,WORK,LWORK,IERROR)
C
C     Purpose
C     =======
C
C     Performing data check and/or converting data from a sparse data
C     structure to another, optionally scaling the matrix.
C
C     Parameters
C     ==========
C
C     CHECK    - CHARACTER*1
C             On entry CHECK specifies whether the routine will check
C             data, convert matrix or both, as follows:
C                CHECK = 'C'         ->  check data
C                CHECK = 'N'         ->  convert matrix
C                CHECK = 'Y'         ->  both
C                CHECK = 'R'         ->  Regeneration of an existing pattern. 
C                                        In this case only look at H and WORK.
C             Unchanged on exit.
C
C     TRANS    - CHARACTER*1
C             On entry TRANS specifies whether the routine will convert
C             matrix A or the transpose of A as follows:
C                TRANS = 'N'         ->  convert matrix A
C                TRANS = 'T' or 'C'  ->  convert A' (the transpose of A)
C             Unchanged on exit.
C
C     M        - INTEGER
C             On entry: number of rows of matrix A (A')
C             and number of rows of matrix H
C             Unchanged on exit.
C
C     N        - INTEGER
C             On entry: number of columns of matrix A (A')
C             and number of columns of matrix H
C             Unchanged on exit.
C
C     UNITD    - CHARACTER*1
C             On entry UNITD specifies whether the diagonal matrix is unit
C             or whether row or column scaling has to be performed, as follows:
C                UNITD = 'U'         ->  unit matrix (no scaling)
C                UNITD = 'L'         ->  scale on the left (row scaling)
C                UNITD = 'R'         ->  scale on the right (column scaling)
C                UNITD = 'B'         ->  scale on the right and on the left
C                                             with D^1/2
C             Unchanged on exit.
C
C     D        - DOUBLE PRECISION array of dimension (M)
C             On entry D specifies the main diagonal of the matrix used
C             for scaling.
C             Unchanged on exit.
C
C     FIDA     - CHARACTER*5
C             On entry FIDA defines the format of the input sparse matrix.
C             Unchanged on exit.
C
C     DESCRA   - CHARACTER*1 array of DIMENSION (9)
C             On entry DESCRA describes the characteristics of the input
C             sparse matrix.
C             Unchanged on exit.
C
C     A        - DOUBLE PRECISION array of DIMENSION (*)
C             On entry A specifies the values of the input sparse
C             matrix.
C             Unchanged on exit.
C
C     IA1      - INTEGER array of dimension (*)
C             On entry IA1 holds integer information on input sparse
C             matrix.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     IA2      - INTEGER array of dimension (*)
C             On entry IA2 holds integer information on input sparse
C             matrix.  Actual information will depend on data format used.
C             Unchanged on exit.
C
C     INFOA    - INTEGER array of dimension (10)
C             On entry can hold auxiliary information on input matrices
C             formats or environment of subsequent calls.
C             Might be changed on exit.
C
C     PL       - INTEGER array of dimension (M)
C             On exit PL specifies the row permutation of matrix H
C             (PL(1) == 0 if no permutation).
C
C     FIDH     - CHARACTER*5
C             On entry FIDH defines the format of the output sparse matrix.
C             Unchanged on exit.
C
C     DESCRH   - CHARACTER*1 array of DIMENSION (9)
C             On exit DESCRH describes the characteristics of the input
C             sparse matrix.
C             Unchanged on exit.
C
C     H        - DOUBLE PRECISION array of DIMENSION (LH)
C             On exit H specifies the values of the output sparse
C             matrix. If LH=0, INT(H(1)) is the minimum value for LH
C             satisfying DCSDP memory requirements.
C
C     IH1      - INTEGER array of dimension (LH1)
C             On exit IH1 holds integer information on output sparse
C             matrix.  Actual information will depend on data format used.
C             If LH1=0, INT(IH1(1)) is the minimum value for LH1
C             satisfying DCSDP memory requirements.
C
C     IH2      - INTEGER array of dimension (LH2)
C             On exit IH2 holds integer information on output sparse
C             matrix.  Actual information will depend on data format used.
C             If LH2=0, INT(IH2(1)) is the minimum value for LH2
C             satisfying DCSDP memory requirements.
C
C     INFOH    - INTEGER array of dimension (10)
C             On exit can hold auxiliary information on output matrices
C             formats or environment of subsequent calls.
C
C     PR       - INTEGER array of dimension (M)
C             On exit PR specifies the column permutation of matrix H
C             (PR(1) == 0 if no permutation).
C
C     LH       - INTEGER
C             On entry LH specifies the dimension of H
C             LH must satisfy memory required from the new data structure.
C             Unchanged on exit.
C
C     LH1      - INTEGER
C             On entry LH1 specifies the dimension of IH1
C             LH1 must satisfy memory required from the new data structure.
C             Unchanged on exit.
C
C     LH2      - INTEGER
C             On entry LH2 specifies the dimension of IH2
C             LH2 must satisfy memory required from the new data structure.
C             Unchanged on exit.
C
C     WORK     - DOUBLE PRECISION array of dimension (LWORK)
C             On entry: work area.
C             On exit INT(WORK(1)) contains the minimum value
C             for LWORK satisfying DCSDP memory requirements.
C
C     LWORK    - INTEGER
C             On entry LWORK specifies the dimension of WORK
C             LWORK must satisfy memory necessary for the data conversion.
C             Unchanged on exit.
C
C     IERROR   - INTEGER
C             On exit IERROR contains the value of error flag as follows:
C             IERROR = 0   no error
C             IERROR > 0   error
C
C     Local Variables
C     ===============
C
C     NERR      - INTEGER
C             NERR contains the number of errors found by DxxxCK
C
C
      SUBROUTINE DCSDP(CHECK,TRANS,M,N,UNITD,D,FIDA,DESCRA,A,IA1,IA2,   
     &  INFOA,PL,FIDH,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,  
     &  LH2,WORK,LWORK,SIZE_REQ,IERROR)
      IMPLICIT NONE                                                      
C     .. Scalar Arguments ..                                             
      INTEGER          LH, LWORK, LH1, LH2, M, N, IERROR,
     +     SIZE_REQ                 
      CHARACTER        CHECK, TRANS, UNITD                               
C     .. Array Arguments ..                                              
      DOUBLE PRECISION D(*), A(*), H(*), WORK(LWORK) 
      INTEGER          IA1(*), IA2(*), IH1(*), IH2(*), PL(*),            
     &  PR(*), INFOA(*), INFOH(*)                         
      CHARACTER        FIDA*5, FIDH*5, DESCRA*11, DESCRH*11          
C     .. Local Scalars ..                                                
      INTEGER          NERR, IOUT, i, j, NNZ, IP1, IP2,
     +  iflag,ichk, nnzt, count, ipc
C     .. Local Array..
      INTEGER           INT_VAL(5), IERRV(5)
      DOUBLE PRECISION  REAL_VAL(5)
      CHARACTER*30      NAME, STRINGS(2)
      logical   debug
      parameter (debug=.false.)
      include 'sparker.fh'
C     .. External Subroutines ..                                         
      EXTERNAL         DCSRCK, DCRCR, XERBLA                             
      EXTERNAL         DCRDI, DCREL, DCRJD                        
C                                                                        
C     .. Executable Statements ..                                        
C                                                                        
C                                                                        
C     Check parameters                                                   
C                                                                        
      IERROR = 0
      NAME = 'DCSDP\0'
      IF (CHECK.NE.'C' .AND. CHECK.NE.'N'
     +  .AND. CHECK.NE.'Y'.AND.CHECK.NE.'R') THEN
        IERROR = 40
        INT_VAL(1) = 1
        STRINGS(1) = CHECK//'\0'
      ELSE IF (TRANS.NE.'T' .AND. TRANS.NE.'N' .AND. TRANS.NE.'C') THEN
        IERROR = 40
        INT_VAL(1) = 2
        STRINGS(1) = TRANS//'\0'
      ELSE IF (UNITD.NE.'U' .AND. UNITD.NE.'L' .AND. UNITD.NE.'R' 
     &    .AND. UNITD.NE.'B') THEN                                  
        IERROR = 40
        INT_VAL(1) = 5
        STRINGS(1) = UNITD//'\0'
      ELSE IF (M.LT.0) THEN
        IERROR = 10
        INT_VAL(1) = 3
        INT_VAL(2) = M
      ELSE IF (N.LT.0) THEN
        IERROR = 10
        INT_VAL(1) = 4
        INT_VAL(2) = N
      ENDIF
C                                                                        
C     Error handling                                                     
C                                                                        

      IF(IERROR.NE.0) THEN
        CALL SPERROR(IERROR,NAME,STRINGS,INT_VAL,REAL_VAL)
        GOTO 9999
      ENDIF

C                                                                        
C     Check for M, N                                                     
C                                                                        
      IF (M.LE.0 .OR. N.LE.0) THEN                                        
        GOTO 9999                                                       
      ENDIF                                                              
      if (debug) write(*,*) 'Entry to DCSDP: ',
     +  check,trans,unitd,fida
      IF (FIDH.EQ.'???') THEN 
        FIDH = FIDEF
      ENDIF
c$$$      if (debug) then
c$$$        iout = 9
c$$$        
c$$$        write(*,*) 'IOUT 1',iout, fida, descra, infoa(1)
c$$$        call dcsprt(M,N,FIDA,DESCRA,A,IA1,
c$$$     +    IA2,INFOA,iout,ierror)
c$$$      endif

      IF (FIDH.NE.'JAD') THEN
         SIZE_REQ = 0
      ENDIF
      
C                                                                        
C     Switching on CHECK                                                 
C                                                                        


      IF  (CHECK.EQ.'Y' .OR. CHECK.EQ.'C') THEN                      
C                                                                        
C        Performing data check                                           
C                                                                        
C        Switching on FIDA                                               
C
        IF (FIDA(1:3).EQ.'CSR') THEN                              
C                                                                        
C           Check CSR format                                             
C
          CALL DCSRCK(TRANS,M,N,DESCRA,A,IA1,IA2,WORK,LWORK,IERROR)

          IF(IERROR.NE.0) THEN
            NAME = 'DCSDP\0'
            IF ((IERROR-10).LT.4) THEN
              INT_VAL(1) = 8
              IF (IERROR.EQ.11) THEN
                INT_VAL(2) = 1
                STRINGS(1) = DESCRA(1:1)//'\0'
              ELSE IF (IERROR.EQ.12) THEN
                INT_VAL(2) = 2
                STRINGS(1) = DESCRA(2:2)//'\0'
              ELSE IF (IERROR.EQ.13) THEN
                INT_VAL(2) = 3
                STRINGS(1) = DESCRA(3:3)//'\0'
              ENDIF
              IERROR = 70
            ELSE IF (IERROR.EQ.14) THEN
              IERROR = 80
              INT_VAL(1) = IA2(1)
            ELSE IF (IERROR.EQ.15) THEN
              IERROR = 90
            ELSE IF (IERROR.EQ.16) THEN
              IERROR = 100
              INT_VAL(1) = N
            ENDIF
          ENDIF
*         ELSE IF (FIDA(1:3).EQ.'DIA') THEN                              
        ENDIF                                                           
      ENDIF                                                             
      IF (CHECK.EQ.'Y' .OR. CHECK.EQ.'N') THEN                           
C

C                                                                        
C        Performing data conversion                                      
C                                                                        
C        Switching on FIDA                                               
C                                                                        
        IF     (FIDA(1:3).EQ.'CSR') THEN                                
C                                                                        
C           Convert CSR --> new format                                   
C                                                                        
C           Switching on FIDH                                            
C                                                                        
          IF     (FIDH(1:3).EQ.'CSR') THEN                             
C                                                                        
C              Convert CSR --> CSR format                                
C                                                                        
            CALL DCRCR(TRANS,M,N,UNITD,D,DESCRA,A,IA1,IA2,INFOA,     
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
     &        LH2,WORK,LWORK,IERROR)

            IF(IERROR .NE. 0) THEN
              NAME = 'DCSDP\0'
              IF (IERROR.EQ.20) THEN
                IERROR = 110
              ELSE IF (IERROR.EQ.21) THEN
                IERROR = 60
                INT_VAL(1) = 21
                INT_VAL(2) = IA2(M+1)-1
                INT_VAL(3) = LH
              ELSE IF (IERROR.EQ.22) THEN
                IERROR = 60
                INT_VAL(1) = 22
                INT_VAL(2) = IA2(M+1)-1
                INT_VAL(3) = LH1
              ELSE IF (IERROR.EQ.23) THEN
                IERROR = 60
                INT_VAL(1) = 23
                INT_VAL(2) = IA2(M+1)-1
                INT_VAL(3) = LH2
              ELSE IF (IERROR.EQ.25) THEN
                IERROR = 50
                INT_VAL(1) = 25
                INT_VAL(2) = 2
                INT_VAL(3) = LWORK
                INT_VAL(4) = M
              ENDIF
            ENDIF

          ELSE IF(FIDH(1:3).EQ.'???') THEN                             
C                                                                        
C              Convert CSR --> JAD format                                
C                                                                        
            FIDH='JAD'                                                
            CALL DCRJD(TRANS,M,N,UNITD,D,DESCRA,A,IA1,IA2,INFOA,
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,
     &        LH2,WORK,LWORK,SIZE_REQ,IERRV)
            IF(IERRV(1) .NE. 0) THEN
              NAME = 'DCSDP\0'
              IF (IERRV(1).EQ.5) THEN
                IERROR = 60
                INT_VAL(1) = 25
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LWORK
              ELSE IF (IERRV(1).EQ.10) THEN
                WORK(1) = DBLE(IERRV(2))
              ELSE IF (IERRV(1).EQ.30) THEN
                WORK(1) = DBLE(0)
                WORK(2) = DBLE(IERRV(2))
                WORK(3) = DBLE(IERRV(3))
                WORK(4) = DBLE(IERRV(4))
              END IF
            ELSE
              WORK(1) = 0
              WORK(2) = 0
              WORK(3) = 0
              WORK(4) = 0
            ENDIF

          ELSE IF(FIDH(1:3).EQ.'JAD') THEN                             
C                                                                        
C              Convert CSR --> JAD format                                
C                                                                        
            CALL DCRJD(TRANS,M,N,UNITD,D,DESCRA,A,IA1,IA2,INFOA,     
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
     &        LH2,WORK,LWORK,SIZE_REQ,IERRV)
            
            IF(IERRV(1) .NE. 0) THEN
              NAME = 'DCSDP\0'
              IF (IERRV(1).EQ.5) THEN
                IERROR = 60
                INT_VAL(1) = 25
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LWORK
              ELSE IF (IERRV(1).EQ.10) THEN
                WORK(1) = DBLE(IERRV(2))
              ELSE IF (IERRV(1).EQ.30) THEN
                WORK(1) = DBLE(0)
                WORK(2) = DBLE(IERRV(2))
                WORK(3) = DBLE(IERRV(3))
                WORK(4) = DBLE(IERRV(4))
              END IF
            ELSE
              WORK(1) = 0
              WORK(2) = 0
              WORK(3) = 0
              WORK(4) = 0
            ENDIF

          ELSE IF(FIDH(1:3).EQ.'COO') THEN                             
C                                                                        
C              Convert CSR --> COO format                                
C                                                                        
             CALL DCRCO(TRANS,M,N,UNITD,D,DESCRA,A,IA1,IA2,INFOA,     
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
     &        LH2,WORK,LWORK,IERRV)

C  ********* CHANGE ERROR  CODES ***************
            IF(IERRV(1) .NE. 0) THEN
              NAME = 'DCSDP\0'
              IF (IERRV(1).EQ.10) THEN
                IERROR = 60
                INT_VAL(1) = 21
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH
              ELSE IF (IERRV(1).EQ.20) THEN
                IERROR = 60
                INT_VAL(1) = 22
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH1
              ELSE IF (IERRV(1).EQ.30) THEN
                IERROR = 60
                INT_VAL(1) = 23
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH2
              END IF

            ENDIF

          ELSE IF(FIDH(1:3).EQ.'ELL') THEN                             
C                                                                        
C              Convert CSR --> ELL format                                
C                                                                        
            CALL DCREL(TRANS,M,N,UNITD,D,DESCRA,A,IA1,IA2,INFOA,     
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
     &        LH2,WORK,LWORK,IERROR)                      
            IF(IERROR .NE. 0)    GOTO 9999                            

          ELSE IF(FIDH(1:3).EQ.'DIA') THEN                             
C                                                                        
C              Convert CSR --> DIA format                                
C                                                                        
            CALL DCRDI(TRANS,M,N,UNITD,D,DESCRA,A,IA1,IA2,INFOA,     
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
     &        LH2,WORK,LWORK,IERROR)                       
            IF(IERROR .NE. 0)    GOTO 9999                            

          ELSE                                                         
C                                                                        
C              other conversions                                         
C                                                                        
            IERROR = 3010
            STRINGS(1) = FIDH(1:4)
            NAME = 'DCSDP\0'

            CALL SPERROR(IERROR,NAME,STRINGS,INT_VAL,REAL_VAL)
            GOTO 9999
          END IF                                                       

        ELSE IF(FIDA(1:3).EQ.'DIA') THEN                                
C                                                                        
C           Convert DIA --> NEW format                                   
C                                                                        
C           Switching on FIDH                                            
C                                                                        
c$$$            IF (FIDH(1:3).EQ.'CSR') THEN                                 
c$$$C                                                                        
c$$$C              Convert DIA --> CSR format                                
c$$$C                                                                        
c$$$c$$$               CALL DDICR(TRANS,M,N,UNITD,D,DESCRA,A,IA1,IA2,INFOA,     
c$$$c$$$     &            PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
c$$$c$$$     &            LH2,WORK,LWORK,IERROR)                       
c$$$               IF(IERROR .NE. 0)    GOTO 9999                            
c$$$            ELSE                                                         
C                                                                        
C              other conversions                                         
C                                                                        
          IERROR = 3011
          STRINGS(1) = FIDH//'\0'
c$$$            END IF                                                       

        ELSE IF ((FIDA(1:3).EQ.'COO').OR.(FIDA(1:3).EQ.'COI')) THEN
          
C                                                                        
C           Convert COO --> new format                                   
C                                                                        
C           Switching on FIDH                                            
C                                                                        
          IF (FIDH(1:3).EQ.'CSR')THEN 
C                                                                        
C              Convert COO --> CSR format                               
C                                                         
c$$$             write(0,*)'in DCSDP',infoa(upd_),infoh(upd_)
            CALL DCOCR(TRANS,M,N,UNITD,D,DESCRA,A,IA2,IA1,INFOA,     
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
     &        LH2,WORK,LWORK*DBLEINT_,IERRV)
c$$$             write(0,*)'in DCSDP dopo dcocr',infoa(upd_),infoh(upd_)
            
            IF (IERRV(1) .NE. 0) THEN
              NAME = 'DCSDP\0'
              IF (IERRV(1).EQ.10) THEN
                IERROR = 60
                INT_VAL(1) = 25
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LWORK
              ELSE IF (IERRV(1).EQ.20) THEN
                IERROR = 60
                INT_VAL(1) = 21
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH
              ELSE IF (IERRV(1).EQ.30) THEN
                IERROR = 60
                INT_VAL(1) = 22
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH1
              ELSE IF (IERRV(1).EQ.40) THEN
                IERROR = 120
                INT_VAL(1) = 23
                INT_VAL(2) = 3
                INT_VAL(3) = LH2
                INT_VAL(4) = M
              ELSE IF (IERRV(1).EQ.100) THEN
                IERROR = 130
              END IF
            ENDIF
            
          ELSE IF (FIDH(1:3).EQ.'???') THEN 
C                                                                        
C              Convert COO --> CSR format                               
C                                                         
            FIDH='CSR'
            CALL DCOCR(TRANS,M,N,UNITD,D,DESCRA,A,IA2,IA1,INFOA,     
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
     &        LH2,WORK,LWORK*DBLEINT_,IERRV)
            IF(IERRV(1) .NE. 0) THEN
              NAME = 'DCSDP\0'
              IF (IERRV(1).EQ.10) THEN
                IERROR = 60
                INT_VAL(1) = 25
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LWORK
              ELSE IF (IERRV(1).EQ.20) THEN
                IERROR = 60
                INT_VAL(1) = 21
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH
              ELSE IF (IERRV(1).EQ.30) THEN
                IERROR = 60
                INT_VAL(1) = 22
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH1
              ELSE IF (IERRV(1).EQ.40) THEN
                IERROR = 120
                INT_VAL(1) = 23
                INT_VAL(2) = 3
                INT_VAL(3) = LH2
                INT_VAL(4) = M
              ELSE IF (IERRV(1).EQ.100) THEN
                IERROR = 130
              END IF
            END IF
          ELSE IF (FIDH(1:3).EQ.'COO')THEN 
C                                                                        
C              Convert COO --> COO format                               
C                                                         
             CALL DCOCO(TRANS,M,N,UNITD,D,DESCRA,A,IA1,IA2,INFOA,     
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
     &        LH2,WORK,LWORK*DBLEINT_,IERRV)
            
            IF (IERRV(1) .NE. 0) THEN
              NAME = 'DCSDP\0'
              IF (IERRV(1).EQ.10) THEN
                IERROR = 60
                INT_VAL(1) = 25
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LWORK
              ELSE IF (IERRV(1).EQ.20) THEN
                IERROR = 60
                INT_VAL(1) = 21
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH
              ELSE IF (IERRV(1).EQ.30) THEN
                IERROR = 60
                INT_VAL(1) = 22
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH1
              ELSE IF (IERRV(1).EQ.40) THEN
                IERROR = 120
                INT_VAL(1) = 23
                INT_VAL(2) = 3
                INT_VAL(3) = LH2
                INT_VAL(4) = M
              ELSE IF (IERRV(1).EQ.100) THEN
                IERROR = 130
              END IF
            ENDIF
          ELSE IF (FIDH(1:3).EQ.'JAD')THEN 
C                                                                        
C     Dirty trick: convert to CSR first, then onto Jad. But leave
C     A on exit as a valid COO format. 
C
            CALL DCOCR(TRANS,M,N,'U',D,DESCRA,A,IA2,IA1,INFOA,     
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
     &        LH2,WORK,LWORK*DBLEINT_,IERRV)
            ip1=infoh(upd_pnt_)
c            write(*,*)'ip1=',ip1
c               write(*,*)'ireg_flgs ip2',ih2(ip1+ip2_)
c               write(*,*)'ireg_flgs nnz',ih2(ip1+nnz_)
c               write(*,*)'ireg_flgs nnzt',ih2(ip1+nnzt_)
c               write(*,*)'ireg_flgs iflag_',ih2(ip1+iflag_)
            IF(IERRV(1) .NE. 0) THEN
              NAME = 'DCSDP\0'
              IF (IERRV(1).EQ.10) THEN
                IERROR = 60
                INT_VAL(1) = 25
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LWORK
              ELSE IF (IERRV(1).EQ.20) THEN
                IERROR = 60
                INT_VAL(1) = 21
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH
              ELSE IF (IERRV(1).EQ.30) THEN
                IERROR = 60
                INT_VAL(1) = 22
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LH1
              ELSE IF (IERRV(1).EQ.40) THEN
                IERROR = 120
                INT_VAL(1) = 23
                INT_VAL(2) = 3
                INT_VAL(3) = LH2
                INT_VAL(4) = M
              ELSE IF (IERRV(1).EQ.100) THEN
                IERROR = 130
              END IF
              GOTO 9999
            END IF
            
            IA2(1) = IH2(1)
            DO I=1, M
              IA2(I+1) = IH2(I+1)
              DO J=IA2(I), IA2(I+1)-1
                A(J)   = H(J)
                IA1(J) = IH1(J) 
              ENDDO
            ENDDO

            ip2=ih2(ip1+ip2_)
c            nnz=ih2(ip1+nnz_)
c           write(*,*)'DCSDP ip1,ip2,nnz',ip1,ip2,nnz
            ia2(ip1+ip2_)=ih2(ip1+ip2_)
            
            do i=1,ih2(ip1+nnzt_)
               ia2(ip2+i-1)=ih2(ip2+i-1)
            enddo
c            write(*,*)'DCSDP ih2(m+2+ip2_),ia..',ih2(m+2+ip2_),
c     +           ia2(m+2+ip2_)
            CALL DCRJD(TRANS,M,N,UNITD,D,DESCRA,A,IA1,IA2,INFOA,     
     &        PL,DESCRH,H,IH1,IH2,INFOH,PR,LH,LH1,        
     &        LH2,WORK,LWORK,SIZE_REQ,IERRV)
            
            IF(IERRV(1) .NE. 0) THEN
              NAME = 'DCSDP\0'
              IF (IERRV(1).EQ.5) THEN
                IERROR = 60
                INT_VAL(1) = 25
                INT_VAL(2) = IERRV(2)
                INT_VAL(3) = LWORK
              ELSE IF (IERRV(1).EQ.10) THEN
                WORK(1) = DBLE(IERRV(2))
              ELSE IF (IERRV(1).EQ.30) THEN
                WORK(1) = DBLE(0)
                WORK(2) = DBLE(IERRV(2))
                WORK(3) = DBLE(IERRV(3))
                WORK(4) = DBLE(IERRV(4))
              END IF
            ELSE
              WORK(1) = 0
              WORK(2) = 0
              WORK(3) = 0
              WORK(4) = 0
            ENDIF
            if (lwork.gt.m) then 
              do i=1,m+1
                work(i) = ia2(i)
              enddo           
              do i=1, m
                do j = int(work(i)), int(work(i+1)) -1
                  ia2(j) = ia1(j)
                  ia1(j) = i                  
                enddo
              enddo
              infoa(1) = int(work(m+1)) -1
            endif
          ELSE
            IERROR = 3011
            STRINGS(1) = FIDH//'\0'
          ENDIF
        else
C
C           other conversions
C
          
          IERROR = 3012
          STRINGS(1) = FIDA//' '//FIDH
          
        ENDIF
        
      ELSE IF (CHECK.EQ.'R') THEN 
c         write(*,*) 'nella dcsdp fidh=',fidh(1:3)        
        if (ibits(infoh(upd_),3,1).eq.0) then 
C
C       Nothing to be done......
C
          goto 9999
        endif


        IF (FIDH(1:3).NE.'JAD') THEN
           ip1   = infoh(upd_pnt_) 
           ip2   = ih2(ip1+ip2_)
           nnz   = ih2(ip1+nnz_)
           iflag = ih2(ip1+iflag_)
           ichk  = ih2(ip1+ichk_)
           nnzt  = ih2(ip1+nnzt_)
           if (debug) write(*,*) 'Regeneration start: ',
     +          infoh(upd_),perm_update,nnz,nnzt,lwork,iflag,ierror
           
c$$$  IF ((ICHK.NE.NNZT+IFLAG).OR.(NNZ.GT.NNZT)) THEN               
           IF ((ICHK.NE.NNZT+IFLAG).OR.(NNZ.NE.NNZT)) THEN               
              IERROR = 10
              INT_VAL(1) = 19
              INT_VAL(2) = perm_update
              write(*,*) 'Regeneration start error: ',
     +             infoh(upd_),perm_update,nnz,nnzt,lwork,iflag,ichk                        
              goto 9999
           endif        
           if (lwork.lt.nnz) then 
              IERROR = 60
              INT_VAL(1) = 25
              INT_VAL(2) = nnz
              INT_VAL(3) = LWORK
              goto 9999
           endif
           if (lh.lt.nnz) then 
              IERROR = 60
              INT_VAL(1) = 21
              INT_VAL(2) = nnz
              INT_VAL(3) = Lh
              goto 9999
           endif
           do i= 1, nnz
              work(i) = 0.d0
           enddo
C     
           if (iflag.eq.2) then 
              do i=1, nnz 
                 work(ih2(ip2+i-1)) = h(i) 
              enddo
           else if (iflag.eq.3) then 
              do i=1, nnz 
                 work(ih2(ip2+i-1)) = h(i) + work(ih2(ip2+i-1)) 
              enddo
           endif
           do i=1, nnz
              h(i) = work(i)
           enddo
        ELSE IF (FIDH(1:3).EQ.'JAD') THEN
           ip1   = infoh(upd_pnt_) 
           ip2   = ih1(ip1+ip2_)
           count = ih1(ip1+zero_)
           ipc   = ih1(ip1+ipc_)
           nnz   = ih1(ip1+nnz_)
           iflag = ih1(ip1+iflag_)
           ichk  = ih1(ip1+ichk_)
           nnzt  = ih1(ip1+nnzt_)
           if (debug) write(*,*) 'Regeneration start: ',
     +          infoh(upd_),perm_update,nnz,nnzt,count,
     +          lwork,iflag,ierror
           
c$$$  IF ((ICHK.NE.NNZT+IFLAG).OR.(NNZ.GT.NNZT)) THEN               
           IF ((ICHK.NE.NNZT+IFLAG).OR.(NNZ.NE.NNZT)) THEN               
              IERROR = 10
              INT_VAL(1) = 19
              INT_VAL(2) = perm_update
              write(*,*) 'Regeneration start error: ',
     +             infoh(upd_),perm_update,nnz,nnzt,lwork,iflag,ichk                        
              goto 9999
           endif        
           if (lwork.lt.nnz) then 
              IERROR = 60
              INT_VAL(1) = 25
              INT_VAL(2) = nnz
              INT_VAL(3) = LWORK
              goto 9999
           endif
           if (lh.lt.nnz) then 
              IERROR = 60
              INT_VAL(1) = 21
              INT_VAL(2) = nnz
              INT_VAL(3) = Lh
              goto 9999
           endif
           do i= 1, nnz+count
              work(i) = 0.d0
           enddo
C     
           if (iflag.eq.2) then 
              do i=1, nnz 
                 work(ih1(ip2+i-1)) = h(i) 
              enddo
           else if (iflag.eq.3) then 
              do i=1, nnz 
                 work(ih1(ip2+i-1)) = h(i) + work(ih1(ip2+i-1)) 
              enddo
           endif
           do i=1, nnz+count 
              h(i) = work(i)
           enddo
           do i=1, count
              h(ih1(ipc+i-1)) = 0.d0
           end do
        ENDIF
      endif
      
 9999 CONTINUE
      CALL SPERROR(IERROR,NAME,STRINGS,INT_VAL,REAL_VAL)
      
c$$$      if (debug) then
c$$$        iout = 8
c$$$        
c$$$        write(*,*) 'IOUT 2',iout, fidh
c$$$        call dcsprt(M,N,FIDH,DESCRH,H,IH1,
c$$$     +     IH2,INFOH,iout,ierror)
c$$$      endif
      
      RETURN
      END

