      SUBROUTINE DCRJD(TRANS,M,N,UNITD,D,DESCRA,AR,IA1,IA2,INFO,
     *  IP1,DESCRN,ARN,IAN1,IAN2,INFON,IP2,LARN,LIAN1,
     *  LIAN2,AUX,LAUX,SIZE_REQ,IERRV)
C
C     Purpose
C     =======
C
C     DCRJD converts a CSR matrix into a Jagged Diagonal.
C
C  
C     Notes
C     =====
C   
C     Parameters
C     ==========
C   
C     TRANS   Whether the transpose should be converted.
C   
C     M,N     Size of input matrix A                
C   
C     UNITD   Scaling by diagonal D: 'U'nit, 'L'eft, 'R'ight 
C     D(*)    
C   
C     DESCRA  Input matrix A.  
C     AR,IA1, 
C     IA2,INFO
C   
C     DESCRN  Output matrix in JAD format
C     ARN,IAN1
C     IAN2,INFON, IP1, IP2
C   
      IMPLICIT NONE
      INCLUDE  'sparker.fh'

C
C     .. Scalar Arguments ..
      INTEGER            LARN, LAUX, LAUX2, LIAN1, LIAN2, M, N,SIZE_REQ
      CHARACTER          TRANS,UNITD
C     .. Array Arguments ..
      DOUBLE PRECISION   AR(*), ARN(*), D(*), AUX(LAUX)
      INTEGER            IA1(*), IA2(*), INFO(*), IAN1(*), IAN2(*),
     *  INFON(*), IP1(*), IP2(*), IERRV(*)
      CHARACTER          DESCRA*11, DESCRN*11
C     .. Local Scalars ..
      INTEGER            IER, IOFF, ISTROW, NJA, NZ, PIA,
     +  PJA, PNG, K, LIMIT, MAX_NG, NG, IERROR, LJA, IW1
      LOGICAL            SCALE
      logical  debug
      parameter (debug=.false.)
      CHARACTER          UPLO
      INTEGER MAX_NNZERO

C     .. External Subroutines ..
      EXTERNAL           DVTFG
      EXTERNAL           MAX_NNZERO
C     .. Executable Statements ..
C
      IERRV(1) = 0

      IF (LAUX.LT.4) THEN
        IERRV(1) = 5
        IERRV(2) = 4
        RETURN
      ENDIF

      IF (TRANS.EQ.'N') THEN
C
        IERRV(1) = 0
        NJA    = 3*M
        SCALE  = (UNITD.EQ.'L') ! meaningless
        IOFF   = 5
C
C        SET THE VALUES OF POINTERS TO VECTOR IAN2 AND AUX
C
        PNG    = IOFF
        PIA    = PNG + 1
        PJA    = PIA + 3*(M+2)

        IF (DESCRA(1:1).EQ.'G') THEN

C
C        CHECK ON DIMENSION OF IAN2 AND AUX
C
          MAX_NG = M/MIN_ROWS+1

          IF ((PIA+3*(MAX_NG+1).GT.LIAN2).OR.(M+1 .GT. LAUX)) THEN
C              ... If I haven't sufficent memory to compute NG in IAN2 ...
            IF (M+1+3*(MAX_NG+1)/DBLEINT_+1.GT.LAUX) THEN
C              ... If I haven't sufficent memory to compute NG in AUX ...
              IERRV(1) = 10
              IERRV(2) = M+1+3*(MAX_NG+1)/DBLEINT_+1-LAUX  
              GOTO 9999
            ELSE
C                 ... I have sufficent memory to compute NG in AUX ...
              CALL DGBLOCK(M,IA2,IP1,AUX(M+2),NG, AUX, LAUX*2)
              CALL CHECK_DIM(M,N,AUX(M+2),NG,IA2,
     +          NZ,LARN,LIAN1,LIAN2,IERRV)
              IF (IERRV(1).NE.0) THEN 
                write(0,*) "error 2",ierrv(1)
                GOTO 9999
              endif
            ENDIF
          END IF
          
          NZ     = IA2(M+1) - 1
C
C           ... Initialize Permutation Matrix ...
C
          DO 10 K = 1, M
            IP1(K) = K
 10       CONTINUE

          IP2(1) = 0

          CALL DGBLOCK(M,IA2,IP1,IAN2(PIA),IAN2(PNG), AUX, LAUX*2)
          
          PJA = PIA + 3*(IAN2(PNG)+1)
C
C           CHECK FOR ARRAY DIMENSIONS
C
          CALL CHECK_DIM(M,N,IAN2(PIA),IAN2(PNG),IA2,
     +      NZ,LARN,LIAN1,LIAN2,IERRV)

          LJA = LIAN2-PJA
          CALL DGINDEX(M,IAN2(PNG),AR,IA1,IA2,ARN,IAN1,IAN2(PIA), 
     +         IAN2(PJA), INFON, LARN,LIAN1,
     +         LJA,IP1, AUX, LAUX*2, SIZE_REQ,IERROR)

          IF (IERROR.NE.0) THEN
            IERRV(1) = IERROR
          ENDIF

          DESCRN(1:1) = 'G'
          DESCRN(2:2) = 'U'
          DESCRN(3:3) = 'N'

        ELSE IF (DESCRA(1:1).EQ.'S' .AND. DESCRA(2:2).EQ.'U') THEN
C
          ISTROW = 1
          NZ     = 2*(IA2(M+1)-1) - M
C
C           CHECK ON DIMENSION OF IAN1 AND ARN
C
          IF (NZ .GT. LIAN1) THEN
            CALL XSPERR('MATST   ',LIAN1,19,'DCRJD',IERRV)
            LIAN1  = NZ
          END IF
          IF (NZ .GT. LARN) THEN
            CALL XSPERR('MATST   ',LARN,18,'DCRJD',IERRV)
            LARN   = NZ
          END IF
C
C           QUICK RETURN IF IERRV IS DIFFERENT FROM ZERO
C
          IF (IERRV(1) .NE. 0) RETURN
          DO 20 K = 1, M
            IP2(K) = K
 20       CONTINUE

c$$$            CALL DVSSG(M,IA1,IA2,IP2,IAN2(PNG),IP1,IP2,AUX(IWLEN),
c$$$     *                 AUX(IWORK1))
c$$$            CALL DVSMR(M,AR,IA1,IA2,IAN2(PNG),AUX(IWLEN),IP1,IP2,
c$$$     *                 IAN2(PIA),IAN2(PJA),IAN1,ARN,AUX(IWORK1),
c$$$     *                 AUX(IWORK2),NJA,IER,SCALE)
C
        ELSE IF (DESCRA(1:1).EQ.'T') THEN
C
C  Only unit diagonal so far for triangular matrices. 
C


          IF (DESCRA(3:3).NE.'U') THEN 
            IERRV(1) = 6
            IERRV(2) = 3
            RETURN
          ENDIF          
          
          UPLO = DESCRA(2:2)
          NZ     = IA2(M+1) - 1
C
C           ...Compute levels...
C           Each level correspond to a block
C           IAN1 is used as a work area

          CALL DVTFG(UPLO,M,IA1,IA2,IAN2(PNG),IP2,IP1,IAN1,
     +      AUX,AUX(M+1),AUX(2*(M+1)))

C           Generate IA(1,*)
          DO K = 1, IAN2(PNG)+1
            IAN2(PIA+3*(K-1)) = IAN1(K)
          ENDDO

          CALL GEN_BLOCK(M,IAN2(PNG),IAN2(PIA),AUX)

          PJA = PIA + 3*(IAN2(PNG)+1)

C
C           CHECK FOR ARRAY DIMENSIONS
C

          CALL CHECK_DIM(M,N,IAN2(PIA),IAN2(PNG),IA2,
     +      NZ,LARN,LIAN1,LIAN2,IERRV)
          
          LJA = LIAN2-PJA

          CALL DGIND_TRI(M,IAN2(PNG),AR,IA1,IA2,ARN,IAN1,IAN2(PIA), 
     +      IAN2(PJA),LARN,LIAN1,LJA,IP1,AUX, LAUX*2, IERROR)

          IF (IERROR.EQ.0) THEN
            IERRV(1) = 0
          ENDIF
          
          DESCRN(1:1) = 'T'
          DESCRN(2:2) = DESCRA(2:2)
          DESCRN(3:3) = DESCRA(3:3)

        END IF
C
C        SET THE OUTPUT PARAMETER
C
        IAN2(1) = PNG
        IAN2(2) = PIA
        IAN2(3) = PJA
        LARN    = NZ
        LIAN1   = NZ
        LIAN2   = 3*M + 10
        LAUX2   = 4*M + 2
C
      ELSE IF (TRANS.NE.'N') THEN
C
C           TO BE DONE
C
        CALL XSPERR('TRANS   ',TRANS,1,'DCRJD',IERRV)
      END IF
      
 9999 continue 
c$$$      write(0,*) 'On exit from DCRJD ',DESCRA(1:1),DESCRN(1:1)
      return
      END
