C     Covert matrix from COO format to COO Format
C
      SUBROUTINE DCOCO(TRANS,M,N,UNITD,D,DESCRA,AR,IA1,IA2,INFO,
     *  P1,DESCRN,ARN,IA1N,IA2N,INFON,P2,LARN,LIA1N,
     *  LIA2N,AUX,LAUX,IERRV)

      IMPLICIT NONE
      INCLUDE  'sparker.fh'

C
C     .. Scalar Arguments ..
      INTEGER            LARN, LAUX, LAUX2, LIA1N, LIA2N, 
     +  M, N
      CHARACTER          TRANS,UNITD
C     .. Array Arguments ..
      DOUBLE PRECISION   AR(*), ARN(*), D(*)
      INTEGER            AUX(0:LAUX-1)
      INTEGER            IA1(*), IA2(*), INFO(*), IA1N(*), IA2N(*),
     *  INFON(*), P1(*), P2(*), IERRV(*)
      CHARACTER          DESCRA*11, DESCRN*11
C     .. Local Scalars ..
      INTEGER            IPX, IP1, IP2, ICHK, IFLAG, CHECK_FLAG
      INTEGER            NNZ, K, ROW, KK, LP, LSWAP, I, J, NZL, IRET
      INTEGER            SWAPIA1N, SWAPIA2N
      INTEGER            ELEM_IN, ELEM_OUT
      DOUBLE PRECISION   SWAPARN
      LOGICAL            SCALE
      INTEGER MAX_NNZERO
      logical     debug
      parameter   (debug=.false.)

C
C     ...Common variables...
C     This flag describe the action to do
      
C     .. External Subroutines ..
      EXTERNAL           MAX_NNZERO
C     .. Executable Statements ..
C
      CHECK_FLAG=IBITS(info(upd_),1,2)
      IF (TRANS.EQ.'N') THEN
        IERRV(1) = 0
        SCALE  = (UNITD.EQ.'L') ! meaningless
        P1(1) = 0
        P2(1) = 0

        NNZ = INFO(1)
        if (debug) then 
          write(*,*) 'On entry to DCOCO: NNZ LAUX ',
     +      nnz,laux,larn,lia1n,lia2n
        endif
        IF (LAUX.LT.NNZ+2) THEN
          IERRV(1) = 10
          IERRV(2) = NNZ+2
          RETURN
        ELSE IF (LARN.LT.NNZ) THEN
          IERRV(1) = 20
          IERRV(2) = NNZ
          RETURN
        ELSE IF (LIA1N.LT.NNZ) THEN
          IERRV(1) = 30
          IERRV(2) = NNZ
          RETURN
        ELSE IF (LIA2N.LT.M+1) THEN
          IERRV(1) = 40
          IERRV(2) = M+1
          RETURN
        ENDIF
        
        IF (DESCRA(1:1).EQ.'G') THEN
C
C     Sort COO data structure
C     
          if (debug) write(*,*)'First sort',nnz
          do k=1, nnz
            arn(k)  = ar(k)
            ia1n(k) = ia1(k)
            ia2n(k) = ia2(k)
          enddo
          
          if (debug) write(*,*)'Second sort'            
          
          
          if ((lia2n.ge.(2*nnz+ireg_flgs+1))
     +      .and.(laux.ge.2*(2+nnz))) then 


C     
C     Prepare for smart regeneration
c     
            ipx = nnz+3            
            do i=1, nnz
              aux(ipx+i-1) = i
            enddo
            ip1              = nnz+2
            infon(upd_pnt_)  = ip1
            ip2              = ip1+ireg_flgs
            ia2n(ip1+ip2_)   = ip2
            ia2n(ip1+iflag_) = check_flag
            ia2n(ip1+nnzt_)  = nnz
            ia2n(ip1+nnz_)   = 0
            ia2n(ip1+ichk_)  = nnz+check_flag
            if (debug) write(0,*) 'Build check :',ia2n(ip1+nnzt_) 
            
C     .... Order with key IA1N ...
            CALL MRGSRT(NNZ,IA1N,AUX,IRET)
            IF (IRET.EQ.0) CALL REORDVN3(NNZ,ARN,IA1N,IA2N,AUX(IPX),AUX)
C     .... Order with key IA2N ...
            
            I    = 1
            J    = I
            DO WHILE (I.LE.NNZ)
              DO WHILE ((IA1N(J).EQ.IA1N(I)).AND.
     +          (J.LE.NNZ))
                J = J+1
              ENDDO
              NZL = J - I
              CALL MRGSRT(NZL,IA2N(I),AUX,IRET)
              IF (IRET.EQ.0) CALL REORDVN3(NZL,ARN(I),IA1N(I),IA2N(I),
     +          AUX(IPX+I-1),AUX)
              I = J
            ENDDO
            
            ia2n(ip2+aux(ipx+1-1)-1) = 1

C     ... Construct final COO  Representation...
            ELEM_OUT = 1
C     ... Insert remaining element ...
            DO ELEM_IN  = 2, NNZ
              IF ((IA1N(ELEM_IN).EQ.IA1N(ELEM_OUT)).AND.
     +          (IA2N(ELEM_IN).EQ.IA2N(ELEM_OUT))) THEN 
                IF (CHECK_FLAG.EQ.1) THEN
C     ... Error, there are duplicated elements ...
                  IERRV(1) = 100
                  RETURN
                ELSE IF (CHECK_FLAG.EQ.2) THEN
C     ... Insert only the first duplicated element ...
                  ia2n(ip2+aux(ipx+elem_in-1)-1) = elem_out
                ELSE IF (CHECK_FLAG.EQ.3) THEN
C     ... Sum the duplicated element ...
                  ARN(ELEM_OUT) = ARN(ELEM_OUT) + ARN(ELEM_IN)
                  ia2n(ip2+aux(ipx+elem_in-1)-1) = elem_out
                END IF
              ELSE
                ELEM_OUT = ELEM_OUT + 1
                ARN(ELEM_OUT)  = ARN(ELEM_IN)
                ia2n(ip2+aux(ipx+elem_in-1)-1) = elem_out
                IA1N(ELEM_OUT) = IA1N(ELEM_IN)
                IA2N(ELEM_OUT) = IA2N(ELEM_IN)
              ENDIF
            ENDDO
            
            
            
            
          ELSE
            
            
C     .... Order with key IA1N ...
            CALL MRGSRT(NNZ,IA1N,AUX,IRET)
            IF (IRET.EQ.0) CALL REORDVN(NNZ,ARN,IA1N,IA2N,AUX)
C     .... Order with key IA2N ...
            
            I    = 1
            J    = I
            DO WHILE (I.LE.NNZ)
              DO WHILE ((IA1N(J).EQ.IA1N(I)).AND.
     +          (J.LE.NNZ))
                J = J+1
              ENDDO
              NZL = J - I
              CALL MRGSRT(NZL,IA2N(I),AUX,IRET)
              IF (IRET.EQ.0) CALL REORDVN(NZL,ARN(I),IA1N(I),IA2N(I),
     +          AUX)
              I = J
            ENDDO
C     ... Construct final COO  Representation...
            ELEM_OUT = 1
C     ... Insert remaining element ...
            DO ELEM_IN  = 2, NNZ
              IF ((IA1N(ELEM_IN).EQ.IA1N(ELEM_OUT)).AND.
     +          (IA2N(ELEM_IN).EQ.IA2N(ELEM_OUT))) THEN 
                IF (CHECK_FLAG.EQ.1) THEN
C     ... Error, there are duplicated elements ...
                  IERRV(1) = 100
                  RETURN
                ELSE IF (CHECK_FLAG.EQ.2) THEN
C     ... Insert only the first duplicated element ...
                ELSE IF (CHECK_FLAG.EQ.3) THEN
C     ... Sum the duplicated element ...
                  ARN(ELEM_OUT) = ARN(ELEM_OUT) + ARN(ELEM_IN)
                END IF
              ELSE
                ELEM_OUT = ELEM_OUT + 1
                ARN(ELEM_OUT)  = ARN(ELEM_IN)
                IA1N(ELEM_OUT) = IA1N(ELEM_IN)
                IA2N(ELEM_OUT) = IA2N(ELEM_IN)
              ENDIF
            ENDDO
          ENDIF
          INFON(1) = ELEM_OUT
          if (debug) write(*,*)'Done Rebuild COO',infon(1)
          
        ELSE IF (DESCRA(1:1).EQ.'S' .AND. DESCRA(2:2).EQ.'U') THEN
C     
C     
C     CHECK ON DIMENSION OF IA1N AND ARN
C     
          IF (NNZ .GT. LIA1N) THEN
            CALL XSPERR('MATST   ',LIA1N,19,'DCOCO',IERRV)
            LIA1N  = NNZ
          END IF
          IF (NNZ .GT. LARN) THEN
            CALL XSPERR('MATST   ',LARN,18,'DCOCO',IERRV)
            LARN   = NNZ
          END IF
C
C           QUICK RETURN IF IERRV IS DIFFERENT FROM ZERO
C
          IF (IERRV(1) .NE. 0) RETURN
          DO 20 K = 1, M
            P2(K) = K
 20       CONTINUE
        ELSE IF (DESCRA(1:1).EQ.'T' .AND. DESCRA(2:2).EQ.'U') THEN
C
C
C           CHECK ON DIMENSION OF IA1N AND ARN
C
          IF (NNZ .GT. LIA1N) THEN
            CALL XSPERR('MATST   ',LIA1N,19,'DCOCO',IERRV)
            LIA1N  = NNZ
          END IF
          IF (NNZ .GT. LARN) THEN
            CALL XSPERR('MATST   ',LARN,18,'DCOCO',IERRV)
            LARN   = NNZ
          END IF
C
C           QUICK RETURN IF IERRV IS DIFFERENT FROM ZERO
C
          IF (IERRV(1) .NE. 0) RETURN
        ELSE IF (DESCRA(1:1).EQ.'T' .AND. DESCRA(2:2).EQ.'L') THEN
C
C
C           CHECK ON DIMENSION OF IA1N AND ARN
C
          IF (NNZ .GT. LIA1N) THEN
            CALL XSPERR('MATST   ',LIA1N,19,'DCOCO',IERRV)
            LIA1N  = NNZ
          END IF
          IF (NNZ .GT. LARN) THEN
            CALL XSPERR('MATST   ',LARN,18,'DCOCO',IERRV)
            LARN   = NNZ
          END IF
C
C           QUICK RETURN IF IERRV IS DIFFERENT FROM ZERO
C
          IF (IERRV(1) .NE. 0) RETURN
        END IF
C
      ELSE IF (TRANS.NE.'N') THEN
C
C           TO DO
C
        CALL XSPERR('TRANS   ',TRANS,1,'DCOCO',IERRV)
      END IF
 9999 RETURN
      END
