      subroutine  zaxpby(m, n, alpha, X, lldx, beta, Y, lldy)
      complex*16 one, zero
      parameter  (one = (1.0d0, 0.0d0), zero=(0.0d0, 0.0d0))
      integer n, m, lldx, lldy
      complex*16 X(lldx,*), Y(lldy,*)
      complex*16 alpha, beta
      
      integer i, j, ierror

      ierror = 0
      if (m.lt.0) then 
         ierror=-1
      else if (n.lt.0) then 
         ierror=-2
      else if (lldx.lt.max(1,m)) then 
         ierror=-5
      else if (lldy.lt.max(1,m)) then 
         ierror=-8
      endif
C
C     Error handling
C
      if (ierror.lt.0) then
         return
      endif

      if (alpha.eq.zero) then 
         if (beta.eq.zero) then 
            do j=1, n 
               do i=1,m 
                  y(i,j) = zero
               enddo 
            enddo
         else if (beta.eq.one) then
c$$$
c$$$     Do nothing! 
c$$$            

         else if (beta.eq.-one) then 
            do j=1,n 
               do i=1,m 
                  y(i,j) = - y(i,j)
               enddo
            enddo
         else  
            do j=1,n 
               do i=1,m 
                  y(i,j) =  beta*y(i,j)
               enddo
            enddo            
         endif

      else if (alpha.eq.one) then

         if (beta.eq.zero) then 
            do j=1,n 
               do i=1,m 
                  y(i,j) = x(i,j)
               enddo
            enddo
         else if (beta.eq.one) then
            do j=1,n 
               do i=1,m 
                  y(i,j) = x(i,j) + y(i,j)
               enddo
            enddo

         else if (beta.eq.-one) then 
            do j=1,n 
               do i=1,m 
                  y(i,j) = x(i,j) - y(i,j)
               enddo
            enddo
         else  
            do j=1,n 
               do i=1,m 
                  y(i,j) = x(i,j) + beta*y(i,j)
               enddo
            enddo            
         endif

      else if (alpha.eq.-one) then 

         if (beta.eq.zero) then 
            do j=1,n 
               do i=1,m 
                  y(i,j) = -x(i,j)
               enddo
            enddo
         else if (beta.eq.one) then
            do j=1,n 
               do i=1,m 
                  y(i,j) = -x(i,j) + y(i,j)
               enddo
            enddo

         else if (beta.eq.-one) then 
            do j=1,n 
               do i=1,m 
                  y(i,j) = -x(i,j) - y(i,j)
               enddo
            enddo
         else  
            do j=1,n 
               do i=1,m 
                  y(i,j) = -x(i,j) + beta*y(i,j)
               enddo
            enddo            
         endif

      else  

         if (beta.eq.zero) then 
            do j=1,n 
               do i=1,m 
                  y(i,j) = alpha*x(i,j)
               enddo
            enddo
         else if (beta.eq.one) then
            do j=1,n 
               do i=1,m 
                  y(i,j) = alpha*x(i,j) + y(i,j)
               enddo
            enddo

         else if (beta.eq.-one) then 
            do j=1,n 
               do i=1,m 
                  y(i,j) = alpha*x(i,j) - y(i,j)
               enddo
            enddo
         else  
            do j=1,n 
               do i=1,m 
                  y(i,j) = alpha*x(i,j) + beta*y(i,j)
               enddo
            enddo            
         endif

      endif

      return
      end
