C     ****************************************
C     * Write error messages                 *
C     ****************************************

      SUBROUTINE WRITE_MESSAGE(IERROR, STRINGS, INT_VAL, REAL_VAL)
      
      IMPLICIT NONE

C
C     ...Scalar Arguments...
C
      INTEGER IERROR
C
C     ...Array Arguments...
C     
      CHARACTER*30      STRINGS(*)
      INTEGER           INT_VAL(*)
      DOUBLE PRECISION  REAL_VAL(*)
      
      IF (IERROR.LT.0) THEN
        WRITE (0,*) 'Error on calling SPERROR.',
     +    ' IERROR must be greater than 0'
      ELSE IF (IERROR.LT.1000) THEN ! Error on input arguments
        WRITE (0,*) 'Input Arguments Error. Code : ',IERROR
        
        IF (IERROR.EQ.10) THEN
          WRITE (0,*) 'Input argument n. ',INT_VAL(1), 
     +      'cannot be less than 0'
          WRITE (0,*) 'Current value is ',INT_VAL(2)
        ELSE IF (IERROR.EQ.20) THEN
          WRITE (0,*) 'Input argument n. ',INT_VAL(1), 
     +      'cannot be greater than 0'
          WRITE (0,*) 'Current value is ',INT_VAL(2)
        ELSE IF (IERROR.EQ.30) THEN
          WRITE (0,*) 'Input argument n. ',INT_VAL(1), 
     +      'has an invalid value'
          WRITE (0,*) 'Current value is ',INT_VAL(2)
        ELSE IF (IERROR.EQ.40) THEN
          WRITE (0,*) 'Input argument n. ',INT_VAL(1), 
     +      'has an invalid value'
          WRITE (0,*) 'Current value is ',STRINGS(1)
        ELSE IF (IERROR.EQ.50) THEN
          WRITE (0,*) 'Input argument n. ',INT_VAL(1),
     +      ' must be equal or greater than input argument n. ',
     +      INT_VAL(2)
          WRITE (0,*) 'Current values are ',INT_VAL(3),
     +      ' < ', INT_VAL(4)
        ELSE IF (IERROR.EQ.60) THEN
          WRITE (0,*) 'Input argument n. ',INT_VAL(1),
     +      ' must be equal or greater than ',
     +      INT_VAL(2)
          WRITE (0,*) 'Current value is ',INT_VAL(3),
     +      ' < ', INT_VAL(2)
        ELSE IF (IERROR.EQ.70) THEN
          WRITE (0,*) 'Input argument n. ',INT_VAL(1),
     +      ' in entry # ',INT_VAL(2),' has an invalid value'
          WRITE (0,*) 'Current value is ',STRINGS(1)
C        ... CSR Format Error ...
        ELSE IF (IERROR.EQ.80) THEN
          WRITE (0,*) 'Input argument IA2(1) is less than 0'
          WRITE (0,*) 'Current value is ',INT_VAL(1)
C        ... CSR Format Error ...
        ELSE IF (IERROR.EQ.90) THEN
          WRITE (0,*) 'Indices in IA2 array are not in',
     +      ' increasing order'
        ELSE IF (IERROR.EQ.91) THEN
          WRITE (0,*) 'Indices in IA1 array are not in',
     +      ' increasing order'
C        ... CSR Format Error ...
        ELSE IF (IERROR.EQ.100) THEN
          WRITE (0,*) 'Indices in IA1 array are not',
     +      ' within problem dimension'
          WRITE (0,*) 'Problem dimension is ',INT_VAL(1)
        ELSE IF (IERROR.EQ.110) THEN
          WRITE (0,*) 'Invalid combination of input arguments'
        ELSE IF (IERROR.EQ.120) THEN
          WRITE (0,*) 'Input argument n. ',INT_VAL(1),
     +      ' must be greater than input argument n. ',
     +      INT_VAL(2)
          WRITE (0,*) 'Current values are ',INT_VAL(3),
     +      ' < ', INT_VAL(4)
C        ... COO Format Error ...
        ELSE IF (IERROR.EQ.130) THEN
          WRITE (0,*) 'There are duplicated elements in COO format'
          WRITE (0,*) 'Please set REPFLAG flag to  2 or 3'
        ELSE IF (IERROR.EQ.140) THEN
          WRITE (0,*) 'Indices in input array are not',
     +      ' within problem dimension',int_val(1),int_val(2)
        ELSE IF (IERROR.EQ.150) THEN
          WRITE (0,*) 'Indices in input array are not',
     +      ' belonging to the calling process',int_val(1)
        ENDIF

      ELSE IF (IERROR.LT.2000) THEN
        WRITE(0,*) 'Computational Error. Code: ',IERROR
      ELSE IF (IERROR.LT.3000) THEN
        WRITE(0,*) 'Resource Error. Code: ',IERROR
      ELSE IF (IERROR.LT.4000) THEN
        WRITE(0,*) 'Miscellaneus Error. Code: ',IERROR
        
        IF ((IERROR.GE.3010).AND.(IERROR.LE.3012)) THEN
          WRITE (0, *) 'Sparse matrix representation ',STRINGS(1),
     +      'not yet implemented'
        ELSE IF (IERROR.EQ.3015) THEN
          WRITE (0, *) 'Transpose option for sparse matrix',
     +      ' representation ',STRINGS(1), ' not implemented'
        ENDIF
      ENDIF

      END
