C     ****************************************
C     *  Set the Check Flag that specify     *
C     *  what kind of action to perform when *
C     *  convert a representation format to  *
C     *  another                             *
C     *  The actions to perform when is      *
C     *  encountered a duplicated point are: *
C     *   1- Return an error code            *
C     *   2- Substitute the old value        *
C     *   3- Sum the old value with the      *
C     *      current value                   *
C     ****************************************

      SUBROUTINE SETREPFLAG(FLAG_CHECK)
      
      IMPLICIT NONE
C
C     ...Scalar argument..
C
      INTEGER FLAG_CHECK
C
C     ...Common variables...
C     This flag describe the action to do
      
      COMMON /CHECKCNTRL/CHECK_FLAG
      INTEGER CHECK_FLAG
      SAVE  /CHECKCNTRL/
      
C     ...Local scalars...
      INTEGER IERROR
C     ...Local Array...
      DOUBLE PRECISION  REAL_VAL(5)
      INTEGER           INT_VAL(5)
      CHARACTER*30      NAME, STRINGS(2)

      IF ((FLAG_CHECK.EQ.1).OR.(FLAG_CHECK.EQ.2).OR.
     +   (FLAG_CHECK.EQ.3)) THEN
         CHECK_FLAG = FLAG_CHECK
      ELSE
C        ...Invalid Input argument....
         NAME = 'SETREPFLAG\0'
         IERROR = 30
         INT_VAL(1) = 1
         INT_VAL(2) = FLAG_CHECK
         WRITE(0,*) 'ERROR in SUBROUTINE ', NAME
         CALL WRITE_MESSAGE(IERROR, STRINGS, INT_VAL, REAL_VAL)
         CALL EXIT(IERROR)
      ENDIF
      END

C     ...Initialize CHECK flag...
      BLOCK DATA INITCHECK
      COMMON /CHECKCNTRL/CHECK_FLAG
      INTEGER CHECK_FLAG
      SAVE  /CHECKCNTRL/
      DATA CHECK_FLAG/2/
      END
