*****************************************************************************
*      SUBROUTINE ZCOOLUN(M,DESCRA,A,JA,IA,INFOA,                           *
*                         DESCRLO,ALO,JLO,ILO,INFOLO,                       *
*                         DESCRUP,AUP,JUP.IUP,INFOUP,                       *
*                         DIAG,METHD,IER)                                   *
*                                                                           *
*     Purpose                                                               *
*     =======                                                               *
*     Computes preconditioner (=ALO*DIAG*AUP) using incomplete LU           *
*     Factorization of A(:,1:M)                                             *
*     A is a general M by K  matrix rappresented in CSR mode with M<=K      *
*     The preconditioner matrices are stored in CSR-general mode            *
*                                                                           *
*     Parameter                                                             *
*     =========                                                             *
*     INPUT=                                                                *
*                                                                           *
*     M:   Parameter No. 1                                                  *
*      Values:        M>0                                                   *
*      Description:   On entry M specifies the number of rows of the        *
*                    sparse matrix.                                         *
*                    Unchanged on exit.                                     *
*                                                                           *
*     A, JA,IA,FIDA,DESCRA,INFOA: Parameters No. 2-7                        *
*     Values: A sparse matrix in the Sparse BLAS format                     *
*     Description:   The sparse matrix to be factored. Only CSR format      *
*                    is supported.                                          *
*                                                                           *
*      METHD:    PARAMETER No. 21.                                          *
*      DESCRIPTION:   Method for factorization: if METHD==1  then           *
*                     we want a positive diagonal, otherwise we want        *
*                     a non-zero diagonal.                                  *
*                                                                           *
*     OUTPUT=                                                               *
*                                                                           *
*     ALO, JLO,ILO,FIDLO,DESCRLO,INFOLO: Parameters No. 8-13                *
*     Values: A sparse matrix in the Sparse BLAS format                     *
*     Description:   The lower factor                                       *
*                                                                           *
*     AUP, JUP,IUP,FIDUP,DESCRUP,INFOUP: Parameters No. 14-19               *
*     Values: A sparse matrix in the Sparse BLAS format                     *
*     Description:   The upper factor                                       *
*                                                                           *
*                                                                           *
*     DIAG :      Parameter No. 20                                          *
*     Values:  double precision array >0.D0                                 *
*     DESCRIPTION:   DIAG(I) specifies the value of i-th element belonging  *
*                    to the preconditioner's diagonal.                      *
*                    The array is rapresented in dense mode                 *
*                                                                           *
*      IER:      PARAMETER No. 22.                                          *
*      DESCRIPTION:   IER contains the values of error flag.                *
*****************************************************************************
      SUBROUTINE ZCOOLU(M,DESCRA,A,IA,JA,INFOA,
     +  DESCRLO,ALO,ILO,JLO,INFOLO,
     +  DESCRUP,AUP,IUP,JUP,INFOUP,DIAG, METHD,
     +  IWORK,LWORK,IER)
C
C     .. Scalar Arguments ..
      INTEGER           IER, M, METHD,LWORK
C     .. Array Arguments ..
      COMPLEX*16        A(*), ALO(*), AUP(*), DIAG(*)
      INTEGER           IA(*), ILO(*), IUP(*), JA(*),
     +  JLO(*), JUP(*), INFOA(*), INFOLO(*), INFOUP(*),IWORK(*)
      CHARACTER         DESCRA*11,DESCRLO*11,DESCRUP*11
C     .. Local Scalars ..
      COMPLEX*16        DIA, TEMP, SCAL
      INTEGER           I, II, J, JJ, K, KK, L, L1, L2, LL, LOW1, LOW2,
     *  NEL, NELMAX, NNZ, LINP, KLW, KUP, ROW, IEL
      double precision epstol
      LOGICAL          LOOP
C     .. Data stetements ..
      DATA              EPSTOL/1.D-12/
C     .. Executable Statements ..
C
      SCAL = 1.D0
      NEL = 0
      NELMAX = 3
      IER = 0
      NNZ = INFOA(1)
c$$$      write(*,*) 'ZCOOLU ',lwork,m
      if (lwork.ge.m+1) then 
        iel=1
        iwork(1) = 1
        DO ROW = IWORK(1), M
c$$$              if (debug) write(*,*)'CSR Loop:',row,m,elem_csr
          DO WHILE (IA(IEL).EQ.ROW)
            IEL = IEL + 1
          ENDDO
          IWORK(ROW+1) = IEL
        ENDDO

 555    CONTINUE
        ILO(1) = 1
        IUP(1) = 1
        L1 = 0
        L2 = 0

C
C     LOOP OVER ROWS
C
        DO 160 I = 1, M
C
C        COPY A(I,*) INTO ALO,DIAG,AUP, AND SORT ROW
C
C        All diagonal elements of A are stored in DIAG
C        All elements below the diagonal of A are stored in ALO
C        All elements above the diagonal of A are stored in AUP
C
          DIAG(I) = 0.D0
          DO 20 J = IWORK(I), IWORK(I+1) - 1
            K = JA(J)
            IF ((K.LT.I).AND.(K.GE.1)) THEN
              L1 = L1 + 1
              ALO(L1) = A(J)*SCAL
              JLO(L1) = K
            ELSE IF (K.EQ.I) THEN
              DIAG(I) = A(J)
            ELSE IF ((K.GT.I).AND.(K.LE.M)) THEN
              L2 = L2 + 1
              AUP(L2) = A(J)*SCAL
              JUP(L2) = K
            END IF
 20       CONTINUE

C

          ILO(I+1) = L1 + 1
          IUP(I+1) = L2 + 1
C
C        INCOMPLETE FACTORIZATION OF MATRIX IN ROW WISE FORMAT
C
          DIA = DIAG(I)
          DO 120 KK = ILO(I), ILO(I+1) - 1
C
C           COMPUTE ELEMENT ALO(I,K) OF INCOMPLETE FACTORIZATION
C
            TEMP = ALO(KK)
            K = JLO(KK)
            ALO(KK) = TEMP*DIAG(K)
C           UPDATE THE REST OF ROW I USING ALO(I,K)
            LOW1 = KK + 1
            LOW2 = IUP(I)
            DO 100 JJ = IUP(K), IUP(K+1) - 1
              J = JUP(JJ)
C
              IF (J.LT.I) THEN
C                 SEARCH ALO(I,*) FOR MATCHING INDEX J
                DO 40 LL = LOW1, ILO(I+1) - 1
                  L = JLO(LL)
                  IF (L.GT.J) THEN
                    LOW1 = LL
                    GO TO 80
                  ELSE IF (L.EQ.J) THEN
                    ALO(LL) = ALO(LL) - TEMP*AUP(JJ)
                    LOW1 = LL + 1
                    GO TO 100
                  END IF
 40             CONTINUE
C
              ELSE IF (J.EQ.I) THEN
C                 J=I  UPDATE DIAGONAL
                DIA = DIA - TEMP*AUP(JJ)
                GO TO 100
C
              ELSE IF (J.GT.I) THEN
C                 SEARCH AUP(I,*) FOR MATCHING INDEX J
                DO 60 LL = LOW2, IUP(I+1) - 1
                  L = JUP(LL)
                  IF (L.GT.J) THEN
                    LOW2 = LL
                    GO TO 80
                  ELSE IF (L.EQ.J) THEN
                    AUP(LL) = AUP(LL) - TEMP*AUP(JJ)
                    LOW2 = LL + 1
                    GO TO 100
                  END IF
 60             CONTINUE
              END IF
 80           CONTINUE
C
C              FOR MILU AL=1.;  FOR ILU AL=0.
C              AL = 1.D0
C              DIA = DIA - AL*TEMP*AUP(JJ)
 100        CONTINUE
 120      CONTINUE
C
          IF (METHD.EQ.1) THEN
C
C           Positive diagonal
C
            IF (ABS(DIA).LT.EPSTOL) THEN
              IF (NEL .GE. NELMAX) THEN
                SCAL = SCAL - 1.D-02
                IF (ABS(SCAL) .GT. EPSTOL) THEN
                  NEL = 0
                  GO TO 555
                ELSE
C
C                    Pivot too small: unstable factorization
C
                  IER = 2
                  RETURN
                END IF
              ELSE
                NEL = NEL + 1
                DIA = ABS(DIA)
              END IF
            ELSE
              DIA = 1.D0/DIA
            END IF
          ELSE
C
C           Non singularity
C
            IF (ABS(DIA).LT.EPSTOL) THEN
C
C              Pivot too small: unstable factorization
C
              IER = 2
              write(6,*)'error pivot too small', dia
              RETURN
            ELSE
              DIA = 1.D0/DIA
            END IF
          END IF
          DIAG(I) = DIA
C        write(6,*)'diag(',i,')=',diag(i)
C        Scale row i of upper triangle
          DO 140 KK = IUP(I), IUP(I+1) - 1
            AUP(KK) = AUP(KK)*DIA
 140      CONTINUE
C
 160    CONTINUE
        do i=1, m+1
          iwork(i) = iup(i)
        enddo
        do i=1, m
          do j=iwork(i), iwork(i+1)-1 
            iup(j) = i
          enddo
        enddo

        do i=1, m+1
          iwork(i) = ilo(i)
        enddo
        do i=1, m
          do j=iwork(i), iwork(i+1)-1 
            ilo(j) = i
          enddo
        enddo


      ELSE
        

 554    CONTINUE
        L1 = 0
        L2 = 0

C
C     LOOP OVER ROWS
C
        LINP = 1
        DO WHILE ((IA(LINP).NE.1).AND.(LINP.LE.NNZ))
          LINP = LINP+1
        ENDDO
        IF ((LINP.GT.NNZ).OR.(IA(LINP).NE.1)) THEN
          IER = 3
          write(6,*)'Invalid input matrix  1', linp, ia(linp)
          RETURN
        ENDIF

        DO I = 1, M
c$$$        write(6,*)'Debug: loop on rows',
c$$$     +     m,i,linp,nnz,ia(linp),ja(linp)
C
C        COPY A(I,*) INTO ALO,DIAG,AUP, AND SORT ROW
C
C        All diagonal elements of A are stored in DIAG
C        All elements below the diagonal of A are stored in ALO
C        All elements above the diagonal of A are stored in AUP
C
          DIAG(I) = 0.D0
          II = LINP
          IF ((LINP.GT.NNZ).OR.(IA(LINP).NE.I)) THEN
            IER = 3
            write(6,*)'Invalid input matrix  2:',
     +        linp, nnz, ia(linp), i
            RETURN
          ENDIF

          DO WHILE ((IA(LINP).EQ.I).AND.(LINP.LE.NNZ))
            LINP = LINP+1
          ENDDO
          KLW = L1+1
          KUP = L2+1

          DO J = II, LINP - 1
            K = JA(J)
            IF ((K.LT.I).AND.(K.GE.1)) THEN
              L1 = L1 + 1
              ALO(L1) = A(J)*SCAL
              ILO(L1) = I
              JLO(L1) = K
            ELSE IF (K.EQ.I) THEN
              DIAG(I) = A(J)
            ELSE IF ((K.GT.I).AND.(K.LE.M)) THEN
              L2 = L2 + 1
              AUP(L2) = A(J)*SCAL
              IUP(L2) = I
              JUP(L2) = K
            END IF
          ENDDO

C
C        INCOMPLETE FACTORIZATION OF MATRIX IN ROW WISE FORMAT
C
          DIA = DIAG(I)
          DO KK = KLW, L1
C
C           COMPUTE ELEMENT ALO(I,K) OF INCOMPLETE FACTORIZATION
C
            TEMP    = ALO(KK)
            K       = JLO(KK)
            ALO(KK) = TEMP*DIAG(K)
C           UPDATE THE REST OF ROW I USING ALO(I,K)
            LOW1    = KK + 1
            LOW2    = KUP
            JJ      = 1
            DO WHILE ( (IUP(JJ).NE.K).AND.(JJ.LE.L2))
              JJ = JJ+1
            ENDDO

            DO WHILE  ((IUP(JJ).EQ.K).AND.(JJ.LE.L2))
              J = JUP(JJ)
C
              IF (J.LT.I) THEN
C                 SEARCH ALO(I,*) FOR MATCHING INDEX J
                LL = LOW1
                LOOP = .TRUE.
                DO WHILE ((LL.LE.L1).AND.LOOP)
                  L = JLO(LL)
                  IF (L.GT.J) THEN
                    LOW1 = LL
                    LOOP = .FALSE.
                  ELSE IF (L.EQ.J) THEN
                    ALO(LL) = ALO(LL) - TEMP*AUP(JJ)
                    LOW1 = LL + 1
                    LOOP = .FALSE.
                  END IF
                  LL = LL+1
                ENDDO
C
              ELSE IF (J.EQ.I) THEN
C                 J=I  UPDATE DIAGONAL
                DIA = DIA - TEMP*AUP(JJ)
C
              ELSE IF (J.GT.I) THEN
C                 SEARCH AUP(I,*) FOR MATCHING INDEX J
                LL = LOW2
                LOOP = .TRUE.
                DO WHILE ((LL.LE.L2).AND.LOOP)
                  L = JUP(LL)
                  IF (L.GT.J) THEN
                    LOW2 = LL
                    LOOP = .FALSE.
                  ELSE IF (L.EQ.J) THEN
                    AUP(LL) = AUP(LL) - TEMP*AUP(JJ)
                    LOW2 = LL + 1
                    LOOP = .FALSE.
                  END IF
                  LL = LL+1
                ENDDO
              END IF
C
C              FOR MILU AL=1.;  FOR ILU AL=0.
C              AL = 1.D0
C              DIA = DIA - AL*TEMP*AUP(JJ)
              JJ = JJ + 1
            ENDDO
          ENDDO
C
          IF (METHD.EQ.1) THEN
C
C           Positive diagonal
C
            IF (ABS(DIA).LT.EPSTOL) THEN
              IF (NEL .GE. NELMAX) THEN
                SCAL = SCAL - 1.D-02
                IF (ABS(SCAL) .GT. EPSTOL) THEN
                  NEL = 0
                  GO TO 554
                ELSE
C
C                    Pivot too small: unstable factorization
C
                  IER = 2
                  RETURN
                END IF
              ELSE
                NEL = NEL + 1
                DIA = ABS(DIA)
              END IF
            ELSE
              DIA = 1.D0/DIA
            END IF
          ELSE
C
C           Non singularity
C
            IF (ABS(DIA).LT.EPSTOL) THEN
C
C              Pivot too small: unstable factorization
C
              IER = 2
              write(6,*)'error pivot too small', dia
              RETURN
            ELSE
              DIA = 1.D0/DIA
            END IF
          END IF
          DIAG(I) = DIA
C        write(6,*)'diag(',i,')=',diag(i)
C        Scale row i of upper triangle
          DO KK = KUP, L2
            AUP(KK) = AUP(KK)*DIA
          ENDDO
C
        ENDDO

      endif

      INFOLO(1) = L1
      DESCRLO   = 'TLU'

      INFOUP(1) = L2
      DESCRUP   = 'TUU'

      RETURN
      END




