*****************************************************************************
*      SUBROUTINE DCSLU (M,A,JA,IA,FIDA,DESCRA,INFOA,                       *
*                         ALO,JLO,ILO,FIDLO,DESCRLO,INFOLO,                 *        
*                         AUP,JUP.IUP,FIDUP,DESCRUP,INFOUP,                 *        
*                         DIAG,METHD,IER)                                   *        
*                                                                           *
*     Purpose                                                               *
*     =======                                                               *
*     Computes preconditioner (=ALO*DIAG*AUP) using incomplete LU           *
*     Factorization of A(:,1:M)                                             *
*     A is a general M by K  matrix rappresented in CSR mode with M<=K      *
*     The preconditioner matrices are stored in CSR-general mode            *
*                                                                           *
*     Parameter                                                             *
*     =========                                                             *
*     INPUT=                                                                *
*                                                                           *
*     M:   Parameter No. 1                                                  *
*      Values:        M>0                                                   *
*      Description:   On entry M specifies the number of rows of the        *
*                    sparse matrix.                                         *
*                    Unchanged on exit.                                     *
*                                                                           *
*     A, JA,IA,FIDA,DESCRA,INFOA: Parameters No. 2-7                        *
*     Values: A sparse matrix in the Sparse BLAS format                     *
*     Description:   The sparse matrix to be factored. Only CSR format      *
*                    is supported.                                          *
*                                                                           *
*      METHD:    PARAMETER No. 21.                                          *
*      DESCRIPTION:   Method for factorization: if METHD==1  then           *
*                     we want a positive diagonal, otherwise we want        *
*                     a non-zero diagonal.                                  *
*                                                                           *
*     OUTPUT=                                                               *
*                                                                           *
*     ALO, JLO,ILO,FIDLO,DESCRLO,INFOLO: Parameters No. 8-13                *
*     Values: A sparse matrix in the Sparse BLAS format                     *
*     Description:   The lower factor                                       *
*                                                                           *
*     AUP, JUP,IUP,FIDUP,DESCRUP,INFOUP: Parameters No. 14-19               *
*     Values: A sparse matrix in the Sparse BLAS format                     *
*     Description:   The upper factor                                       *
*                                                                           *
*                                                                           *
*     DIAG :      Parameter No. 20                                          *
*     Values:  double precision array >0.D0                                 *
*     DESCRIPTION:   DIAG(I) specifies the value of i-th element belonging  *
*                    to the preconditioner's diagonal.                      *
*                    The array is rapresented in dense mode                 *
*                                                                           *
*      IER:      PARAMETER No. 22.                                          *
*      DESCRIPTION:   IER contains the values of error flag.                *
*****************************************************************************
      SUBROUTINE DCSLU(M,FIDA,DESCRA,A,IA1,IA2,INFOA,IPERM,
     +  FIDLO,DESCRLO,ALO,IL1,IL2,LP1,LP2,INFOLO,LARLO,LIA1LO,LIA2LO,
     +  FIDUP,DESCRUP,AUP,IU1,IU2,UP1,UP2,INFOUP,LARUP,LIA1UP,LIA2UP,
     +  FIDH, DESCRH, HR, IH1,IH2,HP1,HP2,INFOH,LHR,LIH1,LIH2, 
     +  DIAG,METHD,WORK,LWORK,IER)
C                                                                               
C     .. Scalar Arguments ..                                                    
      INTEGER           IER, M, METHD, LWORK            
C     .. Array Arguments ..                                                     
      DOUBLE PRECISION  A(*), ALO(*), AUP(*), HR(*), DIAG(*),WORK(*)    
      INTEGER           IA1(*), IL1(*), IU1(*), IH1(*), IA2(*), 
     +  IL2(*), IU2(*), IH2(*), INFOA(*), INFOLO(*),INFOUP(*),INFOH(*),
     +  LP1(*), LP2(*), UP1(*), UP2(*), HP1(*), HP2(*),IPERM(*)
      CHARACTER         DESCRA*11,DESCRLO*11,DESCRUP*11, DESCRH*11,
     +  FIDA*5,FIDLO*5,FIDUP*5,FIDH*5, unitd
C     .. Local Scalars ..                                                       
      DOUBLE PRECISION  DIA, TEMP, EPSTOL, SCAL                                 
      INTEGER           I, J, JJ, K, KK, L, L1, L2, LL, LOW1, LOW2,             
     *  NEL, NELMAX,N                                     
      INTEGER           INT_VAL(5),IERRV(5)
      DOUBLE PRECISION  REAL_VAL(5)
      CHARACTER*30      STRINGS(2)
      CHARACTER         NAME*30
      CHARACTER         TRANS

C     .. Executable Statements ..                                               
C        
C     Check for argument errors
C
      IER = 0
      IERRV(1)=0
      NAME = 'DCSLU\0'
      IF (M.LT.0) THEN
        IER = 10
        INT_VAL(1) = 1
        INT_VAL(2) = M
      ENDIF
      TRANS = 'N'
      UNITD = 'U'
C
C     Error handling
C
      IF(IER.NE.0) THEN
        CALL SPERROR(IER,NAME,STRINGS,INT_VAL,REAL_VAL)
        GOTO 9999
      ENDIF

      IF (M.LE.0) THEN
        GOTO 9999
      ENDIF
      IF (FIDA(1:3).EQ.'CSR') THEN
        CALL DCSRLU(M,DESCRA,A,IA1,IA2,INFOA,DESCRLO,
     +    ALO,IL1,IL2,INFOLO,
     +    DESCRUP,AUP,IU1,IU2,INFOUP,DIAG, METHD,IER)
        FIDLO = 'CSR'
        FIDUP = 'CSR'

      ELSE IF (FIDA(1:3).EQ.'COO') THEN

        CALL DCOOLU(M,DESCRA,A,IA1,IA2,INFOA,DESCRLO,
     +    ALO,IL1,IL2,INFOLO,
     +    DESCRUP,AUP,IU1,IU2,INFOUP,DIAG, METHD,
     +    WORK,2*LWORK,IER)

        FIDLO = 'COO'
        FIDUP = 'COO'

      ELSE IF (FIDA(1:3).EQ.'JAD') THEN
        N  = M 
      
        CALL DJDCO(TRANS,M,N,DESCRA,A,IA1,IA2,IPERM,INFOA,
     +    HP1,DESCRH,HR,IH1,IH2,INFOH,HP2,LHR,LIH1,
     +    LIH2,WORK,2*LWORK,IERRV)

        IF(IERRV(1) .NE. 0) THEN
          NAME = 'DCSLU\0'
          IF (IERRV(1).EQ.10) THEN
            IER = 60
            INT_VAL(1) = 25
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LWORK
          ELSE IF (IERRV(1).EQ.20) THEN
            IER = 60
            INT_VAL(1) = 21
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LH
          ELSE IF (IERRV(1).EQ.30) THEN
            IER = 60
            INT_VAL(1) = 22
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LH1
          ELSE IF (IERRV(1).EQ.40) THEN
            IER = 120
            INT_VAL(1) = 23
            INT_VAL(2) = 3
            INT_VAL(3) = LH2
            INT_VAL(4) = M
          ELSE IF (IERRV(1).EQ.100) THEN
            IER = 130
          END IF
        END IF

        
        FIDH = 'COO'
        CALL DCOOLU(M,DESCRA,HR,IH1,IH2,INFON,DESCRLO,
     +    ALO,IL1,IL2,INFOLO,
     +    DESCRUP,AUP,IU1,IU2,INFOUP,DIAG, METHD,
     +    WORK,2*LWORK,IER)

        FIDLO = 'COO'
        FIDUP = 'COO'

        CALL DCOCR(TRANS,M,N,UNITD,D,DESCRLO,ALO,IL2,IL1,INFOLO,
     +    HP1,DESCRH,HR,IH1,IH2,INFOH,HP2,LHR,LIH1,
     +    LIH2,WORK,LWORK,IERRV)

        IF(IERRV(1) .NE. 0) THEN
          NAME = 'DCSLU\0'
          IF (IERRV(1).EQ.10) THEN
            IER = 60
            INT_VAL(1) = 25
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LWORK
          ELSE IF (IERRV(1).EQ.20) THEN
            IER = 60
            INT_VAL(1) = 21
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LH
          ELSE IF (IERRV(1).EQ.30) THEN
            IER = 60
            INT_VAL(1) = 22
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LH1
          ELSE IF (IERRV(1).EQ.40) THEN
            IER = 120
            INT_VAL(1) = 23
            INT_VAL(2) = 3
            INT_VAL(3) = LH2
            INT_VAL(4) = M
          ELSE IF (IERRV(1).EQ.100) THEN
            IER = 130
          END IF
        END IF
        ierrv(1)=0
        descrh(1:3)=descrlo(1:3)
        CALL DCRJD(TRANS,M,N,UNITD,D,DESCRH,HR,IH1,IH2,INFOH,
     +    LP1,DESCRLO,ALO,IL1,IL2,INFOLO,LP2,LARLO,LIA1LO,
     +    LIA2LO,WORK,LWORK,LIA1LO,IERRV)
        FIDLO = 'JAD'

        IF(IERRV(1) .NE. 0) THEN
          NAME = 'DCSLU\0'
          IF (IERRV(1).EQ.10) THEN
            IER = 60
            INT_VAL(1) = 25
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LWORK
          ELSE IF (IERRV(1).EQ.20) THEN
            IER = 60
            INT_VAL(1) = 21
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LH
          ELSE IF (IERRV(1).EQ.30) THEN
            IER = 60
            INT_VAL(1) = 22
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LH1
          ELSE IF (IERRV(1).EQ.40) THEN
            IER = 120
            INT_VAL(1) = 23
            INT_VAL(2) = 3
            INT_VAL(3) = LH2
            INT_VAL(4) = M
          ELSE IF (IERRV(1).EQ.100) THEN
            IER = 130
          END IF
        END IF


        CALL DCOCR(TRANS,M,N,UNITD,D,DESCRUP,AUP,IU2,IU1,INFOUP,
     +    HP1,DESCRH,HR,IH1,IH2,INFOH,HP2,LHR,LIH1,
     +    LIH2,WORK,LWORK,IERRV)
        
        IF(IERRV(1) .NE. 0) THEN
          NAME = 'DCSLU\0'
          IF (IERRV(1).EQ.10) THEN
            IER = 60
            INT_VAL(1) = 25
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LWORK
          ELSE IF (IERRV(1).EQ.20) THEN
            IER = 60
            INT_VAL(1) = 21
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LH
          ELSE IF (IERRV(1).EQ.30) THEN
            IER = 60
            INT_VAL(1) = 22
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LH1
          ELSE IF (IERRV(1).EQ.40) THEN
            IER = 120
            INT_VAL(1) = 23
            INT_VAL(2) = 3
            INT_VAL(3) = LH2
            INT_VAL(4) = M
          ELSE IF (IERRV(1).EQ.100) THEN
            IER = 130
          END IF
        END IF

        descrh(1:3)=descrup(1:3)
        CALL DCRJD(TRANS,M,N,UNITD,D,DESCRH,HR,IH1,IH2,INFOH,
     +    UP1,DESCRUP,AUP,IU1,IU2,INFOUP,UP2,LARUP,LIA1UP,
     +    LIA2UP,WORK,LWORK,LIA1LO,IERRV)
        FIDUP = 'JAD'
        
        IF(IERRV(1) .NE. 0) THEN
          NAME = 'DCSLU\0'
          IF (IERRV(1).EQ.10) THEN
            IER = 60
            INT_VAL(1) = 25
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LWORK
          ELSE IF (IERRV(1).EQ.20) THEN
            IER = 60
            INT_VAL(1) = 21
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LH
          ELSE IF (IERRV(1).EQ.30) THEN
            IER = 60
            INT_VAL(1) = 22
            INT_VAL(2) = IERRV(2)
            INT_VAL(3) = LH1
          ELSE IF (IERRV(1).EQ.40) THEN
            IER = 120
            INT_VAL(1) = 23
            INT_VAL(2) = 3
            INT_VAL(3) = LH2
            INT_VAL(4) = M
          ELSE IF (IERRV(1).EQ.100) THEN
            IER = 130
          END IF
        END IF



      ELSE
C
C     This data structure not yet considered
C
        IER = 3010
        strings(1) = fida//'\0'
      ENDIF

      IF (IER.NE.0) THEN
        CALL SPERROR(IER,NAME,STRINGS,INT_VAL,REAL_VAL)
      ENDIF


 9999 CONTINUE 
      RETURN                                                                    
      END                                                                       




