/* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*/
/*
*  Include files
*/
#include "psblas.h"

/*#define DEBUGOVRLAP__*/

void pszovrl_(m, n, X, ix, jx, lldx, update_type, exchange, desc_data, desc_halo, 
	      desc_ovrlap, desc_ovrlap_elem, work, lwork)
     /*
      *  .. Scalar Arguments ..
      */
     int          * ix, * jx, * lldx, * m, * n, * lwork, *update_type;
     unsigned int *exchange;
     /* ..
      *  .. Array Arguments ..
      */
     int         desc_data[], desc_halo[], desc_ovrlap[], desc_ovrlap_elem[];
     double       X[], work[];
{
  /*
   *  Purpose
   *  =======
   *
   *  PSZOVRL swap Overlap elements,
   *
   *  Notes
   *  =====
   *
   *  Some description vectors are associated with each distributed sparse
   *  matrix. These vectors stores the information required to the
   *  communication needed to perform distributed operations.
   *
   *  They are:
   *
   *  NAME		 EXPLANATION
   *  ------------------ -------------------------------------------------------
   *  MATRIX_DATA	 Array of INTEGER that contains some local and global
   *			 information of matrix.
   *
   *  DESC_HALO          Array of INTEGER that contains informations for local 
   *                     halo points.
   *
   *  DESC_OVRLAP        Array of INTEGER that contains a list of local overlap 
   *                     elements.
   *                     
   *  OVRLAP_ELEM        Array of INTEGER that contains a list of local overlap
   *                     elements with their multiplicity.
   *
   *  Now we explain each of the above vectors.
   *
   *  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
   *  array for matrix A.
   *  Data stored in MATRIX_DATA array are:
   *
   *  NOTATION        STORED IN		     EXPLANATION
   *  --------------- ---------------------- -------------------------------------
   *  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
   *  M 	      MATDATA_A[M_]          Total number of equations
   *  N 	      MATDATA_A[N_]          Total number of variables
   *  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
   *  N_COL           MATDATA_A[N_COL_]      Number of local variables
   *  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
   *					     the global context of the operation
   *					     on the matrix.
   *					     The context itself is global.
   *
   *  Let DESCHALO_P be the array DESC_HALO for local process.
   *  This is composed of variable dimension blocks for each process to 
   *  communicate to.
   *  Each block contain indexes of local halo elements to exchange with other 
   *  process.
   *  Let P be the pointer to the first element of a block in DESCHALO_P.
   *  This block is stored in DESCHALO_P as :
   *
   *  NOTATION        STORED IN		          EXPLANATION
   *  --------------- --------------------------- -----------------------------------
   *  PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
   *						  data with.
   *  N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
   *  ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
   *					          receive. These are stored in the
   *					          array from location P+ELEM_RECV_ to
   *					          location P+ELEM_RECV_+
   *						  DESCHALO_P[P+N_ELEM_RECV_]-1.
   *  N_ELEMENTS_SEND DESCHALO_P[P+N_ELEM_SEND_]  Number of elements to send.
   *  ELEMENTS_SEND   DESCHALO_P[P+ELEM_SEND_+i]  Indexes of local elements to
   *					          send. These are stored in the
   *					          array from location P+ELEM_SEND_ to
   *					          location P+ELEM_SEND_+
   *						  DESCHALO_P[P+N_ELEM_SEND_]-1.
   *
   *
   *  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
   *  This is composed of variable dimension blocks for each process to 
   *  communicate to.
   *  Each block contain indexes of local overlap elements to exchange with
   *  other process.
   *  Let P be the pointer to the first element of a block in DESCOVRLP_P.
   *  This block is stored in DESCOVRLP_P as :
   *
   *  NOTATION        STORED IN		            EXPLANATION
   *  ------------- ------------------------------- -----------------------------------
   *  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
   *						    data with.
   *  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
   *  OVRLAP_ELEM   DESCOVRLP_P[P+OVRLP_ELEM_TO_+i] Indexes of local elements to
   *					            exchange. These are stored in the
   *					            array from location P+OVRLP_ELEM_ to
   *					            location P+OVRLP_ELEM_+
   *						    DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
   *
   *
   *  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
   *  This is composed of blocks of two elements. The block
   *  corresponding to the i-th overlapped elements, begin at index 
   *  P = i*2 in array OVR_ELEM_P.
   *  This block is stored in OVR_ELEM_P as :
   *
   *  NOTATION      STORED IN		       EXPLANATION
   *  ------------- -------------------------- ----------------------------------
   *  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
   *					       element.
   *  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
   *					       local overlapped element.
   *
   *  Parameters
   *  ==========
   *
   *  M       (global input) pointer to INTEGER.
   *          The number of rows of X to consider. M >= 0.
   *
   *  N	      (global input) pointer to INTEGER.
   *	      The number of column of X to consider.
   *
   *  X       (local input) REAL array containing the local pieces of 
   *          a distributed matrix.
   *          This array contains the entries of the distributed vector
   *          sub( X ).
   *
   *  IX      (global input) pointer to INTEGER
   *          The global row index of the subvector of the distributed
   *          matrix X, to operate on.
   *
   *  JX      (global input) pointer to INTEGER
   *          The global column index of the subvector of the distributed
   *          matrix X to operate on.
   *
   *  LLDX    (local input) pointer to INTEGER
   *          The leading dimension of local dense matrix X.
   *
   *  UPDATETYPE (global input) pointer to INTEGER.
   *             Valid values are : UPDATETYPE = SQUARE_ROOT
   *				    UPDATETYPE = NORMAL
   *             Ref. Technical Report RI.96.05 University of Tor Vergata (Roma)
   * 
   *  EXCHANGE (global input) pointer to INTEGER.
   *           If Exchange == 1 exchange overlap elements, otherwise 
   *           don't exchange elements.
   *
   *  DESCDATA (global and local input) INTEGER array. Is the MATRIX_DATA
   *           array.
   *
   *  DESCHALO (local input) INTEGER array. Is the DESC_HALO array.
   *
   *  DESCOVRLAP (local input) INTEGER array. Is the DESC_OVRLAP array.
   *
   *  DESCOVRLAPELEM (local input) INTEGER array. Is the OVRLAP_ELEM array.
   *
   *  WORK       (local input) REAL array. Work area to memorize intermediate 
   *		 results.
   *
   *  LWORK      (local input) pointer to INTEGER. Dimension of Work area.
   *
   *  =====================================================================
   *
   *  .. Local Scalars ..
   */
  int    ictxt, iix, jjx, mycol, myrow, 
         nprow, npcol, i, j, lwork1 ;
  double *work1;

  /*
   * .. Local Array ..
   */
  double *Sum_Ovrlap;
  double *tmpx;

  /* Error variables */
  int         info, ierror=0, err;
  int         int_err[5];
  double      real_err[5];

  /* ..
   *  .. External Functions ..
   */
  void        blacs_gridinfo();
  void        pbchkvect();
  void        pberror_();
  /* ..
   *  .. Executable Statements ..
   *
   *  Get grid parameters
   */

  ictxt = desc_data[CTXT_];
  Cblacs_gridinfo( ictxt, &nprow, &npcol, &myrow, &mycol );
  /*
   *  Test the input parameters
   */
  info = 0;
  if( nprow == -1 ) {
    info = 2010;
  } else {
    pbchkvect( *m, *n, 1, *ix, *jx, *lldx, desc_data, 9, 3, &iix, &jjx,
	       &info, int_err);
    
    err = info;
    Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, tmpx, tmpx, -1 ,-1,-1);
    
    if( err == 0 )
      if (iix == 1) {
	/* Initialize work array Sum_Ovrlap */
	if (desc_data[N_ROW_] > *lwork) {
	  /* Allocate memory */
	  Sum_Ovrlap = (double *) malloc(desc_data[N_ROW_] * 2 *
					 sizeof(double)) ;
	  work1 = work;
	  lwork1 = *lwork;
	}  else  {
	  Sum_Ovrlap = work;
	  lwork1 = *lwork - desc_data[N_ROW_];
	  work1 = work + desc_data[N_ROW_]; 
	}
	
	for (j = 0; j < *n; j++) {
	  tmpx = &X[2 * ((jjx + j - 1) * (*lldx) + iix - 1)];
#ifdef DEBUGOVRLAP__
	  printf("OVRLAP:Input Vector X\n");
	  for (i = 0; i < desc_data[N_COL_]; i++)
	    printf ("X[%d] = (%lf,%lf)\n", i+1, tmpx[2 * i],
		    tmpx[2 * i + 1]);
#endif	  
	  i = 0;
	  while (desc_ovrlap_elem[i] != -1) {
	    Sum_Ovrlap[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1)] =
	      tmpx[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1)];
	    Sum_Ovrlap[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1) + 1] =
	      tmpx[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1) + 1];
	    i += 2;
	  }
#ifdef DEBUGOVRLAP__
	  printf("OVRLAP:After sum Sum_Ovrlap\n");
	  i = 0;
	  while (desc_ovrlap_elem[i] != -1) {
	    printf ("Sum_Ovrlap [%d] = (%lf,%lf)\n", i+1,
		    Sum_Ovrlap[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1)],
		    Sum_Ovrlap[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1) + 1]
                    );
	    i += 2;
	  }
	  
#endif
	  
	  if (*exchange)
	    PSI_zSwapOverlap(tmpx, Sum_Ovrlap, desc_data, desc_ovrlap, 
			     work1, &lwork1, &info );
#ifdef DEBUGOVRLAP__
	  printf("OVRLAP:After swap Sum_Ovrlap\n");
	  i = 0;
	  while (desc_ovrlap_elem[i] != -1) {
	    printf ("Sum_Ovrlap [%d] = (%lf,%lf)\n", i+1,
		    Sum_Ovrlap[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1)],
		    Sum_Ovrlap[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1) + 1]
                    );
	    i += 2;
	  }	  
#endif
	  
	  /* Check for allocation error in PSI_zSwapOverlap */
	  if (info != 0)  {
	    err = 1;
	    if (info < 0)
	      info = 0 ;
	    else  {
	      int_err[0] = info;
	      info = 2020;
	    }
	  } else
	    /* Update tmpx with the average of overlapped elements
	       over all domains */
	    if (*update_type == SQUARE_ROOT) {
	      i = 0;
	      while (desc_ovrlap_elem[i] != -1) {
		tmpx[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1)] = 
		  Sum_Ovrlap[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1)]
		  / sqrt((double) desc_ovrlap_elem[i + N_DOM_OVR_]);
		
		tmpx[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1) + 1] = 
		  Sum_Ovrlap[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1) + 1]
		  / sqrt((double) desc_ovrlap_elem[i+N_DOM_OVR_]);
		
		i += 2;
	      }
	    } else if (*update_type == NORMAL) {
	      i = 0;
	      while (desc_ovrlap_elem[i] != -1) {
		tmpx[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1)] = 
		  Sum_Ovrlap[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1)]
		  / desc_ovrlap_elem[i + N_DOM_OVR_];
		
		tmpx[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1) + 1] = 
		  Sum_Ovrlap[2 * (desc_ovrlap_elem[i + OVRLP_ELEM_] - 1) + 1]
		  / desc_ovrlap_elem[i+N_DOM_OVR_];
		
		i += 2;
	      }
	    } else  {
	      info = 70;
	      int_err[0] = 7;
	    }
	}	
#ifdef DEBUGOVRLAP__
	printf("OVRLAP:On exit  Vector X\n");
	for (i = 0; i < desc_data[N_COL_]; i++)
	  printf ("X[%d] = (%lf,%lf)\n", i+1, tmpx[2 * i],
		  tmpx[2 * i + 1]);
#endif	  
	/* Deallocate memory if necessary */
	if (desc_data[N_COL_] > *lwork)
	  /* DeAllocate memory */
	  free(Sum_Ovrlap);
      }
      else ;
    else			/* Case: x is not Column vector */
      info = 3060 ;
  }
  
  if( (err != 0) || (info != 0)) {
    psderror_( &ictxt, &info, "PSZOVRL", int_err, real_err );
    return;
  }
}




