/* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*/
/*
*  Include files
*/
#include "psblas.h"
#include <stdlib.h>
#include <memory.h>

/* #define DEBUGSPMM__ */

void psdswaptran_( n, k, Y, iy, jy, lldy, desc_data, desc_halo,
                   desc_ovrlap, desc_ovrlap_elem, work, lwork)
     /*
      *  .. Scalar Arguments ..
      */
     int         * iy, * jy, * lldy, * n, * k, * lwork;
     /* ..
      *  .. Array Arguments ..
      */
     int         desc_data[], desc_halo[], desc_ovrlap[], desc_ovrlap_elem[] ;
     double      Y[], work[];
{
  /*
   *  Purpose
   *  =======
   *
   *  Interface to PSI_dSwapTran
   *
   *  Notes
   *  =====
   *
   *  Some description vectors are associated with each distributed sparse
   *  matrix. These vectors stores the information required to the
   *  communication needed to perform distributed operations.
   *
   *  They are:
   *
   *  NAME		 EXPLANATION
   *  ------------------ -------------------------------------------------------
   *  MATRIX_DATA	 Array of INTEGER that contains some local and global
   *			 information of matrix.
   *
   *  DESC_HALO          Array of INTEGER that contains informations for local 
   *                     halo points.
   *
   *  DESC_OVRLAP        Array of INTEGER that contains a list of local overlap 
   *                     elements.
   *                     
   *  OVRLAP_ELEM        Array of INTEGER that contains a list of local overlap
   *                     elements with their multiplicity.
   *
   *  Now we explain each of the above vectors.
   *
   *  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
   *  array for matrix A.
   *  Data stored in MATRIX_DATA array are:
   *
   *  NOTATION        STORED IN		     EXPLANATION
   *  --------------- ---------------------- -------------------------------------
   *  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
   *  M 	      MATDATA_A[M_]          Total number of equations
   *  N 	      MATDATA_A[N_]          Total number of variables
   *  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
   *  N_COL           MATDATA_A[N_COL_]      Number of local variables
   *  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
   *					     the global context of the operation
   *					     on the matrix.
   *					     The context itself is global.
   *
   *  Let DESCHALO_P be the array DESC_HALO for local process.
   *  This is composed of variable dimension blocks for each process to 
   *  communicate to.
   *  Each block contain indexes of local halo elements to exchange with other 
   *  process.
   *  Let P be the pointer to the first element of a block in DESCHALO_P.
   *  This block is stored in DESCHALO_P as :
   *
   *  NOTATION        STORED IN		          EXPLANATION
   *  --------------- --------------------------- -----------------------------------
   *  PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
   *						  data with.
   *  N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
   *  ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
   *					          receive. These are stored in the
   *					          array from location P+ELEM_RECV_ to
   *					          location P+ELEM_RECV_+
   *						  DESCHALO_P[P+N_ELEM_RECV_]-1.
   *  N_ELEMENTS_SEND DESCHALO_P[P+N_ELEM_SEND_]  Number of elements to send.
   *  ELEMENTS_SEND   DESCHALO_P[P+ELEM_SEND_+i]  Indexes of local elements to
   *					          send. These are stored in the
   *					          array from location P+ELEM_SEND_ to
   *					          location P+ELEM_SEND_+
   *						  DESCHALO_P[P+N_ELEM_SEND_]-1.
   *
   *
   *  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
   *  This is composed of variable dimension blocks for each process to 
   *  communicate to.
   *  Each block contain indexes of local overlap elements to exchange with
   *  other process.
   *  Let P be the pointer to the first element of a block in DESCOVRLP_P.
   *  This block is stored in DESCOVRLP_P as :
   *
   *  NOTATION        STORED IN		            EXPLANATION
   *  ------------- ------------------------------- -----------------------------------
   *  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
   *						    data with.
   *  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
   *  OVRLAP_ELEM   DESCOVRLP_P[P+OVRLP_ELEM_TO_+i] Indexes of local elements to
   *					            exchange. These are stored in the
   *					            array from location P+OVRLP_ELEM_ to
   *					            location P+OVRLP_ELEM_+
   *						    DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
   *
   *
   *  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
   *  This is composed of blocks of two elements. The block
   *  corresponding to the i-th overlapped elements, begin at index 
   *  P = i*2 in array OVR_ELEM_P.
   *  This block is stored in OVR_ELEM_P as :
   *
   *  NOTATION      STORED IN		       EXPLANATION
   *  ------------- -------------------------- ----------------------------------
   *  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
   *					       element.
   *  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
   *					       local overlapped element.
   *
   *  Parameters
   *  ==========
   *
   *  N       (global input) pointer to INTEGER
   *          The number of columns to be operated on i.e the number of
   *          columns of the distributed submatrix sub( A ). N >= 0.
   *
   *  K       (global input) pointer to INTEGER
   *          The number of columns of dense matrix Y to operate on.
   *
   *  Y       (local input/local output) REAL array
   *          containing the local pieces of a distributed matrix.
   *          This array contains the entries of the distributed vector
   *          sub( Y ).  On exit, sub( Y ) is overwritten by the updated
   *          distributed vector sub( Y ).
   *
   *  IY      (global input) pointer to INTEGER
   *          The global row index of the submatrix of the distributed
   *          matrix Y to operate on.
   *
   *  JY      (global input) pointer to INTEGER
   *          The global column index of the submatrix of the distributed
   *          matrix Y to operate on.
   *
   *  LLDY    (local input) pointer to INTEGER
   *          The leading dimension of local dense matrix Y.
   *
   *  DESCDATA (global and local input) INTEGER array. Is the MATRIX_DATA
   *           array.
   *
   *  DESCHALO (local input) INTEGER array. Is the DESC_HALO array.
   *
   *  DESCOVRLAP (local input) INTEGER array. Is the DESC_OVRLAP array.
   *
   *  DESCOVRLAPELEM (local input) INTEGER array. Is the OVRLAP_ELEM array.
   *
   *  WORK       (local input) REAL array. Work area to memorize intermediate 
   *		 results.
   *
   *  LWORK      (local input) pointer to INTEGER. Dimension of Work area.
   *
   *  =====================================================================
   *
   *  .. Local Scalars ..
   */
  int         ictxt, iiy, jjy, mycol, myrow, nprow, npcol, i, j;

  /* Error variables */
  int         info = 0, ierror = 0, err;
  int         int_err[5];
  double      real_err[5];

  /*
   * .. Local Array
   */
  double *tmpx, *tmpy, *Xcopy, *tmpXcopy, *Ycopy, *tmpYcopy;

  /* ..
   *  .. External Functions ..
   */
  void        blacs_gridinfo_();
  void        pbchkvect_sub_();
  void        PSI_dswaptran_();
  void        psderror();
  /* ..
   *  .. Executable Statements ..
   *
   *  Get grid parameters
   */
  ictxt = desc_data[CTXT_];
  Cblacs_gridinfo(ictxt, &nprow, &npcol, &myrow, &mycol);
  /*
   *  Test the input parameters
   */
  info = 0;
  if (nprow == -1)
    info = 2010;
  else {
     pbchkvect_sub(*n, *k, 3, *iy, *jy, *lldy, desc_data, 25, 21, &iiy, &jjy,
                    &info, int_err);
     err = info;
     Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, tmpx, tmpx, -1, -1, -1);
     if (err == 0) {     /* TRANS = T */
	if (desc_ovrlap_elem[0] == -1) {     /* There is no overlap */
           /* Update Halo points */
	  /* Pointer to the local Y vector */
	  tmpy = &Y[(jjy-1)*(*lldy)+iiy-1];
	  PSI_dSwapTran(*k, tmpy, *lldy, desc_data, desc_halo, desc_ovrlap,
			desc_ovrlap_elem, work, &lwork);
	  /* Check for allocation error in PSI_dSwapTran */
	  if (info != 0) {
	    err = 1;
	    if (info < 0)
	      info = 0 ;
	    else {
	      int_err[0] = info;
	      info = 2020;
	    }
	  }
	}
     }
  }
  if ((info != 0) || (err != 0)) {
     psderror_( &ictxt, &info, "PSDSWAP_TRAN\0", int_err, real_err );
     return;
  }
}







