/* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*/
/*
*  Include files
*/
#include "psblas.h"
#include <stdlib.h>
#include <memory.h>

/*  #define DEBUGSPMM__  */
/*  #define DBG1 */

void psdspmm_( trans, m, n, k, alpha, pr, A, ia1, ia2, fida, descra, infoa,
	      pc, ia, ja, X, ix, jx, lldx, beta, Y, iy, jy, lldy,
	      desc_data, desc_halo, desc_ovrlap, desc_ovrlap_elem, 
	      work, lwork)
     /*
      *  .. Scalar Arguments ..
      */
     F_CHAR      trans;
     int         * ia, * ix, * iy, * ja, * jx, * jy, * m, * lldx, * lldy,
     * n, * k, * lwork;
     double       * alpha, * beta;
     /* ..
      *  .. Array Arguments ..
      */
     int         desc_data[], desc_halo[], desc_ovrlap[], desc_ovrlap_elem[] ;
     int	 ia1[], ia2[], infoa[], pr[], pc[];
     char	 fida[5], descra[11];
     double       A[], X[], Y[], work[];
{
  /*
   *  Purpose
   *  =======
   *
   *  PSDPSMM performs one of the distributed matrix-vector operations
   *
   *     sub( Y ) := alpha*Pr*sub( A )*Pc* sub( X )  + beta*sub( Y ),  or
   *     sub( Y ) := alpha*Pr*sub( A )'*Pr* sub( X )  + beta*sub( Y ),
   *
   *  where sub( A ) denotes A(IA:IA+M-1,JA:JA+N-1),
   *
   *        sub( X ) denotes if TRANS = 'N',
   *                       X(IX:IX+N-1,JX:JX+K-1),
   *                     else
   *                       X(IX:IX+M-1,JX:JX+K-1).
   *                     end if
   *
   *        sub( Y ) denotes if trans = 'N',
   *                       Y(IY:IY+M-1,JY:JY+K-1),
   *                     else
   *                       Y(IY:IY+N-1,JY:JY+K-1)
   *                     end if
   *
   *  alpha and beta are scalars, and sub( X ) and sub( Y ) are distributed
   *  vectors and sub( A ) is a M-by-N distributed submatrix.
   *
   *  Notes
   *  =====
   *
   *  Some description vectors are associated with each distributed sparse
   *  matrix. These vectors stores the information required to the
   *  communication needed to perform distributed operations.
   *
   *  They are:
   *
   *  NAME		 EXPLANATION
   *  ------------------ -------------------------------------------------------
   *  MATRIX_DATA	 Array of INTEGER that contains some local and global
   *			 information of matrix.
   *
   *  DESC_HALO          Array of INTEGER that contains informations for local 
   *                     halo points.
   *
   *  DESC_OVRLAP        Array of INTEGER that contains a list of local overlap 
   *                     elements.
   *                     
   *  OVRLAP_ELEM        Array of INTEGER that contains a list of local overlap
   *                     elements with their multiplicity.
   *
   *  Now we explain each of the above vectors.
   *
   *  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
   *  array for matrix A.
   *  Data stored in MATRIX_DATA array are:
   *
   *  NOTATION        STORED IN		     EXPLANATION
   *  --------------- ---------------------- -------------------------------------
   *  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
   *  M 	      MATDATA_A[M_]          Total number of equations
   *  N 	      MATDATA_A[N_]          Total number of variables
   *  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
   *  N_COL           MATDATA_A[N_COL_]      Number of local variables
   *  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
   *					     the global context of the operation
   *					     on the matrix.
   *					     The context itself is global.
   *
   *  Let DESCHALO_P be the array DESC_HALO for local process.
   *  This is composed of variable dimension blocks for each process to 
   *  communicate to.
   *  Each block contain indexes of local halo elements to exchange with other 
   *  process.
   *  Let P be the pointer to the first element of a block in DESCHALO_P.
   *  This block is stored in DESCHALO_P as :
   *
   *  NOTATION        STORED IN		          EXPLANATION
   *  --------------- --------------------------- -----------------------------------
   *  PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
   *						  data with.
   *  N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
   *  ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
   *					          receive. These are stored in the
   *					          array from location P+ELEM_RECV_ to
   *					          location P+ELEM_RECV_+
   *						  DESCHALO_P[P+N_ELEM_RECV_]-1.
   *  N_ELEMENTS_SEND DESCHALO_P[P+N_ELEM_SEND_]  Number of elements to send.
   *  ELEMENTS_SEND   DESCHALO_P[P+ELEM_SEND_+i]  Indexes of local elements to
   *					          send. These are stored in the
   *					          array from location P+ELEM_SEND_ to
   *					          location P+ELEM_SEND_+
   *						  DESCHALO_P[P+N_ELEM_SEND_]-1.
   *
   *
   *  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
   *  This is composed of variable dimension blocks for each process to 
   *  communicate to.
   *  Each block contain indexes of local overlap elements to exchange with
   *  other process.
   *  Let P be the pointer to the first element of a block in DESCOVRLP_P.
   *  This block is stored in DESCOVRLP_P as :
   *
   *  NOTATION        STORED IN		            EXPLANATION
   *  ------------- ------------------------------- -----------------------------------
   *  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
   *						    data with.
   *  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
   *  OVRLAP_ELEM   DESCOVRLP_P[P+OVRLP_ELEM_TO_+i] Indexes of local elements to
   *					            exchange. These are stored in the
   *					            array from location P+OVRLP_ELEM_ to
   *					            location P+OVRLP_ELEM_+
   *						    DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
   *
   *
   *  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
   *  This is composed of blocks of two elements. The block
   *  corresponding to the i-th overlapped elements, begin at index 
   *  P = i*2 in array OVR_ELEM_P.
   *  This block is stored in OVR_ELEM_P as :
   *
   *  NOTATION      STORED IN		       EXPLANATION
   *  ------------- -------------------------- ----------------------------------
   *  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
   *					       element.
   *  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
   *					       local overlapped element.
   *
   *  Parameters
   *  ==========
   *
   *  TRANS   (global input) pointer to CHARACTER
   *          On entry, TRANS specifies the operation to be performed as
   *          follows:
   *
   *          if TRANS = 'N' or 'n',
   *          sub( Y ) := alpha*sub( A )  * sub( X ) + beta*sub( Y ),
   *
   *          else if TRANS = 'T' or 't',
   *          sub( Y ) := alpha*sub( A )' * sub( X ) + beta*sub( Y ),
   *
   *          else if TRANS = 'C' or 'c',
   *          sub( Y ) := alpha*sub( A )' * sub( X ) + beta*sub( Y ).
   *
   *  M       (global input) pointer to INTEGER
   *          The number of rows to be operated on i.e the number of rows
   *          of the distributed submatrix sub( A ). M >= 0.
   *
   *  N       (global input) pointer to INTEGER
   *          The number of columns to be operated on i.e the number of
   *          columns of the distributed submatrix sub( A ). N >= 0.
   *
   *  K       (global input) pointer to INTEGER
   *          The number of columns of dense matrix Y to operate on.
   *
   *  ALPHA   (global input) pointer to DOUBLE
   *          On entry, ALPHA specifies the scalar alpha.
   *
   *  PR      (local input) array of INTEGER
   *          Permutation matrix.
   *
   *  A       (local input) REAL pointer into the local memory
   *          to an array containing the values of
   *          local pieces of the distributed sparse matrix sub( A ).
   *
   *  IA1     (local input) INTEGER array containing the column
   *          coordinates of the values of local pieces of the
   *          distributed sparse matrix sub( A ).
   *
   *  IA2     (local input) INTEGER array containing the coordinates
   *          of the first element of a row of the
   *          distributed sparse matrix sub( A ) in the array of values 'A'.
   *          The coordinates of the first element of row i of the
   *          distributed sparse matrix sub( A ) in the array of values 'A' 
   *          is IA2[i].
   *
   *  FIDA    (global input) pointer to CHARACTER containing a string
   *          that indicates the type of sparse matrix representation.
   *
   *  DESCRA  (global input) pointer to CHARACTER containing the type of
   *          sparse matrix.
   *             DESCRA[1] = 'G' General
   *             DESCRA[1] = 'S' Symmetric
   *             DESCRA[1] = 'H' Hermitian
   *             DESCRA[1] = 'T' Triangular
   *             DESCRA[1] = 'A' Anti-symmetric
   *             DESCRA[1] = 'D' Diagonal
   *             DESCRA[2] = 'U' Upper
   *             DESCRA[2] = 'L' Lower
   *             DESCRA[3] = 'U' Unit diagonal
   *             DESCRA[3] = 'N' Non Unit diagonal
   *
   *  INFOA   (global output) INTEGER array containing user defined 
   *          information.
   *
   *  PC      (local input) array of INTEGER
   *          Permutation matrix.
   *
   *  IA      (global input) pointer to INTEGER
   *          The global row index of the submatrix of the distributed
   *          sparse matrix A to operate on.
   *
   *  JA      (global input) pointer to INTEGER
   *          The global column index of the submatrix of the distributed
   *          sparse matrix A to operate on.
   *
   *  X       (local input) REAL array containing the local
   *          pieces of a distributed matrix.
   *          This array contains the entries of the distributed vector
   *          sub( X ).
   *
   *  IX      (global input) pointer to INTEGER
   *          The global row index of the submatrix of the distributed
   *          matrix X to operate on.
   *
   *  JX      (global input) pointer to INTEGER
   *          The global column index of the submatrix of the distributed
   *          matrix X to operate on.
   *
   *  LLDX    (local input) pointer to INTEGER
   *          The leading dimension of local dense matrix X.
   *
   *  BETA    (global input) pointer to REAL
   *          On entry,  BETA  specifies the scalar  beta.  When  BETA  is
   *          supplied as zero then sub( Y ) need not be set on input.
   *
   *  Y       (local input/local output) REAL array
   *          containing the local pieces of a distributed matrix.
   *          This array contains the entries of the distributed vector
   *          sub( Y ).  On exit, sub( Y ) is overwritten by the updated
   *          distributed vector sub( Y ).
   *
   *  IY      (global input) pointer to INTEGER
   *          The global row index of the submatrix of the distributed
   *          matrix Y to operate on.
   *
   *  JY      (global input) pointer to INTEGER
   *          The global column index of the submatrix of the distributed
   *          matrix Y to operate on.
   *
   *  LLDX    (local input) pointer to INTEGER
   *          The leading dimension of local dense matrix Y.
   *
   *  DESCDATA (global and local input) INTEGER array. Is the MATRIX_DATA
   *           array.
   *
   *  DESCHALO (local input) INTEGER array. Is the DESC_HALO array.
   *
   *  DESCOVRLAP (local input) INTEGER array. Is the DESC_OVRLAP array.
   *
   *  DESCOVRLAPELEM (local input) INTEGER array. Is the OVRLAP_ELEM array.
   *
   *  WORK       (local input) REAL array. Work area to memorize intermediate 
   *		 results.
   *
   *  LWORK      (local input) pointer to INTEGER. Dimension of Work area.
   *
   *  =====================================================================
   *
   *  .. Local Scalars ..
   */
  char        TrA;
  int         ictxt, iia, iix, iiy;
  int         jja, jjx, jjy, lwork1, Size;
  int         mycol, myrow, nota, nprow, npcol, i, j;
  int         ovr_points;

  /* Error variables */
  int         info=0, ierror=0,err;
  int         int_err[5];
  double      real_err[5];

  /*
   * .. Local Array
   */
  double *tmpx, *tmpy, *work1, *Xcopy, *tmpXcopy, *Ycopy, *tmpYcopy;

  /* ..
   *  .. External Functions ..
   */
  void        blacs_gridinfo_();
  void        pbchkmat();
  void        pbchkvect();
  void        pberror_();
  void        dcsmm();
  void        psberror();
  void        PSI_dSwapData();
  /* ..
   *  .. Executable Statements ..
   *
   *  Get grid parameters
   */
  /*  fprintf(stderr,"PSDSPMM: Check:");
  for (i=0; i<=CTXT_; i++) fprintf(stderr," %d",desc_data[i]);
  fprintf(stderr,"\n"); */
  ictxt = desc_data[CTXT_];
  Cblacs_gridinfo( ictxt, &nprow, &npcol, &myrow, &mycol );
  /* fprintf(stderr,"PSDSPMM: %d %d %d %d %d\n",ictxt, nprow, npcol, myrow, mycol );  */
  /*
   *  Test the input parameters
   */
  err = info = 0;
  if ( nprow == -1 ) {
    info = 2010;
    psderror_( &ictxt, &info, "PSDSPMM\0", int_err, real_err );
    return;

  } 

  TrA = Mupcase( F2C_CHAR( trans )[0] );
  nota = ( TrA == 'N' );
  
  if ((*lldx < desc_data[N_COL_])||(*lldy < desc_data[N_COL_]))
    info = 3010;
  
  if( (TrA != 'N') && (TrA != 'T') && (TrA != 'C'))	{
    info = 70;	        /* Error Code */
    int_err[0] = 1;	/* Argument position */
  } else if( TrA == 'C')  {
    info = 3020;	/* Error Code */
    int_err[0] = 1;	/* Argument position */
  }
  if (info == 0) 
    pbchkmat( *m, 2, *n, 3, *ia, *ja, desc_data, 25, 7, &iia, &jja,
	      &info, int_err);
  
  if ( nota ) {
    if (info == 0) 
      pbchkvect( *n, *k, 3, *ix, *jx, *lldx, desc_data, 25, 16, &iix, &jjx,
		 &info, int_err);
    if (info == 0) 
      pbchkvect( *m, *k, 2, *iy, *jy, *lldy, desc_data, 25, 21, &iiy, &jjy,
		 &info, int_err);
    
    if ((*ja == *ix)&&(*ia == *iy)) {	/* No communications */
      /* Initialize work array */
      if (info == 0) {
	if ((iix == 1)&&(iiy == 1))	{	/* Columns vectors */
	  if (desc_data[N_ROW_] > *lwork) {
	    /* Allocate memory */
	    if ((work1 = (double *)malloc(desc_data[N_ROW_]*sizeof(double)))
	      == NULL) {
	      info = 2020;
	      int_err[0] = desc_data[N_ROW_]*sizeof(double);
	    } else {
	      
	      work1[0] = 0;
	      lwork1 = desc_data[N_ROW_];
	  }
#ifdef PS_CONTROL_LEVEL
	    printf("Alloc %d elements in psdspmm",desc_data[N_ROW_]);
#endif
	  } else {
	    work1 = work;
	    work1[0] = 0;
	    lwork1 = *lwork;
	  }
	} else {
	  info = 3040;
	}
      }
	
      /* Check for ERRORS */
      err = info;
      Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, tmpx, tmpx, -1 ,-1,-1);
	
      if (err != 0) {
	psderror_( &ictxt, &info, "PSDSPMM\0", int_err, real_err );
	return;
      }
	
      /* Update Halo */
#ifdef DBG1
      fprintf(stderr,"%d SPMM:   swapdata ....\n",myrow);
#endif
      tmpx = &X[(jjx-1)*(*lldx)+iix-1];	      
      PSI_dSwapData(*k,tmpx,*lldx,desc_data,desc_halo,work1,&lwork1,&info) ;
#ifdef DBG1
      fprintf(stderr,"%d SPMM:   swapdata done\n",myrow);
#endif
	
      /* Matrix-Vector Product */
#ifdef DBG1
      fprintf(stderr,"%d SPMM:   dcsmm.....\n",myrow);
#endif
      if ((iix == 1)&&(iiy == 1)) {
	tmpx = &X[(jjx-1)*(*lldx)+iix-1]; /* Pointer to the local X vector */
	tmpy = &Y[(jjy-1)*(*lldy)+iiy-1]; /* Pointer to the local Y vector */  
#ifdef DEBUGSPMM__
	printf("DSPMM:Vector X\n");
	for (i = 0; i < desc_data[N_COL_]; i++)
	  printf ("X[%d] = %lf\n", i+1, tmpx[i]);
	  
	printf("Vector Y\n");
	for (i = 0; i < desc_data[N_COL_]; i++)
	  printf ("Y[%d] = %lf\n", i+1, tmpy[i]);
#endif
#ifdef DBG1
	fprintf(stderr,"%d SPMM:   dcsmm %c%c%c  Last size: (%d) %d\n", 
		myrow,fida[0],fida[1],fida[2],
		desc_data[N_ROW_],ia2[desc_data[N_ROW_]]);
#endif 
	dcsmm(&TrA, &desc_data[N_ROW_], k, &desc_data[N_COL_],
	      alpha, pr, fida, descra, A, ia1, ia2, infoa, pc,
	      tmpx, lldx, beta, tmpy, lldy, work1, &lwork1, &ierror);
      }
#ifdef DBG1
      fprintf(stderr,"%d SPMM:   dcsmm done.\n",myrow);
#endif
	
      /* Check for ERRORS */
      if (ierror != 0) {	
	if (ierror==3015) {
	  info = ierror;
	} else {
	  info = 2010;
	  int_err[0] = ierror;
	}
      }
	
      err = info;
      Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, tmpx, tmpx, -1 ,-1,-1);
	
      if (err != 0) {
	psderror_( &ictxt, &info, "PSDSPMM\0", int_err, real_err );
	return;
      }
	
#ifdef DEBUGSPMM__
      printf("DSPMM:After local computations\n");
      printf("Vector X\n");
      for (i = 0; i < desc_data[N_COL_]; i++)
	printf ("X[%d] = %lf\n", i+1, tmpx[i]);
	
      printf("Vector Y\n");
      for (i = 0; i < desc_data[N_COL_]; i++)
	printf ("Y[%d] = %lf\n", i+1, tmpy[i]);
#endif

      if ((iix == 1)&&(iiy == 1)) {  /* Columns vectors */	    
#ifdef DEBUGSPMM__
	printf("DSPMM:After local computations\n");
	printf("Vector X\n");
	for (i = 0; i < desc_data[N_COL_]; i++)
	  printf ("X[%d] = %lf\n", i+1, tmpx[i]);
	      
	printf("Vector Y\n");
	for (i = 0; i < desc_data[N_COL_]; i++)
	  printf ("Y[%d] = %lf\n", i+1, tmpy[i]);
#endif	      
	      
	/* Free Work area */
	if (desc_data[N_ROW_] > *lwork)
	  free(work1);
      }
    }  else { 
      if (info == 0) 
	info = 3030;
      /* Check for ERRORS */
      err = info;
      Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, tmpx, tmpx, -1 ,-1,-1);
	
      psderror_( &ictxt, &info, "PSDSPMM\0", int_err, real_err );
      return;	

    }
  
  } else { 			/* TRANS = T */

    if (info == 0) 
      pbchkvect( *m, *k, 2, *ix, *jx, *lldx, desc_data, 25, 16, &iix, &jjx,
		 &info, int_err);
    if (info == 0) 
      pbchkvect( *n, *k, 3, *iy, *jy, *lldy, desc_data, 25, 21, &iiy, &jjy,
		 &info, int_err);
    err = info;
    Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, tmpx, tmpx, -1 ,-1,-1);
    if( (info != 0) || (err != 0)) {
      psderror_( &ictxt, &info, "PSDSPMM\0", int_err, real_err );
      return;
    }
    if ((*ja == *iy)&&(*ia == *ix)) { /* No communications */
      if (desc_ovrlap_elem[0] == -1) { /* There is no overlap */
	/* Initialize work array */
	if ((iix == 1)&&(iiy == 1)) { /* Columns vectors */
	  if (desc_data[N_ROW_] > *lwork) { /* Work area too small */
	    /* Allocate memory for work1 */
	    if ((work1 = (double *)
		 malloc(desc_data[N_ROW_]*sizeof(double))) == NULL) {
	      info = 2020;
	      int_err[0] = desc_data[N_ROW_]*sizeof(double);
	    }
	      
	    work1[0] = 0;
	    lwork1 = desc_data[N_ROW_];
#ifdef PS_CONTROL_LEVEL
	    printf("PSDSPMM: Alloc %d elements\n",desc_data[N_ROW_]);
#endif
	  } else {
	    /* Initialize array work1 */
	    work1 = work;
	    work1[0] = 0;
	    lwork1 = *lwork;
	  }
	}  else {
	  info = 3040;
	}

	/* Check for ERRORS */
	err = info;
	Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, tmpx, tmpx, -1 ,-1,-1);
	    
	if (err != 0) {
	  psderror_( &ictxt, &info, "PSDSPMM\0", int_err, real_err );
	  return;
	}
	/* Initialize Xcopy, Ycopy and Y vectors */		
	for (j = 0; j < *k; j++) {
	  /* Pointer to the local vector */
	  tmpy = &Y[(jjy+j-1)*(*lldy)+iiy-1];
	      
	  for (i = desc_data[N_ROW_]; i < desc_data[N_COL_]; i++)
	    tmpy[i] = 0.0;
	}
	    
	/* Pointer to the local X vector */
	tmpx = &X[(jjx-1)*(*lldx)+iix-1];		
	Xcopy = tmpx;	       
	/* Pointer to the local vector */
	tmpy = &Y[(jjy-1)*(*lldy)+iiy-1];
	  
	/* Matrix-Vector Product */
#ifdef DEBUGSPMM__
	printf("DSPMM:Vector X\n");
	for (i = 0; i < desc_data[N_COL_]; i++)
	  printf ("X[%d] = %lf\n", i+1, tmpXcopy[i]);
	    
	printf("Vector Y\n");
	for (i = 0; i < desc_data[N_COL_]; i++)
	  printf ("Y[%d] = %lf\n", i+1, tmpy[i]);
#endif		
	dcsmm(&TrA, &desc_data[N_COL_], k, &desc_data[N_ROW_],
	      alpha, pr, fida, descra, A, ia1, ia2, infoa, pc,
	      Xcopy, &desc_data[N_ROW_], beta, tmpy, lldy,
	      work1, &lwork1, &ierror);
	    
	if (ierror != 0)  {
	  if (ierror==3015) {
	    info = ierror;
	  } else {
	    info = 2010;
	    int_err[0] = ierror;
	  }
	}
	  
	  
	err = info;
	Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, tmpx, tmpx, -1 ,-1,-1);
	  
	if (err != 0) {
	  psderror_( &ictxt, &info, "PSDSPMM\0", int_err, real_err );
	  return;
	}
#ifdef DEBUGSPMM__
	printf("DSPMM:After local computations\n");
	printf("Vector X\n");
	for (i = 0; i < desc_data[N_COL_]; i++)
	  printf ("X[%d] = %lf\n", i+1, tmpXcopy[i]);
	  
	printf("Vector Y\n");
	for (i = 0; i < desc_data[N_COL_]; i++)
	  printf ("Y[%d] = %lf\n", i+1, tmpy[i]);
#endif	  
	/* Update Halo points */

	  tmpy = &Y[(jjy-1)*(*lldy)+iiy-1]; /* Pointer to the local Y vector */
	  PSI_dSwapTran(*k, tmpy, *lldy, desc_data, desc_halo, desc_ovrlap,
			desc_ovrlap_elem, work1, &lwork1);	     
	      
	  /* Check for allocation error in PSI_dSwapTran */
	  if (info != 0) {
	    err = 1;
	    if (info < 0) {
	      info = 0 ;
	    } else  {
	      int_err[0] = info;
	      info = 2020;
	    }
	  }

	    
	/* Free Memory */
	if (desc_data[N_ROW_] > *lwork) 
	  free(work1);
      } else {
	info = 3070;
      } /* empty overlap */
	  
    } else {
      info = 3030;
    } /* ia==iy */	

  }
    
  
  if( (info != 0) || (err != 0)) {
    psderror_( &ictxt, &info, "PSDSPMM\0", int_err, real_err );
    return;
  }
  
  
}







