/* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*/
/*
*  Include files
*/
#include "psblas.h"
#include <math.h>

void psdnrmisym_( m, n, normi, A, ia1, ia2, fida, descra, infoa,
	      ia, ja, desc_data, desc_halo, desc_ovrlap, 
	      desc_ovrlap_elem, loc_to_glob, work, lwork )
     /*
      *  .. Scalar Arguments ..
      */
     int         * n, *m, * ia, * ja, * loc_to_glob, *lwork;
     double      * normi;
     /* ..
      *  .. Array Arguments ..
      */
     int	 ia1[], ia2[], infoa[];
     char	 fida[5], descra[11];
     int         desc_data[], desc_halo[], desc_ovrlap[], desc_ovrlap_elem[];
     double      A[], *work;
{
  /*
   *  Purpose
   *  =======
   *
   *  PSDNRMISYM forms the approximated norm of a sparse symmetric matrix,
   *  whose triangular upper half part is only stored in A, ia1, ia2.
   *
   *     normi := max(abs(sum(sub(a)(i,j))))
   *
   *  where sub( A ) denotes A(IA:IA+M-1,JA:JA+N-1).
   *
   *
   *  Notes
   *  =====
   *
   *  Some description vectors are associated with each distributed sparse
   *  matrix. These vectors stores the information required to the
   *  communication needed to perform distributed operations.
   *
   *  They are:
   *
   *  NAME		 EXPLANATION
   *  ------------------ -------------------------------------------------------
   *  MATRIX_DATA	 Array of INTEGER that contains some local and global
   *			 information of matrix.
   *
   *  DESC_HALO          Array of INTEGER that contains informations for local 
   *                     halo points.
   *
   *  DESC_OVRLAP        Array of INTEGER that contains a list of local overlap 
   *                     elements.
   *                     
   *  OVRLAP_ELEM        Array of INTEGER that contains a list of local overlap
   *                     elements with their multiplicity.
   *
   *  Now we explain each of the above vectors.
   *
   *  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
   *  array for matrix A.
   *  Data stored in MATRIX_DATA array are:
   *
   *  NOTATION        STORED IN		     EXPLANATION
   *  --------------- ---------------------- -------------------------------------
   *  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
   *  M 	      MATDATA_A[M_]          Total number of equations
   *  N 	      MATDATA_A[N_]          Total number of variables
   *  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
   *  N_COL           MATDATA_A[N_COL_]      Number of local variables
   *  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
   *					     the global context of the operation
   *					     on the matrix.
   *					     The context itself is global.
   *
   *  Let DESCHALO_P be the array DESC_HALO for local process.
   *  This is composed of variable dimension blocks for each process to 
   *  communicate to.
   *  Each block contain indexes of local halo elements to exchange with other 
   *  process.
   *  Let P be the pointer to the first element of a block in DESCHALO_P.
   *  This block is stored in DESCHALO_P as :
   *
   *  NOTATION        STORED IN		          EXPLANATION
   *  --------------- --------------------------- -----------------------------------
   *  PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
   *						  data with.
   *  N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
   *  ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
   *					          receive. These are stored in the
   *					          array from location P+ELEM_RECV_ to
   *					          location P+ELEM_RECV_+
   *						  DESCHALO_P[P+N_ELEM_RECV_]-1.
   *  N_ELEMENTS_SEND DESCHALO_P[P+N_ELEM_SEND_]  Number of elements to send.
   *  ELEMENTS_SEND   DESCHALO_P[P+ELEM_SEND_+i]  Indexes of local elements to
   *					          send. These are stored in the
   *					          array from location P+ELEM_SEND_ to
   *					          location P+ELEM_SEND_+
   *						  DESCHALO_P[P+N_ELEM_SEND_]-1.
   *
   *
   *  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
   *  This is composed of variable dimension blocks for each process to 
   *  communicate to.
   *  Each block contain indexes of local overlap elements to exchange with
   *  other process.
   *  Let P be the pointer to the first element of a block in DESCOVRLP_P.
   *  This block is stored in DESCOVRLP_P as :
   *
   *  NOTATION        STORED IN		            EXPLANATION
   *  ------------- ------------------------------- -----------------------------------
   *  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
   *						    data with.
   *  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
   *  OVRLAP_ELEM   DESCOVRLP_P[P+OVRLP_ELEM_TO_+i] Indexes of local elements to
   *					            exchange. These are stored in the
   *					            array from location P+OVRLP_ELEM_ to
   *					            location P+OVRLP_ELEM_+
   *						    DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
   *
   *
   *  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
   *  This is composed of blocks of two elements. The block
   *  corresponding to the i-th overlapped elements, begin at index 
   *  P = i*2 in array OVR_ELEM_P.
   *  This block is stored in OVR_ELEM_P as :
   *
   *  NOTATION      STORED IN		       EXPLANATION
   *  ------------- -------------------------- ----------------------------------
   *  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
   *					       element.
   *  N_POMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
   *					       local overlapped element.
   *
   *
   *  Parameters
   *  ==========
   *
   *  M       (global input) pointer to INTEGER
   *          Number of rows of the distributed sparse matrix A.
   *          N >= 0 to consider.
   *
   *  N       (global input) pointer to INTEGER
   *          Number of columns of the distributed sparse matrix A.
   *          M >= 0 to consider.
   *
   *  NORMI   (local output) pointer to REAL
   *          The normi of sub( A ) .
   *
   *  A       (local input) REAL pointer to local distributed sparse
   *          matrix containing sub ( A ).
   *
   *  IA1     (local input) INTEGER array containing the column
   *          coordinates of the values of local pieces of the
   *          distributed sparse matrix sub( A ).
   *
   *  IA2     (local input) INTEGER array containing the coordinates
   *          of the first element of a row of the
   *          distributed sparse matrix sub( A ) in the array of values 'A'.
   *          The coordinates of the first element of row i of the
   *          distributed sparse matrix sub( A ) in the array of values 'A' 
   *          is IA2[i].
   *
   *  FIDA    (global input) pointer to CHARACTER containing a string
   *          that indicates the type of sparse matrix representation.
   *
   *  DESCRA  (global input) pointer to CHARACTER containing the type of
   *          sparse matrix.
   *             DESCRA[1] = 'G' General
   *             DESCRA[1] = 'S' Symmetric
   *             DESCRA[1] = 'H' Hermitian
   *             DESCRA[1] = 'T' Triangular
   *             DESCRA[1] = 'A' Anti-symmetric
   *             DESCRA[1] = 'D' Diagonal
   *             DESCRA[2] = 'U' Upper
   *             DESCRA[2] = 'L' Lower
   *             DESCRA[3] = 'U' Unit diagonal
   *             DESCRA[3] = 'N' Non Unit diagonal
   *
   *  INFOA   (global output) INTEGER array containing user defined 
   *          information.
   *
   *  IA      (global input) pointer to INTEGER
   *          The global row index of the submatrix of the distributed
   *          sparse matrix A to operate on.
   *
   *  JA      (global input) pointer to INTEGER
   *          The global column index of the submatrix of the distributed
   *          sparse matrix A to operate on.
   *
   *  DESCDATA (global and local input) INTEGER array. Is the MATRIX_DATA
   *           array.
   *
   *  DESCHALO (local input) INTEGER array. Is the DESC_HALO array.
   *
   *  DESCOVRLAP (local input) INTEGER array. Is the DESC_OVRLAP array.
   *
   *  DESCOVRLAPELEM (local input) INTEGER array. Is the OVRLAP_ELEM array.
   *
   *  =====================================================================
   *
   *  .. Local Scalars ..
   */
  int         ictxt, iia, jja, i, j, mycol, myrow, ione=1, mone=-1,
              nprow, npcol, one=1, required_wa, *tmpx;
  double      SUM=0.0, *result, *row_sum, *col_sum, *work1;
  char        Trans;

  /* Error variables */
  int         info=0,err,max_position;
  int         int_err[5];
  double      real_err[5];

  /*
   * .. Local Array
   */
  int RA[1], CA[1];

  /* ..
   *  .. External Functions ..
   */
  void        blacs_gridinfo();
  void        dgamx2d();
  void        pbchkmat();
  void        pberror_();
  double      dcsnmi();
  /* ..
   *  .. Executable Statements ..
   *
   *  Get grid parameters
   */
  ictxt = desc_data[CTXT_];
  Cblacs_gridinfo( ictxt, &nprow, &npcol, &myrow, &mycol );
  /*
   *  Test the input parameters
   */
  info = 0;
  if( nprow == -1 )
    info = 2010;
  else {
    pbchkmat( *m, 2, *n, 3, *ia, *ja, desc_data, 12, 4, &iia, &jja,
	      &info,int_err);
    err = info;
    Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, &SUM, &SUM, -1 ,-1,-1);
    if (*n != *m) {
      /* Not square global matrix! */
      /* To be set the proper error flags */
         err = 1;
         printf("psdnrmisym: global matrix isn't square\n");
    }                     
    if ( err == 0 )
      if ((*n != 0) && (m != 0)) {
	/* Allocates local work area if the available one
	   isn't large enough  */
	required_wa = desc_data[M_] + desc_data[N_ROW_] + desc_data[N_COL_];
	if (required_wa > *lwork) {
	  /* Allocate memory */
	  if ((work1 = (double *) malloc(required_wa * 
					 sizeof(double))) == NULL) {
	    info = 2020;
	    int_err[0] = desc_data[N_ROW_] * 2 * sizeof(double);
	  } else {
	    result = work1;
	    row_sum =  work1 + desc_data[M_];
	    col_sum = row_sum + desc_data[N_ROW_];
#ifdef PS_CONTROL_LEVEL
	    printf("Alloc %d elements in psdnrmisym\n",2 * desc_data[N_ROW_]);
#endif
	  }
	} else {
	  work1 = work;
	  result = work1;
	  row_sum =  work1 + desc_data[M_];
	  col_sum = row_sum + desc_data[N_ROW_];	  
	} 
	err = info;
	Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, tmpx, tmpx, -1 ,-1,-1); 
	if (err != 0) {
	  psderror_( &ictxt, &info, "PSDNRMISYM\0", int_err, real_err );
	  return;
	}
	for (i = 0; i < desc_data[M_]; i++)
	  result[i] = 0.0;	  
	Trans = 'N'; 
	dcsrs(&Trans,&desc_data[N_ROW_],&desc_data[N_COL_],
	      fida,descra,A,ia1,ia2,infoa,&info,row_sum);
	Trans = 'T';
	/* Subtract elements on the diagonal that otherwise 
	   would be considered twice BEWARE: ONLY CSR. 
            	Boy, is this ugly........       */
	for (i = 0; i < desc_data[N_ROW_]; i++)
	  if (ia1[ia2[i] - 1] - 1 == i)
	    /* this diagonal element isn't zero */
	    row_sum[i] -= A[ia2[i] - 1];
	dcsrs(&Trans,&desc_data[N_ROW_],&desc_data[N_COL_],
	      fida,descra,A,ia1,ia2,infoa,&info,col_sum);
	/* Now elements in row_sum, col_sum are merged in result array */
	for (i = 0; i < desc_data[N_ROW_]; i++)
	  result[loc_to_glob[i] - 1] += row_sum[i];
	for (i = 0; i < desc_data[N_COL_]; i++)
	  result[loc_to_glob[i] - 1] += col_sum[i];
	if (!err) {
	  /* Global Max */
	  Cdgsum2d(ictxt, ALL, TOPDEF, desc_data[M_], ione, result, 
		   desc_data[M_], mone, mone);
	  max_position = idamax(&desc_data[M_], result, &ione);
	  *normi = (result[max_position - 1] > 0.0 ?
		    result[max_position - 1] :
		    - result[max_position - 1]);
	} else
	  *normi = 0.0;
	if (required_wa > *lwork)
	  free(work);
      }
  }  
  if( err ) {
    psderror_( &ictxt, &info, "PSDNRMISYM", int_err, real_err );
    return;
  }
}

