C   ---------------------------------------------------------------------
C
C   -- PSBLAS routine (version 1.0) --
C
C   ---------------------------------------------------------------------
C
      subroutine psdnrm2( n, dnorm2, X, ix, jx, lldx,
     +  desc_data, desc_halo, desc_ovrlap, 
     +  desc_ovrlap_elem)
      
C     Purpose
C     =======
C
C     PSDNRM2 forms the norm2 of a distributed vector,
C
C       norm2 := sqrt ( sub( X )**T * sub( X ) )
C
C     where sub( X ) denotes X(IX:IX+N-1,JX).
C
C  
C     Notes
C     =====
C   
C     Some description vectors are associated with each distributed sparse
C     matrix. These vectors stores the information required to the
C     communication needed to perform distributed operations.
C   
C     They are:
C   
C     NAME		 EXPLANATION
C     ------------------ -------------------------------------------------------
C     MATRIX_DATA	 Array of INTEGER that contains some local and global
C   			 information of matrix.
C   
C     DESC_HALO          Array of INTEGER that contains informations for local 
C                        halo points.
C   
C     DESC_OVRLAP        Array of INTEGER that contains a list of local overlap 
C                        elements.
C                        
C     OVRLAP_ELEM        Array of INTEGER that contains a list of local overlap
C                        elements with their multiplicity.
C   
C     Now we explain each of the above vectors.
C   
C     Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
C     array for matrix A.
C     Data stored in MATRIX_DATA array are:
C   
C     NOTATION        STORED IN		     EXPLANATION
C     --------------- ---------------------- -------------------------------------
C     DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
C     M 	      MATDATA_A[M_]          Total number of equations
C     N 	      MATDATA_A[N_]          Total number of variables
C     N_ROW           MATDATA_A[N_ROW_]      Number of local equations
C     N_COL           MATDATA_A[N_COL_]      Number of local variables
C     CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
C   					     the global context of the operation
C   					     on the matrix.
C   					     The context itself is global.
C   
C     Let DESCHALO_P be the array DESC_HALO for local process.
C     This is composed of variable dimension blocks for each process to 
C     communicate to.
C     Each block contain indexes of local halo elements to exchange with other 
C     process.
C     Let P be the pointer to the first element of a block in DESCHALO_P.
C     This block is stored in DESCHALO_P as :
C   
C     NOTATION        STORED IN		          EXPLANATION
C     --------------- --------------------------- -----------------------------------
C     PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
C   						  data with.
C     N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
C     ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
C   					          receive. These are stored in the
C   					          array from location P+ELEM_RECV_ to
C   					          location P+ELEM_RECV_+
C   						  DESCHALO_P[P+N_ELEM_RECV_]-1.
C     N_ELEMENTS_SEND DESCHALO_P[P+N_ELEM_SEND_]  Number of elements to send.
C     ELEMENTS_SEND   DESCHALO_P[P+ELEM_SEND_+i]  Indexes of local elements to
C   					          send. These are stored in the
C   					          array from location P+ELEM_SEND_ to
C   					          location P+ELEM_SEND_+
C   						  DESCHALO_P[P+N_ELEM_SEND_]-1.
C   
C   
C     Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
C     This is composed of variable dimension blocks for each process to 
C     communicate to.
C     Each block contain indexes of local overlap elements to exchange with
C     other process.
C     Let P be the pointer to the first element of a block in DESCOVRLP_P.
C     This block is stored in DESCOVRLP_P as :
C   
C     NOTATION        STORED IN		            EXPLANATION
C     ------------- ------------------------------- -----------------------------------
C     PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
C   						    data with.
C     N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
C     OVRLAP_ELEM   DESCOVRLP_P[P+OVRLP_ELEM_TO_+i] Indexes of local elements to
C   					            exchange. These are stored in the
C   					            array from location P+OVRLP_ELEM_ to
C   					            location P+OVRLP_ELEM_+
C   						    DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
C   
C   
C     Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
C     This is composed of blocks of two elements. The block
C     corresponding to the i-th overlapped elements, begin at index 
C     P = i*2 in array OVR_ELEM_P.
C     This block is stored in OVR_ELEM_P as :
C   
C     NOTATION      STORED IN		       EXPLANATION
C     ------------- -------------------------- ----------------------------------
C     OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
C   					       element.
C     N_POMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
C   					       local overlapped element.
C   
C   
C     Parameters
C     ==========
C   
C     N       (global input) pointer to INTEGER
C             The length of the distributed vectors to be multiplied.
C             N >= 0.
C   
C     DNORM2  (local output) pointer to REAL
C             The norm2 of sub( X ).
C   
C     X       (local input) REAL array containing the local
C             pieces of a distributed dense matrix.
C             This array contains the entries of the distributed vector
C             sub( X ).
C   
C     IX      (global input) pointer to INTEGER
C             The global row index of the subvector of the distributed
C             matrix X, to operate on.
C   
C     JX      (global input) pointer to INTEGER
C             The global column index of the subvector of the distributed
C             matrix X to operate on.
C   
C     LLDX    (local input) pointer to INTEGER
C             The leading dimension of local dense matrix X.
C
C     DESCDATA (global and local input) INTEGER array. Is the MATRIX_DATA
C              array.
C   
C     DESCHALO (local input) INTEGER array. Is the DESC_HALO array.
C   
C     DESCOVRLAP (local input) INTEGER array. Is the DESC_OVRLAP array.
C   
C     DESCOVRLAPELEM (local input) INTEGER array. Is the OVRLAP_ELEM array.
C   
      implicit none
      include 'psblas.fh'
      double precision one,zero
      parameter (one=1.d0,zero=0.d0)
      integer            ione
      parameter          (ione=1)
      integer            ix, jx, lldx, n
      integer            int_err(5)
      double precision   real_err(5)
      double precision   dnorm2, dd, tmpnrm, w, z 
      double precision   dnrm2
      external           dnrm2
      integer            desc_data(*), desc_halo(*), 
     +  desc_ovrlap(*), desc_ovrlap_elem(2,*)
      double precision   X(lldx,*)
      external dcombnrm2

      integer            iix,jjx,info,err,id,i,nprow,ictxt,npcol,
     +  mycol,myrow,ndim

      ictxt = desc_data(ctxt_)
      call blacs_gridinfo( ictxt, nprow, npcol, myrow, mycol )
      
      info = 0
      if ( nprow .eq. -1 ) then 
        info = 2010
      else         
        call pbchkvectf(n,1,1,ix,jx,
     +    lldx, desc_data,7,3, iix, jjx,
     +    info, int_err)
      endif

      err = info
      call igamx2d(ictxt, all, topdef, ione, ione, err, ione, 
     +  tmpnrm, tmpnrm, -ione ,-ione,-ione)

      if (err .eq. 0) then
        if ( n .ne. 0) then
          if (iix .eq. 1) then    
            if (desc_data(N_ROW_) .gt. 0) then 
              nDim = desc_data(N_ROW_)
              tmpnrm = dnrm2( nDim, x(1,jjx), 1 )
              i=1
              do while (desc_ovrlap_elem(ovrlp_elem_,i) .ne. -1)
                id = desc_ovrlap_elem(n_dom_ovr_,i)
                dd = dble(id-1)/dble(id)
C                     tmpnrm = tmpnrm*sqrt(one-
C     +                  (dd*x(desc_ovrlap_elem(ovrlp_elem_,i),jjx)/
C     +                  tmpnrm)**2)
                tmpnrm = tmpnrm * sqrt(
     +            one - dd * (
     +            x(desc_ovrlap_elem(ovrlp_elem_, i), jjx) 
     +            / tmpnrm
     +            ) ** 2
     +            )
                i = i+1
              enddo		
            else 	    
              tmpnrm = zero
            endif
            
            call pdtreecomb(ictxt,'All',1,tmpnrm,-1,-1,dcombnrm2)
            
          else 
            info = 3040
          endif
        else 
          tmpnrm=zero
        endif

        dnorm2 = tmpnrm
      endif

      if ( info .ne. 0 ) then 
        call psderror( ictxt, info, 'PSDNRM2\0', int_err, real_err )
      endif
      return
      end





