/* ---------------------------------------------------------------------
*
*  -- PSSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*/
/*
 *  Include files
 */
#include "psblas.h"
#include <math.h>

void psdmamax_( n, k, amax, X, ix, jx, lldx, desc_data, desc_halo, 
	      desc_ovrlap, desc_ovrlap_elem )
     /*
      *  .. Scalar Arguments ..
      */
     int         *n, *ix, *jx, *lldx, *k;
     double      *amax;
     /* ..
      *  .. Array Arguments ..
      */
     int         desc_data[], desc_halo[], desc_ovrlap[], desc_ovrlap_elem[] ;
     double      X[];
{
  /*
   *  Purpose
   *  =======
   *
   *  PSDAMAX search the absolute max of X
   *
   *     amax := max(abs(sub(X)(i))
   *
   *  where sub( X ) denotes X(IX:IX+N-1,JX:JX+K-1).
   *
   *
   *  Notes
   *  =====
   *
   *  Some description vectors are associated with each distributed sparse
   *  matrix. These vectors stores the information required to the
   *  communication needed to perform distributed operations.
   *
   *  They are:
   *
   *  NAME		 EXPLANATION
   *  ------------------ -------------------------------------------------------
   *  MATRIX_DATA	 Array of INTEGER that contains some local and global
   *			 information of matrix.
   *
   *  DESC_HALO          Array of INTEGER that contains informations for local 
   *                     halo points.
   *
   *  DESC_OVRLAP        Array of INTEGER that contains a list of local overlap 
   *                     elements.
   *                     
   *  OVRLAP_ELEM        Array of INTEGER that contains a list of local overlap
   *                     elements with their multiplicity.
   *
   *  Now we explain each of the above vectors.
   *
   *  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
   *  array for matrix A.
   *  Data stored in MATRIX_DATA array are:
   *
   *  NOTATION        STORED IN		     EXPLANATION
   *  --------------- ---------------------- -------------------------------------
   *  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
   *  M 	      MATDATA_A[M_]          Total number of equations
   *  N 	      MATDATA_A[N_]          Total number of variables
   *  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
   *  N_COL           MATDATA_A[N_COL_]      Number of local variables
   *  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
   *					     the global context of the operation
   *					     on the matrix.
   *					     The context itself is global.
   *
   *  Let DESCHALO_P be the array DESC_HALO for local process.
   *  This is composed of variable dimension blocks for each process to 
   *  communicate to.
   *  Each block contain indexes of local halo elements to exchange with other 
   *  process.
   *  Let P be the pointer to the first element of a block in DESCHALO_P.
   *  This block is stored in DESCHALO_P as :
   *
   *  NOTATION        STORED IN		          EXPLANATION
   *  --------------- --------------------------- -----------------------------------
   *  PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
   *						  data with.
   *  N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
   *  ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
   *					          receive. These are stored in the
   *					          array from location P+ELEM_RECV_ to
   *					          location P+ELEM_RECV_+
   *						  DESCHALO_P[P+N_ELEM_RECV_]-1.
   *  N_ELEMENTS_SEND DESCHALO_P[P+N_ELEM_SEND_]  Number of elements to send.
   *  ELEMENTS_SEND   DESCHALO_P[P+ELEM_SEND_+i]  Indexes of local elements to
   *					          send. These are stored in the
   *					          array from location P+ELEM_SEND_ to
   *					          location P+ELEM_SEND_+
   *						  DESCHALO_P[P+N_ELEM_SEND_]-1.
   *
   *
   *  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
   *  This is composed of variable dimension blocks for each process to 
   *  communicate to.
   *  Each block contain indexes of local overlap elements to exchange with
   *  other process.
   *  Let P be the pointer to the first element of a block in DESCOVRLP_P.
   *  This block is stored in DESCOVRLP_P as :
   *
   *  NOTATION        STORED IN		            EXPLANATION
   *  ------------- ------------------------------- -----------------------------------
   *  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
   *						    data with.
   *  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
   *  OVRLAP_ELEM   DESCOVRLP_P[P+OVRLP_ELEM_TO_+i] Indexes of local elements to
   *					            exchange. These are stored in the
   *					            array from location P+OVRLP_ELEM_ to
   *					            location P+OVRLP_ELEM_+
   *						    DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
   *
   *
   *  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
   *  This is composed of blocks of two elements. The block
   *  corresponding to the i-th overlapped elements, begin at index 
   *  P = i*2 in array OVR_ELEM_P.
   *  This block is stored in OVR_ELEM_P as :
   *
   *  NOTATION      STORED IN		       EXPLANATION
   *  ------------- -------------------------- ----------------------------------
   *  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
   *					       element.
   *  N_POMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
   *					       local overlapped element.
   *
   *
   *  Parameters
   *  ==========
   *
   *  N       (global input) pointer to INTEGER
   *          The number of rows to be operated on, that is the 
   *          number of rows of submatrix sub(X).  N >= 0.
   *
   *  K       (global input) pointer to INTEGER
   *          The number of columns to be operated on, that is the
   *          number of columns of submatrix sub(X).  K >= 0.
   *
   *  AMAX    (local output) pointer to REAL
   *          Max absolute of elements in sub( X ).
   *
   *  X       (local input) REAL array containing the local
   *          pieces of a distributed dense matrix.
   *          This array contains the entries of the distributed vector
   *          sub( X ).
   *
   *  IX      (global input) pointer to INTEGER
   *          The global row index of the subvector of the distributed
   *          matrix X, to operate on.
   *
   *  JX      (global input) pointer to INTEGER
   *          The global column index of the subvector of the distributed
   *          matrix X to operate on.
   *
   *  LLDX    (local input) pointer to INTEGER
   *          The leading dimension of local dense matrix X.
   *
   *  DESCDATA (global and local input) INTEGER array. Is the MATRIX_DATA
   *           array.
   *
   *  DESCHALO (local input) INTEGER array. Is the DESC_HALO array.
   *
   *  DESCOVRLAP (local input) INTEGER array. Is the DESC_OVRLAP array.
   *
   *  DESCOVRLAPELEM (local input) INTEGER array. Is the OVRLAP_ELEM array.
   *
   *  =====================================================================
   *
   *  .. Local Scalars ..
   */
  int DimCol, nDim, ictxt, iix, jjx,
  mycol, myrow, nprow, npcol, ione=1,mone=-1,i,jj;

  /* Error variables */
  int         info=0,err;
  int         int_err[5];
  double      real_err[5];

  /* ..
   *  .. Local Array ..
   */
  double *tmpx, *tmpy;
  int RA[1], CA[1];
  /* ..
   *  .. External Functions ..
   */
  void        blacs_gridinfo();
  void        dgamx2d();
  int         idamax();
  void        pbchkvect();
  void        pberror_();

  /* ..
   *  .. Executable Statements ..
   *
   *  Get grid parameters
   */
  ictxt = desc_data[CTXT_];
  Cblacs_gridinfo( ictxt, &nprow, &npcol, &myrow, &mycol );
  /*
   *  Test the input parameters
   */
  info = 0;
  if( nprow == -1 ) {
    info = 2010;
  } else {
    pbchkvect( *n, 1, 1, *ix, *jx, *lldx, desc_data, 7, 3, &iix, &jjx,
	       &info, int_err);
    
    err = info;
    Cigamx2d(ictxt, ALL, TOPDEF, 1, 1, &err, 1, tmpx, tmpx, -1 ,-1,-1);
    
    if ( err == 0 )
      if (*n != 0)
	if (iix == 1)		/* Columns vectors */
	  if (desc_data[N_ROW_] > 0) /* I partecipate to the computation */ {
	    nDim = desc_data[N_ROW_];
	    for (jj=0; jj< *k; jj++) {
	      tmpx = &X[(jjx+jj-1)*(*lldx)+iix-1]; 
	      amax[jj] = fabs(tmpx[idamax(&nDim,tmpx,&ione)-1]);
	    }	    
	    /* Global Max */
	    Cdgamx2d(ictxt, ALL, TOPDEF, *k, ione, amax, *k, RA, CA,
		     mone, mone, mone);
	  } else {
	    for (jj=0; jj< *k; jj++) {
	      amax[jj] = 0.0;
	    }
	    /* Global Max */
	    Cdgamx2d(ictxt, ALL, TOPDEF, *k, ione, amax, *k, RA, CA,
		     mone, mone, mone);
	  }
	else
	  info =  3040;
      else
	*amax = 0.0;
  }
  
  if ( (info != 0) || (err != 0)) {
    psderror_( &ictxt, &info, "PSDAMAX", int_err, real_err );
    return;
  }
}
