#include "psblas.h"
#include <stdio.h>
#include <string.h>

void psderror_(ictxt, error_code, routine, int_values, real_values)
     char       *routine;
     int        *ictxt, *error_code, *int_values;
     double     *real_values;
{
  char message[150];
  int myrow, mycol, nprow, npcol, length;

  /* ..
   *  .. External Functions ..
   */

  /* ..
   *  .. Executable Statements ..
   */
  
  if (*error_code != 0)  {
    Cblacs_gridinfo( *ictxt, &nprow, &npcol, &myrow, &mycol );
    
    if( nprow == -1 ) {
      fprintf( stderr, "ERROR in SUBROUTINE %s\nNumber of process = -1\n Possible cause: Parallel environment is not initialized or context in matrix_data is invalid.\nPossibly call interface is incorrect\n",routine);
      length=strlen(message);
      PSI_create_msg(error_code, int_values, real_values, &message[length] );
      fprintf(stderr, message);
    } else {
      sprintf( message, "\nERROR on PROCESS %d in SUBROUTINE %s\n", myrow, routine );
      length=strlen(message);
      PSI_create_msg(error_code, int_values, real_values, &message[length] );
      fprintf(stderr, message);
    }
  }
  
  Cblacs_barrier(*ictxt, ALL);
  
  if ((*error_code <= 2000)&&(*error_code > 1000))  /* Computational errors */
    ;
  else  {
    Cblacs_abort(*ictxt, *error_code);
    exit(1);
  }
}
