/* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*/
/*
*  Include files
*/
#include "psblas.h"

#define DESCMULT      100
#define BIGNUM     100000

void pbchkvectf( m, n, mpos0, ix, jx, lldx, desc_dec, dpos0, xpos0, iix, jjx, 
	       info, int_values )
     /*
      *  .. Scalar Arguments ..
      */
     int *xpos0, *dpos0, *iix, *info, *ix, *jjx, *lldx,
     *jx, *n, *m, *mpos0;
     /*
      *  .. Array Arguments ..
      */
     int         *desc_dec, *int_values;
{
  pbchkvect(*m, *n, *mpos0,*ix,*jx, *lldx, desc_dec,
      *dpos0,*xpos0,iix,jjx,info,int_values);
}



void pbchkvect( m, n, mpos0, ix, jx, lldx, desc_dec, dpos0, xpos0, iix, jjx, 
	       info, int_values )
     /*
      *  .. Scalar Arguments ..
      */
     int xpos0, dpos0, * iix, * info, ix, * jjx, lldx,
     jx, n, m, mpos0;
     /*
      *  .. Array Arguments ..
      */
     int        *desc_dec, *int_values;
{
  /*
   *
   *  Purpose
   *  =======
   *
   *  pbchkvect checks the validity of a descriptor vector DESCDEC, the
   *  related global indexes IX, JX and the leading dimension LLDX. It also
   *  computes the starting local indexes (IIX,JJX) corresponding to the
   *  submatrix starting globally at the entry pointed by (IX,JX).
   *  Finally, if an inconsistency is found among its parameters IX, JX,
   *  DESCDEC and LLDX, the routine returns an error code in info.
   *
   *  Arguments
   *  =========
   *
   *  M       (global input) INTEGER
   *          The number of rows of the dense matrix X being operated on.
   *
   *  N       (global input) INTEGER
   *          The number of columns of the dense matrix X being operated on.
   *
   *  NPOS0   (global input) INTEGER
   *          Where in the calling routine's parameter list M appears.
   *
   *  IX      (global input) INTEGER
   *          X's global row index, which points to the beginning of the
   *          dense submatrix which is to be operated on.
   *
   *  JX      (global input) INTEGER
   *          X's global column index, which points to the beginning of
   *          the dense submatrix which is to be operated on.
   *
   *  LLDX    (local input) INTEGER
   *          The leading dimension of the local dense matrix X.
   *
   *  DESCDATA (global and local input) INTEGER array. Is the MATRIX_DATA
   *           array.
   *
   *  DPOS0   (global input) INTEGER
   *          Where in the calling routine's parameter list DESCDATA
   *          appears.
   *
   *  XPOS0   (global input) INTEGER
   *	      Where in the calling routine's parameter list X appears.
   *
   *  IIX     (local output) pointer to INTEGER
   *          The local rows starting index of the submatrix.
   *
   *  JJX     (local output) pointer to INTEGER
   *          The local columns starting index of the submatrix.
   *
   *  INFO    (local input/local output) INTEGER
   *          = 0:  successful exit
   *          < 0:  If the i-th argument is an array and the j-entry had
   *                an illegal value, then INFO = -(i*100+j), if the i-th
   *                argument is a scalar and had an illegal value, then
   *                INFO = -i.
   *
   *  =====================================================================
   *
   *  =====================================================================
   *
   *  .. Parameters ..
   */
  /* ..
   *  .. Local Scalars ..
   */
  int descpos, ldpos, ixpos,
  jxpos, mpos, npos;
  /*
   *  .. Executable Statements ..
   */
  if( int_values[0] <= 0 )
    int_values[0] = BIGNUM;

  if ( *info <= 0)
    *info = BIGNUM;
  /*
   *  Figure where in parameter list each parameter was, factoring in
   *  descriptor multiplier
   */
  mpos = mpos0;
  npos = mpos0 + 1;
  ixpos = xpos0 + 1;
  jxpos = xpos0 + 2;
  ldpos = xpos0 + 3;
  descpos = dpos0;
  /*
   *  Check that matrix values make sense from local viewpoint
   */
  if (( m < 0 )&&(*info > 10)) {
    *info = 10;
    int_values[0] = mpos0;		/* Parameter position */
    int_values[1] = m;		/* Parameter value */
  } else if(( n < 0)&&(*info > 10)) {
    *info = 10;
    int_values[0] = mpos0+1;		/* Parameter position */
    int_values[1] = n;		/* Parameter value */   
  } else if((ix < 1) && (m != 0) && (*info > 20))  {
    *info = 20;
    int_values[0] = ixpos;		/* Parameter position */
    int_values[1] = ix;		/* Parameter value */   
  } else if(( jx < 1 ) && ( n != 0) && (*info > 20))  {
    *info = 20;
    int_values[0] = jxpos;		/* Parameter position */
    int_values[1] = jx;		/* Parameter value */   
  } else if (( desc_dec[N_COL_] < 0 ) && (*info > 40))  {
    *info = 40;
    int_values[0] = descpos;		/* Array paramater position */
    int_values[1] = N_COL_ + 1;	/* Entry position */
    int_values[2] = desc_dec[N_COL_];/* Entry value */
  } else if(( desc_dec[N_ROW_] < 0 )&& (*info > 40)) {
    *info = 40;
    int_values[0] = descpos;		/* Array paramater position */
    int_values[1] = N_ROW_ + 1;	/* Entry position */
    int_values[2] = desc_dec[N_ROW_];/* Entry value */
  } else if(( lldx < desc_dec[N_COL_] )&& (*info > 50)) {
    *info = 50;
    int_values[0] = ldpos;		/* Paramater position */
    int_values[1] = lldx;		/* Parameter value */
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = N_COL_ + 1;	/* Entry position */
    int_values[4] = desc_dec[N_COL_];/* Entry value */
  } else if(( desc_dec[N_] < m )&& (*info > 60))  {
    *info = 60;
    int_values[0] = mpos;		/* Paramater position */
    int_values[1] = m;		/* Parameter value */
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = N_ + 1;		/* Entry position */
    int_values[4] = desc_dec[N_];/* Entry value */
  } else if (( desc_dec[N_] < ix ) && (*info > 60))  {
    *info = 60;
    int_values[0] = ixpos;		/* Paramater position */
    int_values[1] = ix;		/* Parameter value */
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = N_ + 1;		/* Entry position */
    int_values[4] = desc_dec[N_];	/* Entry value */
  } else if (( desc_dec[M_] < jx ) && (*info > 60)) {
    *info = 60;
    int_values[0] = jxpos;		/* Paramater position */
    int_values[1] = jx;		/* Parameter value */   
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = M_ + 1;		/* Entry position */
    int_values[4] = desc_dec[M_];	/* Entry value */
  } else if (( desc_dec[N_] < ix + m - 1) && (*info > 80)) {
    *info = 80;
    int_values[0] = mpos;		/* Paramater position */
    int_values[1] = m;		/* Parameter value */   
    int_values[2] = ixpos;		/* Paramater position */
    int_values[3] = ix;		/* Parameter value */   
  }

  if ( *info == BIGNUM ) {
    /* For our applications iix = ix and jjx = jx */
    *iix = ix;
    *jjx = jx;
    
    *info = 0;
  }
}
/*****************************************************************************/
void pbchkglobvect( m, n, mpos0, ix, jx, lldx, desc_dec, dpos0, xpos0,
	       info, int_values )
     /*
      *  .. Scalar Arguments ..
      */
     int xpos0, dpos0, * info, ix, lldx,
     jx, n, m, mpos0;
     /*
      *  .. Array Arguments ..
      */
     int         desc_dec[], int_values[];
{
  /*
   *
   *  Purpose
   *  =======
   *
   *  pbchkvect checks the validity of a descriptor vector DESCDEC, the
   *  related global indexes IX, JX and the leading dimension LLDX. It also
   *  computes the starting local indexes (IIX,JJX) corresponding to the
   *  submatrix starting globally at the entry pointed by (IX,JX).
   *  Finally, if an inconsistency is found among its parameters IX, JX,
   *  DESCDEC and LLDX, the routine returns an error code in info.
   *
   *  Arguments
   *  =========
   *
   *  M       (global input) INTEGER
   *          The number of rows of the dense matrix X being operated on.
   *
   *  N       (global input) INTEGER
   *          The number of columns of the dense matrix X being operated on.
   *
   *  NPOS0   (global input) INTEGER
   *          Where in the calling routine's parameter list M appears.
   *
   *  IX      (global input) INTEGER
   *          X's global row index, which points to the beginning of the
   *          dense submatrix which is to be operated on.
   *
   *  JX      (global input) INTEGER
   *          X's global column index, which points to the beginning of
   *          the dense submatrix which is to be operated on.
   *
   *  LLDX    (local input) INTEGER
   *          The leading dimension of the local dense matrix X.
   *
   *  DESCDATA (global and local input) INTEGER array. Is the MATRIX_DATA
   *           array.
   *
   *  DPOS0   (global input) INTEGER
   *          Where in the calling routine's parameter list DESCDATA
   *          appears.
   *
   *  XPOS0   (global input) INTEGER
   *	      Where in the calling routine's parameter list X appears.
   *
   *
   *  INFO    (local input/local output) INTEGER
   *          = 0:  successful exit
   *          < 0:  If the i-th argument is an array and the j-entry had
   *                an illegal value, then INFO = -(i*100+j), if the i-th
   *                argument is a scalar and had an illegal value, then
   *                INFO = -i.
   *
   *  =====================================================================
   *
   *  =====================================================================
   *
   *  .. Parameters ..
   */
  /* ..
   *  .. Local Scalars ..
   */
  int descpos, ldpos, ixpos,
  jxpos, mpos, npos;
  /*
   *  .. Executable Statements ..
   */
  if( int_values[0] <= 0 )
    int_values[0] = BIGNUM;

  if ( *info <= 0)
    *info = BIGNUM;
  /*
   *  Figure where in parameter list each parameter was, factoring in
   *  descriptor multiplier
   */
  mpos = mpos0;
  npos = mpos0 + 1;
  ixpos = xpos0 + 1;
  jxpos = xpos0 + 2;
  ldpos = xpos0 + 3;
  descpos = dpos0;
  /*
   *  Check that matrix values make sense from local viewpoint
   */
  if (( m < 0 )&&(*info > 10)) {
    *info = 10;
    int_values[0] = mpos0;		/* Parameter position */
    int_values[1] = m;		/* Parameter value */
  } else if(( n < 0)&&(*info > 10)) {
    *info = 10;
    int_values[0] = mpos0+1;		/* Parameter position */
    int_values[1] = n;		/* Parameter value */   
  } else if((ix < 1) && (m != 0) && (*info > 20)) {
    *info = 20;
    int_values[0] = ixpos;		/* Parameter position */
    int_values[1] = ix;		/* Parameter value */   
  } else if(( jx < 1 ) && ( n != 0) && (*info > 20)) {
    *info = 20;
    int_values[0] = jxpos;		/* Parameter position */
    int_values[1] = jx;		/* Parameter value */   
  } else if (( desc_dec[N_COL_] < 0 ) && (*info > 40)) {
    *info = 40;
    int_values[0] = descpos;		/* Array paramater position */
    int_values[1] = N_COL_ + 1;	/* Entry position */
    int_values[2] = desc_dec[N_COL_];/* Entry value */
  } else if(( desc_dec[N_ROW_] < 0 )&& (*info > 40)) {
    *info = 40;
    int_values[0] = descpos;		/* Array paramater position */
    int_values[1] = N_ROW_ + 1;	/* Entry position */
    int_values[2] = desc_dec[N_ROW_];/* Entry value */
  } else if(( lldx < desc_dec[M_] )&& (*info > 50)) {
    *info = 50;
    int_values[0] = ldpos;		/* Paramater position */
    int_values[1] = lldx;		/* Parameter value */
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = N_COL_ + 1;	/* Entry position */
    int_values[4] = desc_dec[N_COL_];/* Entry value */
  } else if(( desc_dec[N_] < m )&& (*info > 60)) {
    *info = 60;
    int_values[0] = mpos;		/* Paramater position */
    int_values[1] = m;		/* Parameter value */
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = N_ + 1;		/* Entry position */
    int_values[4] = desc_dec[N_];/* Entry value */
  } else if (( desc_dec[N_] < ix ) && (*info > 60)) {
    *info = 60;
    int_values[0] = ixpos;		/* Paramater position */
    int_values[1] = ix;		/* Parameter value */
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = N_ + 1;		/* Entry position */
    int_values[4] = desc_dec[N_];	/* Entry value */
  } else if (( desc_dec[M_] < jx ) && (*info > 60)) {
    *info = 60;
    int_values[0] = jxpos;		/* Paramater position */
    int_values[1] = jx;		/* Parameter value */   
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = M_ + 1;		/* Entry position */
    int_values[4] = desc_dec[M_];	/* Entry value */
  } else if (( desc_dec[N_] < ix + m - 1) && (*info > 80)) {
    *info = 80;
    int_values[0] = mpos;		/* Paramater position */
    int_values[1] = m;		/* Parameter value */   
    int_values[2] = ixpos;		/* Paramater position */
    int_values[3] = ix;		/* Parameter value */   
  }
  
  if( *info == BIGNUM ) {
    *info = 0;
  }
}

/* ---------------------------------------------------------------------
*

*  ---------------------------------------------------------------------
*/

void pberror_( ctxt, mess, info )
     /*
      *  .. Scalar Arguments ..
      */
     int         * ctxt, * info;
     /* ..
      *  .. Array Arguments ..
      */
     char        * mess;
{
  /*
   *  Purpose
   *  =======
   *
   *  pberror_ is an error handler of the PSBLAS routines, displays an error
   *  message on stderr, and stops the running program.
   *
   * ======================================================================
   *
   *  .. Parameters ..
   */
  /* ..
   *  .. Local Scalars ..
   */
  int         iinfo, mycol, myrow, npcol, nprow;
  /* ..
   *  .. External Functions ..
   */
  void        blacs_abort();
  void        blacs_gridinfo();
  /* ..
   *  .. Executable Statements ..
   */
  Cblacs_gridinfo( *ctxt, &nprow, &npcol, &myrow, &mycol );

  iinfo = *info;
  if( iinfo < 0 ) {
    iinfo = -iinfo;
    if( iinfo < DESCMULT ) {
      fprintf( stderr, "{%3d,%3d}: On entry to %s ", myrow, mycol,
	       mess );
      fprintf( stderr, "parameter number %2d had an illegal value\n",
	       iinfo );
    } else {
      fprintf( stderr, "{%3d,%3d}: On entry to %s ", myrow, mycol,
	       mess );
      fprintf( stderr, "parameter number %2d had an illegal value\n",
	       iinfo / DESCMULT );
      fprintf( stderr, "entry # %2d had an illegal value\n",
	       iinfo % DESCMULT );
    }
  } else {
    fprintf( stderr,
	     "{%3d,%3d}: Positive error code %2d returned by %s !!!\n",
	     myrow, mycol, iinfo, mess );
  }
  Cblacs_abort( *ctxt, iinfo );
}
