
/* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*/
#include "psblas.h"

void pbchkmat( m, mpos0, n, npos0, ia, ja, desc_dec, dpos0, apos0, iia, jja,
	      info, int_values )
     /*
      *  .. Scalar Arguments ..
      */
     int         dpos0, * iia, * info, ia, * jja,
     ja, m, mpos0, n,
     npos0, apos0;
     /*
      *  .. Array Arguments ..
      */
     int         desc_dec[], int_values[];
{
  /*
   *
   *  Purpose
   *  =======
   *
   *  pbmatvect checks the validity of a descriptor vector DESCDEC, the
   *  related global indexes IA, JA. It also computes the starting local
   *  indexes (IIA,JJA) corresponding to the submatrix starting globally at
   *  the entry pointed by (IA,JA). Finally, if an inconsitency is found among 
   *  its parameters ia, ja and desc_A, the routine returns an error code in
   *  info.
   *
   *  Arguments
   *  =========
   *
   *  M       (global input) INTEGER
   *          The number or matrix rows of A being operated on.
   *
   *  MPOS0   (global input) INTEGER
   *          Where in the calling routine's parameter list M appears.
   *
   *  N       (global input) INTEGER
   *          The number or matrix columns of A being operated on.
   *
   *  NPOS0   (global input) INTEGER
   *          Where in the calling routine's parameter list N appears.
   *
   *  IA      (global input) INTEGER
   *          A's global row index, which points to the beginning of the
   *          submatrix which is to be operated on.
   *
   *  JA      (global input) INTEGER
   *          A's global column index, which points to the beginning of
   *          the submatrix which is to be operated on.
   *
   *  DESCDEC (global and local input) INTEGER array of dimension 8
   *          The array descriptor for the distributed sparse matrix A.
   *
   *  DPOS0   (global input) INTEGER
   *          Where in the calling routine's parameter list DESCDEC
   *          appears.
   *
   *  APOS0   (global input) INTEGER
   *	      Where in the calling routine's parameter list A appears.
   *
   *  IIA     (local output) pointer to INTEGER
   *          The local rows starting index of the submatrix.
   *
   *  JJA     (local output) pointer to INTEGER
   *          The local columns starting index of the submatrix.
   *
   *  INFO    (local input/local output) INTEGER
   *          = 0:  successful exit
   *          < 0:  If the i-th argument is an array and the j-entry had
   *                an illegal value, then INFO = -(i*100+j), if the i-th
   *                argument is a scalar and had an illegal value, then
   *                INFO = -i.
   *
   *  =====================================================================
   *
   *  =====================================================================
   *
   *  .. Parameters ..
   */
#define DESCMULT      100
#define BIGNUM      10000
  /* ..
   *  .. Local Scalars ..
   */
  int         descpos, iapos, japos,
              mpos, npos;

  /*
   *  .. Executable Statements ..
   */
  if( int_values[0] <= 0 )
    int_values[0] = BIGNUM;

  if ( *info <= 0)
    *info = BIGNUM;

  /*
   *  Figure where in parameter list each parameter was, factoring in
   *  descriptor multiplier
   */
  mpos = mpos0;
  npos = npos0;
  iapos = apos0 + 7;
  japos = apos0 + 8;
  descpos = dpos0;
  /*
   *  Check that matrix values make sense from local viewpoint
   */
  if (( m < 0 )&&(*info > 10)) {
    *info = 10;
    int_values[0] = mpos0;		/* Parameter position */
    int_values[1] = m;		/* Parameter value */
  } else if(( n < 0)&&(*info > 10))  {
    *info = 10;
    int_values[0] = mpos0+1;		/* Parameter position */
    int_values[1] = n;		/* Parameter value */   
  } else if((ia < 1) && (m != 0) && (*info > 20))  {
    *info = 20;
    int_values[0] = iapos;		/* Parameter position */
    int_values[1] = ia;		/* Parameter value */   
  } else if(( ja < 1 ) && ( n != 0) && (*info > 20))  {
    *info = 20;
    int_values[0] = japos;		/* Parameter position */
    int_values[1] = ja;		/* Parameter value */   
  } else if (( desc_dec[N_COL_] < 0 ) && (*info > 40)) {
    *info = 40;
    int_values[0] = descpos;		/* Array paramater position */
    int_values[1] = N_COL_ + 1;	/* Entry position */
    int_values[2] = desc_dec[N_COL_];/* Entry value */
  } else if(( desc_dec[N_ROW_] < 0 )&& (*info > 40))  {
    *info = 40;
    int_values[0] = descpos;		/* Array paramater position */
    int_values[1] = N_ROW_ + 1;	/* Entry position */
    int_values[2] = desc_dec[N_ROW_];/* Entry value */
  } else if(( desc_dec[M_] < m )&& (*info > 60)) {
    *info = 60;
    int_values[0] = mpos;		/* Paramater position */
    int_values[1] = m;		/* Parameter value */
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = M_ + 1;		/* Entry position */
    int_values[4] = desc_dec[M_];	/* Entry value */
  } else if(( desc_dec[N_] < n )&& (*info > 60)) {
    *info = 60;
    int_values[0] = npos;		/* Paramater position */
    int_values[1] = n;		/* Parameter value */
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = N_ + 1;		/* Entry position */
    int_values[4] = desc_dec[N_];	/* Entry value */
  } else if (( desc_dec[M_] < ia ) && (*info > 60)) {
    *info = 60;
    int_values[0] = iapos;		/* Paramater position */
    int_values[1] = ia;		/* Parameter value */
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = M_ + 1;		/* Entry position */
    int_values[4] = desc_dec[M_];	/* Entry value */
  } else if (( desc_dec[N_] < ja ) && (*info > 60))  {
    *info = 60;
    int_values[0] = japos;		/* Paramater position */
    int_values[1] = ja;		/* Parameter value */   
    int_values[2] = descpos;		/* Array paramater position */
    int_values[3] = N_ + 1;		/* Entry position */
    int_values[4] = desc_dec[N_];	/* Entry value */
  } else if (( desc_dec[M_] < ia + m - 1) && (*info > 80))  {
    *info = 80;
    int_values[0] = mpos;		/* Paramater position */
    int_values[1] = m;		/* Parameter value */   
    int_values[2] = iapos;		/* Paramater position */
    int_values[3] = ia;		/* Parameter value */   
  } else if (( desc_dec[N_] < ja + n - 1) && (*info > 80))  {
    *info = 80;
    int_values[0] = npos;		/* Paramater position */
    int_values[1] = n;		/* Parameter value */   
    int_values[2] = japos;		/* Paramater position */
    int_values[3] = ja;		/* Parameter value */   
  }
  

  /*
   *  Retrieve local information for matrix A, and prepare output:
   *  set info = 0 if no error, and divide by DESCMULT if error is not
   *  in a descriptor entry.
   */
  if ( *info == BIGNUM ) {
    /* If I partecipate to the computing */
    if ( desc_dec[N_ROW_] > 0 )  {
      *iia = 1 ;
      *jja = 1 ;
    } else {
      *iia = desc_dec[N_ROW_] + 1;
      *jja = desc_dec[N_COL_] + 1;
    }
    
    *info = 0;
  }
}






