* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*
      SUBROUTINE PSI_ZVERIFY_T0(TRANS, UNITD, D,A,IA1, IA2, 
     +   FIDA, DESCRA, INFOA, 
     +   DESC_DATA, DESC_HALO, DESC_OVRLAP, DESC_OVRLAP_ELEM,
     +   LOC_TO_GLOB,CHECK_DESCR,CONVERT_DESCR,
     +   P1, H, IH1, IH2, FIDH, DESCRH, INFOH, P2,
     +   LH, LIH1, LIH2,
     +   DESC_DATA_OUT,DESC_HALO_OUT, LENGHT_DHO,
     +   DESC_OVRLAP_OUT, LENGHT_DOO,
     +   DESC_OVRLAP_ELEM_OUT, LENGHT_DOEO,
     +   WORK,LWORK,DIMH)
C    
C   Purpose
C   =======
C
C   Check the correctness of the data structures describing data distribution.
C   for decomposition type 0
C
C
C  Notes
C  =====
C
C  Some description vectors are associated with each distributed sparse
C  matrix. These vectors stores the information required to the
C  communication needed to perform distributed operations.
C
C  They are:
C
C  NAME		 EXPLANATION
C  ------------------ -------------------------------------------------------
C  DESC_DATA	 Array of INTEGER that contains some local and global
C		 information of matrix.
C
C
C  Now we explain each of the above vectors.
C
C  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
C  array for matrix A.
C  Data stored in MATRIX_DATA array are:
C
C  NOTATION        STORED IN		     EXPLANATION
C  --------------- ---------------------- -------------------------------------
C  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
C  M 	           MATDATA_A[M_]          Total number of equations
C  N 	           MATDATA_A[N_]          Total number of variables
C  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
C  N_COL           MATDATA_A[N_COL_]      Number of local variables
C  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
C		   	                     the global context of the operation
C					     on the matrix.
C					     The context itself is global.
C  
C  Let DESCHALO_P be the array DESC_HALO for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local halo elements to exchange with other 
C  process.
C  Let P be the pointer to the first element of a block in DESCHALO_P.
C  This block is stored in DESCHALO_P as :
C
C  NOTATION        STORED IN		          EXPLANATION
C  --------------- --------------------------- -----------------------------------
C  PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
C						  data with.
C  N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
C  ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
C					          receive. These are stored in the
C					          array from location P+ELEM_RECV_ to
C					          location P+ELEM_RECV_+
C						  DESCHALO_P[P+N_ELEM_RECV_]-1.
C  N_ELEMENTS_SEND DESCHALO_P[P+N_ELEM_SEND_]  Number of elements to send.
C  ELEMENTS_SEND   DESCHALO_P[P+ELEM_SEND_+i]  Indexes of local elements to
C					          send. These are stored in the
C					          array from location P+ELEM_SEND_ to
C					          location P+ELEM_SEND_+
C						  DESCHALO_P[P+N_ELEM_SEND_]-1.
C
C
C  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local overlap elements to exchange with
C  other process.
C  Let P be the pointer to the first element of a block in DESCOVRLP_P.
C  This block is stored in DESCOVRLP_P as :
C
C  NOTATION        STORED IN		            EXPLANATION
C  ------------- ------------------------------- -----------------------------------
C  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
C						    data with.
C  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
C  OVRLAP_ELEM   DESCOVRLP_P[P+OVRLP_ELEM_TO_+i] Indexes of local elements to
C					            exchange. These are stored in the
C					            array from location P+OVRLP_ELEM_ to
C					            location P+OVRLP_ELEM_+
C						    DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
C
C
C  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
C  This is composed of blocks of two elements. The block
C  corresponding to the i-th overlapped elements, begin at index 
C  P = i*2 in array OVR_ELEM_P.
C  This block is stored in OVR_ELEM_P as :
C
C  NOTATION      STORED IN		       EXPLANATION
C  ------------- -------------------------- ----------------------------------
C  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
C					       element.
C  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
C					       local overlapped element.
C
C   Input Data
C   ==========
C
C  A       (local input) COMPLEX*16 pointer into the local memory
C          to an array containing the values of
C          local pieces of the distributed sparse matrix sub( A ).
C
C  IA1     (local input) INTEGER array containing the column
C          coordinates of the values of local pieces of the
C          distributed sparse matrix sub( A ).
C
C  IA2     (local input) INTEGER array containing the coordinates
C          of the first element of a row of the
C          distributed sparse matrix sub( A ) in the array of values 'A'.
C          The coordinates of the first element of row i of the
C          distributed sparse matrix sub( A ) in the array of values 'A' 
C          is IA2[i].
C
C  FIDA    (global input) pointer to CHARACTER containing a string
C          that indicates the type of sparse matrix representation.
C
C  DESCRA  (global input) pointer to CHARACTER containing the type of
C          sparse matrix.
C             DESCRA[1] = 'G' General
C             DESCRA[1] = 'S' Symmetric
C             DESCRA[1] = 'H' Hermitian
C             DESCRA[1] = 'T' Triangular
C             DESCRA[1] = 'A' Anti-symmetric
C             DESCRA[1] = 'D' Diagonal
C             DESCRA[2] = 'U' Upper
C             DESCRA[2] = 'L' Lower
C             DESCRA[3] = 'U' Unit diagonal
C             DESCRA[3] = 'N' Non Unit diagonal
C
C  INFOA   (global output) INTEGER array containing user defined 
C          information.
C
C  DESC_DATA (global and local input) INTEGER array. Is the MATRIX_DATA
C           array.
C
C  DESC_HALO (local input) INTEGER array. Is the DESC_HALO array.
C
C  DESC_OVRLAP (local input) INTEGER array. Is the DESC_OVRLAP array.
C
C  DESC_OVRLAPELEM (local input) INTEGER array. Is the OVRLAP_ELEM array.
C
C  LOC_TO_GLOB (local input) INTEGER array. Element "i" contains global index
C                of local element with index "i", (associated to i-th column
C                of local matrix). 
C                Used only if is perfomed global check ( see CHECK_DESCR 
C                parameter).
C
C  CHECK_DESCR (global input) INTEGER scalar. Indicate what type of check
C                must be perfomed:
C               0-th bit : if 1 then it is performed DEADLOCK check, else
C                           this check will not be performed.
C               1-th bit : if 1 then it is performed LOCAL_MATRX check, else
C                           this check will not be performed.
C               2-th bit : if 1 then is performed LOCAL_COMM check, else
C                           this check will not be performed.
C               3-th bit : if 1 then it is performed CONSISTENCY check, else
C                           this check will not be performed.
C               4-th bit : if 1 then it is performed GLOBAL check, else
C                           this check will not be performed.
C               5-th bit : if 1 then will be optimized communication
C                          between processes.
C
C               -DEADLOCK check: PSVERIFY checks if the 
C                communication ordering, implicitely described in DESC_HALO
C                and DESC_OVRLAP arrays, causes a deadlock among processes.
C                If is found deadlock then PSVERIFY orders the communication
C                between process by a euristic algorithm to avoid deadlock
C                optimizing number of communication step. The new data 
C                structure obtained from DESC_HALO, DESC_OVRLAP and 
C                DESC_OVRLAP_ELM are returned respectively 
C                in DESC_HALO_OUT, DESC_OVRLAP_OUT and DESC_OVRLAP_ELEM_OUT 
C                arrays.
C                This check requires communication among processes.
C
C               -LOCAL_MATRIX check: PSVERIFY checks if ia1 and ia2 indices
C                describing local matrix are consistent respect DESC_DATA.
C                This check not requires communication among processes.
C                If an error occured PSVERIFY displays an error message
C                and stops execution.
C
C               -LOCAL_COMM check : PSVERIFY checks if DESC_HALO DESC_OVRLAP
C                DESC_OVRLAP_ELM indices are locally consistent. 
C                More precisely:
C
C                .every index of elements to send contained in DESC_HALO array 
C                 must be less or equal than No. of internal elements 
C                 (=DESC_DATA(N_ROW_))
C
C                .every index of elements to receive contained in DESC_HALO 
C                 array must be greater than No. of internal elements.
C                 (=DESC_DATA(N_ROW_)) and less or equal than No. of 
C                 global elements
C                 (halo points + internal points =DESC_DATA(N_COL_)).
C
C                .every index of elements contained in DESC_OVRLAP array must
C                 be less or equal than No. of internal elements 
C                 (=DESC_DATA(N_ROW_)).
C
C                .DESC_OVRLAP arrays must be consistent respect DESC_OVRLAP 
C                 array.
C                
C               This check not requires communication among processes.
C               If an error occured PSVERIFY displays an error message
C               and stops execution.
C
C              -CONSISTENCY check: PSVERIFY checks if the number of indices 
C               described in DESC_HALO and DESC_OVRLAP array, to be send
C               to every processor is consistent respect to the number
C               of indices that every process must receive from it.
C               This check requires communication among processes.
C               If an error occured PSVERIFY displays an error message
C               and stops execution.
C
C              -GLOBAL check : PSVERIFY executes CONSISTENCY check and
C               verifies (using LOC_TO_GLOB array ) if indices, to be 
C               exchanged among every pair of processes, matches.
C               This check requires communication among processes.
C               If an error occured PSVERIFY displays an error message
C               and stops execution.
C             
C            In each case PSVERIFY always performs this minimal checks:
C              -Correctness of BLACS grid, associated to DESC_DATA(CTXT_)
C              -Correctness of the list structures:
C                 DESC_HALO,DESC_OVRLAP
C              -Global matching of DESC_DATA(N_) and DESC_DATA(M_) 
C               parameters and correctness of them (must be >=0).
C              -Correctness of DESC_DATA(N_ROW_) and DESC_DATA(N_COL_):
C                     DESC_DATA(N_COL) >= DESC_DATA(N_ROW) >= 0
C              -Matrix type and rappresentation passed is supported by actual 
C               PSBLAS implementation.
C              -Correctness of process identifer in DESC_HALO and DESC_OVRLAP
C               array respect BLACS grid.
C            This checks requires communication among processes.
C            If an error occured PSVERIFY displays an error message
C            and stops execution.
C
C  LENGHT_OEO   (Local input) Scalar integer. Lenght OVERLAP_ELEM_OUT array.
C               If is performed reordering on DESC_OVRLAP list, it must be at
C               least equal to OVERLAP_ELEM array's length.
C
C  LENGHT_DOO   (Local input) Scalar integer. Lenght of DESC_OVRLAP_OUT array.
C               If is performed reordering on DESC_OVRLAP list, it must be at
C               least equal to DESC_OVRLAP array's lenght.
C                     
C
C  LENGHT_DHO   (Local Input) Scalar integer. Lenght of DESC_HALO_OUT array.
C               If is performed reordering on DESC_HALO list, it must be at
C               least equal to DESC_HALO array's lenght.
C               
C  WORK       (local input) INTEGER array. Work area to memorize intermediate 
C	         results. 
C
C  LWORK      (local input) INTEGER. Dimension of Work area.
C            
C
C
C   Output Data
C   ==========
C   
C   CONVERT_DESCR : (global output) INTEGER scalar describes what operation are 
C                     performed.
C                   If PSVERIFY has found deadlock in communication described in
C                   DESC_HALO list, then 0-th bit value is set to 1, 0 otherwise.
C                   If PSVERIFY has found deadlock in communication described in
C                   DESC_OVRLAP list, then 1-th bit value is set to 1, 0 otherwise.
C                   If PSVERIFY has converted input matrix A to a rappresentation
C                   supported by PSBLAS then 1-th bit value is set to 1, 
C                   0 otherwise.
C                 
C 
C  H       (local output) COMPLEX*16 If has changed matrix rappresentation then contains 
C          pointer into the local memory
C          to an array containing the values of
C          local pieces of the distributed converted sparse matrix sub( A ).
C
C  IH1     (local output) INTEGER If has changed matrix rappresentation then contains 
C           array containing the column
C          coordinates of the values of local pieces of the
C          distributed converted sparse matrix sub( A ).
C
C  IH2     (local output) INTEGER  If has changed matrix rappresentation then contains 
C          array containing the coordinates
C          of the first element of a row of the
C          distributed sparse matrix sub( A ) in the array of values 'H'.
C          The coordinates of the first element of row i of the
C          distributed  converted sparse matrix sub( A ) in the array of values 'H' 
C          is IH2[i].
C
C  FIDH    (global output) pointer to CHARACTER  If has changed matrix rappresentation 
C          then contains a string
C          that indicates the type of converted sparse matrix representation.
C
C  DESCRH  (global output) pointer to CHARACTER 
C          If has changed matrix rappresentation then contains 
C          the type of  converted sparse matrix.
C             DESCRA[1] = 'G' General
C             DESCRA[1] = 'S' Symmetric
C             DESCRA[1] = 'H' Hermitian
C             DESCRA[1] = 'T' Triangular
C             DESCRA[1] = 'A' Anti-symmetric
C             DESCRA[1] = 'D' Diagonal
C             DESCRA[2] = 'U' Upper
C             DESCRA[2] = 'L' Lower
C             DESCRA[3] = 'U' Unit diagonal
C             DESCRA[3] = 'N' Non Unit diagonal
C
C  INFOH   (global output) INTEGER array If has changed matrix rappresentation 
C          then contains user defined information about converted matrix.
C   
C
C  DESC_HALO_OUT      Array of INTEGER. If PSVERIFY has found communication 
C                     deadlock on DESC_HALO list and, has reordered communication,
C                     then contains DESC_HALO's information sorted such that
C                     avoid deadlock.
C
C  DESC_OVRLAP_OUT    Array of INTEGER. If PSVERIFY has found communication 
C                     deadlock on DESC_OVRLAP list and, has reordered communication,
C                     then contains DESC_OVRLAP's information sorted such that
C                     avoid deadlock.
C  OVRLAP_ELEM_OUT    Array of INTEGER. If PSVERIFY has reordered 
C                     communication on DESC_OVRLAP list
C                     then contains reorded information contained in
C                     DESC_OVRLAP list.
      IMPLICIT NONE
      INCLUDE 'psblas.fh'      
C     .....Array Input Arguments....
      INTEGER IA1(*),IA2(*),DESC_DATA(*),
     +   DESC_HALO(*),DESC_OVRLAP(*),
     +   DESC_OVRLAP_ELEM(*),INFOA(*),WORK(*),
     +   LOC_TO_GLOB(*),P1(*),P2(*)

      COMPLEX*16 A(*), D(*)
      CHARACTER FIDA*5,DESCRA*11, TRANS, UNITD

C    ...Output arrays....
      INTEGER IH1(*),IH2(*),DESC_DATA_OUT(*),
     +   DESC_HALO_OUT(*),DESC_OVRLAP_OUT(*),
     +   DESC_OVRLAP_ELEM_OUT(*),INFOH(*),DIMH(*)

      COMPLEX*16 H(*)
      CHARACTER FIDH*5,DESCRH*11

      INTEGER ITWO,IONE
      PARAMETER (ITWO=2,IONE=1)

C     ...scalar parameters....
      INTEGER CHECK_DESCR,LWORK,CONVERT_DESCR,LENGHT_DHO,
     +   LENGHT_DOO,LENGHT_DOEO,
     +   LH, LIH1, LIH2


C     ...Local Arrays...
      INTEGER INT_ERR(7)
      DOUBLE PRECISION REAL_ERR(5)

C     ...Local Scalars...
      INTEGER LWORK1,LWORK2,MYROW,NP,NPCOL,MYCOL,LWORK3,I,
     +   CHECK_DESCR_INT,MAX_SEND,MAX_RECV,
     +   DL_LDA_HALO,DL_LDA_OVRLAP,ERR,INFO,ICTXT
      INTEGER MAX_LENGHT_DL, IERR

      ICTXT = DESC_DATA(CTXT_)
      IERR = 0
      INFO = 0

      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NP,NPCOL,MYROW,MYCOL)

      IF (IBITS(CHECK_DESCR,LOC_TO_GLOB_CHECK,1).EQ.1) THEN
C     ...check on loc_to_glob list....
         DO I=1,DESC_DATA(N_COL_)
            IF ((DESC_DATA(LOC_TO_GLOB_+I).LT.1)
     +         .OR.(DESC_DATA(LOC_TO_GLOB_+I).GT.DESC_DATA(M_))) THEN
               INFO = 240
               INT_ERR(1) = LOC_TO_GLOB_+I
               INT_ERR(2) = 10
               INT_ERR(3) = M_
               INT_ERR(4) = 10
               INT_ERR(5) = 1
               INT_ERR(6) = DESC_DATA(LOC_TO_GLOB_+I)
               INT_ERR(7) = DESC_DATA(M_)
               GOTO 998
            ENDIF
         ENDDO
      ENDIF
      IF ((LWORK.LT.2*NP).AND.(INFO.EQ.0)) THEN
         INFO = 90
         INT_ERR(1) = 2*NP
         INT_ERR(2) = LWORK
      ENDIF
 998  CONTINUE 
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      
C     ...check correctness of list structures...
      CALL PSI_LOC_VERIFY(CHECK_DESCR,NP,
     +   DESC_DATA, DESC_HALO, DESC_OVRLAP, 
     +   DESC_OVRLAP_ELEM,MAX_SEND,MAX_RECV,DL_LDA_HALO,DL_LDA_OVRLAP,
     +   WORK,WORK(NP+1))

      CONVERT_DESCR=0

C     ...Split Work Area....
      LWORK2=DL_LDA_HALO*NP
      LWORK3=NP
      LWORK1=LWORK-LWORK2-LWORK3

      IF (LWORK.LT.LWORK2+NP+(NP**2)) THEN
         INFO = 90
         INT_ERR(1) = LWORK2+NP+(NP**2)
         INT_ERR(2) = LWORK
      ENDIF

      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999

C     ...Check if there is deadlock in DESC_HALO communication        
      CALL PSI_OPTIMIZE_DATA(DESC_DATA,DESC_HALO,NP,
     +   CHECK_DESCR,CONVERT_DESCR,CONVERT_HALO,
     +   DESC_HALO_OUT,LENGHT_DHO,
     +   WORK,DL_LDA_HALO,
     +   WORK(LWORK2+1),WORK(LWORK2+LWORK3+1),LWORK1,IERR)

      IF (IERR.NE.0) THEN
         INFO = 100
         INT_ERR(1) = 29
         INT_ERR(2) = IERR
         INT_ERR(3) = LENGHT_DHO
      ENDIF

      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999

      IF ((CONVERT_DESCR.EQ.1).AND.
     +   (IBITS(CHECK_DESCR,ORDER_COMMUNICATION,1).EQ.0)) THEN
C          ...if DESC_HALO is sorted then force to sort also DESC_OVRLAP
         CHECK_DESCR_INT=CHECK_DESCR+2**ORDER_COMMUNICATION
      ELSE
         CHECK_DESCR_INT=CHECK_DESCR
      ENDIF


C     ...Split Work Area....
      LWORK2=DL_LDA_OVRLAP*NP
      LWORK3=NP
      LWORK1=LWORK-LWORK2-LWORK3
      IF (LWORK.LT.LWORK2+NP+(NP**2)) THEN
         INFO = 90
         INT_ERR(1) = LWORK2+NP+(NP**2)
         INT_ERR(2) = LWORK
      ENDIF

      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999

C     ...Check if there is deadlock in DESC_OVRLAP communication        
      CALL PSI_OPTIMIZE_DATA(DESC_DATA,DESC_OVRLAP,NP,
     +   CHECK_DESCR_INT,CONVERT_DESCR,CONVERT_OVRLAP,
     +   DESC_OVRLAP_OUT,LENGHT_DOO,
     +   WORK,DL_LDA_OVRLAP,
     +   WORK(LWORK2+1),WORK(LWORK2+LWORK3+1),LWORK1,IERR)

      IF (IERR.NE.0) THEN
         INFO = 100
         INT_ERR(1) = 31
         INT_ERR(2) = IERR
         INT_ERR(3) = LENGHT_DOO
      ENDIF

      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999

C     check how work area is necessary in this procedure...
C     ...Verify matrix structure......
      CALL PSI_ZMTRX_VERIFY(TRANS, UNITD, D, A, IA1, IA2,
     +   FIDA, DESCRA, INFOA,P1, H, IH1, IH2, FIDH, DESCRH, INFOH, P2,
     +   LH, LIH1, LIH2,  DESC_DATA,
     +   CHECK_DESCR,WORK,LWORK/DBLEINT_,DIMH)

      IF ((IBITS(CHECK_DESCR,CONSISTENCY_CHECK,1).EQ.1).OR.
     +   (IBITS(CHECK_DESCR,GLOBAL_CHECK,1).EQ.1)) THEN
C     ...if consistency check or global check are active....
         
C     ...Split Work Area....
         LWORK1=MAX_RECV
         LWORK2=LWORK-LWORK1
         IF ((LWORK.LT.MAX_SEND+MAX_RECV).AND.
     +      (IBITS(CHECK_DESCR,GLOBAL_CHECK,1).EQ.1)) THEN
            INFO = 90
            INT_ERR(1) = MAX_SEND+MAX_RECV
            INT_ERR(2) = LWORK
         ENDIF

         ERR = INFO
         CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +      IH1, IH1, -IONE ,-IONE,-IONE)
      
         IF (ERR.NE.0) GOTO 9999

C        ....perform global checks on new lists....
         CALL PSI_GLOB_HALO_VERIFY(CHECK_DESCR,
     +      DESC_DATA,DESC_HALO_OUT,LOC_TO_GLOB,
     +      WORK,LWORK1,WORK(LWORK1+1),LWORK2)
         
         CALL PSI_GLOB_OVR_VERIFY(CHECK_DESCR,
     +      DESC_DATA,DESC_OVRLAP_OUT,LOC_TO_GLOB,
     +      WORK, LWORK1,WORK(LWORK1+1), LWORK2) 
         
      ENDIF

C     ...copy DESC_OVRLAP_ELEM to DESC_OVRLAP_ELEM_OUT.....
      I=1
      DO WHILE (DESC_OVRLAP_ELEM(I).NE.-1)
         DESC_OVRLAP_ELEM_OUT(I)=DESC_OVRLAP_ELEM(I)
         I=I+1
      ENDDO

      DESC_OVRLAP_ELEM_OUT(I)=-1

C     ... Error Check ...
      IF (I.GT.LENGHT_DOEO) THEN
         INFO = 100
         INT_ERR(1) = 34
         INT_ERR(2) = I
         INT_ERR(3) = LENGHT_DOEO
      ENDIF

      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999

      
C     ....copy DESC_DATA in DESC_DATA_OUT
      DESC_DATA_OUT(DEC_TYPE_)=DESC_DATA(DEC_TYPE_)
      
      DESC_DATA_OUT(M_)=DESC_DATA(M_)
      DESC_DATA_OUT(N_)=DESC_DATA(N_)
      
      DESC_DATA_OUT(N_ROW_)=DESC_DATA(N_ROW_)
      DESC_DATA_OUT(N_COL_)=DESC_DATA(N_COL_)
      DESC_DATA_OUT(CTXT_)=DESC_DATA(CTXT_)
      IF (IBITS(CHECK_DESCR,GLOBAL_CHECK,1).EQ.1) THEN
         DO I=1,DESC_DATA(N_COL_)
            DESC_DATA_OUT(LOC_TO_GLOB_+I)=DESC_DATA(LOC_TO_GLOB_+I)
         ENDDO
      ENDIF

      RETURN

 9999 CALL PSDERROR( ICTXT, INFO, 'PSZVERIFY\0', INT_ERR, REAL_ERR )
      END


           



