C ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*
      SUBROUTINE PSI_DMTRX_VERIFY(TRANS, UNITD, D, A, IA1, IA2, 
     +   FIDA, DESCRA, INFOA, PL, H, IH1, IH2, FIDH, DESCRH, INFOH, PR,
     +   LH, LIH1, LIH2, DESC_DATA, CHECK_DESCR, WORK, LWORK, DIMH)
C    
C    INTERNAL ROUTINE
C    ================ 
C   
C    _____Called by PSDVERIFY ______
C
C    PURPOSE
C    =======
C
C     Check correctness of Local matrix descriptors.
C
C    INPUT PARAMETERS
C    ================
C
C  IA1     (local input) INTEGER array containing the column
C          coordinates of the values of local pieces of the
C          distributed sparse matrix sub( A ).
C
C  IA2     (local input) INTEGER array containing the coordinates
C          of the first element of a row of the
C          distributed sparse matrix sub( A ) in the array of values 'A'.
C          The coordinates of the first element of row i of the
C          distributed sparse matrix sub( A ) in the array of values 'A' 
C          is IA2[i].
C 

C  FIDA    (global input) pointer to CHARACTER containing a string
C          that indicates the type of sparse matrix representation.
C
C  DESCRA  (global input) pointer to CHARACTER containing the type of
C          sparse matrix.
C             DESCRA[1] = 'G' General
C             DESCRA[1] = 'S' Symmetric
C             DESCRA[1] = 'H' Hermitian
C             DESCRA[1] = 'T' Triangular
C             DESCRA[1] = 'A' Anti-symmetric
C             DESCRA[1] = 'D' Diagonal
C             DESCRA[2] = 'U' Upper
C             DESCRA[2] = 'L' Lower
C             DESCRA[3] = 'U'
C             DESCRA[3] = 'N' Non Unit diagonal
C
C  INFOA   (global input) INTEGER array containing user defined 
C          information.
C
C  DESC_DATA (global and local input) INTEGER array.
C            see "psverify.f" for its description.
C
C  CHECK_DESCR (global input) INTEGER scalar. Indicate what type of check
C                must be perfomed. See "psverify.f" for its description.
C

C     .....Array Arguments....
      IMPLICIT NONE
      INCLUDE 'psblas.fh'
      CHARACTER FIDA*5,FIDH*5,DESCRA*11,DESCRH*11,
     +   TRANS*1, UNITD*1
      INTEGER CHECK_DESCR, LIH1, LIH2, LH, LWORK, I
      INTEGER IA1(*),IA2(*),IH1(*),IH2(*), 
     +   DESC_DATA(*), PL(*), PR(*),
     +   INFOA(*), INFOH(*), DIMH(*)
      DOUBLE PRECISION A(*), D(*), H(*)
      DOUBLE PRECISION WORK(*)

      

      INTEGER INFO,ROW,POINTER, IERROR, IONE, ICTXT, ERR
      CHARACTER CSR*5,G*1,CHECK*1
      PARAMETER (CSR='CSR',G='G',IONE=1)
      INTEGER   INT_ERR(5)
      DOUBLE PRECISION REAL_ERR(5)

      

C     ....Verify DESC_DATA correctness.....         
      
      IF (DESC_DATA(M_).LE.0) THEN
         INFO = 40
         INT_ERR(1) = 7
         INT_ERR(2) = M_
         INT_ERR(3) = DESC_DATA(M_)
      ELSE IF (DESC_DATA(N_).LE.0) THEN
         INFO = 40
         INT_ERR(1) = 7
         INT_ERR(2) = N_
         INT_ERR(3) = DESC_DATA(N_)
      ELSE IF (DESC_DATA(N_ROW_).LT.0) THEN
         INFO = 40
         INT_ERR(1) = 7
         INT_ERR(2) = N_ROW_
         INT_ERR(3) = DESC_DATA(N_ROW_)
      ELSE IF (DESC_DATA(N_COL_).LT.0) THEN
         INFO = 40
         INT_ERR(1) = 7
         INT_ERR(2) = N_COL_
         INT_ERR(3) = DESC_DATA(N_COL_)
      ENDIF

      ICTXT = DESC_DATA(CTXT_)

      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   IH1, IH1, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      
C     ....Verify matrix correctness.......
      IF (IBITS(CHECK_DESCR,LOCAL_MTRX_CHECK,1).EQ.1) THEN
C        DO check on local matrix indices
         IF (IBITS(CHECK_DESCR,CHANGE_REPRESENT,1).EQ.1) THEN
            CHECK = 'Y'
         ELSE
            CHECK = 'C'
         ENDIF
         
         CALL DCSDP(CHECK,TRANS,DESC_DATA(N_ROW_),DESC_DATA(N_COL_),
     +      UNITD,D,FIDA,DESCRA,A,IA1,IA2,   
     &      INFOA,PL,FIDH,DESCRH,H,IH1,IH2,INFOH,PR,LH,LIH1,  
     &      LIH2,WORK,LWORK,IERROR)
      ELSE
         IF (IBITS(CHECK_DESCR,CHANGE_REPRESENT,1).EQ.1) THEN
            CHECK = 'N'
            CALL DCSDP(CHECK,TRANS,DESC_DATA(N_ROW_),DESC_DATA(N_COL_),
     +         UNITD,D,FIDA,DESCRA,A,IA1,IA2,
     &         INFOA,PL,FIDH,DESCRH,H,IH1,IH2,INFOH,PR,LH,LIH1,  
     &         LIH2,WORK,LWORK,IERROR)
         ENDIF
      ENDIF
      
      DO I = 1, 4
         DIMH(I) = INT(WORK(I))
      ENDDO
      IF (IERROR.NE.0) THEN
         INFO = 1040
         INT_ERR(1) = IERROR
         GOTO 9999
      ENDIF
      
      RETURN

 9999 CALL PSDERROR( ICTXT, INFO, 'PSDVERIFY\0', INT_ERR, REAL_ERR )
      END




