void PSI_create_msg(error_code, int_values, real_values, message )
     int        *error_code, *int_values;
     double     *real_values;
     char       *message;

{
  int            length;

  if (*error_code < 0) {
    strcpy(message, "Error on calling PSDERROR. 'error_code' must be greater than 0\n");
  } else if (*error_code < 1000) /* Error on input Arguments */
    if (*error_code < 500) /* Error on local input Arguments */ {
      sprintf(message,"Local Input Error. Code: %d\n",*error_code);
      length = strlen(message);
      switch (*error_code) {
      case 10: {
	sprintf(&message[length],"Input argument n. %1d cannot be less than 0\nCurrent value is %d.\n",int_values[0], int_values[1]) ;
	break;
      }
      
      case 20: {
	sprintf(&message[length],"Input argument n. %1d must be greater than 0\nCurrent value is %d.\n",int_values[0], int_values[1]) ;
	break;
      }
      
      case 30: {
	sprintf(&message[length],"Input argument n. %1d must be greater than input argument n. %1d\nCurrent values are %d < %d.\n",
		int_values[0], int_values[2],int_values[1],int_values[3]) ; 
	break;
      }      
      case 35: {
	sprintf(&message[length],"Size of input array argument n. %3d is invalid.\nCurrent value is %d.\n",
		int_values[0], int_values[1]) ; 
	break;
      }
      case 40: {
	sprintf(&message[length],"Entry n. %d in input array argument n. %1d must be greater than 0\nCurrent value is %d.\n",
		int_values[1], int_values[0],int_values[2]) ; 
	break;
      }
      case 45: {
	sprintf(&message[length],"Entry n. %d in input array argument n. %1d must be greater or equal than 0\nCurrent value is %d.\n",
		int_values[1], int_values[0],int_values[2]) ; 
	break;
      }

      case 50: {
	sprintf(&message[length],"Input argument n. %d cannot be less than entry n. %d in array input argument n. %1d\nCurrent values are %d < %d.\n",
		int_values[0], int_values[3],int_values[2],
		int_values[1],int_values[4]) ; 
	break;
      }
	    
      case 60: {
	sprintf(&message[length],"Input argument n. %d cannot be greater than entry n. %d in array input argument n. %1d\nCurrent values are %d > %d.\n",
		int_values[0], int_values[3],int_values[2],
		int_values[1],int_values[4]) ;
	break;
      }

      case 70: {
	sprintf(&message[length],"Input argument n. %d is not valid\n",int_values[0]) ;
	break;
      }
	
      case 80: {
	sprintf(&message[length],"Input arguments n. %d and/or n. %d are too large\nCurrent values are %d, %d.\n",
		int_values[0], int_values[2],int_values[1],
		int_values[3]) ;
	break;
      }
      case 90: {
	sprintf(&message[length],"Work area too small.\nAre necessary, at least, %d elements instead of %d elements.\n",
		int_values[0], int_values[1]) ;
	break;
      }
      case 100: {
	sprintf(&message[length],"Input argument n. %d must be greater than %d.\nCurrent values are %d <= %d.\n",
		int_values[0], int_values[1], int_values[2], int_values[1]) ;
	break;
      }
      case 110: {
	sprintf(&message[length],"Invalid process identifier in input array argument n. %d.\nCurrent value is %d.\n",
		int_values[0], int_values[1]) ;
	break;
      }
      case 120: {
	sprintf(&message[length],"Invalid local index to receive in input argument n. %d.\nThe value must be greater than %d and less than %d.\nCurrent value is %d.\n",
		int_values[0], int_values[1], int_values[2], int_values[3]) ;
	break;
      }
      case 130: {
	sprintf(&message[length],"Invalid local index to send in input argument n. %d.\nThe value must be greater than %d and less than %d.\nCurrent value is %d.\n",
		int_values[0], int_values[1], int_values[2], int_values[3]) ;
	break;
      }
      case 140: {
	sprintf(&message[length],"Number of overlap elements to send differs from number of overlap elements to receive in argument n. %d.\nCurrents values are: %d to send, %d to receive.\n",
		int_values[0], int_values[1], int_values[2]) ;
	break;
      }    
      case 150: {
	sprintf(&message[length],"Number of overlap elements in input argument n. %d differs from number of overlap elements in input argument n. %d.\nCurrents values are: %d in argument n. %d; %d in input argument n. %d.\n",
		int_values[0], int_values[1], int_values[2], int_values[0], int_values[3],int_values[1]) ;
	break;
      }    
      case 160: {
	sprintf(&message[length],"Communication ordering involved from data structures, create deadlock.\nTo avoid deadlock please change bit for re-ordering, in parameter n. %d.\n",
		int_values[0]) ;
	break;
      }    
      case 170: {
	sprintf(&message[length],"Number of halo elements that proc. %d must receive from proc. %d (n elem. %d)\ndiffers from number of halo elements to send from proc. %d to proc. %d (n elem. %d)\n",
		int_values[0],int_values[1],int_values[2],int_values[1],int_values[0],int_values[3]) ;
	break;
      }    
      case 180: {
	sprintf(&message[length],"Invalid input argument n. %d on proc. %d.\nGlobal index of %d-th element to send to proc. %d differs from corresponding global index to receive in proc. %d.\n",int_values[0], int_values[1], int_values[2], int_values[3],int_values[3]);
	length = strlen(message);
	sprintf(&message[length],"Current values are: (glob. index to send to proc. %d = %d differs from glob. index to receive from proc. %d = %d)\n",
		int_values[3],int_values[3],int_values[4],int_values[5]) ;
	break;
      }
      case 190: {
	sprintf(&message[length],"Number of overlap elements that proc. %d must receive from proc. %d (n elem. %d)\ndiffers from number of overlap elements to send from proc. %d to proc. %d (n elem. %d)\n",
		int_values[0],int_values[1],int_values[2],int_values[1],int_values[0],int_values[3]) ;
	break;
      }    
      case 200: {
	sprintf(&message[length],"Entry n. %d in input argument n. %d cannot be greater than entry n. %d in array input argument n. %1d\nCurrent values are %d > %d.\n",
		int_values[0], int_values[3],int_values[2],
		int_values[1],int_values[4],int_values[5]) ; 
	break;
      }
      case 210: {
	sprintf(&message[length],"Entry n. %d in input argument n. %d must be greater than entry n. %d in array input argument n. %1d\nCurrent values are %d <= %d.\n",
		int_values[0], int_values[3],int_values[2],
		int_values[1],int_values[4],int_values[5]) ; 
	break;
      }
      case 220: {
	sprintf(&message[length],"The %d-th halo element that proc. %d must receive from proc. %d doesn't belong to proc.%d\nElement global index = %d.\n",
		int_values[0], int_values[1],int_values[2],
		int_values[2],int_values[3]) ; 
	break;
      }
      case 230: {
	sprintf(&message[length],"The %d-th halo element that proc. %d must receive from proc. %d belongs to halo of proc.%d\nElement global index = %d.\n",
		int_values[0], int_values[1],int_values[2],
		int_values[2],int_values[3]) ; 
	break;
      }
      case 240: {
	sprintf(&message[length],"Entry n. %d in input argument n. %d cannot be greater than entry n. %d in input argument n. %d or less than %d\nCurrent values are %d > %d or %d < %d.\n",
		int_values[0],int_values[1],int_values[2],int_values[3],int_values[4],
		int_values[5],int_values[6],int_values[5],int_values[4]);
	break;
      }
      case 250: {
	sprintf(&message[length],"The %d-th overlap element that proc. %d must receive from proc. %d doesn't belong to proc.%d\nElement global index = %d.\n",
		int_values[0], int_values[1],int_values[2],
		int_values[2],int_values[3]) ; 
	break;
      }
      case 260: {
	sprintf(&message[length],"Parameter n. %d in proc. %d specify that there is overlap between proc. %d and proc. %d \nbut parameter n. %d in proc. %d specify that there isn't overlap between proc. %d and proc.\n",
		int_values[0], int_values[1],int_values[1],
		int_values[2],int_values[0],int_values[2],
		int_values[2],int_values[1]) ; 
	break;
      } 
      case 270: {
	sprintf(&message[length],"Parameter n. %d in proc. %d specify different number of non-zero elements respect parameter n. %d \n",
		int_values[0], int_values[1], int_values[2]);
	break;
      } 
	    
      case 280: {
	sprintf(&message[length]," Otpional Parameter NUM_LOC_ROW passed in psdalloc routine is inconsistent respect parameter No %d in proc.\n",
		int_values[0]);
	break;
      } 
      case 290: {
	sprintf(&message[length]," Is not possible to call psdins without calling before psdalloc on the same matrix\n");
	break;
      }  
      case 295: {
	sprintf(&message[length]," Is not possible to call this routine without calling before psdspalloc on the same matrix\n");
	break;
      } 

      case 300: {
	sprintf(&message[length],"Input argument n. %d must be equal to entry n. %d in array input argument n. %1d\nCurrent values are %d != %d.\n",
		int_values[0], int_values[3],int_values[2],
		int_values[1],int_values[4]) ;
	break;
      }
      case 310: {
	sprintf(&message[length],"Array parameter n. %d is not allocated correctly.\nPossible causes are:\n 1. You haven't called psdalloc\n 2. Parameter n. %d is not associated to array parameter n. %d.\n",
		int_values[0], int_values[1],int_values[0]) ;
	break;
      }
      case 320: {
	sprintf(&message[length],"Input argument n. %d cannot be greater than %d.\nCurrent value is %d > %d.\n",
		int_values[0], int_values[1],int_values[2],
		int_values[1]);
	break;
      }
      case 330: {
	sprintf(&message[length],"You have inserted more nnzero values than nnz parameter specified in psdspalloc.\nCurrent value is %d > %d.\n",
		int_values[0], int_values[1]);
	break;
      }
      default: {
	sprintf(&message[length],"INTERNAL ERROR:Invalid error code\n");
	break;
      }
      }

    } else  {               /* Error on global input Arguments */      
      sprintf(message,"Global Input Error. Code: %d\n",*error_code);
      length = strlen(message);
      switch (*error_code) {
      case 500: {
	sprintf(&message[length],"Entry n. %d in input array argument n. %d on process %d, differ from the root value.\nCurrent values are (local=%d) != (root=%d).\n",
		int_values[1], int_values[0],int_values[2],
		int_values[4],int_values[5]) ;
	break;
      }
      case 520: {
	sprintf(&message[length],"Parameter n. %d on process assign global point %d to a not-existent BLACS process, current value returned is %d.\n",
		int_values[0], int_values[1],int_values[2]);
	break;
	
      }
      case 540: {
	sprintf(&message[length],"Length of array, passed as parameter n. %d must be greater than %d.\n",
		int_values[0], int_values[1]);
	break;
      }
      case 550: {
	sprintf(&message[length],"Parameter n. %d must be equal on all BLACS processes.\n",
		int_values[0]);
	break;
      }
      case 560: {
	sprintf(&message[length],"This routine cannot be called more times on the same matrix.\n");
	break;
      }
      case 570: {
	sprintf(&message[length],"partition function passed as input argument n. %d returns number of processes greater than No of grid's processes on global point %d. Actual number of grid's processes is %d, number returned is %d \n",
		int_values[0],int_values[3],int_values[1],int_values[2]);
	break;
      }
      case 575: {
	sprintf(&message[length],"partition function passed as input argument n. %d returns number of processes less or equal to 0 on global point %d. Number returned is %d \n",
		int_values[0],int_values[2],int_values[1]);
	break;
      }
      case 580: {
	sprintf(&message[length],"partition function passed as input argument n. %d returns wrong processes identifier on global point %d. Current value returned is : %d\n",
		int_values[0],int_values[2],int_values[1]);
	break;
      }
      case 590: {
	sprintf(&message[length],"Cannot reinitialize a matrix that is not in ASSEMBLED state.\n");
	break;
      }
      case 600: {
	sprintf(&message[length],"Sparse Matrix and decsriptors are in an invalid state for this subroutine call: %d.\n",int_values[0]);
	break;
      }
      }
    } else if (*error_code < 2000) /* Computationals Errors */  {
      sprintf(message,"Computational Error. Code: %d\n",*error_code);
      length = strlen(message);
      switch (*error_code) {
      case 1010: {
	sprintf(&message[length],"Error in 'dcsmm' routine. Code error returned is %d\n",int_values[0]);
	break;
      }
      case 1020: {
	sprintf(&message[length],"Iteration Breakdown.\n");
	break;
      }
      case 1030: {
	sprintf(&message[length],"Method failed to converge to %g in %d iterations.\n",real_values[0],int_values[0]);
	break;
      }
      case 1040: {
	sprintf(&message[length],"Error in 'dcsdp' routine. Code error returned is %d\n",int_values[0]);
	break;
      }
      }
    } else if (*error_code < 3000) /* Resource Errors */  {
      sprintf(message,"Resource Error. Code: %d\n",*error_code);
      length = strlen(message);
      switch (*error_code) {
      case 2010: {
	sprintf(&message[length],"BLACS ERROR: Number of process = -1\n");
	break;
      }
      
      case 2020: {
	sprintf(&message[length],"Cannot allocate %d bytes.\n",int_values[0]);
	break;
      }
      case 2023: {
	sprintf(&message[length],"Cannot allocate %d integer elements\n",int_values[0]);
	break;
      }
      case 2025: {
	sprintf(&message[length],"Cannot allocate %d double precision elements\n",int_values[0]);
	break;
      }
      
      case 2030: {
	sprintf(&message[length],"BLACS ERROR: Number of grid columns must be equal to 1\nCurrent value is %d != 1.\n",int_values[0]);          
	break;
      }     
      case 2040: {
	sprintf(&message[length],"Error in deallocation of a temporary work area");          
	break;
      }
      case 2050: {
	sprintf(&message[length],"Error in deallocation");          
	break;
      }     
      }
    } else if (*error_code < 4000) /* Miscellaneus Errors */   {
      sprintf(message,"Miscellaneus Error. Code: %d\n",*error_code);
      length = strlen(message);
      
      switch (*error_code) {
      case 3010: {
	sprintf(&message[length],"Case lld not equal matrix_data[N_COL_] is not yet implemented.\n") ;
	break;
      }
      
      case 3015: {
	sprintf(&message[length],"Case trans != 'N' is not yet implemented with the chosen sparse matrix storage.\n") ;
	break;
      }

      case 3020: {
	sprintf(&message[length],"Case trans = 'C' is not yet implemented.\n") ;
	break;
      }
      
      case 3030: {
	sprintf(&message[length],"Case 'ja!=ix or ia!=iy' is not yet implemented.\n") ;
	break;
      }
      case 3040: {
	sprintf(&message[length],"Case 'ix != 1 or iy != 1' is not yet implemented.\n") ;
	break;
      }
      case 3050: {
	sprintf(&message[length],"Case 'ix != iy' is not yet implemented.\n") ;
	break;
      }
      case 3060: {
	sprintf(&message[length],"Case 'ix != 1' is not yet implemented.\n") ;
	break;
      }
      case 3070: {
	sprintf(&message[length],"This operation is only implemented with no overlap.\n") ;
	break;
      }
      case 3080: {
	sprintf(&message[length],"Decompostion type %d not yet supported.\n",int_values[0]) ;
	break;
      }
      case 3090: {
	sprintf(&message[length],"Insert matrix mode not yet implemented.\n") ;
	break;
      }  
      case 3100: {
	sprintf(&message[length],"Before you call this routine, you must have inserted all sparse matrix's rows\n") ;
	break;
      }
      case 3110: {
	sprintf(&message[length],"Before you call this routine, you must assembly sparse matrix\n") ;
	break;
      }
      }
 
    } else   /* Internals errors */   {
      sprintf(message,"Internal Error. Code: %d\n",*error_code);
      
      /*
	error_code = 4000                Length  of array for dependence 
	                                 list is too small
	error_code = 4010                Work area too small in 
                                   	PSI_Glob_halo_verify
	error_code = 4020                Work area too small in 
                                 	PSI_Glob_ovr_verify
	error_code = 4030                Work area too small in 
                                  	PSI_Desc_Halo
	error_code = 4040                Error in PSI_Desc_Halo
	error_code = 4050                Error in PSI_Comm, 
                                  	Buffer for communication too small
	error_code = 4060                Error in PSI_Crea_Overlap
                                          Work area too small
         error_code = 4070                Error in PSI_Cut_duplicate.
                                          Work area too small
         error_code = 4080                Error in PSI_Glo_No.
                                          Indices array too small
         error_code = 4090                Error in PSI_Optimize_data
                                          Workl area too small
         error_code = 4100                Error in PSI_convert_Comm
	 Workl area too small
         error_code = 4110                Error in psdspassx
                                          Halo index too small*/
      
    }
}

