* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*
      SUBROUTINE PSI_OPTIMIZE_DATA(DESC_DATA,STR_DATA,NP,
     +   CHECK_DESCR,CONVERT_DESCR,SUM_TO_CONVERT_DESCR,
     +   STR_DATA_OUT,LENGHT_STO,
     +   DEP_LIST,DL_LDA,LENGHT_DL,
     +   WORK,LWORK,IERR)

C    INTERNAL ROUTINE
C    ================ 
C   
C    _____Called by PSVERIFY ______
C
C    PURPOSE
C    =======
C
C    If OPTIMIZE bit of CHECK DESCR parameter is set to 1 then order and optimize 
C    communication step described by STR_DATA. The result is put in STR_DATA_OUT.
C    Otherwise if DEADLOCK bit of CHECK DESCR parameter is set to 1, then
C    verify if communication structure STR_DATA (in the form of DESC_HALO of
C    DESC_OVRLAP list) may cause a communication deadlock among processes.
C    In this case order and optimize communication step described by 
C    STR_DATA the result is put in STR_DATA_OUT.
C 
C   
C
C  DESC_DATA (global and local input) INTEGER array. 
C            See "psverify.f" for its description
C
C  STR_DESC  (local input) INTEGER array. Is the list of indices
C            that must be exchanged it could be DESC_HALO 
C            or alternatively DESC_OVRLAP arrays. 
C            See "psverify.f" for their description.
C
C  CHECK_DESCR (global input) INTEGER scalar. Indicate what type of check
C                must be perfomed. See "psverify.f" for its description.
C
C  SUM_TO_CONVERT: (Global input) is the number to sum to CONVERT_DESCR
C                  if it is performed the reordering.
C                  if this procedure is executed with DESC_HALO passed as
C                  STR_DESC  then it must be equal to 2**CONVERT_HALO.
C                  if this procedure is executed with DESC_OVRLAP passed as
C                  STR_DESC  then it must be equal to 2**CONVERT_OVRLAP.
C
C  LENGHT_STO   (Local input) Scalar integer. Lenght of STR_DATA_OUT array.
C               If is performed reordering on STR_DATA list, it must be at
C               least equal to STR_DATA array's lenght.
C               
C  WORK       (local input) REAL array. Work area to memorize intermediate 
C	         results. 
C
C  LWORK      (local input) pointer to INTEGER. Dimension of Work area.
C           
C
C   Output Data
C   ===========
C
C  CONVERT_DESCR : (global output) INTEGER scalar describes if reorder
C                   operations is performed. See "psverify.h" for its description.
C
C  STR_DATA_OUT     (local output) Array of INTEGER. 
C                    If PSVERIFY has reordered communication
C                    then contains STR_DAT indices with reordered comm.

      IMPLICIT NONE
     
      INTEGER LENGHT_STO,OPTIMIZE_LEV,NP,DL_LDA,LWORK,
     +   CONVERT_DESCR,SUM_TO_CONVERT_DESCR,CHECK_DESCR
      INTEGER DESC_DATA(*),STR_DATA(*),DEP_LIST(DL_LDA,0:NP-1),
     +   LENGHT_DL(0:NP),STR_DATA_OUT(*),WORK(*)

      
      INTEGER RESULT,MYROW,ME,NPCOL,MYCOL,NPROW,I,J,K,PROC,
     +   LWORK1,LWORK2,IERR
      
      INCLUDE 'psblas.fh'
      INTEGER ROOT,NO_COMM
      PARAMETER (ROOT=0,NO_COMM=-1)

      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NPROW,NPCOL,ME,MYCOL)

C     ...extract dependence list (ordered list of identifer process
C        which every process must communcate with..................
      CALL PSI_EXTRACT_DEP_LIST(DESC_DATA,
     +   STR_DATA,DEP_LIST,LENGHT_DL,NP,DL_LDA,0)
C    ...Now process root contains dependence list of all processes...

      IF (ME.EQ.ROOT) THEN
         IF (LWORK.LT.NP*(NP+1)+1) THEN
            IERR= 4090
            RETURN
         ENDIF
         IF (IBITS(CHECK_DESCR,ORDER_COMMUNICATION,1).EQ.0) THEN
C           in this case if we encounter deadlock exit 
            OPTIMIZE_LEV=1
         ELSE
C           in this case if we encounter deadlock reorder comm
            OPTIMIZE_LEV=0
         ENDIF

C        ....check if there is deadlock among processes....
         CALL PSI_DEADLOCK(DEP_LIST,LENGHT_DL,NP,DL_LDA,OPTIMIZE_LEV,
     +      RESULT,WORK,WORK(NP*NP+1))
         
C        ....if order_communication is active, reorder always. 
         IF (OPTIMIZE_LEV.EQ.0) RESULT=1

C        .....Send to all processes result of check.....
         CALL IGEBS2D(DESC_DATA(CTXT_),ALL,' ', 1, 1, RESULT, 1)

C        ....sort communication......
         IF (RESULT.EQ.1) THEN
            
C     ....I must order communication in in STR_DATA
            
C     ....first: cut duplicate element in every dependence list row....
            DO PROC=0,NP-1
               I=1
               DO WHILE (I.LE.LENGHT_DL(PROC))
                  IF (DEP_LIST(I,PROC).NE.NO_COMM) THEN
                     J=I+1
                     DO WHILE (J.LE.LENGHT_DL(PROC))
                        IF (DEP_LIST(I,PROC).EQ.DEP_LIST(J,PROC)) THEN
C                    ...cut duplicate element and shift dep_list(proc) from it..
                           DO K=J+1,LENGHT_DL(PROC)-1
                              DEP_LIST(J,PROC)=DEP_LIST(J+1,PROC)
                           ENDDO
C                    ...now dep_list(proc) is smaller....
                           LENGHT_DL(PROC)=LENGHT_DL(PROC)-1
                        ENDIF
                        J=J+1
                     ENDDO
                  ENDIF
                  I=I+1
               ENDDO
            ENDDO
C        ....Now I can sort dependence list......
            CALL SORT_DEP_LIST(DEP_LIST,LENGHT_DL,NP,DL_LDA,work,lwork)

            DO PROC=0,NP-1
               IF (PROC.NE.ME) THEN
C                 ...send lenght of list to send....
                  CALL IGESD2D(DESC_DATA(CTXT_),1,1,LENGHT_DL(PROC),
     +               NP,PROC,0)
C                 ....Send dep_list.....
                  CALL IGESD2D(DESC_DATA(CTXT_),LENGHT_DL(PROC),1,
     +               DEP_LIST(1,PROC),LENGHT_DL(PROC),PROC,0)
               ENDIF
            ENDDO
         ENDIF
      ELSE IF (ME.NE.ROOT) THEN
C        .....receive result about deadlock check....
         CALL IGEBR2D(DESC_DATA(CTXT_),ALL,' ', 1, 1, RESULT, 1, ROOT,0)
         IF (RESULT.EQ.1) THEN
C        ...receive lenght of list to receive...
            CALL IGERV2D(DESC_DATA(CTXT_),1,1,LENGHT_DL(0),
     +         NP,ROOT,0)
C        ....receive dep_list.....
            CALL IGERV2D(DESC_DATA(CTXT_),LENGHT_DL(0),1,
     +         DEP_LIST(1,0),LENGHT_DL(0),ROOT,0)
         ENDIF
         
      ENDIF
      IF (RESULT.EQ.1) THEN
C        ..reorder comunication for str_data.....
         CALL PSI_REORDER(DESC_DATA,STR_DATA,DEP_LIST(1,0),
     +      LENGHT_DL(0),STR_DATA_OUT,LENGHT_STO,IERR)
         
C        ...update CONVERT_DESCR: we have changed a communication 
C           structure.......
         CONVERT_DESCR=CONVERT_DESCR+SUM_TO_CONVERT_DESCR
      ELSE
C     ...copy unchanged STR_DATA in STR_DATA_OUT....
         I=1
         DO WHILE (STR_DATA(I).NE.-1) 
            STR_DATA_OUT(I)=STR_DATA(I)
            I=I+1
         ENDDO
         STR_DATA_OUT(I)=-1
      ENDIF
      END
      
      


