* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*

      SUBROUTINE PSI_LOC_VERIFY(CHECK_VERIFY,NP,
     +  DESC_DATA, DESC_HALO, DESC_OVRLAP, DESC_OVRLAP_ELEM,
     +  MAX_SEND, MAX_RECV, DL_LDA_HALO,DL_LDA_OVRLAP,
     +  COUNTER_SEND,COUNTER_RECV)
C    
C    INTERNAL ROUTINE
C    ================ 
C   
C    _____Called by PSVERIFY ______
C
C    PURPOSE
C    =======
C
C    Check local correctness of  DESC_HALO, DESC_OVRLAP and DESC_OVRLAP_ELEM
C    list.
C
C  DESC_DATA (global and local input) INTEGER array. Is the MATRIX_DATA
C           array.
C           See "psverify.f" for its description.
C
C  DESC_HALO (local input) INTEGER array.
C           See "psverify.f" for its description.
C
C  DESC_OVRLAP (local input) INTEGER array. 
C           See "psverify.f" for its description.
C
C  DESC_OVRLAP_ELEM (local input) INTEGER array. 
C           See "psverify.f" for its description.
C

      IMPLICIT NONE
      INCLUDE 'psblas.fh'
C     ....Scalars parameters....
      INTEGER CHECK_VERIFY, MAX_SEND, MAX_RECV,DL_LDA_HALO,
     +  DL_LDA_OVRLAP,NP
C     .....Array Parameters....
      INTEGER DESC_DATA(*), DESC_HALO(*), DESC_OVRLAP(*), 
     +  DESC_OVRLAP_ELEM(*),COUNTER_SEND(0:NP-1),COUNTER_RECV(0:NP-1)
      

C     ....Local Scalars....      
      INTEGER I,J,K,COUNTER,NPCOL,NPROW,INFO,MYCOL,MYROW,PROC,ERR,
     +  ICTXT

      INTEGER IONE
      PARAMETER (IONE=1)

C     ....Local array...
      INTEGER EXCH(2), INT_ERR(5)
      DOUBLE PRECISION REAL_ERR(5)

C     ..Initialize counters...
      DO I=0,NP-1
        COUNTER_SEND(I)=0
        COUNTER_RECV(I)=0
      ENDDO


      INFO = 0

      ICTXT = DESC_DATA(CTXT_)

      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NPROW,NPCOL,MYROW,MYCOL)

      DL_LDA_HALO=0
C     ....Verify Local correctness of DESC_HALO....
      I=1
      DO WHILE (DESC_HALO(I).NE.-1)
        PROC=DESC_HALO(I)
        IF ((PROC.GT.NP-1).OR.(PROC.LT.0)) THEN
          INFO = 110
          INT_ERR(1) = 11
          INT_ERR(2) = PROC
          GOTO 997
        ENDIF
        DL_LDA_HALO=DL_LDA_HALO+1
C        ..Update No of elements to receive from proc PROC..         
        COUNTER_RECV(PROC)=COUNTER_RECV(PROC)+
     +    DESC_HALO(I+1)

        I=I+1
        IF ((IBITS(CHECK_VERIFY,GLOBAL_CHECK,1).EQ.0).AND.
     +    (IBITS(CHECK_VERIFY,LOCAL_COMM_CHECK,1).EQ.1)) THEN
          DO J=1,DESC_HALO(I)
            IF ((DESC_HALO(I+J).GT.DESC_DATA(N_COL_)).OR.
     +        (DESC_HALO(I+J).LE.DESC_DATA(N_ROW_))) THEN
C        ...else this correctness will be verified in PSI_Glob_halo.f.......
              INFO = 120
              INT_ERR(1) = 11
              INT_ERR(2) = DESC_DATA(N_ROW_)
              INT_ERR(3) = DESC_DATA(N_COL_)+1
              INT_ERR(4) = DESC_HALO(I+J)
              GOTO 997
            ENDIF
          ENDDO
        ENDIF

        IF (INFO.NE.0) GOTO 997
        
        I=I+DESC_HALO(I)+1
        
C        ..Update No of elements to send to proc PROC..         
        COUNTER_SEND(PROC)=COUNTER_SEND(PROC)+
     +    DESC_HALO(I)

        IF ((IBITS(CHECK_VERIFY,GLOBAL_CHECK,1).EQ.0).AND. 
     +    (IBITS(CHECK_VERIFY,LOCAL_COMM_CHECK,1).EQ.1)) THEN
C        ...else this correctness will be verified in PSI_Glob_halo.f.......
          DO J=1,DESC_HALO(I)
            IF ((DESC_HALO(I+J).GT.DESC_DATA(N_ROW_)).OR.
     +        (DESC_HALO(I+J).LT.1)) THEN
              INFO = 130
              INT_ERR(1) = 11
              INT_ERR(2) = 0
              INT_ERR(3) = DESC_DATA(N_ROW_)+1
              INT_ERR(4) = DESC_HALO(I+J)
              GOTO 997
            ENDIF
          ENDDO
        ENDIF
        
        IF (INFO.NE.0) GOTO 997

        I=I+DESC_HALO(I)+1
      ENDDO
 997  CONTINUE 
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +  I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999

      MAX_SEND=0
      MAX_RECV=0
      DO I=0,NP-1
        IF (COUNTER_RECV(I).GT.MAX_RECV) MAX_RECV=COUNTER_RECV(I)
        COUNTER_RECV(I)=0
        IF (COUNTER_SEND(I).GT.MAX_SEND) MAX_SEND=COUNTER_SEND(I)
        COUNTER_SEND(I)=0
      ENDDO

C     
      DL_LDA_OVRLAP=0
C     .....Verify Local Correctness of DESC_OVRLAP....
      I=1
      DO WHILE (DESC_OVRLAP(I).NE.-1)
        PROC=DESC_OVRLAP(I)
        IF ((PROC.GT.NP-1).OR.(PROC.LT.0)) THEN
          INFO = 110
          INT_ERR(1) = 12
          INT_ERR(2) = PROC
          GOTO 998
        ENDIF
        IF (DESC_OVRLAP(I+1).NE.DESC_OVRLAP(I+DESC_OVRLAP(I+1)+2))
     +    THEN
          INFO = 140
          INT_ERR(1) = 12
          INT_ERR(2) = DESC_OVRLAP(I+1)
          INT_ERR(3) = DESC_OVRLAP(I+DESC_OVRLAP(I+1)+2)
          GOTO 998
        ENDIF

        DL_LDA_OVRLAP=DL_LDA_OVRLAP+1

C        ..Update No of elements to receive from proc PROC..         
        COUNTER_RECV(PROC)=COUNTER_RECV(PROC)+
     +    DESC_OVRLAP(I+1)

        I=I+1
        IF ((IBITS(CHECK_VERIFY,GLOBAL_CHECK,1).EQ.0).AND.
     +    (IBITS(CHECK_VERIFY,LOCAL_COMM_CHECK,1).EQ.1)) THEN
C        ...This correctness will be verified in PSI_Glob_ovr.f.......
          DO J=1,DESC_OVRLAP(I)
            IF ((DESC_OVRLAP(I+J).GT.DESC_DATA(N_ROW_)).OR.
     +        (DESC_OVRLAP(I+J).LT.1)) THEN
              INFO = 130
              INT_ERR(1) = 12
              INT_ERR(2) = 0
              INT_ERR(3) = DESC_DATA(N_ROW_)+1
              INT_ERR(4) = DESC_OVRLAP(I+J)
              GOTO 998
            ENDIF
          ENDDO
        ENDIF

        IF (INFO.NE.0) GOTO 998

        I=I+DESC_OVRLAP(I)+1

C        ..Update No of elements to receive from proc PROC..         
        COUNTER_SEND(PROC)=COUNTER_SEND(PROC)+
     +    DESC_OVRLAP(I)

        IF ((IBITS(CHECK_VERIFY,GLOBAL_CHECK,1).EQ.0).AND.
     +    (IBITS(CHECK_VERIFY,LOCAL_COMM_CHECK,1).EQ.1)) THEN
C        ...This correctness will be verified in PSI_Glob_ovr.f.......
          DO J=1,DESC_OVRLAP(I)
            IF ((DESC_OVRLAP(I+J).GT.DESC_DATA(N_ROW_)).OR.
     +        (DESC_OVRLAP(I+J).LT.1)) THEN
              INFO = 130
              INT_ERR(1) = 12
              INT_ERR(2) = 0
              INT_ERR(3) = DESC_DATA(N_ROW_)+1
              INT_ERR(4) = DESC_OVRLAP(I+J)
              GOTO 998
            ENDIF
          ENDDO
        ENDIF

        IF (INFO.NE.0) GOTO 998
        
        I=I+DESC_OVRLAP(I)+1
      ENDDO
 998  CONTINUE
 
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +  I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      
      DO I=0,NP-1
        IF (COUNTER_RECV(I).GT.MAX_RECV) MAX_RECV=COUNTER_RECV(I)
        COUNTER_RECV(I)=0
        IF (COUNTER_SEND(I).GT.MAX_SEND) MAX_SEND=COUNTER_SEND(I)
        COUNTER_SEND(I)=0
      ENDDO
      
C     computing max global value of DL_LDA_HALO and DL_LDA_OVRLAP...
      EXCH(1)=DL_LDA_HALO
      EXCH(2)=DL_LDA_OVRLAP

      CALL IGAMX2D(DESC_DATA(CTXT_), ALL, TOPDEF, 2, IONE, EXCH, 
     +  IONE, COUNTER, COUNTER, -IONE ,-IONE,-IONE)

      DL_LDA_HALO=EXCH(1)*EXCH(1)
      DL_LDA_OVRLAP=EXCH(2)*EXCH(2)

C     ....Verify local correctness of DESC_OVRLAP_ELEM....
C     ....For each overlap element described in DESC_OVRLAP_ELEM with his 
C     ....molteplicity "N", it must be replicated "N" times in 
C     .....DESC_OVRLAP array................................................
      I=1
      IF (IBITS(CHECK_VERIFY,LOCAL_COMM_CHECK,1).EQ.1) THEN
        DO WHILE (DESC_OVRLAP_ELEM(I).NE.-1)
          J=1
          COUNTER=1
          DO WHILE (DESC_OVRLAP(J).NE.-1) 
            DO K=1,DESC_OVRLAP(J+1)
              IF (DESC_OVRLAP(J+1+K).EQ.DESC_OVRLAP_ELEM(I)) 
     +          COUNTER=COUNTER+1
            ENDDO
            J=J+2*(DESC_OVRLAP(J+1)+1)+1
          ENDDO
          IF (COUNTER.NE.DESC_OVRLAP_ELEM(I+1)) THEN
            INFO = 150
            INT_ERR(1) = 12
            INT_ERR(2) = 13
            INT_ERR(3) = COUNTER
            INT_ERR(4) = DESC_OVRLAP_ELEM(I+1)
            GOTO 999
          ENDIF
          I=I+2
        ENDDO
      ENDIF
 999  CONTINUE 
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +  I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      
      RETURN
      
 9999 CALL PSDERROR( ICTXT, INFO, 'PSDVERIFY\0', INT_ERR, REAL_ERR )
      
      END
         

