* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*
      SUBROUTINE PSI_GLOB_OVR_VERIFY(CHECK_DESCR,
     +   DESC_DATA,DESC_OVR,LOC_TO_GLOB,
     +   WORK,LWORK,WORK2,LWORK2)
C    
C   Purpose
C   =======
C
C   Check the correctness of the data structures describing data distribution.
C
C
C  Notes
C  =====
C
C  Some description vectors are associated with each distributed sparse
C  matrix. These vectors stores the information required to the
C  communication needed to perform distributed operations.
C
C  They are:
C
C  NAME		 EXPLANATION
C  ------------------ -------------------------------------------------------
C  DESC_DATA	 Array of INTEGER that contains some local and global
C		 information of matrix.
C
C
C  Now we explain each of the above vectors.
C
C  Let A be a generic sparse matrix. We denote with MATDATA_A the DESC_DATA
C  array for matrix A.
C  Data stored in MATRIX_DATA array are:
C
C  NOTATION        STORED IN		     EXPLANATION
C  --------------- ---------------------- -------------------------------------
C  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
C  M 	           MATDATA_A[M_]          Total number of equations
C  N 	           MATDATA_A[N_]          Total number of variables
C  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
C  N_COL           MATDATA_A[N_COL_]      Number of local variables
C  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
C		   	                     the global context of the operation
C					     on the matrix.
C					     The context itself is global.
C
C
C  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local overlap elements to exchange with
C  other process.
C  Let P be the pointer to the first element of a block in DESCOVRLP_P.
C  This block is stored in DESCOVRLP_P as :
C
C  NOTATION        STORED IN		            EXPLANATION
C  ------------- ------------------------------- -----------------------------------
C  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
C						    data with.
C  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
C  OVRLAP_ELEM   DESCOVRLP_P[P+OVRLP_ELEM_TO_+i] Indexes of local elements to
C					            exchange. These are stored in the
C					            array from location P+OVRLP_ELEM_ to
C					            location P+OVRLP_ELEM_+
C						    DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
C
C
C
C
C   Input Data
C   ==========
C
C    CHECK_DESCR (global input) INTEGER scalar. Indicate what type of check
C                must be perfomed: See "psverify.f" for ist values.
C    
C    DESC_DATA (global local input) Array of integer. Is the MATDATA_A array.
C
C
C    DESC_OVRLAP (local input) INTEGER array. Is the DESCOVRLP_P array.
C
C    LOC_TO_GLOB (local input) INTEGER array. Element "i" contains global index
C                of local element with index "i", (associated to i-th column
C                of local matrix). 
C                Used only if is perfomed global check ( see CHECK_DESCR 
C                parameter). 
C
C               
C     WORK1     (local input) INTEGER array. Work area to memorize intermediate 
C	         results. 
C
C     LWORK1    (local input) INTEGER. Dimension of Work area, work1.
C            
C               
C     WORK2     (local input) INTEGER array. Work area to memorize intermediate 
C	         results. 
C
C     LWORK2    (local input) INTEGER. Dimension of Work area, Work2.
C            
C    
C     Note
C    ======
C    
C     if list of communications are not sorted correctly
C     this routine may go in !!!deadlock!!! while processes communicating.


      IMPLICIT NONE
      INCLUDE 'psblas.fh'

C     ....Array Parameters....
      INTEGER DESC_DATA(*), DESC_OVR(*), 
     +   LOC_TO_GLOB(*),WORK(*), WORK2(*)

C     ....Scalar parameters.....
      INTEGER LWORK,LWORK2,CHECK_DESCR

      EXTERNAL BIN
      INTEGER BIN

C     ...Local scalars....
      INTEGER NPROW,NPCOL,ME,MYCOL,COUNTER_R,PROC,N,I,J,INFO,LOC_IND,
     +   N_EL_SEND,K,N_EL_RECV,POINTER,GLB_CHECK, ERR,ICTXT,LTG_CHECK

C     ...Local Array...
      INTEGER INT_ERR(7)
      DOUBLE PRECISION REAL_ERR(5)

      INTEGER IONE
      PARAMETER (IONE=1)

      GLB_CHECK=IBITS(CHECK_DESCR,GLOBAL_CHECK,IONE)
      LTG_CHECK=IBITS(CHECK_DESCR,LOC_TO_GLOB_CHECK,1)
      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NPROW,NPCOL,ME,MYCOL)
      COUNTER_R=1
C     ...For all processes......
      DO WHILE(DESC_OVR(COUNTER_R).NE.-1)
         PROC=DESC_OVR(COUNTER_R)
         N_EL_RECV=DESC_OVR(COUNTER_R+1)

         IF ((N_EL_RECV.GT.LWORK).AND.(GLB_CHECK.EQ.1)) THEN
            INFO = 4020
            GOTO 998
         ENDIF

         POINTER=COUNTER_R+1
         IF (LTG_CHECK.EQ.0) THEN
C        ...check on LOC_TO_GLOB elements already performed...
            DO K=1,N_EL_RECV
C           ....Check consistency of ovrlap element indices to recv.....
               IF ((DESC_OVR(K+POINTER).GT.DESC_DATA(N_ROW_)).OR.
     +            (DESC_OVR(K+POINTER).LT.1)) THEN
                  INFO = 130
                  INT_ERR(1) = 12
                  INT_ERR(2) = 0
                  INT_ERR(3) = DESC_DATA(N_ROW_)+1
                  INT_ERR(4) = DESC_OVR(K+POINTER)
                  GOTO 998
               ENDIF
               IF (GLB_CHECK.EQ.1) THEN
C              ...store global index of element to recv from PROC....
                  WORK(K)=LOC_TO_GLOB(DESC_OVR(K+POINTER))
                  IF ((WORK(K).LT.1).OR.(WORK(K).GT.DESC_DATA(M_))) THEN
                     INFO = 240
                     INT_ERR(1) = LOC_TO_GLOB_+DESC_OVR(K+POINTER)
                     INT_ERR(2) = 10
                     INT_ERR(3) = M_
                     INT_ERR(4) = 10
                     INT_ERR(5) = 1
                     INT_ERR(6) = WORK(K)
                     INT_ERR(7) = DESC_DATA(M_)
                     GOTO 998
                  ENDIF
               ENDIF
            ENDDO
         ELSE
C        ...check on LOC_TO_GLOB not performed...
            DO K=1,N_EL_RECV
C           ....Check consistency of ovrlap element indices to recv.....
               IF ((DESC_OVR(K+POINTER).GT.DESC_DATA(N_ROW_)).OR.
     +            (DESC_OVR(K+POINTER).LT.1)) THEN
                  INFO = 130
                  INT_ERR(1) = 12
                  INT_ERR(2) = 0
                  INT_ERR(3) = DESC_DATA(N_ROW_)+1
                  INT_ERR(4) = DESC_OVR(K+POINTER)
                  GOTO 998
               ENDIF
               IF (GLB_CHECK.EQ.1)
C              ...store global index of element to recv from PROC....
     +            WORK(K)=LOC_TO_GLOB(DESC_OVR(K+POINTER))
            ENDDO
         ENDIF

         IF (INFO.NE.0) GOTO 998

         COUNTER_R=COUNTER_R+N_EL_RECV+2
         N_EL_SEND=DESC_OVR(COUNTER_R)
         IF (ME.GT.PROC) THEN

C        ...Receive No of element to receive....
            CALL IGERV2D(DESC_DATA(CTXT_),1,1,N,1,PROC,0)
            IF (N.NE.N_EL_SEND) THEN
               INFO = 190
               INT_ERR(1) = ME
               INT_ERR(2) = PROC
               INT_ERR(3) = N
               INT_ERR(4) = N_EL_SEND
               GOTO 998
            ENDIF

            IF ((N.GT.LWORK2).AND.(GLB_CHECK.EQ.1)) THEN
               INFO = 4020
               GOTO 998
            ENDIF
            IF (GLB_CHECK.EQ.1)
C          ...Receive global indices of "OVR" element to send..
     +         CALL IGERV2D(DESC_DATA(CTXT_),N,1,WORK2,N,PROC,0)

C         ...Send to PROC No of "OVR" element to send....
            CALL IGESD2D(DESC_DATA(CTXT_),1,1,N_EL_RECV,1,PROC,0)

            IF (GLB_CHECK.EQ.1)
C          ...Send to PROC global indices of "OVR" element to send..
     +         CALL IGESD2D(DESC_DATA(CTXT_),N_EL_RECV,1,WORK,
     +         N_EL_RECV,PROC,0)
         ELSE IF (ME.LT.PROC) THEN

C         ...Send to PROC No of "OVR" element to send....
            CALL IGESD2D(DESC_DATA(CTXT_),1,1,N_EL_RECV,1,PROC,0)

            IF (GLB_CHECK.EQ.1)
C          ...Send to PROC global indices of "OVR" element to send..
     +         CALL IGESD2D(DESC_DATA(CTXT_),N_EL_RECV,1,WORK,
     +         N_EL_RECV,PROC,0)

C        ...Receive No of element to receive....
            CALL IGERV2D(DESC_DATA(CTXT_),1,1,N,1,PROC,0)

            IF (N.NE.N_EL_SEND) THEN
               INFO = 190
               INT_ERR(1) = ME
               INT_ERR(2) = PROC
               INT_ERR(3) = N
               INT_ERR(4) = N_EL_SEND
               GOTO 998
            ENDIF

            IF ((N.GT.LWORK2).AND.(GLB_CHECK.EQ.1)) THEN
               INFO = 4020
               GOTO 998
            ENDIF

            IF (GLB_CHECK.EQ.1)
C          ...Receive global indices of "OVR" element to send..
     +         CALL IGERV2D(DESC_DATA(CTXT_),N,1,WORK2,N,PROC,0)

         ELSE IF (ME.EQ.PROC) THEN
            N=DESC_OVR(COUNTER_R)
            IF (N.NE.N_EL_SEND) THEN
               INFO = 190
               INT_ERR(1) = PROC
               INT_ERR(2) = ME
               INT_ERR(3) = N_EL_SEND
               INT_ERR(4) = N
               GOTO 998
            ENDIF
            IF ((N_EL_SEND.GT.LWORK2).AND.(GLB_CHECK.EQ.1)) THEN
               INFO = 4020
               GOTO 998
            ENDIF
            IF (LTG_CHECK.EQ.0) THEN
C        ...check on LOC_TO_GLOB not performed...
               DO J=1,N_EL_SEND
                  IF ((DESC_OVR(COUNTER_R+J).GT.DESC_DATA(N_ROW_)).OR.
     +               (DESC_OVR(COUNTER_R+J).LT.1)) THEN
                     INFO = 130
                     INT_ERR(1) = 12
                     INT_ERR(2) = 0
                     INT_ERR(3) = DESC_DATA(N_ROW_)+1
                     INT_ERR(4) = DESC_OVR(COUNTER_R+J)
                     GOTO 998
                  ENDIF
                  IF (GLB_CHECK.EQ.1) THEN
C           ....Copy OVR indices to recv in WORK2.....
                     WORK2(J)=LOC_TO_GLOB(DESC_OVR(COUNTER_R+J))
                     IF ((WORK(K).LT.1).OR.(WORK(K).GT.DESC_DATA(M_)))
     +                  THEN
                        INFO = 240
                        INT_ERR(1) = LOC_TO_GLOB_+DESC_OVR(COUNTER_R+J)
                        INT_ERR(2) = 10
                        INT_ERR(3) = M_
                        INT_ERR(4) = 10
                        INT_ERR(5) = 1
                        INT_ERR(6) = WORK(K)
                        INT_ERR(7) = DESC_DATA(M_)
                        GOTO 998
                     ENDIF
                  ENDIF
               ENDDO
            ELSE
C        ...check on LOC_TO_GLOB elements already performed...
               DO J=1,N_EL_SEND
                  IF ((DESC_OVR(COUNTER_R+J).GT.DESC_DATA(N_ROW_)).OR.
     +               (DESC_OVR(COUNTER_R+J).LT.1)) THEN
                     INFO = 130
                     INT_ERR(1) = 12
                     INT_ERR(2) = 0
                     INT_ERR(3) = DESC_DATA(N_ROW_)+1
                     INT_ERR(4) = DESC_OVR(COUNTER_R+J)
                     GOTO 998
                  ENDIF
                  IF (GLB_CHECK.EQ.1)
C           ....Copy OVR indices to recv in WORK2.....
     +               WORK2(J)=LOC_TO_GLOB(DESC_OVR(COUNTER_R+J))
               ENDDO
            ENDIF
         ENDIF

         IF (INFO.NE.0) GOTO 998
         IF (LTG_CHECK.EQ.1) THEN
C        ...check on LOC_TO_GLOB already performed...
            DO J=1,N_EL_SEND
C        ...Check consistency of ovrlap indices to send........
               IF ((DESC_OVR(COUNTER_R+J).GT.DESC_DATA(N_ROW_)).OR.
     +            (DESC_OVR(COUNTER_R+J).LT.1)) THEN
                  INFO = 130
                  INT_ERR(1) = 12
                  INT_ERR(2) = 0
                  INT_ERR(3) = DESC_DATA(N_ROW_)+1
                  INT_ERR(4) = DESC_OVR(COUNTER_R+J)
                  GOTO 998
               ENDIF
               IF (GLB_CHECK.EQ.1) THEN
C              ...do global check.....
                  IF (LOC_TO_GLOB(DESC_OVR(COUNTER_R+J)).NE.WORK2(J)) 
     +               THEN
C              ....Error elements not match.......
                     INFO = 180
                     INT_ERR(1) = 12
                     INT_ERR(2) = ME
                     INT_ERR(3) = J
                     INT_ERR(4) = PROC
                     INT_ERR(5) = LOC_TO_GLOB(DESC_OVR(COUNTER_R+J))
                     INT_ERR(6) = WORK2(J)
                     GOTO 998
                  ENDIF
               ENDIF
            ENDDO
         ELSE
C        ...check on LOC_TO_GLOB not performed...
            DO J=1,N_EL_SEND
C        ...Check consistency of ovrlap indices to send........
               IF ((DESC_OVR(COUNTER_R+J).GT.DESC_DATA(N_ROW_)).OR.
     +            (DESC_OVR(COUNTER_R+J).LT.1)) THEN
                  INFO = 130
                  INT_ERR(1) = 12
                  INT_ERR(2) = 0
                  INT_ERR(3) = DESC_DATA(N_ROW_)+1
                  INT_ERR(4) = DESC_OVR(COUNTER_R+J)
                  GOTO 998
               ENDIF
               
               IF (GLB_CHECK.EQ.1) THEN
                  LOC_IND=LOC_TO_GLOB(DESC_OVR(COUNTER_R+J))
                  IF ((LOC_IND.GT.DESC_DATA(M_)).OR.(LOC_IND.LT.1)) THEN
                     INFO = 240
                     INT_ERR(1) = LOC_TO_GLOB_+DESC_OVR(COUNTER_R+J)
                     INT_ERR(2) = 10
                     INT_ERR(3) = M_
                     INT_ERR(4) = 10
                     INT_ERR(5) = 1
                     INT_ERR(6) = LOC_IND
                     INT_ERR(7) = DESC_DATA(M_)
                     GOTO 998
                  ENDIF
C              ...do global check.....
                  IF (LOC_TO_GLOB(DESC_OVR(COUNTER_R+J)).NE.WORK2(J)) 
     +               THEN
C              ....Error elements not match.......
                     INFO = 180
                     INT_ERR(1) = 12
                     INT_ERR(2) = ME
                     INT_ERR(3) = J
                     INT_ERR(4) = PROC
                     INT_ERR(5) = LOC_TO_GLOB(DESC_OVR(COUNTER_R+J))
                     INT_ERR(6) = WORK2(J)
                     GOTO 998
                  ENDIF
               ENDIF
            ENDDO
         ENDIF

         IF (INFO.NE.0) GOTO 998

         COUNTER_R=COUNTER_R+N_EL_SEND+1
      ENDDO

 998  continue 

      ICTXT = DESC_DATA(CTXT_)
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999

      RETURN

 9999 CALL PSDERROR( ICTXT, INFO, 'PSDVERIFY\0', INT_ERR, REAL_ERR )
      END
      

