      SUBROUTINE PSI_GLOB_HALO_VERIFY(CHECK_VERIFY,
     +  DESC_DATA,DESC_HALO,LOC_TO_GLOB,
     +  WORK,LWORK,WORK2,LWORK2)
C    
C  Purpose
C  =======
C
C  Check the correctness of the data structures describing data distribution.
C
C
C  Notes
C  =====
C
C  Some description vectors are associated with each distributed sparse
C  matrix. These vectors stores the information required to the
C  communication needed to perform distributed operations.
C
C  They are:
C
C  NAME		 EXPLANATION
C  ------------------ -------------------------------------------------------
C  DESC_DATA	 Array of INTEGER that contains some local and global
C		 information of matrix.
C
C
C  Now we explain each of the above vectors.
C
C  Let A be a generic sparse matrix. We denote with MATDATA_A the DESC_DATA
C  array for matrix A.
C  Data stored in MATRIX_DATA array are:
C
C  NOTATION        STORED IN		     EXPLANATION
C  --------------- ---------------------- -------------------------------------
C  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
C  M 	           MATDATA_A[M_]          Total number of equations
C  N 	           MATDATA_A[N_]          Total number of variables
C  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
C  N_COL           MATDATA_A[N_COL_]      Number of local variables
C  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
C		   	                     the global context of the operation
C					     on the matrix.
C					     The context itself is global.
C
C
C  
C  Let DESCHALO_P be the array DESC_HALO for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local halo elements to exchange with other 
C  process.
C  Let P be the pointer to the first element of a block in DESCHALO_P.
C  This block is stored in DESCHALO_P as :
C
C  NOTATION        STORED IN		          EXPLANATION
C  --------------- --------------------------- -----------------------------------
C  PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
C						  data with.
C  N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
C  ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
C					          receive. These are stored in the
C					          array from location P+ELEM_RECV_ to
C					          location P+ELEM_RECV_+
C						  DESCHALO_P[P+N_ELEM_RECV_]-1.
C  N_ELEMENTS_SEND DESCHALO_P[P+N_ELEM_SEND_]  Number of elements to send.
C  ELEMENTS_SEND   DESCHALO_P[P+ELEM_SEND_+i]  Indexes of local elements to
C					          send. These are stored in the
C					          array from location P+ELEM_SEND_ to
C					          location P+ELEM_SEND_+
C						  DESCHALO_P[P+N_ELEM_SEND_]-1.
C
C
C
C   Input Data
C   ==========
C
C    CHECK_DESCR (global input) INTEGER scalar. Indicate what type of check
C                must be perfomed: See "psverify.f" for ist values.
C    
C    DESC_DATA (global local input) Array of integer. Is the MATDATA_A array.
C
C
C    DESC_HALO (local input) INTEGER array. Is the DESCHALO_P array.
C
C    LOC_TO_GLOB (local input) INTEGER array. Element "i" contains global index
C                of local element with index "i", (associated to i-th column
C                of local matrix). 
C                Used only if is perfomed global check ( see CHECK_DESCR 
C                parameter). 
C
C               
C     WORK1     (local input) INTEGER array. Work area to memorize intermediate 
C	         results. 
C
C     LWORK1    (local input) INTEGER. Dimension of Work area, work1.
C            
C               
C     WORK2     (local input) INTEGER array. Work area to memorize intermediate 
C	         results. 
C
C     LWORK2    (local input) INTEGER. Dimension of Work area, Work2.
C            
C    
C     Note
C    ======
C    
C     if list of communications are not sorted correctly
C     this routine may go in !!!deadlock!!! while processes communicating.
C
C
C     .....Array Parameters....
      IMPLICIT NONE
      INCLUDE 'psblas.fh'
      INTEGER DESC_DATA(*), DESC_HALO(*),
     +  LOC_TO_GLOB(*),WORK(*), WORK2(*)

      INTEGER LWORK,LWORK2,CHECK_VERIFY

C     ...Local scalars....
      INTEGER NPROW,NPCOL,ME,MYCOL,COUNTER_R,PROC,N,I,J,INFO,LOC_IND,
     +  N_EL_SEND,K,N_EL_RECV,POINTER,GLB_CHECK, ERR,ICTXT,LTG_CHECK

C     ...Local Array...
      INTEGER INT_ERR(7)
      DOUBLE PRECISION REAL_ERR(5)

      INTEGER IONE
      PARAMETER (IONE=1)
      
      INFO = 0

      GLB_CHECK=IBITS(CHECK_VERIFY,GLOBAL_CHECK,IONE)
      LTG_CHECK=IBITS(CHECK_VERIFY,LOC_TO_GLOB_CHECK,IONE)
      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NPROW,NPCOL,ME,MYCOL)
      COUNTER_R=1
C     ...For all processes......
      DO WHILE(DESC_HALO(COUNTER_R).NE.-1)
        PROC=DESC_HALO(COUNTER_R)
        N_EL_RECV=DESC_HALO(COUNTER_R+1)
        POINTER=COUNTER_R+1
        IF ((N_EL_RECV.GT.LWORK).AND.(GLB_CHECK.EQ.1)) THEN
          INFO = 4010
          GOTO 998
        ENDIF
        IF (LTG_CHECK.EQ.0) THEN
C        ...check on loc to glob array not performed....
          DO K=1,N_EL_RECV
C        ...store global index of element to recv from PROC....
            
C        .. and check indices to recv of DESC_HALO array correctness...
            IF ((DESC_HALO(k+POINTER).GT.DESC_DATA(N_COL_)).OR.
     +        (DESC_HALO(K+POINTER).LE.DESC_DATA(N_ROW_))) THEN
              INFO = 120
              INT_ERR(1) = 11
              INT_ERR(2) = DESC_DATA(N_ROW_)
              INT_ERR(3) = DESC_DATA(N_COL_)+1
              INT_ERR(4) = DESC_HALO(K+POINTER)
              GOTO 998
            ENDIF
            IF (GLB_CHECK.EQ.1) THEN
              WORK(K)=LOC_TO_GLOB(DESC_HALO(K+POINTER))
              IF ((WORK(K).LT.1).OR.(WORK(K).GT.DESC_DATA(M_))) 
     +          THEN
                INFO = 240
                INT_ERR(1) = LOC_TO_GLOB_+DESC_HALO(K+POINTER)
                INT_ERR(2) = 10
                INT_ERR(3) = M_
                INT_ERR(4) = 10
                INT_ERR(5) = 1
                INT_ERR(6) = WORK(K)
                INT_ERR(7) = DESC_DATA(M_)
                GOTO 998
              ENDIF
            ENDIF
          ENDDO
        ELSE
C        ....check on loc to glob array already performed...
          DO K=1,N_EL_RECV
C        ...store global index of element to recv from PROC....
            
C        .. and check indices to recv of DESC_HALO array correctness...
            IF ((DESC_HALO(k+POINTER).GT.DESC_DATA(N_COL_)).OR.
     +        (DESC_HALO(K+POINTER).LE.DESC_DATA(N_ROW_))) THEN
              INFO = 120
              INT_ERR(1) = 11
              INT_ERR(2) = DESC_DATA(N_ROW_)
              INT_ERR(3) = DESC_DATA(N_COL_)+1
              INT_ERR(4) = DESC_HALO(K+POINTER)
              GOTO 998
            ENDIF
            IF (GLB_CHECK.EQ.1)
     +        WORK(K)=LOC_TO_GLOB(DESC_HALO(K+POINTER))
          ENDDO
        ENDIF

        IF (INFO.NE.0) GOTO 998

        COUNTER_R=COUNTER_R+N_EL_RECV+2
        N_EL_SEND=DESC_HALO(COUNTER_R)
        IF (ME.GT.PROC) THEN
C        ...Receive No of element to receive....
          CALL IGERV2D(DESC_DATA(CTXT_),1,1,N,1,PROC,0)
          IF (N.NE.N_EL_SEND) THEN
            INFO = 170
            INT_ERR(1) = ME
            INT_ERR(2) = PROC
            INT_ERR(3) = N
            INT_ERR(4) = N_EL_SEND
            GOTO 998
          ENDIF

          IF ((N_EL_SEND.GT.LWORK2).AND.(GLB_CHECK.EQ.1)) THEN
            INFO = 4010
            GOTO 998
          ENDIF

          IF (GLB_CHECK.EQ.1)
C          ...Receive global indices of "halo" element to receive..
     +      CALL IGERV2D(DESC_DATA(CTXT_),N,1,WORK2,N,PROC,0)
          
C         ...Send to PROC No of "halo" element to receive....
          CALL IGESD2D(DESC_DATA(CTXT_),1,1,N_EL_RECV,1,PROC,0)

          IF (GLB_CHECK.EQ.1)
C          ...Send to PROC global indices of "halo" element to send..
     +      CALL IGESD2D(DESC_DATA(CTXT_),N_EL_RECV,1,WORK,
     +      N_EL_RECV,PROC,0)
        ELSE IF (ME.LT.PROC) THEN

C         ...Send to PROC No of "halo" element to send....
          CALL IGESD2D(DESC_DATA(CTXT_),1,1,N_EL_RECV,1,PROC,0)

          IF (GLB_CHECK.EQ.1)
C          ...Send to PROC global indices of "halo" element to send..
     +      CALL IGESD2D(DESC_DATA(CTXT_),N_EL_RECV,1,WORK,
     +      N_EL_RECV,PROC,0)

C        ...Receive No of element to receive....
          CALL IGERV2D(DESC_DATA(CTXT_),1,1,N,1,PROC,0)
          IF (N.NE.N_EL_SEND) THEN
            INFO = 170
            INT_ERR(1) = ME
            INT_ERR(2) = PROC
            INT_ERR(3) = N
            INT_ERR(4) = N_EL_SEND
            GOTO 998
          ENDIF

          IF ((N_EL_SEND.GT.LWORK2).AND.(GLB_CHECK.EQ.1)) THEN
            INFO = 4010
            GOTO 998
          ENDIF

          IF (GLB_CHECK.EQ.1)
C          ...Receive global indices of "halo" element to receive..
     +      CALL IGERV2D(DESC_DATA(CTXT_),N,1,WORK2,N,PROC,0)
        ELSE IF (ME.EQ.PROC) THEN
          N=DESC_HALO(COUNTER_R)
          IF (N.NE.N_EL_SEND) THEN
            INFO = 170
            INT_ERR(1) = PROC
            INT_ERR(2) = ME
            INT_ERR(3) = N_EL_SEND
            INT_ERR(4) = N
            GOTO 998
          ENDIF
          IF ((N_EL_SEND.GT.LWORK2).AND.(GLB_CHECK.EQ.1)) THEN
            INFO = 4010
            GOTO 998
          ENDIF
C           ....Copy HALO indices to send in WORK2.....
          IF (LTG_CHECK.EQ.0) THEN
C           ....check on loc to glob array not performed.....
            DO J=1,N_EL_SEND
C        .. and check indices to send of DESC_HALO array correctness...
              IF ((DESC_HALO(COUNTER_R+J).GT.DESC_DATA(N_ROW_)).OR.
     +          (DESC_HALO(COUNTER_R+J).LT.1)) THEN
                INFO = 130
                INT_ERR(1) = 11
                INT_ERR(2) = 0
                INT_ERR(3) = DESC_DATA(N_ROW_)+1
                INT_ERR(4) = DESC_HALO(COUNTER_R+J)
                GOTO 998
              ENDIF
              IF (GLB_CHECK.EQ.1) THEN
                WORK2(J)=LOC_TO_GLOB(DESC_HALO(COUNTER_R+J))
                IF ((WORK2(J).LT.1).OR.(WORK2(J).GT.DESC_DATA(M_))) 
     +            THEN
                  INFO = 240
                  INT_ERR(1) = LOC_TO_GLOB_+DESC_HALO(COUNTER_R+J)
                  INT_ERR(2) = 10
                  INT_ERR(3) = M_
                  INT_ERR(4) = 10
                  INT_ERR(5) = 1
                  INT_ERR(6) = WORK2(J)
                  INT_ERR(7) = DESC_DATA(M_)
                  GOTO 998
                ENDIF
              ENDIF
            ENDDO
          ELSE
C           ...check on loc to glob array already performed...
            DO J=1,N_EL_SEND
C        .. and check indices to send of DESC_HALO array correctness...
              IF ((DESC_HALO(COUNTER_R+J).GT.DESC_DATA(N_ROW_)).OR.
     +          (DESC_HALO(COUNTER_R+J).LT.1)) THEN
                INFO = 130
                INT_ERR(1) = 11
                INT_ERR(2) = 0
                INT_ERR(3) = DESC_DATA(N_ROW_)+1
                INT_ERR(4) = DESC_HALO(COUNTER_R+J)
                GOTO 998
              ENDIF
              IF (GLB_CHECK.EQ.1)
     +          WORK2(J)=LOC_TO_GLOB(DESC_HALO(COUNTER_R+J))
            ENDDO
          ENDIF
        ENDIF
        
        IF (INFO.NE.0) GOTO 998
        IF (LTG_CHECK.EQ.0) THEN
C        .....check on loc to glob array already performed....
          DO J=1,N_EL_SEND
C            ....check consistency of halo element to send.....
            IF ((DESC_HALO(COUNTER_R+J).GT.DESC_DATA(N_ROW_)).OR.
     +        (DESC_HALO(COUNTER_R+J).LT.1)) THEN
              INFO = 130
              INT_ERR(1) = 11
              INT_ERR(2) = 0
              INT_ERR(3) = DESC_DATA(N_ROW_)+1
              INT_ERR(4) = DESC_HALO(COUNTER_R+J)
              GOTO 998
            ENDIF
            IF (GLB_CHECK.EQ.1) THEN
              LOC_IND=LOC_TO_GLOB(DESC_HALO(COUNTER_R+J))
              IF ((LOC_IND.LT.1).OR.(LOC_IND.GT.DESC_DATA(M_))) 
     +          THEN
                INFO = 240
                INT_ERR(1) = LOC_TO_GLOB_+DESC_HALO(COUNTER_R+J)
                INT_ERR(2) = 10
                INT_ERR(3) = M_
                INT_ERR(4) = 10
                INT_ERR(5) = 1
                INT_ERR(6) = LOC_IND
                INT_ERR(7) = DESC_DATA(M_)
                GOTO 998
              ENDIF
              IF (LOC_IND.NE.WORK2(J)) 
     +          THEN
C              ....Error elements not match.......
                INFO = 180
                INT_ERR(1) = 11
                INT_ERR(2) = ME
                INT_ERR(3) = J
                INT_ERR(4) = PROC
                INT_ERR(5) = LOC_TO_GLOB(DESC_HALO(COUNTER_R+J))
                INT_ERR(6) = WORK2(J)
                GOTO 998
              ENDIF
            ENDIF
            
            
          ENDDO
        ELSE
C        check on loc to glob array already performed....
          DO J=1,N_EL_SEND
C            ....check consistency of halo element to send.....
            IF ((DESC_HALO(COUNTER_R+J).GT.DESC_DATA(N_ROW_)).OR.
     +        (DESC_HALO(COUNTER_R+J).LT.1)) THEN
              INFO = 130
              INT_ERR(1) = 11
              INT_ERR(2) = 0
              INT_ERR(3) = DESC_DATA(N_ROW_)+1
              INT_ERR(4) = DESC_HALO(COUNTER_R+J)
              GOTO 998
            ENDIF
            IF (GLB_CHECK.EQ.1) THEN
              IF (LOC_TO_GLOB(DESC_HALO(COUNTER_R+J)).NE.WORK2(J)) 
     +          THEN
C              ....Error elements not match.......
                INFO = 180
                INT_ERR(1) = 11
                INT_ERR(2) = ME
                INT_ERR(3) = J
                INT_ERR(4) = PROC
                INT_ERR(5) = LOC_TO_GLOB(DESC_HALO(COUNTER_R+J))
                INT_ERR(6) = WORK2(J)
                GOTO 998
              ENDIF
            ENDIF
            
            
          ENDDO
        ENDIF

        IF (INFO.NE.0) GOTO 998

        COUNTER_R=COUNTER_R+N_EL_SEND+1
      ENDDO


 998  CONTINUE 
      ICTXT = DESC_DATA(CTXT_)
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +  I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999

      RETURN

 9999 CALL PSDERROR( ICTXT, INFO, 'PSDVERIFY\0', INT_ERR, REAL_ERR )

      END
      
