* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*
      SUBROUTINE PSI_EXTRACT_DEP_LIST(DESC_DATA,
     +  DESC_STR,DEP_LIST,
     +  LENGTH_DL,NP,DL_LDA,MODE)

C    INTERNAL ROUTINE
C    ================ 
C   
C    _____Called by PSI_Crea_halo and PSI_Crea_Ovrlap ______
C
C PURPOSE
C =======
C   Process root (pid=0) extracts for each process "k" the ordered list of process
C   to which "k" must communicate. This list with its order is extracted from
C   DESC_STR list
C
C   
C  INPUT
C =======
C  DESC_DATA :integer array
C  Explanation:
C  NAME		 EXPLANATION
C  ------------------ -------------------------------------------------------
C  DESC_DATA	 Array of INTEGER that contains some local and global
C		 information of matrix.
C
C
C  Now we explain each of the above vectors.
C
C  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
C  array for matrix A.
C  Data stored in MATRIX_DATA array are:
C
C  NOTATION        STORED IN		     EXPLANATION
C  --------------- ---------------------- -------------------------------------
C  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
C  M 	           MATDATA_A[M_]          Total number of equations
C  N 	           MATDATA_A[N_]          Total number of variables
C  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
C  N_COL           MATDATA_A[N_COL_]      Number of local variables
C  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
C	     	                          the global context of the operation
C					  on the matrix.
C					  The context itself is global.
C  DESC_STR INTEGER array
C  Explanation:
C  Let DESC_STR_P be the array DESC_STR for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local halo elements to exchange with other 
C  process.
C  Let P be the pointer to the first element of a block in DESC_STR_P.
C  This block is stored in DESC_STR_P as :
C
C  NOTATION        STORED IN		          EXPLANATION
C  --------------- --------------------------- -----------------------------------
C  PROCESS_ID      DESC_STR_P[P+PROC_ID_]      Identifier of process which exchange
C						  data with.
C  N_ELEMENTS_RECV DESC_STR_P[P+N_ELEM_RECV_]  Number of elements to receive.
C  ELEMENTS_RECV   DESC_STR_P[P+ELEM_RECV_+i]  Indexes of local elements to
C					          receive. These are stored in the
C					          array from location P+ELEM_RECV_ to
C					          location P+ELEM_RECV_+
C						  DESC_STR_P[P+N_ELEM_RECV_]-1.
C  IF DESC_DATA(DEC_TYPE_) == 0 
C  then also will be:
C  N_ELEMENTS_SEND DESC_STR_P[P+N_ELEM_SEND_]  Number of elements to send.
C  ELEMENTS_SEND   DESC_STR_P[P+ELEM_SEND_+i]  Indexes of local elements to
C					          send. These are stored in the
C					          array from location P+ELEM_SEND_ to
C					          location P+ELEM_SEND_+
C						  DESC_STR_P[P+N_ELEM_SEND_]-1.
C  List is ended by -1 value
C  
C  NP     INTEGER (global input)
C         Number of grid process.
C
C  MODE   INTEGER (global input)
C         IF MODE =0 then will be inserted also duplicate element in 
C         a same dependence list
C         IF MODE =1 then not will be inserted duplicate element in
C          a same dependence list
C  OUTPUT
C  =====
C  only for Root (pid=0) process:
C  DEP_LIST  INTEGER ARRAY(DL_LDA,0:NP)
C            Dependence list DEP_LIST(*,I) is the list of process identifiers to which process I
C            must communicate with. This list with its order is extracted from
C            DESC_STR list.
C   LENGTH_DL  INTEGER ARRAY(0:NP)
C             LENGTH_DL(I) is the length of DEP_LIST(*,I) list

      IMPLICIT NONE
C     ....Scalar parameters...
      INTEGER NP,DL_LDA,MODE

C     ....Array parameters....
      INTEGER DESC_STR(*),DESC_DATA(*),
     +  DEP_LIST(DL_LDA,0:NP),LENGTH_DL(0:NP)
      INCLUDE 'psblas.fh'

C     .....Local Arrays....
      INTEGER INT_ERR(5)
      DOUBLE PRECISION REAL_ERR(5)

C     .....Local Scalars...
      INTEGER I,NPROW,NPCOL,ME,MYCOL,POINTER_DEP_LIST,PROC,INFO,J
      INTEGER ROOT, ICTXT, ERR, IONE
      logical debug
      PARAMETER (ROOT=0,IONE=1,debug=.false.)
      
      INFO = 0
      ICTXT = DESC_DATA(CTXT_)

      CALL BLACS_GRIDINFO(ICTXT,NPROW,NPCOL,ME,MYCOL)
      I=1
      if (debug) write(*,*) 'Extract: INFO ',info,desc_data(deC_type_)
      POINTER_DEP_LIST=1
      IF (DESC_DATA(DEC_TYPE_).EQ.SP_MAT_BLD) THEN
        DO WHILE (DESC_STR(I).NE.-1)
          if (debug) write(*,*) me,' Extract: looping ',i,
     +      desc_str(i),desc_str(i+1),desc_str(i+2)
          
C        ...with different decomposition type we have different
C           structure of indices  lists............................
          IF ((DESC_STR(I+1).NE.0).OR.(DESC_STR(I+2).NE.0)) THEN
C           ..If number of element to be exchanged !=0
            PROC=DESC_STR(I)
            if ((proc.lt.0).or.(proc.ge.nprow)) then
              if (debug) write(*,*) 'Extract error ',i,desc_str(i)
              INFO = 3999
              GOTO 998
            endif
            IF (MODE.EQ.1) THEN
C              ...search if already exist PROC 
C                 in dep_list(*,me)...  
              J=1
              DO WHILE ((J.LT.POINTER_DEP_LIST).AND.
     +          (DEP_LIST(J,ME).NE.PROC))
                J=J+1
              ENDDO
              
              IF (J.EQ.POINTER_DEP_LIST) THEN
C                 ...if not founded.....
                DEP_LIST(POINTER_DEP_LIST,ME)=PROC
                POINTER_DEP_LIST=POINTER_DEP_LIST+1
              ENDIF
            ELSE IF (MODE.EQ.0) THEN
              IF (POINTER_DEP_LIST.GT.DL_LDA) THEN
                INFO = 4000
                GOTO 998
              ENDIF
              DEP_LIST(POINTER_DEP_LIST,ME)=PROC
              POINTER_DEP_LIST=POINTER_DEP_LIST+1
            ENDIF
          ENDIF
          I=I+DESC_STR(I+1)+2
        ENDDO
      ELSE IF (DESC_DATA(DEC_TYPE_).EQ.SP_MAT_UPD) THEN
        DO WHILE (DESC_STR(I).NE.-1)
          if (debug) write(*,*) 'Extract: looping ',i,desc_str(i)
          
C        ...with different decomposition type we have different
C           structure of indices  lists............................
          IF (DESC_STR(I+1).NE.0) THEN
            
            PROC=DESC_STR(I)
C        ..If number of element to be exchanged !=0
            
            IF (MODE.EQ.1) THEN
C              ...search if already exist PROC....                 
              J=1
              DO WHILE ((J.LT.POINTER_DEP_LIST).AND.
     +          (DEP_LIST(J,ME).NE.PROC))
                J=J+1
              ENDDO
              IF (J.EQ.POINTER_DEP_LIST) THEN
C                 ...if not founded.....
                IF (POINTER_DEP_LIST.GT.DL_LDA) THEN
                  INFO = 4000
                  GOTO 998
                ENDIF
                DEP_LIST(POINTER_DEP_LIST,ME)=PROC
                POINTER_DEP_LIST=POINTER_DEP_LIST+1
              ENDIF
            ELSE IF (MODE.EQ.0) THEN
              IF (POINTER_DEP_LIST.GT.DL_LDA) THEN
                INFO = 4000
                GOTO 998
              ENDIF
              DEP_LIST(POINTER_DEP_LIST,ME)=PROC
              POINTER_DEP_LIST=POINTER_DEP_LIST+1
            ENDIF
          ENDIF
          I=I+DESC_STR(I+1)+2
        ENDDO
      ELSE
        write(0,*) 'Invalid DEC_TYPE',desc_data(dec_type_)
        info = 2020
      ENDIF

      LENGTH_DL(ME)=POINTER_DEP_LIST-1

C     ... Check for errors...
 998  CONTINUE 
      if (debug) write(*,*) 'Extract: INFO ',info
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +  I, I, -IONE ,-IONE,-IONE)

      IF (ERR.NE.0) GOTO 9999
      
      IF (ME.EQ.ROOT) THEN
        DO PROC=0,NP-1
          IF (PROC.NE.ROOT) THEN
            if (debug) write(*,*) 'Receiving from: ',proc
C              ...receive from PROC LENGTH of its dependence list....
            CALL IGERV2D(ICTXT,1,1,LENGTH_DL(PROC),1,
     +        PROC,MYCOL)

C              ...receive from PROC its dependence list....
            CALL IGERV2D(ICTXT,LENGTH_DL(PROC),1,
     +        DEP_LIST(1,PROC),LENGTH_DL(PROC),PROC,MYCOL)

          ENDIF
        ENDDO
      ELSE IF (ME.NE.ROOT) THEN
C        ...send to ROOT dependence list LENGTH.....
        if (debug) write(*,*) 'Sending to: ',me,root
        CALL IGESD2D(ICTXT,1,1,LENGTH_DL(ME),1,ROOT,MYCOL)
        if (debug) write(*,*) 'Sending to: ',me,root
C        ...send to ROOT dependence list....
        CALL IGESD2D(ICTXT,LENGTH_DL(ME),1,DEP_LIST(1,ME),
     +    LENGTH_DL(ME),ROOT,MYCOL)

      ENDIF

      RETURN

 9999 CALL PSDERROR( ICTXT, INFO, 'PSDVERIFY\0', INT_ERR, REAL_ERR )
      END
