* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*  
      SUBROUTINE PSI_DESC_OVRLAPM1(DESC_DATA,OVERLAP_IN,DEP_LIST,
     +   LENGHT_DL,DESC_OVERLAP,LENGHT_DO,LOC_TO_GLOB,GLOB_TO_LOC,
     +   BUFFER_OUT,LENGHT_BO,BUFFER_IN,LENGHT_BI)
C
C    INTERNAL ROUTINE
C    ================ 
C   
C    _____Called by PSI_CREA_OVRLAP ______
C  
C PURPOSE
C =======
C
C    Create OVRLAP_INDEX-PSBLAS list  from internal list of OVRLAP communication,
C    and ordered list of process which I must communicate with
C  
C  INPUT
C =======
C  DESC_DATA :integer array
C  Explanation:
C  NAME		 EXPLANATION
C  ------------------ -------------------------------------------------------
C  DESC_DATA	 Array of INTEGER that contains some local and global
C		 information of matrix.
C
C
C  Now we explain each of the above vectors.
C
C  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
C  array for matrix A.
C  Data stored in MATRIX_DATA array are:
C
C  NOTATION        STORED IN		     EXPLANATION
C  --------------- ---------------------- -------------------------------------
C  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
C  M 	           MATDATA_A[M_]          Total number of equations
C  N 	           MATDATA_A[N_]          Total number of variables
C  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
C  N_COL           MATDATA_A[N_COL_]      Number of local variables
C  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
C	     	                          the global context of the operation
C					  on the matrix.
C					  The context itself is global.
C      
C  OVRLAP_IN  Integer array.
C  explanation
C  Let DESCOVRLP_P be the array OVRLAP_IN for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local overlap elements to exchange with
C  other process.
C  Let P be the pointer to the first element of a block in DESCOVRLP_P.
C  This block is stored in DESCOVRLP_P as :
C
C  NOTATION        STORED IN		            EXPLANATION
C  ------------- ------------------------------- -----------------------------------
C  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
C						    data with.
C  N_OVRLAP_ELEM DESCOVRLP_P[P+N_ELEM_RECV]    Number of elements to recv.
C  OVRLAP_ELEM   DESCOVRLP_P[P+ELEM_RECV_+i]   global Indexes of ovrlap elements to
C					       recv. These are stored in the
C					       array from location P+OVRLP_ELEM_ to
C					       location P+OVRLP_ELEM_+
C					       DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
C  DEP_LIST     (Local input) Integer array.
C               Ordered list of process identifier which I must communcate with.
C               This order optimizes communication in PSBLAS kernels and avoids deadlock.
C               If an element is equal to -1 (NO_COMM) communicate with next element ne -1.
C
C  LENGTH_DL   (local Input)
C              length of DEP_LIST list.
C       
C  
C  LENGTH_DO   (Local input) Scalar integer. LENGTH of DESC_OVRLAP array.
C               If is performed reordering on OVRLAP list, it must be at
C               least equal to OVRLAP array's LENGTH.
C
C  LOC_TO_GLOB   (local input) INTEGER array. Element "i" contains global index
C                of local element with index "i", (associated to i-th column
C                of local matrix). 
C  GLOB_TO_LOC   (local input) INTEGER array. Element "i" contains local index
C                of global element with index "i".
C                If global element not belong to my internal point
C                and to my halo points, correspondent element is setted
C                to -1 value.
C  BUFFER_OUT    (local input ) integer array
C               Used like work area for sending indices to other processes.         
C  
C  LENGTH_BO    (Local input)
C               Length of BUFFER_OUT array.
C
C  BUFFER_IN    (local input ) integer array
C               Used like work area for receiving indices to other processes.         
C  
C  LENGTH_BI    (Local input)
C               Length of BUFFER_IN array.
C OUTPUT
C ======
C
C  DESC_OVRLAP      pointer to integer array
C             EXPLANATION
C
C  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local overlap elements to exchange with
C  other process.
C  Let P be the pointer to the first element of a block in DESCOVRLP_P.
C  This block is stored in DESCOVRLP_P as :
C
C  NOTATION        STORED IN		            EXPLANATION
C  ------------- ------------------------------- -----------------------------------
C  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
C						   data with.
C  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
C  OVRLAP_RECV   DESCOVRLP_P[P+ELEM_RECV_+i]     Indexes of local elements to
C					           receive. These are stored in the
C					           array from location P+OVRLP_ELEM_ to
C					           location P+OVRLP_ELEM_+
C						   DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
C  OVRLAP_SEND   DESCOVRLP_P[P+ELEM_SEND_+i]     Indexes of local elements to
C					           send.These are stored in the
C					           array from location P+ELEM_SEND_ to
C					           location P+ELEM_SEND_+
C						   DESCOVRLP_P[P+N_ELEM_SEND_]-1.
C  List is ended by -1 character
C
      IMPLICIT NONE
      INCLUDE 'psblas.fh'
C     ....array parameter....
      INTEGER DESC_DATA(*),OVERLAP_IN(*),DEP_LIST(*)
      INTEGER LENGHT_DL,DESC_OVERLAP(*),LENGHT_DO
      INTEGER BUFFER_OUT(*),BUFFER_IN(*)
      INTEGER LOC_TO_GLOB(*),GLOB_TO_LOC(*)

C     ...scalar parameter.....
      INTEGER LENGHT_BI,LENGHT_BO

C     ...local scalars...
      INTEGER OVRLAP_P,TEMP_PROC

      INTEGER POINTER_BO,GLOB_INDX,N_EL_RECV,POINTER_BI,
     +   ME,N_EL_SEND,I,J,PROC,P_DL,N_EL_PNT,MYCOL,PNT_DO,
     +   NP,NPCOL,ERR,INFO,ICTXT

C     ...local arrays..
      INTEGER INT_ERR(5)
      DOUBLE PRECISION REAL_ERR(5)

C     ...parameters...
      INTEGER IONE
      PARAMETER (IONE=1)

      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NP,NPCOL,ME,MYCOL)
      PNT_DO=1
      INFO = 0
      DO P_DL=1,LENGHT_DL
C     ...Loop over all processor of DEP_LIST
         PROC=DEP_LIST(P_DL)
         POINTER_BO=1
         IF (PROC.NE.-1) THEN
          
C           ....Setting pointer to OVERLAP.....
            OVRLAP_P=1
            DO WHILE (OVERLAP_IN(OVRLAP_P).NE.-1)
C           ...Loop until ending OVERLAP list....
               
C              ...TEMP_PROC is current processor contained in OVERLAP list..
               TEMP_PROC=OVERLAP_IN(OVRLAP_P)

               IF ((TEMP_PROC.GT.NP-1).OR.(TEMP_PROC.LT.0)) THEN
                  INFO = 110
                  INT_ERR(1) = 11
                  INT_ERR(2) = TEMP_PROC
                  GOTO 998
               ENDIF
               
               OVRLAP_P=OVRLAP_P+1
               IF (TEMP_PROC.EQ.PROC) THEN
C              ...Now OVRLAP_P points to No of indices to send
C                 contained in OVERLAP_IN........................
                  
                  DO I=1,OVERLAP_IN(OVRLAP_P)
                     
                     IF (POINTER_BO.GT.LENGHT_BO) THEN
                        WRITE(0,*)'errore'
                     ENDIF
C                ...Put in BUFFER_OUT(POINTER_BO) Global Index associated to
C                   overlap point.....
                     BUFFER_OUT(POINTER_BO)=OVERLAP_IN(OVRLAP_P+I)
                     
                     POINTER_BO=POINTER_BO+1
            
                  ENDDO
               ENDIF
               OVRLAP_P=OVRLAP_P+OVERLAP_IN(OVRLAP_P)+1

               IF (INFO.NE.0) GOTO 998
            ENDDO
            
            IF (INFO.NE.0) GOTO 998
   
            N_EL_SEND=POINTER_BO-1
C           ...Exchange Data (BUFFER_OUT<->BUFFER_IN) with PROC....
            CALL PSI_COMM(DESC_DATA,PROC,N_EL_SEND,BUFFER_OUT,
     +         ME,N_EL_RECV,BUFFER_IN,LENGHT_BI,INFO)

            IF (INFO.NE.0) GOTO 998

C           ....Assign PROC to DESC_OVERLAP.....
            DESC_OVERLAP(PNT_DO)=PROC

            PNT_DO=PNT_DO+1

C              ...Now N_EL_PNT point to N_ELEMENT to send tag in DESC_OVERLAP
C                 associated to processor PROC.........................
            N_EL_PNT=PNT_DO
C              ....Initialize to Zero N_EL_TO_SEND.......
            DESC_OVERLAP(N_EL_PNT)=0
            
            DO POINTER_BI=1,N_EL_RECV

C           ....assign local index to send....
               DESC_OVERLAP(PNT_DO+POINTER_BI)=
     +            GLOB_TO_LOC(BUFFER_IN(POINTER_BI))
               IF (DESC_OVERLAP(PNT_DO+POINTER_BI).LE.0) THEN
                  WRITE(0,*)'erroreM1'
               ENDIF
                if (lenght_do.lt.pnt_do+pointer_bi) then
                  write(0,*)'erroreM2'
               ENDIF
               DESC_OVERLAP(N_EL_PNT)=DESC_OVERLAP(N_EL_PNT)+1
            ENDDO
            N_EL_PNT=N_EL_PNT+DESC_OVERLAP(N_EL_PNT)+1
            PNT_DO=N_EL_PNT

C              ....Initialize to Zero N_EL_TO_RECV.......
            DESC_OVERLAP(N_EL_PNT)=0
            DO POINTER_BO=1,N_EL_SEND

C           ....assign local index to send....
               DESC_OVERLAP(PNT_DO+POINTER_BO)=
     +            GLOB_TO_LOC(BUFFER_OUT(POINTER_BO))
               IF (DESC_OVERLAP(PNT_DO+POINTER_BO).LE.0) THEN
                  WRITE(0,*)'erroreM3'
               ENDIF
               IF (LENGHT_DO.LT.PNT_DO+POINTER_BO) THEN
                  WRITE(0,*)'erroreM4'
               ENDIF

               
               DESC_OVERLAP(N_EL_PNT)=DESC_OVERLAP(N_EL_PNT)+1
            ENDDO
            N_EL_PNT=N_EL_PNT+DESC_OVERLAP(N_EL_PNT)+1
            PNT_DO=N_EL_PNT
         ENDIF

      ENDDO      
      DESC_OVERLAP(PNT_DO)=-1
 998  CONTINUE 
      ICTXT = DESC_DATA(CTXT_)
      
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      
      RETURN

 9999 CALL PSDERROR( ICTXT, INFO, 'PSDVERIFY\0', INT_ERR, REAL_ERR )

      END
