      SUBROUTINE PSI_DESC_OVRLAP(DESC_DATA,OVERLAP_IN,DEP_LIST,
     +   LENGHT_DL,DESC_OVERLAP,LENGHT_OE,LOC_INDICES,PERM,
     +   LOC_TO_GLOB,GLOB_TO_LOC,MODE,BUFFER_OUT,
     +   LENGHT_BO,BUFFER_IN,LENGHT_BI,INDICES,LENGHT_INDICES)
C  
C PURPOSE
C =======
C
C Create from OVERLAP_IN and dependence list DESC_OVRLAP_PSBLAS
C list.

      
      IMPLICIT NONE
      INCLUDE 'psblas.fh'
      INTEGER DESC_DATA(*),OVERLAP_IN(*),DEP_LIST(*)
      INTEGER LENGHT_DL,DESC_OVERLAP(*),LENGHT_OE
      INTEGER LOC_INDICES(*),PERM(*),BUFFER_OUT(*),
     +   BUFFER_IN(*),INDICES(*)
      INTEGER LOC_TO_GLOB(*),GLOB_TO_LOC(*)
      INTEGER LENGHT_BI,LENGHT_BO,LENGHT_INDICES

      INTEGER OVRLAP_P,TEMP_PROC,MODE

      INTEGER POINTER_BO,GLOB_INDX,LOC_TIMES,REM_TIMES,
     +   N_EL_RECV,POINTER_BI,ME,N_EL_SEND,POINTER_I,I,J
     +   PNT_SB,PROC,J,P_DL,N_EL_PNT,N_INDEX_OUT,MYCOL,PNT_DO,
     +   NP,NPCOL,COUNTER,PNT_RECV,NUM_INSERTED,ERR,INFO,ICTXT,
     +   IONE

      PARAMETER (IONE=1)

      INTEGER INT_ERR(5)
      DOUBLE PRECISION REAL_ERR(5)

      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NP,NPCOL,ME,MYCOL)
      PNT_DO=1
      INFO = 0
      DO P_DL=1,LENGHT_DL
C     ...Loop over all processor of DEP_LIST
         PROC=DEP_LIST(P_DL)
         POINTER_BO=1
         POINTER_I=1
         IF (PROC.NE.-1) THEN
          
C           ....Setting pointer to OVERLAP.....
            OVRLAP_P=1
C            PNT_SB=0
            DO WHILE (OVERLAP_IN(OVRLAP_P).NE.-1)
C           ...Loop until ending OVERLAP list....
               
C              ...TEMP_PROC is current processor contained in OVERLAP list..
               TEMP_PROC=OVERLAP_IN(OVRLAP_P)

               IF ((TEMP_PROC.GT.NP-1).OR.(TEMP_PROC.LT.0)) THEN
                  INFO = 110
                  INT_ERR(1) = 11
                  INT_ERR(2) = TEMP_PROC
                  GOTO 998
               ENDIF

               OVRLAP_P=OVRLAP_P+1
               IF (TEMP_PROC.EQ.PROC) THEN
C              ...Now OVRLAP_P points to No of indices to send
C                 contained in OVERLAP_IN........................
                  
                  DO I=1,OVERLAP_IN(OVRLAP_P)
                     
C                ...Put in BUFFER_OUT(POINTER_BO) Global Index associated to
C                   overlap point.....
                     BUFFER_OUT(POINTER_BO)=OVERLAP_IN(OVRLAP_P+I)
                     
                     POINTER_BO=POINTER_BO+1

C                ...Put in INDICES(POINTER_I..)  Local indices
C                   associated to global index contained in 
C                   (OVERLAP_IN(OVRLAP_P+I)                    

C                ....Put in BUFFER_OUT(POINTER_BO) the number of local indices
C                    associated to global index: OVERLAP_IN(OVRLAP_P+I)....
                     INT_ERR(4) = OVERLAP_IN(OVRLAP_P+I)
                     IF (MODE.EQ.0) THEN
                        CALL PSI_GLOB_NO(OVERLAP_IN(OVRLAP_P+I),
     +                     BUFFER_OUT(POINTER_BO),INDICES(POINTER_I),
     +                     LENGHT_INDICES-POINTER_I,
     +                     LOC_INDICES,PERM,DESC_DATA,INFO)
                     ELSE
                        INDICES(POINTER_I)=
     +                     GLOB_TO_LOC(OVERLAP_IN(OVRLAP_P+I))
                        BUFFER_OUT(POINTER_BO)=1
                     ENDIF
                     
                     IF (INFO.NE.0) GOTO 998 

                     IF (BUFFER_OUT(POINTER_BO).EQ.-1) THEN
                        INFO = 250
                        INT_ERR(1) = I
                        INT_ERR(2) = PROC
                        INT_ERR(3) = ME
                        GOTO 998
                     ENDIF

C                    Set BUFFER_OUT(POINTER_BO+1) to pointing
C                    to local indices contained in INDICES array....

                     BUFFER_OUT(POINTER_BO+1)=POINTER_I

C                    ....Now INDICES contains Local indices
C                       associated to global index contained in 
C                       BUFFER_OUT(POINTER_BO)....................   
                     POINTER_I=POINTER_I+BUFFER_OUT(POINTER_BO)

                     POINTER_BO=POINTER_BO+2

                  ENDDO
               ENDIF
               OVRLAP_P=OVRLAP_P+OVERLAP_IN(OVRLAP_P)+1

               IF (INFO.NE.0) GOTO 998
            ENDDO

            IF (INFO.NE.0) GOTO 998
   
            N_EL_SEND=POINTER_BO-1
C           ...Exchange Data (BUFFER_OUT<->BUFFER_IN) with PROC....
            CALL PSI_COMM(DESC_DATA,PROC,N_EL_SEND,BUFFER_OUT,
     +         ME,N_EL_RECV,BUFFER_IN,LENGHT_BI,INFO)

            IF (INFO.NE.0) GOTO 998 

C           ....Assign PROC to DESC_OVERLAP.....
            DESC_OVERLAP(PNT_DO)=PROC

            PNT_DO=PNT_DO+1

            POINTER_BI=1
C              ...Now N_EL_PNT point to N_ELEMENT to send tag in DESC_OVERLAP
C                 associated to processor PROC.........................
            N_EL_PNT=PNT_DO
C              ....Initialize to Zero N_EL_TO_SEND.......
            DESC_OVERLAP(N_EL_PNT)=0

            DO WHILE (POINTER_BI.LE.N_EL_RECV)
               POINTER_BO=1

C              ....Search in BUFFER_OUT element with global index 
C                  BUFFER_IN(POINTER_BI)
               DO WHILE ((POINTER_BO.LE.N_EL_SEND).AND.
     +            (BUFFER_OUT(POINTER_BO).NE.BUFFER_IN(POINTER_BI)))
                  POINTER_BO=POINTER_BO+3
               ENDDO


C              ...REM_TIMES = Molteplicity of point GLOB_INDX
C                             associated to processor PROC......
               REM_TIMES=BUFFER_IN(POINTER_BI+1)

               GLOB_INDX=BUFFER_IN(POINTER_BI)
               POINTER_BI=POINTER_BI+3
               
C              ...LOC_TIMES = Molteplicity of point GLOB_INDX
C                             associated to actual processor (ME)...
               LOC_TIMES=BUFFER_OUT(POINTER_BO+1)

C              ....POINTER_I is the pointer to LOCAL_INDICES array
C                  and now we set it to position corespondent
C                   to local indices associated to GLOB_INDX....
               POINTER_I=BUFFER_OUT(POINTER_BO+2)

               IF (PROC.NE.ME) THEN
C              ...Copy REM_TIMES Local indices associated to
C                 GLOB_INDX...................................
                  DO I=1,REM_TIMES
                     DO J=1,LOC_TIMES
                        DESC_OVERLAP(PNT_DO+J)=INDICES(POINTER_I+J-1)
                     ENDDO
                     PNT_DO=PNT_DO+LOC_TIMES
                     DESC_OVERLAP(N_EL_PNT)=DESC_OVERLAP(N_EL_PNT)+
     +               LOC_TIMES
                  ENDDO
               ELSE IF (PROC.EQ.ME) THEN
                  DO J=1,LOC_TIMES
                     DO I=1,REM_TIMES-1
                        DESC_OVERLAP(PNT_DO+I)=INDICES(POINTER_I+J-1)
                     ENDDO
                     PNT_DO=PNT_DO+REM_TIMES-1
                     DESC_OVERLAP(N_EL_PNT)=DESC_OVERLAP(N_EL_PNT)+
     +                  REM_TIMES-1
                  ENDDO
               ENDIF
C               PNT_DO=PNT_DO+1
            ENDDO

            PNT_RECV=N_EL_PNT+1
            POINTER_BO=1
            PNT_DO=PNT_DO+1

C              ...Now N_EL_PNT point to N_ELEMENT to recv tag in DESC_OVERLAP
C                 associated to processor PROC.........................
            N_EL_PNT=PNT_DO
C              ....Initialize to Zero N_EL_TO_SEND.......
            DESC_OVERLAP(N_EL_PNT)=0

            DO WHILE (POINTER_BO.LE.N_EL_SEND)

C              ....Search in BUFFER_OUT element with global index 
C                 BUFFER_IN(POINTER_BI)
               POINTER_BI=1
               DO WHILE ((POINTER_BI.LE.N_EL_RECV).AND.
     +            (BUFFER_OUT(POINTER_BO).NE.BUFFER_IN(POINTER_BI)))
                  POINTER_BI=POINTER_BI+3
               ENDDO

C              ...REM_TIMES = Molteplicity of point GLOB_INDX
C                             asscociated to processor PROC......
               REM_TIMES=BUFFER_IN(POINTER_BI+1)


C              ...LOC_TIMES = Molteplicity of point GLOB_INDX
C                             associated to actual processor (ME)...
               LOC_TIMES=BUFFER_OUT(POINTER_BO+1)

               GLOB_INDX=BUFFER_OUT(POINTER_BO)




C              ....POINTER_I is the pointer to LOCAL_INDICES array
C                  and now we set it to position corespondent
C                   to local indices associated to GLOB_INDX....
               POINTER_I=BUFFER_OUT(POINTER_BO+2)               
               POINTER_BO=POINTER_BO+3

               IF (PROC.NE.ME) THEN
                  DO J=1,LOC_TIMES
                     DO I=1,REM_TIMES
                        DESC_OVERLAP(PNT_DO+I)=INDICES(POINTER_I+J-1)
                     ENDDO
                     PNT_DO=PNT_DO+REM_TIMES
                     DESC_OVERLAP(N_EL_PNT)=DESC_OVERLAP(N_EL_PNT)+
     +                  REM_TIMES
                  ENDDO
               ELSE IF (PROC.EQ.ME) THEN
                  DO I=1,LOC_TIMES
                     J=0
                     NUM_INSERTED=0
                     DO WHILE (NUM_INSERTED.LT.LOC_TIMES-1)
                        IF (INDICES(POINTER_I+J).NE.
     +                     DESC_OVERLAP(PNT_RECV+NUM_INSERTED)) THEN

                           DESC_OVERLAP(PNT_DO+NUM_INSERTED+1)=
     +                        INDICES(POINTER_I+J)

                           NUM_INSERTED=NUM_INSERTED+1

                        ENDIF
                        J=MOD(J+1,LOC_TIMES)
                     ENDDO
                     PNT_RECV=PNT_RECV+NUM_INSERTED
                     PNT_DO=PNT_DO+NUM_INSERTED
                     DESC_OVERLAP(N_EL_PNT)=DESC_OVERLAP(N_EL_PNT)+
     +                  NUM_INSERTED

                  ENDDO
               ENDIF
            ENDDO
            PNT_DO=PNT_DO+1
         ENDIF
      ENDDO
 998  CONTINUE 
      DESC_OVERLAP(PNT_DO)=-1

      ICTXT = DESC_DATA(CTXT_)
      
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      
      RETURN

 9999 CALL PSDERROR( ICTXT, INFO, 'PSDVERIFY', INT_ERR, REAL_ERR )

      END
