* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*
      SUBROUTINE PSI_DESC_HALO(DESC_DATA,HALO_IN,DEP_LIST,
     +  LENGTH_DL,LOC_TO_GLOB,GLOB_TO_LOC,
     +  DESC_HALO,LENGTH_DH,
     +  BUFFER_SEND,LENGTH_BS)

C    INTERNAL ROUTINE
C    ================ 
C   
C    _____Called by PSI_CREA_HALO ______
C
C    PURPOSE
C    =======
C
C    Create HALO_INDEX-PSBLAS list  from internal list of halo communication,
C    and ordered list of process which I must communicate with.
C  
C  INPUT
C =======
C  DESC_DATA :integer array
C  Explanation:
C  NAME		 EXPLANATION
C  ------------------ -------------------------------------------------------
C  DESC_DATA	 Array of INTEGER that contains some local and global
C		 information of matrix.
C
C
C  Now we explain each of the above vectors.
C
C  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
C  array for matrix A.
C  Data stored in MATRIX_DATA array are:
C
C  NOTATION        STORED IN		     EXPLANATION
C  --------------- ---------------------- -------------------------------------
C  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
C  M 	           MATDATA_A[M_]          Total number of equations
C  N 	           MATDATA_A[N_]          Total number of variables
C  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
C  N_COL           MATDATA_A[N_COL_]      Number of local variables
C  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
C	     	                          the global context of the operation
C					  on the matrix.
C					  The context itself is global.
C  
C  HALO : integer array 
C  Explanation
C
C  Let DESCHALO_P be the array HALO for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local halo elements to exchange with other 
C  process.
C  Let P be the pointer to the first element of a block in DESCHALO_P.
C  This block is stored in DESCHALO_P as :
C
C  NOTATION        STORED IN		          EXPLANATION
C  --------------- --------------------------- -----------------------------------
C  PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
C						  data with.
C  N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
C  ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
C					          receive. These are stored in the
C					          array from location P+ELEM_RECV_ to
C					          location P+ELEM_RECV_+
C						  DESCHALO_P[P+N_ELEM_RECV_]-1.
C  list is ended by -1 value
C
C  
C  LENGTH_DH   (Local input) Scalar integer. LENGTH of DESC_HALO array.
C               If is performed reordering on HALO list, it must be at
C               least equal to HALO array's LENGTH.
C
C  DEP_LIST     (Local input) Integer array.
C               Ordered list of process identifier which I must communcate with.
C               This order optimizes communication in PSBLAS kernels and avoids deadlock.
C               If an element is equal to -1 (NO_COMM) communicate with next element ne -1.
C
C  LENGTH_DL   (local Input)
C              length of DEP_LIST list.
C       
C  LOC_TO_GLOB   (local input) INTEGER array. Element "i" contains global index
C                of local element with index "i", (associated to i-th column
C                of local matrix). 
C  GLOB_TO_LOC   (local input) INTEGER array. Element "i" contains local index
C                of global element with index "i".
C                If global element not belong to my internal point
C                and to my halo points, correspondent element is setted
C                to -1 value.
C  BUFFER_SEND  (Local input) Integer array.
C               Used like work area for sending indices to other processes.
C
C  LENGTH_BS    (Local input)
C               Length of BUFFER_SEND array.
C  
C  OUTPUT
C  ======
C 
C  DESC_HALO
C  DESC_HALO INTEGER array
C  Explanation:
C  Let HALO_INDEX_P be the array DESC_HALO for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local halo elements to exchange with other 
C  process.
C  Let P be the pointer to the first element of a block in HALO_INDEX_P.
C  This block is stored in HALO_INDEX_P as :
C
C  NOTATION        STORED IN		          EXPLANATION
C  --------------- --------------------------- -----------------------------------
C  PROCESS_ID      HALO_INDEX_P[P+PROC_ID_]      Identifier of process which exchange
C						  data with.
C  N_ELEMENTS_RECV HALO_INDEX_P[P+N_ELEM_RECV_]  Number of elements to receive.
C  ELEMENTS_RECV   HALO_INDEX_P[P+ELEM_RECV_+i]  Indexes of local elements to
C					          receive. These are stored in the
C					          array from location P+ELEM_RECV_ to
C					          location P+ELEM_RECV_+
C						  HALO_INDEX_P[P+N_ELEM_RECV_]-1.
C  N_ELEMENTS_SEND HALO_INDEX_P[P+N_ELEM_SEND_]  Number of elements to send.
C  ELEMENTS_SEND   HALO_INDEX_P[P+ELEM_SEND_+i]  Indexes of local elements to
C					          send. These are stored in the
C					          array from location P+ELEM_SEND_ to
C					          location P+ELEM_SEND_+
C						  HALO_INDEX_P[P+N_ELEM_SEND_]-1.
C  List is ended by -1 value
C  
      IMPLICIT NONE
      INCLUDE 'psblas.fh'
C     ...Array parameters.....
      INTEGER DESC_DATA(*),HALO_IN(*),DEP_LIST(*)
      INTEGER LOC_TO_GLOB(*),GLOB_TO_LOC(*),DESC_HALO(*),BUFFER_SEND(*)
C    ....Local scalars...   
      INTEGER LENGTH_DL
      INTEGER LENGTH_DH
      INTEGER LENGTH_BS

C    ....scalars parameters...        
      INTEGER POINTER_HI,J,POINTER_BS,POINTER_DH,TEMP_PROC,ME,
     +  NP,NPCOL,MYCOL,NUM_ELEM_DH,NUM_EL_TO_RECV,I,PROC,IONE

C    ...Parameters...
      PARAMETER (IONE=1)
      INTEGER INFO, ERR, ICTXT
      INTEGER NO_COMM
      PARAMETER (NO_COMM=-1)

C    ...Local arrays..
      INTEGER INT_ERR(7)
      DOUBLE PRECISION REAL_ERR(5)


C    if Mode == 1 then we can use glob_to_loc array
C    else we can't utilize it

      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NP,NPCOL,ME,MYCOL) 
      POINTER_DH=1
      INFO = 0
      DO I=1,LENGTH_DL
C        ...loop for each process contained in DEP_LIST....
        POINTER_BS=0
        PROC=DEP_LIST(I)
        IF (PROC.NE.NO_COMM) THEN

          IF (POINTER_DH.GT.LENGTH_DH) THEN
            INFO = 100
            INT_ERR(1) = 29
            INT_ERR(2) = POINTER_DH-1
            INT_ERR(3) = LENGTH_DH
            INT_ERR(4) = POINTER_DH-1
            GOTO 998
          ENDIF
          
          DESC_HALO(POINTER_DH)=PROC

          NUM_ELEM_DH=POINTER_DH+1
C           ...Now Num_element points to Number of HALO element to receive
          POINTER_DH=POINTER_DH+1

C           ...Set To zero Number of element to receive from PROC...
          DESC_HALO(NUM_ELEM_DH)=0

C           ...Reset Pointer to HALO_IN.............
          POINTER_HI=1

          DO WHILE (HALO_IN(POINTER_HI).NE.-1)
C          .... Correctness on List structuring of HALO_IN Array
C               and its accettable PROC values are made in PSI_LOC_VERIFY_T1..
            
C           ....Loop for all-local index in HALO_IN....

            TEMP_PROC=HALO_IN(POINTER_HI)

C              ...Test correctness of PROC identifier....
            IF ((TEMP_PROC.GT.NP-1).OR.(TEMP_PROC.LT.0)) THEN
              INFO = 110
              INT_ERR(1) = 11
              INT_ERR(2) = TEMP_PROC
              GOTO 998
            ENDIF
            
            POINTER_HI=POINTER_HI+1
            NUM_EL_TO_RECV=HALO_IN(POINTER_HI)

            IF (TEMP_PROC.EQ.PROC) THEN
C                 ...if actual processor is eq to PROC....
              
              IF (POINTER_DH+NUM_EL_TO_RECV+1.GT.LENGTH_DH) 
     +          THEN
                INFO = 100
                INT_ERR(1) = 29
                INT_ERR(2) = POINTER_DH+NUM_EL_TO_RECV
                INT_ERR(3) = LENGTH_DH
                INT_ERR(4) = POINTER_DH+NUM_EL_TO_RECV
                GOTO 998
              ENDIF

              IF (POINTER_BS+NUM_EL_TO_RECV+1.GT.LENGTH_BS) 
     +          THEN
                INFO = 4030
                GOTO 998
              ENDIF

C                 ....Increase Number of indices to receive....
              DESC_HALO(NUM_ELEM_DH)=
     +          DESC_HALO(NUM_ELEM_DH)+HALO_IN(POINTER_HI)
              
C                 ...Store local indices to receive in DESC_HALO
C                    adn correspondent global indices in BUFFER_SEND..
              DO J=1,NUM_EL_TO_RECV

C NOTE: to be modified
C                     IF (HALO_IN(POINTER_HI+J).GT.DESC_DATA(N_COL_)) 
C     +                  THEN
C                        INFO = 200
C                        INT_ERR(1) = POINTER_HI+J
C                        INT_ERR(2) = 11
C                        INT_ERR(3) = N_COL_
C                        INT_ERR(4) = 10
C                        INT_ERR(5) = HALO_IN(POINTER_HI+J)
C                        INT_ERR(6) = DESC_DATA(N_COL_)
C                        GOTO 998
C                     ENDIF
C
C                     IF (HALO_IN(POINTER_HI+J).LE.DESC_DATA(N_ROW_)) 
C     +                  THEN
C                        INFO = 210
C                        INT_ERR(1) = POINTER_HI+J
C                        INT_ERR(2) = 11
C                        INT_ERR(3) = N_ROW_
C                        INT_ERR(4) = 10
C                        INT_ERR(5) = HALO_IN(POINTER_HI+J)
C                        INT_ERR(6) = DESC_DATA(N_ROW_)
C                        GOTO 998
C                     ENDIF
                DESC_HALO(POINTER_DH+J)=
     +            HALO_IN(POINTER_HI+J)
                BUFFER_SEND(POINTER_BS+J)=
     +            LOC_TO_GLOB(HALO_IN(POINTER_HI+J))
                                !     +                  DESC_DATA(LOC_TO_GLOB_+HALO_IN(POINTER_HI+J))

                IF ((BUFFER_SEND(POINTER_BS+J).GT.DESC_DATA(M_))
     +            .OR.((BUFFER_SEND(POINTER_BS+J).LT.1)))
     +            THEN
                  INFO = 240
                  INT_ERR(1) = LOC_TO_GLOB_+HALO_IN(POINTER_HI+J)
                  INT_ERR(2) = 10
                  INT_ERR(3) = M_
                  INT_ERR(4) = 10
                  INT_ERR(5) = 1
                  INT_ERR(6) = BUFFER_SEND(POINTER_BS+J) 
                  INT_ERR(7) = DESC_DATA(M_)
                  GOTO 998
                ENDIF
              ENDDO

              IF (INFO.NE.0) GOTO 998

C                 ...Increase pointers to BUFFER_SEND, DESC_HALO and  
C                    HALO_IN
              POINTER_BS=POINTER_BS+NUM_EL_TO_RECV                  
              POINTER_DH=POINTER_DH+NUM_EL_TO_RECV

            ENDIF
            POINTER_HI=POINTER_HI+NUM_EL_TO_RECV+1
          ENDDO

          IF (INFO.NE.0) GOTO 998

          POINTER_DH=POINTER_DH+1

C           ...Send BUFFER_SEND to PROC and receive from it 
          CALL PSI_COMM(DESC_DATA,PROC,POINTER_BS,BUFFER_SEND,ME,
     +      DESC_HALO(POINTER_DH),DESC_HALO(POINTER_DH+1),
     +      LENGTH_DH-POINTER_DH-1,INFO)

          IF (INFO.NE.0) GOTO 998

C        ...converting each global index received to correspondent
C            local index...
          DO J=1,DESC_HALO(POINTER_DH)
            
C           ...Put in DESC_HALO(POINTER_DH+J) local index of global element
C              with global index DESC_HALO(POINTER_DH+J)...................
            INT_ERR(4) = DESC_HALO(POINTER_DH+J)
            DESC_HALO(POINTER_DH+J)=
     +        GLOB_TO_LOC(DESC_HALO(POINTER_DH+J))
            IF (DESC_HALO(POINTER_DH+J).EQ.-1) THEN
              INFO = 220
              INT_ERR(1) = J
              INT_ERR(2) = PROC
              INT_ERR(3) = ME
              GOTO 998
            ENDIF

C NOTE: to be modified
C
C               IF ((DESC_HALO(POINTER_DH+J).GT.DESC_DATA(N_ROW_))
C     +            .AND.(DESC_HALO(POINTER_DH+J).LE.DESC_DATA(N_COL_)))
C     +            THEN
C                  INFO = 230
C                  INT_ERR(1) = J
C                  INT_ERR(2) = PROC
C                  INT_ERR(3) = ME
C                  GOTO 998
C               ENDIF
            IF ((DESC_HALO(POINTER_DH+J).GT.DESC_DATA(N_COL_)).OR.
     +        (DESC_HALO(POINTER_DH+J).LT.1)) THEN
              INFO = 4040
              GOTO 998
            ENDIF
          ENDDO
          IF (INFO.NE.0) GOTO 998

C           ....Update pointer to DESC_HALO....
          POINTER_DH=POINTER_DH+DESC_HALO(POINTER_DH)+1
        ENDIF
      ENDDO

 998  CONTINUE
      
      DESC_HALO(POINTER_DH)=-1

      ICTXT = DESC_DATA(CTXT_)
      
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +  I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      
      RETURN

 9999 CALL PSDERROR( ICTXT, INFO, 'PSDVERIFY\0', INT_ERR, REAL_ERR )

      END
      
