* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*     
      SUBROUTINE PSI_CREA_OVRLAP(DESC_DATA,OVERLAP,NP,
     +   DESC_OVERLAP,LENGTH_DO,DEP_LIST,
     +   DL_LDA,LENGTH_DL,
     +   LOC_TO_GLOB,GLOB_TO_LOC,
     +   MAX_SIZE1,MAX_SIZE2,WORK,LWORK)
C
C    INTERNAL ROUTINE
C    ================ 
C   
C    _____Called by PSI_CONVERT_COMM ______
C
C    purpose
C    =======
C
C    Create OVRLAP_INDEX-PSBLAS list  from internal list of OVRLAP communication
C
C  INPUT
C =======
C  DESC_DATA :integer array
C  Explanation:
C  NAME		 EXPLANATION
C  ------------------ -------------------------------------------------------
C  DESC_DATA	 Array of INTEGER that contains some local and global
C		 information of matrix.
C
C
C  Now we explain each of the above vectors.
C
C  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
C  array for matrix A.
C  Data stored in MATRIX_DATA array are:
C
C  NOTATION        STORED IN		     EXPLANATION
C  --------------- ---------------------- -------------------------------------
C  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
C  M 	           MATDATA_A[M_]          Total number of equations
C  N 	           MATDATA_A[N_]          Total number of variables
C  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
C  N_COL           MATDATA_A[N_COL_]      Number of local variables
C  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
C	     	                          the global context of the operation
C					  on the matrix.
C					  The context itself is global.
C  
C  OVRLAP  Integer array.
C  explanation
C  Let DESCOVRLP_P be the array OVRLAP for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local overlap elements to exchange with
C  other process.
C  Let P be the pointer to the first element of a block in DESCOVRLP_P.
C  This block is stored in DESCOVRLP_P as :
C
C  NOTATION        STORED IN		            EXPLANATION
C  ------------- ------------------------------- -----------------------------------
C  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
C						    data with.
C  N_OVRLAP_ELEM DESCOVRLP_P[P+N_ELEM_RECV]    Number of elements to recv.
C  OVRLAP_ELEM   DESCOVRLP_P[P+ELEM_RECV_+i]   global Indexes of ovrlap elements to
C					       recv. These are stored in the
C					       array from location P+OVRLP_ELEM_ to
C					       location P+OVRLP_ELEM_+
C					       DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
C  
C  DEP_LIST   (local input) Integer array(DL_LDA,NP)
C             used to store halo dependence list (internal use)
C
C  DL_LDA     (global input) DEP_LIST leading dimension 
C
C  LENGTH_DL  (local input) Integer array (NP)
C             used to store halo LENGTH dependence list of each process (internal use)
C       
C  LOC_TO_GLOB   (local input) INTEGER array. Element "i" contains global index
C                of local element with index "i", (associated to i-th column
C                of local matrix). 
C  GLOB_TO_LOC   (local input) INTEGER array. Element "i" contains local index
C                of global element with index "i".
C                If global element not belong to my internal point
C                and to my halo points, correspondent element is setted
C                to -1 value.
C               
C  WORK       (local input) INTEGER array. 
C             Work area.
C
C  LWORK      (local input) INTEGER. Dimension of Work area.
C         
C  LENGHT_DO   (Local input) Scalar integer. Lenght of DESC_OVERLAP array.
C
C  MAX_SIZE1  (Local Input ) integer.
C             is an upper-bound of Max number of ovrlap point which must be sended
C             from each process.
C
C  MAX_SIZE2  (Local Input ) integer.
C             is an upper-bound of Max number of ovrlap point which must be received
C             from each process.
C  
C OUTPUT
C ======
C
C  DESC_OVRLAP      pointer to integer array
C             EXPLANATION
C
C  Let DESCOVRLP_P be the array DESC_OVRLAP for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local overlap elements to exchange with
C  other process.
C  Let P be the pointer to the first element of a block in DESCOVRLP_P.
C  This block is stored in DESCOVRLP_P as :
C
C  NOTATION        STORED IN		            EXPLANATION
C  ------------- ------------------------------- -----------------------------------
C  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
C						   data with.
C  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
C  OVRLAP_RECV   DESCOVRLP_P[P+ELEM_RECV_+i]     Indexes of local elements to
C					           receive. These are stored in the
C					           array from location P+OVRLP_ELEM_ to
C					           location P+OVRLP_ELEM_+
C						   DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
C  OVRLAP_SEND   DESCOVRLP_P[P+ELEM_SEND_+i]     Indexes of local elements to
C					           send.These are stored in the
C					           array from location P+ELEM_SEND_ to
C					           location P+ELEM_SEND_+
C						   DESCOVRLP_P[P+N_ELEM_SEND_]-1.
C  List is ended by -1 character
C
      IMPLICIT NONE
      INCLUDE 'psblas.fh'
C     ...Scalar parameters....
      INTEGER NP,LENGTH_DO,LWORK,DL_LDA,
     +   MAX_SIZE1,MAX_SIZE2

C    ...Array parameters....
      INTEGER DESC_DATA(*),OVERLAP(*),DESC_OVERLAP(*),
     +   WORK(*),LENGTH_DL(0:NP-1),
     +   DEP_LIST(DL_LDA,0:NP-1),LOC_TO_GLOB(*),
     +   GLOB_TO_LOC(*)

C     ...local scalars....
      INTEGER PROC,ME,PROC2,I,J,K,NPROW,NPCOL,MYCOL,LWORK1,LWORK2
      INTEGER INFO, ERR, ICTXT

C     ...Local arrays...
      INTEGER INT_ERR(5)
      DOUBLE PRECISION REAL_ERR(5)

C     ....Parameters....
      INTEGER NO_COMM,IONE
      PARAMETER (NO_COMM=-1,IONE=1)
      INTEGER ROOT
      PARAMETER (ROOT=0)


      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NPROW,NPCOL,ME,MYCOL)

      INFO = 0

C     ...extract dependence list (ordered list of identifer process
C        which every process must communcate with..................     
      CALL PSI_EXTRACT_DEP_LIST(DESC_DATA,OVERLAP,DEP_LIST,
     +   LENGTH_DL,NP,DL_LDA,1)
C    ...Now process root contains dependence list of all processes...
      
      IF (ME.EQ.ROOT) THEN

C       ....if in DEP_LIST of process I there is J
C           and in DEP_LIST of process J there isn't I,
C           then error.......
         DO PROC=0,NP-1
            I=1
            DO WHILE (I.LE.LENGTH_DL(PROC))
               PROC2=DEP_LIST(I,PROC)
               IF (PROC2.NE.NO_COMM) THEN
C             ...search PROC in PROC2's DEP_LIST....
                  J=1
                  DO WHILE ((J.LE.LENGTH_DL(PROC2).AND.
     +               DEP_LIST(J,PROC2).NE.PROC))
                     J=J+1
                  ENDDO
                  IF ((DEP_LIST(J,PROC2).NE.PROC).OR.
     +               (J.GT.LENGTH_DL(PROC2))) THEN

C                 ...PROC not founded...
                     INFO = 260
                     INT_ERR(1) = 12
                     INT_ERR(2) = PROC
                     INT_ERR(3) = PROC2
                     GOTO 998
                  ENDIF
               ENDIF
               I=I+1
            ENDDO

            IF (INFO.NE.0) GOTO 998
         ENDDO

         IF (INFO.NE.0) GOTO 998

C        ....Now I can sort dependence list......
         CALL SORT_DEP_LIST(DEP_LIST,LENGTH_DL,NP,DL_LDA,work,lwork)
         DO PROC=0,NP-1
            IF (PROC.NE.ME) THEN
C                 ...send LENGTH of list to send....
               CALL IGESD2D(DESC_DATA(CTXT_),1,1,LENGTH_DL(PROC),
     +            NP,PROC,0)
C                 ....Send dep_list.....
               CALL IGESD2D(DESC_DATA(CTXT_),LENGTH_DL(PROC),1,
     +            DEP_LIST(1,PROC),DL_LDA,PROC,0)
            ENDIF
         ENDDO
      ELSE IF (ME.NE.ROOT) THEN
C        ...receive LENGTH of list to receive...
         CALL IGERV2D(DESC_DATA(CTXT_),1,1,LENGTH_DL(0),
     +      NP,ROOT,0)
C        ....receive dep_list.....
         CALL IGERV2D(DESC_DATA(CTXT_),LENGTH_DL(0),1,
     +      DEP_LIST(1,0),DL_LDA,ROOT,0)
      ENDIF
             
      LWORK1=MAX_SIZE1
      LWORK2=LWORK-LWORK1
C     ...Create OVRLAP_INDEX-PSBLAS list....
      CALL PSI_DESC_OVRLAPM1(DESC_DATA,OVERLAP,DEP_LIST(1,0),
     +   LENGTH_DL(0),DESC_OVERLAP,LENGTH_DO,
     +   LOC_TO_GLOB,GLOB_TO_LOC,WORK,LWORK1,WORK(LWORK1+1),LWORK2)
      

 998  CONTINUE 

      ICTXT = DESC_DATA(CTXT_)
      
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +   I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      
      RETURN

 9999 CALL PSDERROR( ICTXT, INFO, 'PSDVERIFY\0', INT_ERR, REAL_ERR )

      END


