* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*
      SUBROUTINE PSI_CREA_OVR_ELEM(DESC_OVERLAP,OVR_ELEM,DIM_OVR_ELEM)
C
C
C  Internal routine called by PSI_CONVERT_COMM
C      
C     PURPOSE:
C     ======
C
C     ....Create OVR_ELEM-PSBLAS LIST list from DESC_OVERLAP-PSBLAS LIST..
C     
C
C     INPUT:
C     ======
C
C     DIM_OVR_ELEM Dimension of OVR_ELEM array.........................
C   DESC_OVERLAP
C  Let DESCOVRLP_P be the array DESC_OVERLAP for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local overlap elements to exchange with
C  other process.
C  Let P be the pointer to the first element of a block in DESCOVRLP_P.
C  This block is stored in DESCOVRLP_P as :
C
C  NOTATION        STORED IN		            EXPLANATION
C  ------------- ------------------------------- -----------------------------------
C  PROCESS_ID    DESCOVRLP_P[P+PROC_ID_]         Identifier of process which exchange
C						   data with.
C  N_OVRLAP_ELEM DESCOVRLP_P[P+N_OVRLP_ELEM_]    Number of elements to exchange.
C  OVRLAP_RECV   DESCOVRLP_P[P+ELEM_RECV_+i]     Indexes of local elements to
C					           receive. These are stored in the
C					           array from location P+OVRLP_ELEM_ to
C					           location P+OVRLP_ELEM_+
C						   DESCOVRLP_P[P+N_OVRLP_ELEM_]-1.
C  OVRLAP_SEND   DESCOVRLP_P[P+ELEM_SEND_+i]     Indexes of local elements to
C					           send.These are stored in the
C					           array from location P+ELEM_SEND_ to
C					           location P+ELEM_SEND_+
C						   DESCOVRLP_P[P+N_ELEM_SEND_]-1.
C
C
C
C     OUTPUT:
C     =======
C   OVRLAP_ELEM
C
C  Let OVR_ELEM_P be the array OVERLAP_ELEM for local process.
C  This is composed of blocks of two elements. The block
C  corresponding to the i-th overlapped elements, begin at index 
C  P = i*2 in array OVR_ELEM_P.
C  This block is stored in OVR_ELEM_P as :
C
C  NOTATION      STORED IN		       EXPLANATION
C  ------------- -------------------------- ----------------------------------
C  OVRLAP_ELEM   OVR_ELEM_P[P+OVRLP_ELEM_]  The index of local overlapped 
C					       element.
C  N_DOMAINS     OVR_ELEM_P[P+N_DOM_OVR_]   The number of copies of
C					       local overlapped element.     
C  List is ended by -1 character
      IMPLICIT NONE
C     ...scalar parameter....
      INTEGER DIM_OVR_ELEM
C     ...Parameter arrays....      
      INTEGER DESC_OVERLAP(*),OVR_ELEM(DIM_OVR_ELEM)
C     ...Local scalars...
      INTEGER I,PNT_NEW_ELEM,RET,J

C     ...External function...
      INTEGER PSI_EXIST_OVR_ELEM
      EXTERNAL PSI_EXIST_OVR_ELEM


      I=1
      PNT_NEW_ELEM=1
      DO WHILE (DESC_OVERLAP(I).NE.-1)
C        ...loop over all procs of DESC_OVERLAP list....

         I=I+1
         DO J=1,DESC_OVERLAP(I)
C           ....loop over all overlap indices referred to act proc.....
            RET=PSI_EXIST_OVR_ELEM(OVR_ELEM,PNT_NEW_ELEM-2,
     +         DESC_OVERLAP(I+J))
            IF (RET.EQ.-1) THEN

C            ...this point not exist in OVR_ELEM list:
C               add to it.............................
               OVR_ELEM(PNT_NEW_ELEM)=DESC_OVERLAP(I+J)  
               OVR_ELEM(PNT_NEW_ELEM+1)=2             
               PNT_NEW_ELEM=PNT_NEW_ELEM+2              

C              ...check if overflow ELEMENT_D array......
               IF (PNT_NEW_ELEM.GT.DIM_OVR_ELEM)
     +            WRITE(0,*)'Crea_OVR_ELEM MAX_ELEM_D too small'
            ELSE
C              ....this point already exist in OVR_ELEM list
C                  its position is RET............................
               OVR_ELEM(RET+1)=OVR_ELEM(RET+1)+1
            ENDIF
         ENDDO
         I=I+2*DESC_OVERLAP(I)+2
      ENDDO

C     ...add -1 at the end of output list......
      OVR_ELEM(PNT_NEW_ELEM)=-1
      END



