* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*
      SUBROUTINE PSI_CREA_HALO(DESC_DATA,HALO,NP,
     +   DESC_HALO,LENGTH_DH,
     +   DEP_LIST,DL_LDA,LENGTH_DL,
     +   LOC_TO_GLOB,GLOB_TO_LOC,
     +   WORK,LWORK)

C    INTERNAL ROUTINE
C    ================ 
C   
C    _____Called by PSI_CONVERT_COMM ______
C
C    purpose
C    =======
C
C    Create HALO_INDEX-PSBLAS list  from internal list of halo communication
C   
C  INPUT
C =======
C  DESC_DATA :integer array
C  Explanation:
C  NAME		 EXPLANATION
C  ------------------ -------------------------------------------------------
C  DESC_DATA	 Array of INTEGER that contains some local and global
C		 information of matrix.
C
C
C  Now we explain each of the above vectors.
C
C  Let A be a generic sparse matrix. We denote with MATDATA_A the MATRIX_DATA
C  array for matrix A.
C  Data stored in MATRIX_DATA array are:
C
C  NOTATION        STORED IN		     EXPLANATION
C  --------------- ---------------------- -------------------------------------
C  DEC_TYPE        MATDATA_A[DEC_TYPE_]   Decomposition type
C  M 	           MATDATA_A[M_]          Total number of equations
C  N 	           MATDATA_A[N_]          Total number of variables
C  N_ROW           MATDATA_A[N_ROW_]      Number of local equations
C  N_COL           MATDATA_A[N_COL_]      Number of local variables
C  CTXT_A          MATDATA_A[CTXT_]       The BLACS context handle, indicating
C	     	                          the global context of the operation
C					  on the matrix.
C					  The context itself is global.
C  
C  HALO : integer array 
C  Explanation
C
C  Let DESCHALO_P be the array HALO for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local halo elements to exchange with other 
C  process.
C  Let P be the pointer to the first element of a block in DESCHALO_P.
C  This block is stored in DESCHALO_P as :
C
C  NOTATION        STORED IN		          EXPLANATION
C  --------------- --------------------------- -----------------------------------
C  PROCESS_ID      DESCHALO_P[P+PROC_ID_]      Identifier of process which exchange 
C						  data with.
C  N_ELEMENTS_RECV DESCHALO_P[P+N_ELEM_RECV_]  Number of elements to receive.
C  ELEMENTS_RECV   DESCHALO_P[P+ELEM_RECV_+i]  Indexes of local elements to
C					          receive. These are stored in the
C					          array from location P+ELEM_RECV_ to
C					          location P+ELEM_RECV_+
C						  DESCHALO_P[P+N_ELEM_RECV_]-1.
C  list is ended by -1 value
C
C  
C  NP          (global input) INTEGER 
C              Number of grid processors.
C
C  LENGTH_DH   (Local input) Scalar integer. LENGTH of DESC_HALO array.
C               If is performed reordering on HALO list, it must be at
C               least equal to HALO array's LENGTH.
C  
C  DEP_LIST   (local input) Integer array(DL_LDA,NP)
C             used to store halo dependence list (internal use)
C
C  DL_LDA     (global input) DEP_LIST leading dimension 
C
C  LENGTH_DL  (local input) Integer array (NP)
C             used to store halo LENGTH dependence list of each process (internal use)
C       
C  LOC_TO_GLOB   (local input) INTEGER array. Element "i" contains global index
C                of local element with index "i", (associated to i-th column
C                of local matrix). 
C  GLOB_TO_LOC   (local input) INTEGER array. Element "i" contains local index
C                of global element with index "i".
C                If global element not belong to my internal point
C                and to my halo points, correspondent element is setted
C                to -1 value.
C  WORK       (local input) INTEGER  array. Work area to memorize intermediate 
C	         results. 
C
C  LWORK      (local input) INTEGER. Dimension of Work area.
C           
C
C   Output Data
C   ===========
C
C  DESC_HALO INTEGER array
C  Explanation:
C  Let HALO_INDEX_P be the array DESC_HALO for local process.
C  This is composed of variable dimension blocks for each process to 
C  communicate to.
C  Each block contain indexes of local halo elements to exchange with other 
C  process.
C  Let P be the pointer to the first element of a block in HALO_INDEX_P.
C  This block is stored in HALO_INDEX_P as :
C
C  NOTATION        STORED IN		          EXPLANATION
C  --------------- --------------------------- -----------------------------------
C  PROCESS_ID      HALO_INDEX_P[P+PROC_ID_]      Identifier of process which exchange
C						  data with.
C  N_ELEMENTS_RECV HALO_INDEX_P[P+N_ELEM_RECV_]  Number of elements to receive.
C  ELEMENTS_RECV   HALO_INDEX_P[P+ELEM_RECV_+i]  Indexes of local elements to
C					          receive. These are stored in the
C					          array from location P+ELEM_RECV_ to
C					          location P+ELEM_RECV_+
C						  HALO_INDEX_P[P+N_ELEM_RECV_]-1.
C  N_ELEMENTS_SEND HALO_INDEX_P[P+N_ELEM_SEND_]  Number of elements to send.
C  ELEMENTS_SEND   HALO_INDEX_P[P+ELEM_SEND_+i]  Indexes of local elements to
C					          send. These are stored in the
C					          array from location P+ELEM_SEND_ to
C					          location P+ELEM_SEND_+
C						  HALO_INDEX_P[P+N_ELEM_SEND_]-1.
C  List is ended by -1 value
C  
      IMPLICIT NONE
      INCLUDE 'psblas.fh'

C     ....Scalar parameters....      
      INTEGER LENGTH_DH,NP,DL_LDA,LWORK

C     ...Array parameters.....
      INTEGER DESC_DATA(*),HALO(*),DEP_LIST(DL_LDA,0:NP-1),
     +   LENGTH_DL(0:NP),DESC_HALO(*),WORK(*),
     +   GLOB_TO_LOC(*),LOC_TO_GLOB(*)


C    ....Local scalars...      
      INTEGER RESULT,MYROW,ME,NPCOL,MYCOL,NPROW,I,J,K,PROC,
     +   LWORK1,LWORK2,PROC2,MODE

C    ...Parameters...
      INTEGER ROOT,NO_COMM
      logical   debug
      PARAMETER (ROOT=0,NO_COMM=-1,debug=.false.)

      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NPROW,NPCOL,ME,MYCOL)

C     ...extract dependence list (ordered list of identifer process
C        which every process must communcate with..................
      if (debug) write(*,*) 'Crea_Halo: Calling extract_dep_list',lwork
      MODE = 1
      CALL PSI_EXTRACT_DEP_LIST(DESC_DATA,
     +   HALO,DEP_LIST,LENGTH_DL,NP,DL_LDA,MODE)
      if (debug) write(*,*) 'Crea_Halo: from extract_dep_list',
     +  length_dl(0)
C    ...Now process root contains dependence list of all processes...
      IF (ME.EQ.ROOT) THEN
        if (debug) write(*,*) 'Crea_Halo: Root sorting dep list'
C     ....I must order communication in in HALO

C       ....if in DEP_LIST of process I there is J
C           and in DEP_LIST of process J there isn't I,
C           add to it process I................................
         DO PROC=0,NP-1
            I=1
            DO WHILE (I.LE.LENGTH_DL(PROC))
               PROC2=DEP_LIST(I,PROC)
               IF (PROC2.NE.NO_COMM) THEN
C             ...search PROC in PROC2's DEP_LIST....
                  J=1
                  DO WHILE ((J.LE.LENGTH_DL(PROC2).AND.
     +               DEP_LIST(J,PROC2).NE.PROC))
                     J=J+1
                  ENDDO
                  IF ((DEP_LIST(J,PROC2).NE.PROC).OR.
     +               (J.GT.LENGTH_DL(PROC2))) THEN

C                 ...PROC not founded...
C                 ...Add PROC to PROC2's DEP_LIST.....

                     LENGTH_DL(PROC2)=LENGTH_DL(PROC2)+1
                     IF (LENGTH_DL(PROC2).GT.DL_LDA) THEN
                       write(0,*)'error in crea_halo', proc2,
     +                     LENGTH_DL(PROC2),'>',DL_LDA
                       ENDIF
                     DEP_LIST(LENGTH_DL(PROC2),PROC2)=PROC
                  ENDIF
               ENDIF
               I=I+1
            ENDDO
         ENDDO

C        ....Now I can sort dependence list......
         CALL SORT_DEP_LIST(DEP_LIST,LENGTH_DL,NP,DL_LDA,work,lwork)

         DO PROC=0,NP-1
            IF (PROC.NE.ME) THEN
C                 ...send LENGTH of list to send....
               CALL IGESD2D(DESC_DATA(CTXT_),1,1,LENGTH_DL(PROC),
     +            NP-1,PROC,0)
C                 ....Send dep_list.....
               CALL IGESD2D(DESC_DATA(CTXT_),LENGTH_DL(PROC),1,
     +            DEP_LIST(1,PROC),DL_LDA,PROC,0)
            ENDIF
         ENDDO
      ELSE IF (ME.NE.ROOT) THEN
C        ...receive LENGTH of list to receive...
         CALL IGERV2D(DESC_DATA(CTXT_),1,1,LENGTH_DL(0),
     +      NP,ROOT,0)
C        ....receive dep_list.....
         CALL IGERV2D(DESC_DATA(CTXT_),LENGTH_DL(0),1,
     +      DEP_LIST(1,0),DL_LDA,ROOT,0)
      ENDIF

C     ..Create DESC_HALO array.....
      CALL PSI_DESC_HALO(DESC_DATA,HALO,DEP_LIST(1,0),
     +   LENGTH_DL(0),LOC_TO_GLOB,GLOB_TO_LOC,
     +   DESC_HALO,LENGTH_DH,WORK,LWORK)
      RETURN
      END
      
      


