* ---------------------------------------------------------------------
*
*  -- PSBLAS routine (version 1.0) --
*
*  ---------------------------------------------------------------------
*
      SUBROUTINE PSI_COMPUTE_SIZE(NP,
     +  DESC_DATA, HALO_IN, OVRLAP_IN, 
     +  MAX_HALO,MAX_OVRLAP,
     +  DL_LDA_HALO,DL_LDA_OVRLAP,COUNTER_RECV,COUNTER_DL)

C    
C    INTERNAL ROUTINE
C    ================ 
C   
C    _____Called by PSI_CONVERT_COMM ______
C
C    PURPOSE
C    =======
C
C   Compute work area size for PSI_CONVERT_COMM procedure
C
C  INPUT
C =======
C
C  NP       (global input) Number of grid processors.
C
C  DESC_DATA (global and local input) INTEGER array. Is the MATRIX_DATA
C           array.
C           See "PSI_Convert_Comm.f" for its description.
C
C  HALO_IN (local input) INTEGER array.
C           See "PSI_Convert_Comm.f"  for its description.
C
C  OVRLAP_IN (local input) INTEGER array. 
C           See  "PSI_Convert_Comm.f" for its description.
C
C
C  COUNTER_RECV integer array(0:NP-1).
C               Work area.
C  COUNTER_DL   integer array(0:NP-1).
C               Work area.
C  OUTPUT
C ========
C
C  MAX_HALO   INTEGER 
C             max number of halo points to be received from same processor
C  MAX_OVRLAP INTEGER 
C             max number of ovrlap points to be received from same processor
C  DL_LDA_HALO INTEGER
C             maximal length of halo dependence list that can be reached
C             is setted to the 5*square(max over all processes of number
C             of processes to which eac process must exchange halo points).
C  DL_LDA_OVRLAP INTEGER
C             maximal length of ovrlap dependence list that can be reached
C             is setted to the 5*square(max over all processes of number
C             of processes to which each process must exchange ovrlap points).

      IMPLICIT NONE
      INCLUDE 'psblas.fh'
C     ....Scalars parameters....
      INTEGER MAX_HALO, MAX_OVRLAP,MAX_GLOB_MOLT,
     +  DL_LDA_HALO,DL_LDA_OVRLAP,NP
C     .....Array Parameters....
      INTEGER DESC_DATA(*), HALO_IN(*), OVRLAP_IN(*), 
     +  COUNTER_RECV(0:NP-1),COUNTER_DL(0:NP-1)
C     ....Local Scalars....      
      INTEGER I,NPCOL,NPROW,INFO,MYCOL,MYROW,PROC,COUNTER,PREC
      INTEGER ICTXT, ERR
C     ...local array...
      INTEGER EXCH(2)
      INTEGER INT_ERR(6)
      DOUBLE PRECISION REAL_ERR(5)

C     ...parameters
      INTEGER IONE
      PARAMETER (IONE=1)
      logical debug
      parameter (debug=.false.)

      INFO = 0
      ICTXT = DESC_DATA(CTXT_)

C     ..Initialize counters...
      DO I=0,NP-1
        COUNTER_RECV(I)=0
        COUNTER_DL(I)=0
      ENDDO
      CALL BLACS_GRIDINFO(DESC_DATA(CTXT_),NPROW,NPCOL,MYROW,MYCOL)

      
C     ....Verify Local correctness of HALO_IN....
      I=1
      DO WHILE (HALO_IN(I).NE.-1)
        PROC=HALO_IN(I)
        IF ((PROC.GT.NP-1).OR.(PROC.LT.0)) THEN
          INFO = 110
          INT_ERR(1) = 11
          INT_ERR(2) = PROC
          GOTO 997
        ENDIF
        COUNTER_DL(PROC)=1

C        ..Update No of elements to receive from proc PROC..         
        COUNTER_RECV(PROC)=COUNTER_RECV(PROC)+
     +    HALO_IN(I+1)

        I=I+HALO_IN(I+1)+2
      ENDDO
 997  CONTINUE 
      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +  I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      
C     ...computing MAX_HALO: max halo points to be received from
C                            same processor
      MAX_HALO=0
      dl_lda_halo=0
      DO I=0,NP-1
        IF (COUNTER_RECV(I).GT.MAX_HALO) MAX_HALO=COUNTER_RECV(I)
        IF (COUNTER_DL(I).EQ.1) DL_LDA_HALO=DL_LDA_HALO+1
        COUNTER_DL(I)=0
        COUNTER_RECV(I)=0
      ENDDO

C     .....Verify Local Correctness of OVRLAP_IN....
      I=1
      DO WHILE (OVRLAP_IN(I).NE.-1)
        PROC=OVRLAP_IN(I)
        IF ((PROC.GT.NP-1).OR.(PROC.LT.0)) THEN
          INFO = 110
          INT_ERR(1) = 12
          INT_ERR(2) = PROC
          GOTO 998
        ENDIF
C        ..Update No of elements to receive from proc PROC..         
        COUNTER_RECV(PROC)=COUNTER_RECV(PROC)+
     +    OVRLAP_IN(I+1)

        COUNTER_DL(PROC)=1

        I=I+OVRLAP_IN(I+1)+2
      ENDDO

 998  CONTINUE 

      ERR = INFO
      CALL IGAMX2D(ICTXT, ALL, TOPDEF, IONE, IONE, ERR, IONE, 
     +  I, I, -IONE ,-IONE,-IONE)
      
      IF (ERR.NE.0) GOTO 9999
      
      DL_LDA_OVRLAP=0      
      MAX_OVRLAP=0
      DO I=0,NP-1
        IF (COUNTER_RECV(I).GT.MAX_OVRLAP) MAX_OVRLAP=COUNTER_RECV(I)
        IF (COUNTER_DL(I).EQ.1) DL_LDA_OVRLAP=DL_LDA_OVRLAP+1
      ENDDO

C     computing max global value of DL_LDA_HALO and DL_LDA_OVRLAP...
      EXCH(1)=DL_LDA_HALO
      EXCH(2)=DL_LDA_OVRLAP

      CALL IGAMX2D(DESC_DATA(CTXT_), ALL, TOPDEF, 2, IONE, EXCH, 
     +  2, COUNTER, COUNTER, -IONE ,-IONE,-IONE)


      DL_LDA_HALO=EXCH(1)*EXCH(1)*5
      DL_LDA_OVRLAP=EXCH(2)*EXCH(2)*5
      if (debug) then 
        write(*,*) 'PSI_Compute_size: ',exch(1),dl_lda_halo,exch(2)
      endif

      RETURN
      
 9999 CALL PSDERROR( ICTXT, INFO, 'PSDVERIFY\0', INT_ERR, REAL_ERR )

      END

         

